#include "RuleManager.h"
#include <stdio.h>

CRuleManager::CRuleManager(void)
{
}

CRuleManager::~CRuleManager(void)
{
}

void CRuleManager::init(void)
{
	// W[iQ[̍ŏŃ[w肳ȂƂɓKpj
	this->mbConstraint = true;
	this->mbEightStop = true;
	this->mbMiniRevolution = true;
	this->mbRevolution = true;

	this->mbStateConstraint = false;
	this->mbStateMiniRevolution = false;
	this->mbStateRevolution = false;
	this->mConstraintCount = 0;
}

void CRuleManager::printRule(void)
{
	printf( "[\n" );

	printf( "v\t : " );
	if( this->mbRevolution ){
		printf( "\n" );
	}else{
		printf( "Ȃ\n" );
	}

	printf( "v\t : " );
	if( this->mbMiniRevolution ){
		printf( "\n" );
	}else{
		printf( "Ȃ\n" );
	}

	printf( "W؂\t : " );
	if( this->mbEightStop ){
		printf( "\n" );
	}else{
		printf( "Ȃ\n" );
	}

	printf( "\t : " );
	if( this->mbConstraint ){
		printf( "\n" );
	}else{
		printf( "Ȃ\n" );
	}

	printf( "\n" );
}

// v
void CRuleManager::eventRevolution(void)
{
	if( this->mbStateRevolution ){
		// vԂȂʏԂɖ߂
		this->mbStateRevolution = false;
	}else{
		this->mbStateRevolution = true;
	}
}

// v
void CRuleManager::eventMiniRevolution()
{
	this->mbStateMiniRevolution = true;
}

// 肪
void CRuleManager::eventConstraint()
{
	this->mbStateConstraint = true;
}

// ꎞIȏԂZbg
void CRuleManager::resetTmpStatus(void){
	this->mbStateConstraint = false;
	this->mConstraintCount = 0;
	this->mbStateMiniRevolution = false;
}

// ̏Ԃ\
void CRuleManager::printStatus(void) const
{
	if( this->mbStateConstraint ){
		printf( "!!  !!\n" );
	}

	if( this->mbStateRevolution ){
		printf( "!! v !!\n" );
	}

	if( this->mbStateMiniRevolution ){
		printf( "!! v !!\n" );
	}

}

// o邩ǂ`FbN
bool CRuleManager::checkNext(const CCard card, const CCard fieldTop)
{
	// 0PassȂ̂falseԂ
	if( card.getCardNum() == 0 ){
		return false;
	}

	// 5ȏ㓯ɏoƂƃAEg
	if( card.getCardNum() > 4 ){
		return false;
	}

	//̃J[hƏoJ[h̖ĂȂƃAEg
	if( fieldTop.getCardNum() == 0 ){
		// ɃJ[hȂꍇOK
		;
	}else{
		if( card.getCardNum() != fieldTop.getCardNum() ){
			// ĂȂƃAEg
			return false;
		}
	}

	int cardNum = 0;	// J[h̐ۑ

	// ̐܂Ƃ߂ďoƂĂƃAEg
	// Joker͗Oł܂Ƃ߂ďoOK
	// ɉ̐oĂ邩T
	if( card.getCardNum() >= 1 ){
		for( int i = 0; i < 4; i++ ){
			for( int j = 1; j <= CARD_NUM; j++ ){
				// J[hݒ
				Card c;
				c.type = i;
				c.num = j;

				if( card.hasCard( c ) ){
					// J[hicjĂ
					if( cardNum == 0 ){
						// ŏ̃J[h
						cardNum = c.num;
					}else{
						// 2ڈȍ~̃J[h
						if( cardNum != c.num ){
							// ̐m
							return false;
						}
					}
				}
			}
		}
	}


	// ܂łőx̃[゠肦ȂJ[hZbgeĂ
	// ̓Iɂ
	//   E5ȏ̃J[hoƂĂȂ
	//   EJokerĕ̐oƂĂȂ
	//   EɃJ[hȂāA̖ƏoƂ閇Ă
	// ȏ3_ۏ؂Ă
	// ȉȀ󋵁Aׂ[ݒ肩o邩ǂ`FbN

	int fieldNum = 0;	// ̐
	
	if( fieldTop.getCardNum() == 0 ){
		// ɃJ[hȂ΁Ało
		return true;
	}

	// ɃJ[h΁A̐T
	for( int i = 0; i < 4; i++ ){
		for( int j = 1; j <= CARD_NUM; j++ ){
			// J[hݒ
			Card c;
			c.type = i;
			c.num = j;

			if( fieldTop.hasCard( c ) ){
				fieldNum = j;
				break;
			}
		}
	}
	if( fieldNum == 0 ){
		// Ȃ΁AɂJ[h̓W[J[݂̂Ȃ̂
		// oȂ
		return false;
	}

	if( this->mbEightStop && fieldNum == 8 ){
		// W؂肠ŁA̐WȂΏoȂ
		return false;
	}

	if( cardNum == 0 ){
		// ꂪW[J[łȂ΁AW[J[͕Ko
		return true;
	}

	// ]邽߂ɒl␳
	// 3ԎキA2ԋ
	// ␳30, 41, ... ,1310, 111, 212
	fieldNum = ( fieldNum + 10 ) % 13;
	cardNum = ( cardNum + 10 ) % 13;


	// ʏEvԂ̔
	if( this->mbStateRevolution ^ this->mbStateMiniRevolution ){
		// vԂ̏
		if( this->mbStateConstraint ){
			// Ԃ̏
			if( cardNum == fieldNum - 1 ){
				// ɎアJ[ho
				return true;
			}else{
				return false;
			}
		}else{
			// ȂԂ̏
			if( cardNum < fieldNum ){
				// アJ[ho
				return true;
			}else{
				return false;
			}
		}
	}else{
		// ʏԂ̏
		if( this->mbStateConstraint ){
			// Ԃ̏
			if( cardNum == fieldNum + 1 ){
				// ɋJ[ho
				return true;
			}else{
				return false;
			}
		}else{
			// ȂԂ̏
			if( cardNum > fieldNum ){
				// J[ho
				return true;
			}else{
				return false;
			}
		}
	}
}

// [ύX
void CRuleManager::changeRule( const CCard card, const CCard fieldTop )
{
	int cardNum = 0;	// J[h̐
	int fieldNum = 0;	// ̃J[h̐

	// J[hoĂȂƂ̓[ύXȂ
	if( card.getCardNum() == 0 ){
		return;
	}

	// J[h̐
	for( int i = 0; i < 4; i++ ){
		for( int j = 1; j <= CARD_NUM; j++ ){
			Card c;
			c.type = i;
			c.num = j;
			// J[h̐
			if( card.hasCard( c ) ){
				cardNum = c.num;
			}
			// ̃J[h̐
			if( fieldTop.hasCard( c ) ){
				fieldNum = c.num;
			}
		}
	}

	if( cardNum == 0 ){
		// JokerȂ牽NȂ
		this->mConstraintCount = 0;
		return;
	}

	// v𔻒
	if( card.getCardNum() == 4 && this->mbRevolution ){
		this->eventRevolution();
	}

	// v𔻒
	if( cardNum == 11 && this->mbMiniRevolution ){
		this->eventMiniRevolution();
	}


	// 𔻒
	// ]邽߂ɒl␳
	// 3ԎキA2ԋ
	// ␳30, 41, ... ,1310, 111, 212
	fieldNum = ( fieldNum + 10 ) % 13;
	cardNum = ( cardNum + 10 ) % 13;
	
	// ̃J[h̎̐oĂ
	// ̃JEgCNg
	if( cardNum == fieldNum + 1 ){
		this->mConstraintCount++;
	}

	// ̃JEg3ȏȂA
	if( this->mConstraintCount >= 3 && this->mbConstraint ){
		this->eventConstraint();
	}
}