#include "GameManager.h"
#include <stdio.h>
#include <stdlib.h>

CGameManager::CGameManager(void)
{
}

CGameManager::~CGameManager(void)
{
}

// Q[s
void CGameManager::game()
{
	// [}l[W[̍쐬
	this->mpRuleManager = new CRuleManager();

	// [
	this->mpRuleManager->init();

	// [̐ݒ
	this->mpRuleManager->mbConstraint = false;		// 
	this->mpRuleManager->mbEightStop = false;		// W؂
	this->mpRuleManager->mbMiniRevolution = false;	// v
	this->mpRuleManager->mbRevolution = false;		// v

	// [\
	this->mpRuleManager->printRule();

	// ̊m
	this->mPlayerNum = PLAYER_NUM;
	this->mpOrder = new int[this->mPlayerNum];
	this->mpAllPlayer = new Player[this->mPlayerNum];

	// v[[̐
	this->mpAllPlayer[0].player = new CSample();
	this->mpAllPlayer[1].player = new CPlayer();
	this->mpAllPlayer[2].player = new CPlayer();
	this->mpAllPlayer[3].player = new CPlayer();
	this->mpAllPlayer[4].player = new CPlayer();

	// Q[
	this->gameInit();

	// S̏Ԃ̕\
	this->printAllPlayer();

	// Q[s
	this->gamePlay();

	// ʕ\
	this->pirntGameResult();

	// ̉
	for( int i = 0; i < this->mPlayerNum; i++ ){
		delete this->mpAllPlayer[i].player;
	}
	delete[] this->mpAllPlayer;
	delete[] this->mpOrder;
	delete this->mpRuleManager;
}

// Q[̏s
// vCEJ[hzzEv[[ւ̊Jn}
void CGameManager::gameInit(){
	// vČ
	this->setPlayOrder();
	
	// v[[̏
	for( int i = 0; i < this->mPlayerNum; i++ ){
		Player* p;
		p = &(this->mpAllPlayer[ this->mpOrder[i] ]);
		// v[[IĎ
		p->playerID = i + 1;
		// pXĂȂԂɂ
		p->pass = false;
		// LOŉʂɐݒ
		p->rank = this->mPlayerNum;
	}
	
	// J[hz
	this->dealCard();

	// v[[ւ̃Q[Jn}
	for( int i = 0; i < this->mPlayerNum; i++ ){
		this->mpAllPlayer[i].player->gameStart( this->mPlayerNum, this->mpAllPlayer[i].playerID );
	}
}

// Q[̎s
void CGameManager::gamePlay()
{
	this->mPlayingPlayer = this->mPlayerNum;
	
	// vCĂll葽Ƃ͑s
	while( mPlayingPlayer > 1 ){
		// ̃EhJn
		this->nextRound();
	}
}

// Q[iEhj̎s
void CGameManager::nextRound()
{
	CCard fieldTop;
	Player* player;
	int nextOrder = 0;

	// Jnv[[̌
	for( int i = 0; i < this->mPlayerNum; i++ ){
		// ÕEhŃpXĂȂv[[
		if( !this->mpAllPlayer[ this->mpOrder[i] ].pass ){
			nextOrder = i;
			break;
		}
	}

	// v[[̃pXݒ̉
	this->mPassedPlayer = 0;
	for( int i = 0; i < this->mPlayerNum; i++ ){
		this->mpAllPlayer[i].pass = false;
	}

	// ꎞIȃ[ύX̉
	this->mpRuleManager->resetTmpStatus();

	// pXĂȂv[[2lȏ̏ꍇ͑s
	while( this->mPlayingPlayer - this->mPassedPlayer >= 2 ){
		// ̏Ԃ̃v[[̃|C^Rs[
		player = &(this->mpAllPlayer[ this->mpOrder[nextOrder] ]);

		// v[[pXĂȂāAAJ[hcĂꍇ
		if( !player->pass && player->card.getCardNum() > 0 ){
			nextTurn( &fieldTop, player );
		}
		
		// ̃v[[
		nextOrder = ( nextOrder + 1 ) % this->mPlayerNum;
	}
}

// ^[i߂
void CGameManager::nextTurn( CCard* fieldTop, Player* player )
{
	bool check;

	// v[[̏oJ[h擾
	CCard card = player->player->myTurn( &(player->card), fieldTop, this->mpRuleManager );

	// v[[oJ[hĂ邩ǂ𔻒
	if( player->card.include( card ) ){
		// J[ho邩ǂ
		check = this->mpRuleManager->checkNext( card, *fieldTop );
	}else{
		// J[hĂȂΏoȂ
		check = false;
	}

	// J[hoȂo
	if( check ){
		// v[[̏oJ[h𑼂̃v[[ɍm
		for( int i = 0; i < this->mPlayerNum; i++ ){
			Player* p;
			p = &(this->mpAllPlayer[i]);
			if( p->playerID != player->playerID ){
				// ̃^[łȂ΍m
				p->player->othersTurn( player->playerID, player->card.getCardNum(), &card, fieldTop, this->mpRuleManager );
			}
		}

		// [ύX
		this->mpRuleManager->changeRule( card, *fieldTop );

		// ̃J[hύX
		fieldTop->copyCard( card );

		// oJ[h폜
		player->card.removeCard( card );
	}else{
		// J[hoȂȂpXƂɂ
		player->pass = true;
		this->mPassedPlayer++;

		// pX͑̃v[[ɍm
		for( int i = 0; i < this->mPlayerNum; i++ ){
			Player* p;
			p = &(this->mpAllPlayer[i]);
			if( p != player ){
				// ̃^[łȂ΍m
				card.removeAllCard();
				p->player->othersTurn( player->playerID, player->card.getCardNum(), &card, fieldTop, this->mpRuleManager );
			}
		}
	}

	// v[[̃J[hȂȂƂ̏
	if( player->card.getCardNum() == 0 ){
		// LOɓo^
		this->mPlayingPlayer--;
		player->rank = this->mPlayerNum - this->mPlayingPlayer;
	}
}

// Q[̌ʕ\
void CGameManager::pirntGameResult()
{
	printf( "\n" );
	for( int i = 0; i < this->mPlayerNum; i++ ){
		printf( "[%d] %s\t : %d \n", i, this->mpAllPlayer[i].player->mPlayerName, this->mpAllPlayer[i].rank );
	}
	printf( "\n" );
}

// J[hz
void CGameManager::dealCard()
{
	CCard gameMngCard;

	// ׂẴJ[h
	gameMngCard.setCardAll();

	// ꖇz
	Card card;
	for( int i = 0; gameMngCard.getCardNum() > 0; i++ ){
		// ꖇ_ɑI
		card = gameMngCard.chooseRandomly();
		// vCɔz
		this->mpAllPlayer[ this->mpOrder[ i % this->mPlayerNum ] ].card.addCard( card );
		// zJ[h͏
		gameMngCard.removeCard( card );
	}
}

// vCZbg
// P`mPlayerNum
void CGameManager::setPlayOrder()
{
	int r;
	bool* decided = new bool[this->mPlayerNum];

	// łɌ܂ǂۑϐ
	for( int i = 0; i < this->mPlayerNum; i++ ){
		decided[i] = false;
	}

	// vC
	for( int i = 0; i < this->mPlayerNum; i++ ){
		// 擪炒Ԗڂ̃v[[̃vCɂ
		r = rand() % ( this->mPlayerNum - i );

		// łɌ܂ĂƂ͂Ƃ΂
		for( int j = 0; j <= r; j++ ){
			if( decided[j] ){
				r++;
			}
		}

		// Ԃ
		this->mpOrder[r] = i;
		decided[r] = true;
	}

	// 
	delete decided;
}

void CGameManager::printPlayer( Player p ){
	printf( "%s------------------------\n", p.player->mPlayerName );
	printf( "Player ID\t : %d\n", p.playerID );
	if( p.pass ){
		printf( "Pass\t\t : true\n" );
	}else{
		printf( "Pass\t\t : false\n" );
	}
	p.card.printCard();
	printf( "--------------------------------------\n" );
}

void CGameManager::printAllPlayer(){
	for( int i = 0; i < this->getPlayerNum(); i++ ){
		this->printPlayer( this->mpAllPlayer[i] );
	}
	printf( "\n" );
}

int CGameManager::getPlayerNum(){
	return this->mPlayerNum;
}
