#include "Card.h"
#include <stdio.h>
#include <stdlib.h>

CCard::CCard(void)
{
	// 
	// J[hȂԂɂ
	for( int i = 0; i <= CARD_NUM; i++ ){
		this->mClover[i] = false;
		this->mDiamond[i] = false;
		this->mHeart[i] = false;
		this->mSpade[i] = false;
	}
	for( int i = 0; i <= JOKER_NUM; i++ ){
		this->mJoker[i] = false;
	}
	this->mNum = 0;

}

CCard::~CCard(void)
{
}

// J[h_ɑI
Card CCard::chooseRandomly(void) const
{
	Card card;

	// J[hȂƂ
	if( this->mNum == 0 ){
		card.num = 0;
		card.type = 0;
		return card;
	}

	// _Ő擪rڂ̃J[hI
	int r = ( rand() % this->mNum );

	for( int i = 0, j = 0; i <= r; j++ ){
		card.type = j / CARD_NUM;
		card.num = j % CARD_NUM + 1;
		if( hasCard( card ) ){
			i++;
		}
	}

	return card;
}

// J[hǉ
void CCard::addCard( Card card )
{
	bool* pCard = linkCard( card );
	
	if( *pCard == false ){
		*pCard = true;
		this->mNum++;
	}
}

void CCard::addCard( const CCard card )
{
	Card c;

	// JokerȊÕJ[h
	for( int i = 0; i < 4; i++ ){
		for( int j = 1; j <= CARD_NUM; j++ ){
			c.type = i;
			c.num = j;
			if( card.hasCard( c ) ){
				this->addCard( c );
			}
		}
	}
	// Jokeȑ
	for( int i = 1; i <= JOKER_NUM; i++ ){
		c.type = 4;
		c.num = i;
		if( card.hasCard( c ) ){
			this->addCard( c );
		}
	}
}

// J[h폜
void CCard::removeCard( Card card )
{
	bool* pCard = linkCard( card );
	
	if( *pCard == true ){
		*pCard = false;
		this->mNum--;
	}
}

void CCard::removeCard( const CCard card )
{
	Card c;

	for( int i = 0; i < 4; i++ ){
		for( int j = 1; j <= CARD_NUM; j++ ){
			c.type = i;
			c.num = j;
			if( card.hasCard( c ) ){
				this->removeCard( c );
			}
		}
	}
	// Jokeȑ
	for( int i = 1; i <= JOKER_NUM; i++ ){
		c.type = 4;
		c.num = i;
		if( card.hasCard( c ) ){
			this->removeCard( c );
		}
	}
}

// ׂẴJ[h폜
void CCard::removeAllCard( void )
{
	// ẑOԖڂfalseɂ
	this->mClover[0] = false;
	this->mDiamond[0] = false;
	this->mHeart[0] = false;
	this->mSpade[0] = false;
	this->mJoker[0] = false;

	// ׂẴJ[hfalseɂ
	for( int i = 1; i <= CARD_NUM; i++ ){
		this->mClover[i] = false;
		this->mDiamond[i] = false;
		this->mHeart[i] = false;
		this->mSpade[i] = false;
	}
	for( int i = 1; i <= JOKER_NUM; i++ ){
		this->mJoker[i] = false;
	}

	// ݒ
	this->mNum = 0;
}

// J[hRs[
void CCard::copyCard( CCard card )
{
	this->removeAllCard();
	this->addCard( card );
}

// J[hׂėLɂ
void CCard::setCardAll()
{
	// ẑOԖڂfalseɂ
	this->mClover[0] = false;
	this->mDiamond[0] = false;
	this->mHeart[0] = false;
	this->mSpade[0] = false;
	this->mJoker[0] = false;

	for( int i = 1; i <= CARD_NUM; i++ ){
		this->mClover[i] = true;
		this->mDiamond[i] = true;
		this->mHeart[i] = true;
		this->mSpade[i] = true;
	}
	for( int i = 1; i <= JOKER_NUM; i++ ){
		this->mJoker[i] = true;
	}

	// 13 * 4 + 2(Joker)
	this->mNum = 54;
}

// J[hĂ邩
bool CCard::hasCard( Card card ) const
{
	switch( card.type ){
		case SPADE:
			return this->mSpade[card.num];
			break;
		case DIAMOND:
			return this->mDiamond[card.num];
			break;
		case CLOVER:
			return this->mClover[card.num];
			break;
		case HEART:
			return this->mHeart[card.num];
			break;
		case JOKER:
			return this->mJoker[card.num];
			break;
		default:
			return false;
			break;
	}
}

// J[h܂ł邩
bool CCard::include( const CCard card ){
	Card c;

	for( int i = 0; i < 4; i++ ){
		for( int j = 1; j <= CARD_NUM; j++ ){
			c.type = i;
			c.num = j;
			// cardɂthisɂȂJ[h݂ꍇfalseԂ
			if( card.hasCard( c ) && ( !this->hasCard( c ) ) ){
				return false;
			}
		}
	}

	// Joker̔
	for( int i = 1; i <= JOKER_NUM; i++ ){
		c.type = 4;
		c.num = i;
		// cardɂthisɂȂJ[h݂ꍇfalseԂ
		if( card.hasCard( c ) && ( !this->hasCard( c ) ) ){
			return false;
		}
	}

	// ׂĂ̏𖞂trueԂ
	return true;
}

// J[h̖Ԃ
int CCard::getCardNum(void) const{
	return this->mNum;
}

// J[h̃|C^Ԃ
bool* CCard::linkCard( Card card ){
	bool* pCard;

	switch( card.type ){
		case SPADE:
			pCard = &this->mSpade[card.num];
			break;
		case DIAMOND:
			pCard = &this->mDiamond[card.num];
			break;
		case CLOVER:
			pCard = &this->mClover[card.num];
			break;
		case HEART:
			pCard = &this->mHeart[card.num];
			break;
		case JOKER:
			pCard = &this->mJoker[card.num];
			break;
		default:
			return NULL;
			break;
	}

	return pCard;
}

// J[hʂɏo
void CCard::printCard() const
{
	// Xy[h\
	printf( "Spade\t " );
	for( int i = 1; i <= CARD_NUM; i++ ){
		if( this->mSpade[i] ){
			printf( "%d ", i );
		}else{
			for( int j = 0; j < (i / 10 + 2); j++ ){
				printf( " " );
			}
		}
	}
	printf( "\n" );

	// Xy[h\
	printf( "Diamond\t " );
	for( int i = 1; i <= CARD_NUM; i++ ){
		if( this->mDiamond[i] ){
			printf( "%d ", i );
		}else{
			for( int j = 0; j < (i / 10 + 2); j++ ){
				printf( " " );
			}
		}
	}
	printf( "\n" );

	// Xy[h\
	printf( "Clover\t " );
	for( int i = 1; i <= CARD_NUM; i++ ){
		if( this->mClover[i] ){
			printf( "%d ", i );
		}else{
			for( int j = 0; j < (i / 10 + 2); j++ ){
				printf( " " );
			}
		}
	}
	printf( "\n" );

	// Xy[h\
	printf( "Heart\t " );
	for( int i = 1; i <= CARD_NUM; i++ ){
		if( this->mHeart[i] ){
			printf( "%d ", i );
		}else{
			for( int j = 0; j < (i / 10 + 2); j++ ){
				printf( " " );
			}
		}
	}
	printf( "\n" );

	// W[J[\
	printf( "Joker\t " );
	for( int i = 1; i <= JOKER_NUM; i++ ){
		if( this->mJoker[i] ){
			printf( "%d ", i );
		}else{
			for( int j = 0; j < (i / 10 + 2); j++ ){
				printf( " " );
			}
		}
	}
	printf( "\n" );
}
