unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ObjStreamV, ExtCtrls;



type TTestType = (tt0,tt1,tt2,tt3);

type TTestSet = set of TTestType;

type
  TTestCompSub = class(TComponent)
  private
    { Private 錾 }
    FVSubInt: Integer;
    FVSubStr: string;
    FVSubBool: Boolean;
  public
    { Public 錾 }
  published

    property VSubInt : Integer read FVSubInt write FVSubInt default 0;
    property VSubStr : string read FVSubStr write FVSubStr;
    property VSubBool : Boolean read FVSubBool write FVSubBool;

  end;
type
  TTestComp = class(TComponent)
  private
    { Private 錾 }
    FVInt: Integer;
    FVStr: string;
    FVBool: Boolean;
    FVDouble: Double;
    FVInt64: Int64;
    FVSet: TTestSet;
    FVColor: TColor;
    FVFontStyle: TFontStyles;
    FVDate: TDateTime;
    FVComp: TTestCompSub;
    FVFont: TFont;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;
  published

    property VInt : Integer read FVInt write FVInt default 1;
    property VStr : string read FVStr write FVStr;
    property VBool : Boolean read FVBool write FVBool;
    property VDouble : Double read FVDouble write FVDouble;
    property VInt64 : Int64 read FVInt64 write FVInt64 default 123456789;
    property VSet : TTestSet read FVSet write FVSet;
    property VColor : TColor read FVColor write FVColor;
    property VDate : TDateTime read FVDate write FVDate;
    property VFont : TFont read FVFont write FVFont;
    property VComp : TTestCompSub read FVComp write FVComp;
  end;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Memo2: TMemo;
    Button2: TButton;
    Panel1: TPanel;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Label1: TLabel;
    Label2: TLabel;
    ComboBox1: TComboBox;
    Label3: TLabel;
    CBoxCSaved: TCheckBox;
    Panel2: TPanel;
    Panel3: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
  private
    { Private 錾 }
    FTestComp : TTestComp;
    FSaveObj : TComponent;
    FPerformanceCounter    : array[0..9] of Int64;
    function BinToTextOut(m : TMemoryStream) : string;
    procedure SetData();
    procedure StopTimStart(const no: Integer);
    function StopTimStop(const no: Integer): string;
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;
  PerformanceFrequency  : Int64;

implementation

{$R *.DFM}

function TForm1.BinToTextOut(m: TMemoryStream): string;
var
  StrStream: TStringStream;
  s: string;
begin
  StrStream := TStringStream.Create(s);
  try
    m.Seek(0, soFromBeginning);
    ObjectBinaryToText(m, StrStream);
    StrStream.Seek(0, soFromBeginning);
    Result:= StrStream.DataString;
  finally
    StrStream.Free;

  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FTestComp := TTestComp.Create(Self);


  FSaveObj := Form1; // ŵȂ̓tH[ۑ
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FTestComp.Free;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  e : TMemoryStream;
begin
  e := TMemoryStream.Create;
  try
    StopTimStart(1);
    e.WriteComponent(FSaveObj);
    Caption := StopTimStop(1);
    e.SaveToFile('test.bin');
  finally
    e.Free;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  e : TMemoryStream;
  d : TObjStreamV;
begin
  e := TMemoryStream.Create;
  d := TObjStreamV.Create;
  try
    StopTimStart(1);
    d.ComponentSaved := CBoxCSaved.Checked;
    d.WriteComponent(FSaveObj,e);
    Caption := StopTimStop(1);
    e.SaveToFile('test.bin');
  finally
    d.Free;
    e.Free;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  e : TMemoryStream;
begin
  e := TMemoryStream.Create;
  try
    e.LoadFromFile('test.bin');
    StopTimStart(1);
    e.ReadComponent(FSaveObj);
    Caption := StopTimStop(1);
  finally
    e.Free;
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  e : TMemoryStream;
  d : TObjStreamV;
begin
  e := TMemoryStream.Create;
  d := TObjStreamV.Create;
  try
    e.LoadFromFile('test.bin');
    StopTimStart(1);
    d.ReadComponent(FSaveObj,e);
    Caption := StopTimStop(1);
  finally
    d.Free;
    e.Free;
  end;
end;


procedure TForm1.Button5Click(Sender: TObject);
begin
  SetData();
end;

procedure TForm1.SetData;
var
  i : Integer;
  s : string;
begin
  s := '';
  for i := 0 to 200 do begin
    s := s + 'abcdefg';
  end;

  FTestComp.FVInt := 1;
  FTestComp.FVStr  := s;
  FTestComp.FVDouble := 12.34;
  FTestComp.FVInt64 := 123456789;
  FTestComp.FVBool := True;
  FTestComp.FVSet := [tt2,tt3];
  FTestComp.FVColor := $123456;
  FTestComp.FVDate := Now;
  FTestComp.FVFontStyle := [fsBold];
  FTestComp.VComp.VSubInt := 1;

  Panel3.Caption := '';
end;



procedure TForm1.ComboBox1Change(Sender: TObject);
var
  e : TMemoryStream;
  d : TObjStreamV;
  s1,s2 : string;
begin
  // ŕۑ^ǍŎIuWFNgw肵Ă܂B
  case TComboBox(Sender).ItemIndex of
    0 : FSaveObj := Form1;
    1 : FSaveObj := Form1.Button1;
    2 : FSaveObj := Form1.Memo1;
    3 : FSaveObj := Form1.Panel2;
    4 : FSaveObj := Form1.Label1;
    5 : FSaveObj := FTestComp;
  end;
  e := TMemoryStream.Create;
  d := TObjStreamV.Create;
  try
    d.ComponentSaved := CBoxCSaved.Checked;
    StopTimStart(1);
    d.WriteComponent(FSaveObj,e);
    s2 := StopTimStop(1);
    s2 := BinToTextOut(e) +s2;
  finally
    d.Free;
    e.Free;
  end;
  e := TMemoryStream.Create;
  try
    StopTimStart(1);
    e.WriteComponent(FSaveObj);
    s1 := StopTimStop(1);
    s1 := BinToTextOut(e) + s1;
  finally
    e.Free;
  end;
  Memo1.Lines.Text := s1;
  Memo2.Lines.Text := s2;

end;

procedure TForm1.StopTimStart(const no: Integer);
begin
  QueryPerformanceCounter(FPerformanceCounter[no]);
end;

function TForm1.StopTimStop(const no: Integer) : string;
var
  str       : string;
  stop_cnt  : Int64;
  tim_cnt   : Int64;
begin
  QueryPerformanceCounter(stop_cnt);
  tim_cnt := stop_cnt - FPerformanceCounter[no];
  tim_cnt := Round(tim_cnt / PerformanceFrequency * 1000000);

  str := IntToStr(tim_cnt);
  result := 'oߎ = ' + str + 'b';
end;

{ TTestComp }

constructor TTestComp.Create(AOwner: TComponent);
begin
  inherited;
  FVComp := TTestCompSub.Create(Self);
  FVFont := TFont.Create;
end;

destructor TTestComp.Destroy;
begin
  FVFont.Free;
  FVComp.Free;
  inherited;
end;

initialization
  QueryPerformanceFrequency(PerformanceFrequency);
end.
