//**************************************************************************//
//                                                                          //
//  ` IuWFNgXg[ɕۑ邽߂̃NX `                    //
//                                                                          //
//                      Version 1.03                                        //
//                                                                          //
//          F  vS                                  //
//        gpׁ߲F  c T.O (Build 5.108)                    //
//                                                                          //
//        t@CF  nruD                        //
//                                                                          //
//          ҖF  uq`l̖pt                                    //
//                                                                          //
//      ŏIXVtF  QOOR^PP^PS                                //
//                                                                          //
//**************************************************************************//
unit ObjStreamV;

interface

{$IFNDEF VER130}           // Delphi 5ȊO̎
  {$DEFINE VER_OVER6}      // Delphi 6ȏłƔf
{$ENDIF}

{$IFDEF VER_OVER6} // Delphi 6 ȏ̎
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,TypInfo,IniFiles;
{$ENDIF}
{$IFNDEF VER_OVER6}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,TypInfo;
{$ENDIF}

//--------------------------------------------------------------------------//
//  gTPersistentNXiDefineProperties\bh̋Jj             //
//--------------------------------------------------------------------------//
type TPersistentEx = class(TPersistent);
//--------------------------------------------------------------------------//
//  gTWriterNXiWriteValue\bh̋Jj                       //
//--------------------------------------------------------------------------//
type TWriterEx = class(TWriter);
//--------------------------------------------------------------------------//
//  gTReaderNXiReadProperty\bh̋Jj                     //
//--------------------------------------------------------------------------//
type TReaderEx = class(TReader);

// ^
type TRttiType = (rtNormal,rtBoolean,rtImitation,rtComponent,rtClass,rtCollection,rtRootClass);

{$IFNDEF VER_OVER6}
//--------------------------------------------------------------------------//
//  nbV𗘗păCfbNX^TStringListNX     //
//--------------------------------------------------------------------------//
type THashedStringListV = class(TPersistent)
  private
    { Private 錾 }
    FList : TStringList;
    FTbl : array[0..1200] of TList;       // nbVpe[u
    FCnt : Integer;
    function GetHashedIndex(const S: string): Integer;
  public
    { Public 錾 }
    constructor Create;dynamic;
    destructor Destroy;override;

    function Add(const S: string): Integer;
    function IndexOf(const S: string): Integer;
    procedure Clear();
  end;
{$ENDIF}

//--------------------------------------------------------------------------//
//  vpeB̈ꗗǗNX                                              //
//--------------------------------------------------------------------------//
type TObjStreamV = class(TPersistent)
  private
    { Private 錾 }
    FObject : TObject;

    FInfo  : PTypeInfo;
    FData  : PTypeData;
    FProps : PPropList;

{$IFDEF VER_OVER6} // Delphi 6 ȏ̎
    FPropNames : THashedStringList;
{$ENDIF}
{$IFNDEF VER_OVER6}
    FPropNames : THashedStringListV;
{$ENDIF}

    FClassName : string;      // Font.Size ̂悤ɋLqꍇ̍̕
    FComponentSaved: Boolean;

    procedure WriteStreamRoot(w : TWriter; aClassName: string;aRttiType : TRttiType);
    procedure ReadStreamRoot(r : TReaderEx;w : TWriterEx; aClassName: string;aRttiType : TRttiType);
    function WriteStream(w : TWriter) : Boolean;
    function ReadStream(r : TReaderEx;w : TWriterEx;aRttiType: TRttiType) : Boolean;
    function ReadStreamNormal(r : TReaderEx;p : PPropInfo) : Boolean;
    //function ReadStreamClass(r : TReaderEx;aClassName : string) : Boolean;
    procedure GetRttiInfo();
    procedure GetPropertyNameList();
    function CheckPod(str : string;var StrLeft : string;var StrRight : string) : Boolean;
    function CheckRttiType(aProp : PPropInfo) : TRttiType;
    function CheckImitationProperty(aObject : TObject) : Boolean;
    procedure ReaderToWriter(r : TReader;w : TWriter);
    function WritePropertys(Sender : TObject;aClassName : string;w :TWriter;aRttiType : TRttiType) : Boolean;
    function ReadPropertys(Sender : TObject;aClassName : string;r :TReaderEx;w : TWriterEx;aRttiType : TRttiType) : Boolean;
  public
    { Public 錾 }
    constructor Create;dynamic;
    destructor Destroy;override;

    function ReadComponent(Sender : TObject;ReadStream : TStream) : Boolean;
    function WriteComponent(Sender : TObject;WriteStream : TStream) : Boolean;
    property ComponentSaved : Boolean read FComponentSaved write FComponentSaved;
  end;

implementation

{ TObjStreamV }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TObjStreamV.Create;
begin
{$IFDEF VER_OVER6} // Delphi 6 ȏ̎
  FPropNames := THashedStringList.Create;
{$ENDIF}
{$IFNDEF VER_OVER6}
  FPropNames := THashedStringListV.Create;
{$ENDIF}
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TObjStreamV.Destroy;
begin
  if FProps <> nil then begin
    // 擾s^j
    FreeMem(FProps,FData^.PropCount * SizeOf(PPropInfo));
  end;
  FPropNames.Free;
  inherited;

end;

//**************************************************************************//
//                                                                          //
//  `@UvpeB@`                                              //
//                                                                          //
//   - Input -  aObjec : ΏۃIuWFNg                                   //
//                                                                          //
//   - Output - True : UvpeB                                         //
//                                                                          //
//**************************************************************************//
function TObjStreamV.CheckImitationProperty(aObject: TObject): Boolean;
var
  stm : TWriter;
  m : TStringStream;
  s : string;
begin
  result := False;
  if aObject = nil then exit;
  m := TStringStream.Create(s);
  stm := TWriter.Create(m,4096);
  try
    result := False;
    TPersistentEx(aObject).DefineProperties(stm);
    stm.FlushBuffer;
    m.Seek(0, soFromBeginning);
    result := m.DataString <> '';
  finally
    m.Free;
    stm.Free;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@uDsIhv̑Oŕ𕪉@`                          //
//                                                                          //
//   - Input -  str :                                               //
//              StrLeft : sIh荶ɂ镶                        //
//              StrRight : sIhEɂ镶                       //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TObjStreamV.CheckPod(str: string; var StrLeft,
  StrRight: string): Boolean;
var
  i : Integer;
begin
  result := False;
  i := Pos('.',str);
  if i = 0 then exit;
  result := True;
  StrLeft  := Copy(str,1,i - 1);
  StrRight := Copy(str,i+1 ,Length(str));
end;

//**************************************************************************//
//                                                                          //
//  `@vpeB̎ނʁ@`                                          //
//                                                                          //
//   - Input -  aProp : ʂvpeB                                  //
//                                                                          //
//   - Output - ʌ                                                    //
//                                                                          //
//**************************************************************************//
function TObjStreamV.CheckRttiType(aProp: PPropInfo): TRttiType;
begin
  result := rtNormal;
  if (aProp.PropType^.Kind = tkClass) then begin
    if (CheckImitationProperty(GetObjectProp(FObject,aProp))) then begin
      // UvpeB̏
      result := rtImitation;
    end
    else if GetObjectProp(FObject,aProp.Name) <> nil then begin
      // NX̏
      if GetObjectProp(FObject,aProp.Name) is TComponent then begin
        // TComponent̔hNX̂Ƃ
        result := rtComponent;
      end
      else begin
        // TComponentȊO̔hNX̂Ƃ
        result := rtClass;
      end;
    end;
  end
  else if aProp.PropType^.Name = 'Boolean' then begin
    result := rtBoolean;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@s^擾@`                                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TObjStreamV.GetRttiInfo;
begin
  FInfo := FObject.ClassInfo;
  FData := GetTypeData(FInfo);

  GetMem(FProps,FData^.PropCount * SizeOf(PPropInfo));
  GetPropInfos(FInfo,FProps);

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Propertÿꗗ擾@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TObjStreamV.GetPropertyNameList;
var
  i : Integer;
begin
  FPropNames.Clear;

{$IFDEF VER_OVER6} // Delphi 6 ȏ̎
  FPropNames.CaseSensitive := True;
  FPropNames.Sorted := False;
  for i :=0  to FData^.PropCount-1 do begin
    FPropNames.AddObject(FProps^[i].Name,Pointer(i));
  end;
{$ENDIF}
{$IFNDEF VER_OVER6}
  for i :=0  to FData^.PropCount-1 do begin
    FPropNames.Add(FProps^[i].Name);
  end;
{$ENDIF}

end;

//**************************************************************************//
//                                                                          //
//  `@Xg[f[^ǂݍށ@`                              //
//                                                                          //
//   - Input -  r : f[^ǂݍރXg[                            //
//              w : ǂݍ񂾃f[^oXg[                  //
//                  (w = nil̏ꍇ͏oȂj                          //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TObjStreamV.ReaderToWriter(r: TReader; w: TWriter);
var
  i,cnt : Integer;
  b : Byte;
  s : string;
  f : Boolean;
  tt : TValueType;
begin
  //CopyValueQlɂč쐬Ă;
  f := w <> nil;
  tt := r.NextValue;
  case tt of
    vaNull,
    vaFalse,
    vaTrue,
    vaNil      :  begin
                     if f then TWriterEx(w).WriteValue(r.ReadValue)
                          else r.ReadValue;
                  end;
    vaString :    begin
                    if f then begin
                      TWriterEx(w).WriteValue(r.ReadValue);
                      w.WriteStr(r.ReadStr);
                    end
                    else begin
                      r.ReadValue;
                      r.ReadStr;
                    end;
                  end;
    vaInt8,
    vaInt16,
    vaInt32:      begin
                    if f then w.WriteInteger(r.ReadInteger)
                         else r.ReadInteger;
                  end;
    vaInt64:      begin
                    if f then w.WriteInteger(r.ReadInt64)
                         else r.ReadInt64;
                  end;
    vaExtended:   begin
                    if f then w.WriteFloat(r.ReadFloat)
                         else r.ReadFloat;
                  end;
    vaSingle :    begin
                    if f then w.WriteSingle(r.ReadSingle)
                         else r.ReadSingle;
                  end;
    vaCurrency:   begin
                    if f then w.WriteCurrency(r.ReadCurrency)
                         else r.ReadCurrency;
                  end;
    vaDate:       begin
                    if f then w.WriteDate(r.ReadDate)
                         else r.ReadDate;
                  end;
    vaSet:        begin
                    if f then TWriterEx(w).WriteValue(r.ReadValue)
                         else r.ReadValue;
                    repeat
                      s := r.ReadStr;
                      if f then w.WriteStr(s);
                    until s = '';
                  end;
    vaList,
    vaCollection :begin
                    r.ReadListBegin;
                    if f then w.WriteListBegin;
                    while r.NextValue <> vaNull do begin
                      ReaderToWriter(r,w);
                    end;
                    if f then TWriterEx(w).WriteValue(r.ReadValue)
                         else r.ReadValue;
                  end;
    vaIdent :     begin
                    if f then w.WriteIdent(r.ReadIdent)
                         else r.ReadIdent;
                  end;

{$IFDEF VER_OVER6} // Delphi 6 ȏ̎
    vaUTF8String,
{$ENDIF}
    vaLString,
    vaBinary :    begin
                    if f then begin
                      TWriterEx(w).WriteValue(r.ReadValue);
                      r.Read(cnt, SizeOf(cnt));
                      w.Write(cnt, SizeOf(cnt));
                      for i := 0 to cnt-1 do begin
                        r.Read(b,SizeOf(b));
                        w.Write(b,SizeOf(b));
                      end;
                    end
                    else begin
                      r.ReadValue;
                      r.Read(cnt, SizeOf(cnt));
                      for i := 0 to cnt-1 do begin
                        r.Read(b,SizeOf(b));
                      end;
                    end;
                  end;
  else            begin
                    //tt := tt;
                  end;
  end;

end;

//**************************************************************************//
//                                                                          //
//  `@IuWFNgXg[ɏށ@`                              //
//                                                                          //
//   - Input -  Sender      : ΏۃIuWFNg                              //
//              WriteStream : oXg[                            //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//**************************************************************************//
function TObjStreamV.WriteComponent(Sender: TObject;WriteStream: TStream): Boolean;
var
  w : TWriter;
begin
  w := TWriter.Create(WriteStream, 4096);
  try
    w.WriteSignature;                                   // wb_
    result := WritePropertys(Sender,'',w,rtRootClass);  // vpeB
    w.WriteListEnd;                                     // tb^
  finally
    w.Free;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@Xg[IuWFNgǂݍށ@`                        //
//                                                                          //
//   - Input -  Sender      : ΏۃIuWFNg                              //
//              ReadStream  : ǂݍރXg[                            //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//**************************************************************************//
function TObjStreamV.ReadComponent(Sender: TObject;ReadStream: TStream): Boolean;
var
  r : TReaderEx;
  w : TWriterEx;
begin
  r := TReaderEx.Create(ReadStream, 4096);
  w := TWriterEx.Create(ReadStream, 4096);
  try
    r.ReadSignature;                                    // wb_ǂݍ
    result := ReadPropertys(Sender,'',r,w,rtRootClass); // vpeBǂݍ
    r.ReadListEnd;                                      // tb^ǂݍ
  finally
    w.Free;
    r.Free;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@IuWFNgXg[ɏށiċAj@`                //
//                                                                          //
//   - Input -  Sender      : ΏۃIuWFNg                              //
//              aClassName  : IuWFNg̖                            //
//              w           : oXg[                            //
//              aRttiType   : ^                                        //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//--------------------------------------------------------------------------//
function TObjStreamV.WritePropertys(Sender: TObject; aClassName: string;w :TWriter;aRttiType : TRttiType): Boolean;
var
  i : Integer;
  aStmV : TObjStreamV;
begin
  FObject := Sender;
  FClassName := aClassName;
  GetRttiInfo();

  // IuWFNg̏
  WriteStreamRoot(w,aClassName,aRttiType);

  if (FObject is TWinControl) then begin
    // TWinControl̔hNX̏ꍇ
    // ێĂRNVۑ
    for i :=0  to TWinControl(FObject).ControlCount-1 do begin
      aStmV := TObjStreamV.Create;
      try
        //aStmV.WritePropertys(TComponent(FObject).Components[i],'',w,rtCollection);
        aStmV.WritePropertys(TWinControl(FObject).Controls[i],'',w,rtCollection);
      finally
        aStmV.Free;
      end;
    end;
  end;
  result := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Xg[IuWFNgǂݍށiċAj@`          //
//                                                                          //
//   - Input -  Sender      : ΏۃIuWFNg                              //
//              aClassName  : IuWFNg̖                            //
//              r           : ǂݍރXg[                            //
//              w           : oXg[                            //
//              aRttiType   : ^                                        //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//--------------------------------------------------------------------------//
function TObjStreamV.ReadPropertys(Sender: TObject; aClassName: string;
  r: TReaderEx;w : TWriterEx; aRttiType: TRttiType): Boolean;
var
  i : Integer;
  aStmV : TObjStreamV;
  aCmp : TComponent;
  s : string;
  aPos : Integer;
begin
  FObject := Sender;
  FClassName := aClassName;
  GetRttiInfo();
  GetPropertyNameList();
  ReadStreamRoot(r,w,aClassName,aRttiType);

  if (aRttiType = rtRootClass) and (FObject is TWinControl) then begin
    // qRNV̏
    if r.NextValue <> vaNull then begin
      repeat
        aPos := r.Position;
        s := r.ReadStr;
        s := r.ReadStr;
        aCmp := nil;
        for i :=0  to TWinControl(FObject).ControlCount-1 do begin
          //if TComponent(FObject).Components[i].Name = s then aCmp := TComponent(FObject).Components[i];
          if TWinControl(FObject).Controls[i].Name = s then aCmp := TWinControl(FObject).Controls[i];
        end;
        if aCmp <> nil then begin
          r.Position := aPos;
          aStmV := TObjStreamV.Create;
          try
            aStmV.ReadPropertys(aCmp,'',r,w,rtCollection);
          finally
            aStmV.Free;
          end;
        end
        else begin
          // NXۂƑ݂ȂƂ
          repeat
            s := r.ReadStr;
            ReaderToWriter(r,nil);
          until r.NextValue = vaNull;
          r.ReadListEnd;
          r.ReadListEnd;
        end;
      until r.NextValue = vaNull;
    end;
  end;

  result := True;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@IuWFNgێĂpublishedpropertyށ@`         //
//                                                                          //
//   - Input -  w : oXg[                                      //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//--------------------------------------------------------------------------//
function TObjStreamV.WriteStream(w: TWriter) : Boolean;
var
  i,j : Integer;
  Converter : TIntToIdent;
  aStr : string;
  aInt : Integer;
  aInt64 : Int64;
  r : TReader;
  //stm : TMemoryStream;
  stm : TStringStream;
  w2 : TWriter;
  aStmV : TObjStreamV;
  aComp : PTypeData;
  aMask : Integer;
  aInfo  : PTypeInfo;
  aData  : PTypeData;
begin
  result := False;
  for i :=0  to FData^.PropCount-1 do begin
    // StoredFalsêƂ
    if not IsStoredProp(FObject,FProps^[i]) then Continue;
    case CheckRttiType(FProps^[i]) of
      rtNormal: begin
        case FProps^[i].PropType^.Kind of
          tkChar,
          tkWChar,
          tkInteger : begin
            //  Integer^̏
            aInt := GetOrdProp(FObject,FProps^[i].Name);
            if aInt = FProps^[i].Default then begin
              //result := True;
              Continue;
            end;
            w.WriteStr(FClassName + FProps^[i].Name);
            Converter := FindIntToIdent(FProps^[i].PropType^);
            if Assigned(Converter) and Converter(aInt,aStr) then begin
              TWriterEx(w).WriteValue(vaIdent);
              w.WriteStr(aStr);
            end
            else begin
              w.WriteInteger(aInt);
            end;
            result := True;
          end;
          tkInt64 : begin
            //  Int64^̏
            aInt64 := GetInt64Prop(FObject,FProps^[i]);
            // DefaultƓl̏ꍇ͏ȗ
            //if  aInt64 = FProps^[i].Default then Continue;

            // Delphi5łDefaultl𖳎uOv̂ƂȗƂdlɏ
            if  aInt64 = 0 then Continue;
            w.WriteStr(FClassName + FProps^[i].Name);
            w.writeInteger(aInt64);
            result := True;
          end;
          tkString : begin
            //  Z^̏
            aStr := GetStrProp(FObject,FProps^[i].Name);
            if aStr = '' then Continue;
            w.WriteStr(FClassName + FProps^[i].Name);
            TWriterEx(w).WriteValue(vaString);
            w.WriteStr(aStr);
            result := True;
          end;
          tkLString,
          tkWString : begin
            //  ^̏
            aStr := GetStrProp(FObject,FProps^[i].Name);
            if aStr = '' then Continue;
            w.WriteStr(FClassName + FProps^[i].Name);
            aInt := Length(aStr);
            if aInt < 256 then begin
              TWriterEx(w).WriteValue(vaString);
              w.Write(aInt, SizeOf(Byte));
            end
            else begin
              TWriterEx(w).WriteValue(vaLString);
              w.Write(aInt, SizeOf(Integer));
            end;
            w.Write(Pointer(aStr)^, aInt);
            // UTF8ŏޏꍇ
            //w.WriteString(FValue);
            result := True;
          end;
          tkEnumeration : begin
            //  񋓌^̏
            //aProp := FProps^[i];

            aInt := GetOrdProp(FObject,FProps^[i].Name);
            if aInt = FProps^[i].Default then Continue;

            w.WriteStr(FClassName + FProps^[i].Name);
            w.WriteIdent(GetEnumName(FProps^[i].PropType^,aInt));
            result := True;
          end;
          tkSet : begin
            //  W^̏

            aInt := GetOrdProp(FObject,FProps^[i].Name);
            if aInt = FProps^[i].Default then Continue;
            w.WriteStr(FClassName + FProps^[i].Name);

            aInfo := FProps^[i].PropType^;
            aData := GetTypeData(aInfo);

            aComp := GetTypeData(aData.CompType^);
            aMask := aInt;
            TWriterEx(w).WriteValue(vaSet);
            for j := aComp^.MinValue to aComp^.MaxValue do begin
              if (aMask and 1) <> 0 then begin
                aStr := GetEnumName(aData.CompType^,j);
                w.WriteStr(aStr);
              end;
              aMask := aMask shr 1;
            end;
            w.WriteListEnd;
            result := True;
          end;
          tkFloat : begin
            //  Float^̏
            if GetFloatProp(FObject,FProps^[i]) = 0 then Continue;
            w.WriteStr(FClassName + FProps^[i].Name);
            w.WriteFloat(GetFloatProp(FObject,FProps^[i]));
            result := True;
          end;
        end;
      end;
      rtBoolean : begin
        //  Boolean^̏
        aInt := GetOrdProp(FObject,FProps^[i].Name);
        if aInt = FProps^[i].Default then Continue;
        w.WriteStr(FClassName + FProps^[i].Name);
        w.WriteBoolean(Boolean(aInt));
        result := True;
      end;
      rtImitation : begin
        // UvpeB̏
        stm := TStringStream.Create(aStr);
        try
          w2 := TWriter.Create(stm,4096);
          try
            TPersistentEx(GetObjectProp(FObject,FProps^[i].Name)).DefineProperties(w2);
            w2.FlushBuffer;
          finally
            w2.Free;
          end;
          stm.Seek(0, soFromBeginning);
          r := TReaderEx.Create(stm,4096);
          try
            aStr := r.ReadStr;
            w.WriteStr(FClassName + FProps^[i].Name+'.'+aStr);
            ReaderToWriter(r,w);
          finally
            r.Free;
          end;
        finally
          stm.Free;
        end;
        result := True;
      end;
      rtClass : begin
        //  Class^̏
        aStmV := TObjStreamV.Create;
        try
          result := aStmV.WritePropertys(GetObjectProp(FObject,FProps^[i].Name),FClassName + FProps^[i].Name + '.',w,rtClass);
        finally
          aStmV.Free;
        end;
      end;
      rtComponent : begin
        //  Component^̏
        if FComponentSaved then begin
          aStmV := TObjStreamV.Create;
          try
            result := aStmV.WritePropertys(GetObjectProp(FObject,FProps^[i].Name),FClassName + FProps^[i].Name + '.',w,rtClass);
          finally
            aStmV.Free;
          end;
        end;  
      end;
    end;

  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@IuWFNgێĂpublishedpropertyǂݍށ@`         //
//                                                                          //
//   - Input -  r : ǂݍރXg[                                      //
//              p : ^                                                  //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//--------------------------------------------------------------------------//
function TObjStreamV.ReadStreamNormal(r: TReaderEx; p : PPropInfo): Boolean;
var
  Converter : TIdentToInt;
  aStr : string;
  aInt : Integer;
  CompData : PTypeData;
  Mask : Integer;
  aData  : PTypeData;
  i : Integer;
  pt: LongInt;
begin
  result := False;
  case CheckRttiType(p) of
    rtNormal: begin
      case p.PropType^.Kind of
        tkChar,
        tkWChar,
        tkInteger : begin
          //  Integer^̓ǂݍ
          Converter := FindIdentToInt(p.PropType^);
          if Assigned(Converter) then begin
            pt := r.Position;
            if r.ReadValue = vaIdent then begin
              aStr := r.ReadStr;
              Converter(aStr,aInt);
            end
            else begin
              r.Position := pt;
              aInt := r.ReadInteger;
            end
          end
          else begin
            aInt := r.ReadInteger;
          end;
          SetOrdProp(FObject,p,aInt);
          result := True;
        end;
        tkLString,
        tkWString,
        tkString : begin
          //  String^̓ǂݍ
          aStr := r.ReadString();
          SetStrProp(FObject,p,aStr);
          result := True;
        end;
        tkFloat : begin
          //  Float^̓ǂݍ
           SetFloatProp(FObject,p,r.ReadFloat);
          result := True;
        end;
        tkInt64 : begin
          //  Int64^̓ǂݍ
          SetInt64Prop(FObject,p,r.ReadInt64);
          result := True;
        end;
        tkEnumeration : begin
          //  񋓌^̓ǂݍ
          aInt := GetEnumValue(p.PropType^,r.ReadIdent);
          SetOrdProp(FObject,p,aInt);
          result := True;
        end;
        tkSet : begin
          //  W^̓ǂݍ
          aData := GetTypeData(p.PropType^);
          CompData := GetTypeData(aData.CompType^);
          Mask := 1;
          aInt := 0;
          r.ReadValue;
          while r.NextValue <> vaNull do begin
            aStr := r.ReadStr;
            for i := CompData^.MinValue to CompData^.MaxValue do begin
              aInt := aInt or (Mask shl GetEnumValue(aData.CompType^,aStr));
            end;
          end;
          r.ReadValue;
          SetOrdProp(FObject,p,aInt);
          result := True;
        end;
      end;
    end;
    rtBoolean : begin
      // Boolean^̓ǂݍ
      aInt := Integer(r.ReadBoolean);
      SetOrdProp(FObject,p,aInt);
      result := True;
    end;
    else begin
      result := True;
    end;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@IuWFNgǂݍށ@`                                          //
//                                                                          //
//   - Input -  r : ǂݍރXg[                                      //
//              w : oXg[                                      //
//              aRttiType : ^                                          //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//--------------------------------------------------------------------------//
function TObjStreamV.ReadStream(r: TReaderEx;w : TWriterEx;aRttiType: TRttiType): Boolean;
var
  s,s1,s2 : string;
  i,Len : Integer;
  aPos : Integer;
  f,ff : Boolean;
  aStmV : TObjStreamV;
  aStm : TStringStream;
  w2 : TWriter;
  r2 : TReaderEx;
begin
  ff := True;
  case aRttiType of
    rtRootClass,
    rtCollection : begin
      repeat
        f := False;
        aPos := r.Position;
        s := r.ReadStr;
        i := FPropNames.IndexOf(s);
        if i<>-1 then begin
          // ʏvpeB̏
          f := ReadStreamNormal(r,FProps[i]);
          //f := True;
        end
        else begin
          if CheckPod(s,s1,s2) then begin
            // sIh؂vpeB̏
            i := FPropNames.IndexOf(s1);
            if i<>-1 then begin
              aStmV := TObjStreamV.Create;
              try
                r.Position := aPos;
                aStmV.ReadPropertys(GetObjectProp(FObject,FProps^[i]),FClassName + FProps^[i].Name + '.',r,w,rtClass);
                f := True;
              finally
                aStmV.Free;
              end;
            end;
          end;
        end;
        if not f then begin
          // vpeB݂ȂƂǂݔ΂
          ReaderToWriter(r,nil);
        end;
      until r.NextValue = vaNull;
    end;
    rtClass : begin
      repeat
        aPos := r.Position;
        f := False;
        s := r.ReadStr;
        Len := Length(FClassName);
        if Copy(s,1,Len) = FClassName then begin
          s := Copy(s,Len+1,Length(s));
          if CheckPod(s,s1,s2) then begin
            i := FPropNames.IndexOf(s1);
            if i<>-1 then begin
              aStmV := TObjStreamV.Create;
              try
                r.Position := aPos;
                aStmV.ReadPropertys(GetObjectProp(FObject,FProps^[i]),FClassName + FProps^[i].Name + '.',r,w,rtClass);
                f := True;
              finally
                aStmV.Free;
              end;
            end;
          end
          else begin
            i := FPropNames.IndexOf(s);
            if i<>-1 then begin
              // ʏvpeB̏
              f := ReadStreamNormal(r,FProps[i]);
              //f := True;
            end
            else begin
              // NXł͂ȂUvpeB̂Ƃ
              aStm := TStringStream.Create(s);
              w2 := TWriter.Create(aStm,4096);
              try
                //w2.WriteStr(s2);
                w2.WriteStr(s);
                ReaderToWriter(r,w2);
                w2.FlushBuffer;
                aStm.Seek(0,soFromBeginning);
                r2 := TReaderEx.Create(aStm,4096);
                try
                  r2.ReadProperty(TPersistent(FObject));
                  //f := True;
                  ff := False;
                finally
                  r2.Free;
                end;
              finally
                w2.Free;
                aStm.Free;
              end;
              f := True;
            end;
          end;
        end;
        if not f then begin
          // ǂݍ񂾃vpeB̂̃IuWFNĝ̂ł͂ȂƂ
          // ǂݍޑȌԂɖ߂
          r.Position := aPos;
          break;
        end;
      until r.NextValue = vaNull;
    end;
  end;
  result := ff;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@IuWFNgށiwb_Atb^j@`                      //
//                                                                          //
//   - Input -  w          : oXg[                             //
//              aClassName : IuWFNg                               //
//              aRttiType : ^                                          //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TObjStreamV.WriteStreamRoot(w : TWriter; aClassName: string;aRttiType : TRttiType);
var
  s : string;
  aPosition : Integer;
begin
  s := '';
  aPosition := w.Position;            // ÔƂ̖߂ʒuL
  if FData^.PropCount = 0 then exit;
  case aRttiType of
    rtRootClass : begin
                      w.WriteStr(FInfo.Name);
                      if FObject is TComponent then begin
                        s := GetStrProp(FObject,'name');
                        if s <> '' then begin
                          w.WriteStr(s);
                        end
                        else begin
                          w.WriteListEnd;
                        end;
                      end;
                   end;
    rtCollection : begin
                      //w.WriteListEnd;
                      w.WriteStr(FInfo.Name);
                      if FObject is TComponent then begin
                        s := GetStrProp(FObject,'name');
                        if s <> '' then begin
                          w.WriteStr(s);
                        end
                        else begin
                          w.WriteListEnd;
                        end;
                      end;
                   end;
    rtComponent : begin
                    w.WriteListEnd;
                    w.WriteStr(FInfo.Name);
                    w.WriteStr(aClassName);
                  end;
  end;

  if WriteStream(w) then begin
    case aRttiType of
      rtCollection :begin
                      w.WriteListEnd;
                      w.WriteListEnd;
                    end;
      rtRootClass : begin
                      w.WriteListEnd;
                    end;
      rtClass :     begin
                      //w.WriteListEnd;
                    end;
      rtComponent : begin
                      w.WriteListEnd;
                    end;
    end;

  end
  else begin
    w.Position := aPosition;              // ݑȌԂɖ߂
  end;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@IuWFNgǂݍށiwb_Atb^j@`                      //
//                                                                          //
//   - Input -  r          : ǂݍރXg[                             //
//              w          : oXg[                             //
//              aClassName : IuWFNg                               //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TObjStreamV.ReadStreamRoot(r: TReaderEx;w : TWriterEx; aClassName: string;
  aRttiType: TRttiType);
begin
  case aRttiType of
    rtRootClass : begin
                      r.ReadStr();
                      if FObject is TComponent then begin
                        if r.NextValue = vaNull then begin
                          r.ReadListEnd;
                        end
                        else begin
                          r.ReadStr();
                        end;
                      end;
                   end;
    rtCollection : begin
                      //r.ReadListEnd;
                      r.ReadStr();
                      if FObject is TComponent then begin
                        if r.NextValue = vaNull then begin
                          r.ReadListEnd;
                        end
                        else begin
                          r.ReadStr();
                        end;
                      end;
                   end;
  end;

  if ReadStream(r,w,aRttiType) then begin
    case aRttiType of
      rtCollection :begin
                      r.ReadListEnd;
                      r.ReadListEnd;
                    end;
      rtRootClass : begin
                      r.ReadListEnd;
                    end;  
      rtClass :     begin
                      //r.ReadListEnd;
                    end;
      rtComponent : begin
                      r.ReadListEnd;
                    end;
    end;

  end
  
end;

{ THashedStringListV }
{$IFNDEF VER_OVER6}

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//**************************************************************************//
constructor THashedStringListV.Create;
begin
  FList := TStringList.Create;
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//**************************************************************************//
destructor THashedStringListV.Destroy;
var
  i : Integer;
begin
  FList.Free;
  for i := 0 to High(FTbl) do begin
    if FTbl[i] <> nil then FTbl[i].Free;
  end;

  inherited;

end;

//**************************************************************************//
//                                                                          //
//  `@nbVXgɒlǉ@`                                        //
//                                                                          //
//   - Input -  S : ǉ镶                                          //
//                                                                          //
//   - Output - ǉʒu                                                //
//                                                                          //
//**************************************************************************//
function THashedStringListV.Add(const S: string): Integer;
var
  i : Integer;
begin
  i := GetHashedIndex(S);
  if FTbl[i] = nil then begin
    FTbl[i] := TList.Create;
  end;
  result := FList.Add(S);
  FTbl[i].Add(Pointer(result));
  FCnt := FCnt + 1;
end;

//**************************************************************************//
//                                                                          //
//  `@nbVXg@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure THashedStringListV.Clear;
var
  i : Integer;
begin
  for i := 0 to High(FTbl) do begin
    if FTbl[i] <> nil then FTbl[i].Free;
  end;
  FCnt := 0;
end;

//**************************************************************************//
//                                                                          //
//  `@񂩂nbVlvZ@`                                  //
//                                                                          //
//   - Input -  s : nbVlvZ镶                              //
//                                                                          //
//   - Output - nbVl                                                  //
//                                                                          //
//**************************************************************************//
function THashedStringListV.GetHashedIndex(const S: string): Integer;
var
  i,c : Integer;
begin
  c := 0;
  for i := 1 to Length(S) do begin
    c := c * 37 + Ord(S[i]);
    c := c mod (High(FTbl)+1);
  end;
  result := c;
end;

//**************************************************************************//
//                                                                          //
//  `@nbVXg̈̕ʒu擾@`                            //
//                                                                          //
//   - Input -  s : 镶                                          //
//                                                                          //
//   - Output - -1 : ݂Ȃ @ȊO : CfbNXl                 //
//                                                                          //
//**************************************************************************//
function THashedStringListV.IndexOf(const S: string): Integer;
var
  i,j,k : Integer;
begin
  result := -1;
  i := GetHashedIndex(S);
  if FTbl[i] = nil then exit;
  for j := 0 to FTbl[i].Count-1 do begin
    k := Integer(FTbl[i].Items[j]);
    if S = FList[k] then begin
      result := k;
      exit;
    end;
  end;
end;
{$ENDIF}

end.
