unit PanelSuicaHist;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,ListViewV,FelicaLibV,DBFelica;

//--------------------------------------------------------------------------//
//  Suicapf[^ǗNXޏowǗłlɊg             //
//--------------------------------------------------------------------------//
type
  TFeliCaLibSuicaHistItemEx = class(TFeliCaLibSuicaHistItem)
  private
    { Private 錾 }
    FInStationName: string;
    FInCompanyName: string;
    FOutStationName: string;
    FOutCompanyName: string;
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    // H
    property InCompanyName : string read FInCompanyName;
    // w
    property InStationName : string read FInStationName;
    // oHiƂƂ悻HɂȂj
    property OutCompanyName : string read FOutCompanyName;
    // ow
    property OutStationName : string read FOutStationName;
  end;

//--------------------------------------------------------------------------//
//  SuicapꗗǗNXiĒ`j                                   //
//--------------------------------------------------------------------------//
type
  TFelicaLibSuicaHistItemExs = class(TFelicaLibSuicaHistItems)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TFeliCaLibSuicaHistItemEx;
  public
    { Public 錾 }
    function Add() : TFeliCaLibSuicaHistItemEx;
    property Items[Index: Integer] : TFeliCaLibSuicaHistItemEx read GetItems;default;
  end;

//--------------------------------------------------------------------------//
//  Suicapꗗ\NX                                             //
//--------------------------------------------------------------------------//
type
  TPanelSuicaHist = class(TPanel)
  private
    { Private 錾 }
    FItems : TFelicaLibSuicaHistItemExs; // pXg
    FListV : TListViewV;                 // ꗗ\NX
    //FDataBase: TFeliCaDB;                // pwf[^x[X
    FDataBase: TDBFeliCaItems;

    // ꗗ̃J\
    procedure ShowColumn();
    // ꗗ`Cxg
    procedure OnListViewDrawItem(Canvas : TCanvas;Column,Index: Integer;
                                         Rect: TRect; State: TOwnerDrawState);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy;override;
    // \
    procedure Show();

    // ǉ
    procedure Add(dh : TFelicaLibSuicaHistItem);
    // NA
    procedure Clear();
    // f[^x[XiԂQƂ̂݁j
    //property DataBase : TFeliCaDB read FDataBase write FDataBase;
    // f[^x[XiԂQƂ̂݁j
    property DataBase : TDBFeliCaItems read FDataBase write FDataBase;

  end;

implementation

{ TPanelSuicaHist }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TPanelSuicaHist.Create(AOwner: TComponent);
begin
  inherited;
  FItems := TFelicaLibSuicaHistItemExs.Create;
  FListV := TListViewV.Create(Self);
  FListV.Parent := Self;
  FListV.Align := alClient;
  FListV.OnDrawItem := OnListViewDrawItem;  // `Cxg̎󂯎w
  FListV.Style := lvOwnerDrawFixed;         // ŕ`悷鎖w
  FListV.Font.Height := -12;                // tHg̍PUhbg
end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TPanelSuicaHist.Destroy;
begin
  FListV.Free;
  FItems.Free;
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@\ɍs@`                                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TPanelSuicaHist.Show;
begin
  ShowColumn();
end;

//**************************************************************************//
//                                                                          //
//  `@\Ƀf[^ǉ@`                                          //
//                                                                          //
//   - Input -  dh : ǉ闚NX                                     //
//   - Output - Ȃ                                                        //
//                                                                          //
//  ǉɉwȂǂ擾Ă                                    //
//                                                                          //
//**************************************************************************//
procedure TPanelSuicaHist.Add(dh: TFelicaLibSuicaHistItem);
var
  d : TListViewVItem;
  d2 : TFeliCaLibSuicaHistItemEx;
begin
  d2 := FItems.Add();          // ẘ݂ǗNXɃf[^ǉ
  d2.Assign(dh);               // l
  {
  if DataBase.Search(dh.InCode,dh.InStation) then begin  // wꍇ
    d2.FInCompanyName := DataBase.CompanyName;           // H
    d2.FInStationName := DataBase.StationName;           // w
  end;

  if DataBase.Search(dh.OutCode,dh.OutStation) then begin
    d2.FOutCompanyName := DataBase.CompanyName;          // H
    d2.FOutStationName := DataBase.StationName;          // w
  end;
  }
  if DataBase.Search(dh.AreaCode,dh.InCode,dh.InStation) then begin  // wꍇ
    d2.FInCompanyName := FDataBase.Items[0].CompanyName;           // H
    d2.FInStationName := FDataBase.Items[0].StationName;           // w
  end;

  if DataBase.Search(dh.AreaCode,dh.OutCode,dh.OutStation) then begin  // wꍇ
    d2.FInCompanyName := FDataBase.Items[0].CompanyName;           // H
    d2.FInStationName := FDataBase.Items[0].StationName;           // w
  end;

  d := FListV.Items.Add();                               // \ɒǉ
  d.Data := d2;                                          // ֘AÂ
end;

//**************************************************************************//
//                                                                          //
//  `@NA@`                                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TPanelSuicaHist.Clear;
begin
  FListV.Items.Clear;
  FItems.Clear;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ ꗗ̃J\@`                                               //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelSuicaHist.ShowColumn;
var
  dc :TListViewVColumn;
begin
  FListV.Items.BeginUpdate();
  FListV.Color := clWhite;             // wi𔒐F
  FListV.ListColor := clWhite;         // eڂ𔒐F
  FListV.ItemHeight := 22;             // Ps̍QQhbgɎw

  FListV.Columns.Clear;

  dc := FListV.Columns.Add;
  dc.Caption := 't';
  dc.Width := 8*13;
  dc.WidthLocked := True;

  dc := FListV.Columns.Add;
  dc.Caption := '';
  dc.Width := 8*10;
  dc.WidthLocked := True;

  dc := FListV.Columns.Add;
  dc.Caption := '@';
  dc.Width := 8*10;
  dc.WidthLocked := True;

  dc := FListV.Columns.Add;
  dc.Caption := '';
  dc.Width := 8*10;
  dc.WidthLocked := True;

  dc := FListV.Columns.Add;
  dc.Caption := 'H';
  dc.Width := 8*20;
  dc.WidthLocked := True;

  dc := FListV.Columns.Add;
  dc.Caption := 'ԉw';
  dc.Width := 8*10;
  dc.WidthLocked := True;

  dc := FListV.Columns.Add;
  dc.Caption := '~ԉw';
  dc.Width := 8*10;
  dc.WidthLocked := True;

  dc := FListV.Columns.Add;
  dc.Caption := 'z';
  dc.Width := 8*10;
  dc.WidthLocked := True;

  FListV.Items.EndUpdate();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ ꗗ`Cxg@`                                               //
//                                                                          //
//   - Input -  ȗ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelSuicaHist.OnListViewDrawItem(Canvas: TCanvas; Column,
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  dh : TFeliCaLibSuicaHistItemEx;
  dd : TDateTimeCtrl;
  cv : TCanvas;
  x,y : Integer;
  s : string;
begin
  dh :=  TFeliCaLibSuicaHistItemEx(FListV.Items[Index].Data);
  cv := Canvas;
  x := Rect.Left + 1;
  y := Rect.Top + 1;
  cv.Font.Color := clBlack;
  cv.Brush.Color := clWhite;
  s := '';
  if dh = nil then begin
    cv.TextRect(Rect,x,y,s);
    exit;
  end;
  case Column of
    0:  begin
          //s := TimeToStr(d.DateTime);
          dd := dh.DateTime;
          s := Format('%4.4d/%2.2d/%2.2d',[dd.Yer,dd.Mon,dd.Day]);
          cv.TextRect(Rect,x,y,s);
        end;
    1:  begin
          //s := TimeToStr(d.DateTime);
          if dh.TimeEnabled then begin
            dd := dh.DateTime;
            s := Format('%2.2d:%2.2d:%2.2d',[dd.Hou,dd.Min,dd.Sec]);
          end
          else begin
            s := ''; 
          end;
          cv.TextRect(Rect,x,y,s);
        end;
    2:  begin
          s := dh.MatineName;
          cv.TextRect(Rect,x,y,s);
        end;
    3:  begin
          s := s + dh.ProcName;
          cv.TextRect(Rect,x,y,s);
        end;
    4:  begin
          s := dh.InCompanyName;
          cv.TextRect(Rect,x,y,s);
        end;
    5:  begin
          s := dh.InStationName;
          cv.TextRect(Rect,x,y,s);
        end;
    6:  begin
          if dh.OutCode = 0 then begin
            s := '';
          end
          else begin
            s := dh.OutStationName;
          end;
          cv.TextRect(Rect,x,y,s);
        end;
    7:  begin
          s := '\'+IntToStr(dh.MoneySpent);
          cv.TextRect(Rect,x,y,s);
        end;
  end;
end;

{ TFelicaLibSuicaHistItemExs }

function TFelicaLibSuicaHistItemExs.Add: TFeliCaLibSuicaHistItemEx;
var
  d : TFelicaLibSuicaHistItemEx;
begin
  d := TFelicaLibSuicaHistItemEx.Create;
  TList(Self).add(d);
  result := d;
end;

function TFelicaLibSuicaHistItemExs.GetItems(
  Index: Integer): TFeliCaLibSuicaHistItemEx;
begin
  result := TFeliCaLibSuicaHistItemEx(inherited Items[Index]);
end;

{ TFeliCaLibSuicaHistItemEx }

procedure TFeliCaLibSuicaHistItemEx.Assign(Source: TPersistent);
var
  a : TFeliCaLibSuicaHistItemEx;
begin
  if Source is TFeliCaLibSuicaHistItemEx then begin
    a := TFeliCaLibSuicaHistItemEx(Source);
    FInCompanyName := a.FInCompanyName;
    FInStationName := a.FInStationName;
    FOutCompanyName := a.FOutCompanyName;
    FOutStationName := a.FOutStationName;
    inherited;
  end
  else begin
    inherited;
  end;
end;

end.
