//**********************************************************************//
//                                                                      //
//  ` ListView̕sȌۉ̂߂̓ƎListViewNX `          //
//                                                                      //
//    ʓIȃp[cō\Ă                                    //
//                                                                      //
//  2006/07/24 TListViewVItemsNXBeginUpdate  EndUpdateǉ      //
//                                                                      //
//  2006/07/24 TListViewVItemsNXObjects[]ǉ                   //
//                                                                      //
//**********************************************************************//
unit ListViewV;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls;

type TListViewVStyle = (lvStandard, lvOwnerDrawFixed);
type TListViewVDrawItemEvent = procedure(Canvas : TCanvas;Column,Index: Integer;
                                         Rect: TRect; State: TOwnerDrawState) of object;
type TListViewVColumnClickEvent = procedure(Sender: TObject; Column: Integer) of object;

type
  TPanelEx = class(TPanel)
  public
    { Public 錾 }
    property Canvas;
  end;
//--------------------------------------------------------------------------//
//  ƎListView̃Jf[^ǗNX                              //
//--------------------------------------------------------------------------//
type
  TListViewVColumn = class(TPersistent)
  private
    { Private 錾 }
    FOwner : Pointer;                     // TListViewVw
    FCaption: string;                     // s^Cgɕ\镶
    FIndex : Integer;                     // ڂ\iO`j
    FWidth: Integer;                      // 
    FMinWidth: Integer;                   // ŏ
    FMaxWidth: Integer;                   // ő啝(OȂ疳)
    FAlignment: TAlignment;               // LvV\ʒu
    FWidthLocked : Boolean;               // True : TCYύXs
    procedure SetCaption(const Value: string);
    procedure SetWidth(const Value: Integer);
    procedure SetAlignment(const Value: TAlignment);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    property Caption : string read FCaption write SetCaption;
    property Width : Integer read FWidth write SetWidth;
    property MinWidth : Integer read FMinWidth write FMinWidth;
    property MaxWidth : Integer read FMaxWidth write FMaxWidth;
    property Alignment: TAlignment read FAlignment write SetAlignment;
    property WidthLocked : Boolean read FWidthLocked write FWidthLocked;
  end;

//--------------------------------------------------------------------------//
//  ƎListView̃JꗗǗNX                                //
//--------------------------------------------------------------------------//
type
  TListViewVColumns = class(TList)
  private
    { Private 錾 }
    FOwner : Pointer;                     // TListViewVw
    function GetItems(Index: Integer): TListViewVColumn;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TListViewVColumns) ;
    function Add() : TListViewVColumn;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TListViewVColumn read GetItems;default;
  end;


//--------------------------------------------------------------------------//
//  ƎListView̕\ItemǗNX                                  //
//--------------------------------------------------------------------------//
type
  TListViewVItem = class(TPersistent)
  private
    { Private 錾 }
    FStrings : TStringList;                   // Ps̕f[^
    FOwner : Pointer;                         // TListViewVw
    FIndex : Integer;                         // sڂ\iO`j
    FData: Pointer;                           // ֘AÂf[^
    procedure OnChange(Sender: TObject);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    property Strings : TStringList read FStrings;
    property Data : Pointer read FData write FData;
  end;

//--------------------------------------------------------------------------//
//  ƎListView̕\ItemXgǗNX                            //
//--------------------------------------------------------------------------//
type
  TListViewVItems = class(TList)
  private
    { Private 錾 }
    FOwner : Pointer;                         // TListViewVw
    function GetItems(Index: Integer): TListViewVItem;
    function GetObjects(Index: Integer): Pointer;
  public
    { Public 錾 }
    destructor Destroy;override;
    function Add() : TListViewVItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    function Insert(Index: Integer) : TListViewVItem;

    procedure BeginUpdate();
    procedure EndUpdate();
    property Items[Index: Integer] : TListViewVItem read GetItems;default;
    property Objects[Index : Integer] : Pointer read GetObjects;
  end;

//--------------------------------------------------------------------------//
//  JplNX                                              //
//--------------------------------------------------------------------------//
type
  TListViewVPanelColumns = class(TPanel)
  private
    { Private 錾 }
    FList : TList;                           // plێ郊Xg
    FMoveFlag : Boolean;                     // True : J[\񕝕ύXʒuɂ
    FMoveX : Integer;                        // Õ}EXWێiwj
    FMoveY : Integer;                        // Õ}EXWێixj
    FMoveCurDown : Boolean;                  // True : 񕝕ύX
    FMoveXOld : Integer;                     // ߋ̐ߍWێ
    FCurLineFlag : Boolean;                  // True:ʂɕ`

    function Add() : TPanel;
    procedure Clear();
    function GetItems(Index: Integer): TPanel;
    property Items[Index : Integer] : TPanel read GetItems;

    procedure DrawMoveCursol(const aLeft,X : Integer);

    procedure OnSubMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure OnSubMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure OnSubMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ColumnMove(const Index : Integer;const MoveX : Integer);
    procedure ViewColumn();

  public
    { Public 錾 }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;
  end;

//--------------------------------------------------------------------------//
//  ƎScrollBarNX(Visible̕ύXCxg𔭐)                //
//--------------------------------------------------------------------------//
type
  TListViewVScrollBar = class(TScrollBar)
  private
    { Private 錾 }
    FOnVisibleChange: TNotifyEvent;
    function GetVisible: Boolean;
    procedure SetVisible(const Value: Boolean);
    procedure DoVisibleChange();
  public
    { Public 錾 }
  published
    property Visible : Boolean read GetVisible write SetVisible;
    property OnVisibleChange : TNotifyEvent read FOnVisibleChange write FOnVisibleChange;
  end;

//--------------------------------------------------------------------------//
//  ƎListBoxNX                                                      //
//--------------------------------------------------------------------------//
type
  TListViewVListBox = class(TListBox)
  private
    { Private 錾 }
    procedure OnSelfDrawItem(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
    function GetShowCount: Integer;
    procedure OnSelfClick(Sender: TObject);
    procedure OnSelfDblClick(Sender: TObject);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure WMMousewheel(var Msg: TMessage); message WM_MOUSEWHEEL;

    function CheckOver() : Boolean;
    function GetOverCount() : Integer;
    property ShowCount : Integer read GetShowCount;
  end;

//--------------------------------------------------------------------------//
//  ƎScrollBoxNX                                                     //
//--------------------------------------------------------------------------//
type
  TListViewVScrollBox = class(TPanel)
  private
    { Private 錾 }
    FPanel : TPanel;                              // \\̈
    FPanelClient : TPanel;                        // zu̎̂upl
    FHorzScrollBar : TListViewVScrollBar;         // XN[o[
    FVertScrollBar : TListViewVScrollBar;         // cXN[o[
    procedure OnSelfResize(Sender: TObject);
    procedure OnClientResize(Sender: TObject);
    procedure OnHorzScrollBarChange(Sender: TObject);
    procedure OnVertScrollBarChange(Sender: TObject);
    procedure OnHorzScrollBarVisibleChange(Sender: TObject);
    procedure OnVertScrollBarVisibleChange(Sender: TObject);

    procedure DoSelfResize();

    procedure ViewChangeHorzBar();
    procedure ViewChangeVertBar();
    procedure ViewChangeClientHeight();
    procedure ViewClient();

    procedure CheckOverWidth();
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;
    property PanelClient : TPanel read FPanelClient;
    property HorzScrollBar: TListViewVScrollBar read FHorzScrollBar;
    property VertScrollBar: TListViewVScrollBar read FVertScrollBar;
  end;

//--------------------------------------------------------------------------//
//  ƎListViewNX                                                      //
//--------------------------------------------------------------------------//
type
  TListViewV = class(TPanel)
  private
    { Private 錾 }
    FItems : TListViewVItems;               // svfێ郊Xg
    FColumns : TListViewVColumns;           // \ێ郊Xg
    FPanelColumn : TListViewVPanelColumns;  // \\pplNX
    FListBoxV : TListViewVListBox;          // vf\pListBox
    FScrBoxV : TListViewVScrollBox;         // ƎXN[{bNX
    FColumnHeight: Integer;                 // \̍
    FOnListClick: TNotifyEvent;             // zC[ɂړ
    FOnDrawItem: TListViewVDrawItemEvent;
    FStyle: TListViewVStyle;
    FOnColumnClick: TListViewVColumnClickEvent;
    FMouseWheelLine: Integer;
    FOnListDblClick: TNotifyEvent;
    FOnHorzScrollBarChange: TNotifyEvent;
    FOnVertScrollBarChange: TNotifyEvent;

    procedure DoListBoxChange();

    procedure OnSelfResize(Sender: TObject);
    procedure SetColumnHeight(const Value: Integer);

    procedure DoListClick();
    procedure DoListDblClick();
    procedure DoDrawItem(Column,Index: Integer;
                         Rect: TRect; State: TOwnerDrawState);
    procedure DoColumnClick(Column: Integer);

    function GetItemIndex: Integer;
    function GetItemHeight: Integer;
    procedure SetItemHeight(const Value: Integer);
    procedure SetItemIndex(const Value: Integer);
    function GetListColor: TColor;
    procedure SetListColor(const Value: TColor);
    function GetColor: TColor;
    procedure SetColor(const Value: TColor);
    function GetDebugPanel: TPanel;
    function GetListShowCount: Integer;
    function GetOnListMouseDown: TMouseEvent;
    procedure SetOnListMouseDown(const Value: TMouseEvent);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;
    procedure Loaded();override;
    procedure Refresh();
    procedure Paint; override;

    function MousePosToColIndex(const X : Integer) : Integer;
    function MousePosToRowIndex(const Y : Integer) : Integer;
    function ColRowToRect(const X,Y : Integer) : TRect;

    property Columns : TListViewVColumns read FColumns;
    property ColumnHeight : Integer read FColumnHeight write SetColumnHeight;
    property Style : TListViewVStyle read FStyle write FStyle;
    property ItemHeight : Integer read GetItemHeight write SetItemHeight;
    property MouseWheelLine : Integer read FMouseWheelLine write FMouseWheelLine;

    property Items : TListViewVItems read FItems;
    property ItemIndex : Integer read GetItemIndex write SetItemIndex;

    property ListColor : TColor read GetListColor write SetListColor;
    property Color : TColor read GetColor write SetColor;

    property OnListClick : TNotifyEvent read FOnListClick write FOnListClick;
    property OnListDblClick : TNotifyEvent read FOnListDblClick write FOnListDblClick;
    property OnListMouseDown : TMouseEvent read GetOnListMouseDown write SetOnListMouseDown;
    //property OnListKeyPress :
    property OnDrawItem : TListViewVDrawItemEvent read FOnDrawItem write FOnDrawItem;
    property OnColumnClick : TListViewVColumnClickEvent read FOnColumnClick write FOnColumnClick;

    property OnHorzScrollBarChange : TNotifyEvent read FOnHorzScrollBarChange write FOnHorzScrollBarChange;
    property OnVertScrollBarChange : TNotifyEvent read FOnVertScrollBarChange write FOnVertScrollBarChange;

    property ListShowCount : Integer read GetListShowCount;

    property DebugPanel : TPanel read GetDebugPanel;
  end;


implementation

{ ListViewV }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TListViewV.Create(AOwner: TComponent);
begin
  inherited;

  FColumnHeight := 20;                                 // J̍l
  FMouseWheelLine := 2;                                // zC[ړl

  FItems := TListViewVItems.Create;                    // sf[^ێpXg
  FItems.FOwner := Self;                               // TListViewVQƂ
  BevelOuter := bvLowered;                             // [߂ɉ܂ĕ\
  BevelWidth := 2;                                     //

  FScrBoxV := TListViewVScrollBox.Create(Self);        // ƎXN[{bNX
  FScrBoxV.Parent := Self;                             // gɓ\t
  FScrBoxV.Align := alClient;                          // ڈtL

  FColumns := TListViewVColumns.Create;                // Jf[^ێpXg
  FColumns.FOwner := Self;                             // TListViewVQƂ

  FPanelColumn := TListViewVPanelColumns.Create(Self); // J\ppl
  FPanelColumn.Parent := FScrBoxV.PanelClient;         // ƎXN[{bNXɏ悹
  FPanelColumn.Height := FColumnHeight;                // 𒲐
  FPanelColumn.BevelOuter := bvNone;                   // \tbg

  FListBoxV := TListViewVListBox.Create(Self);         // ƎXg{bNX
  FListBoxV.Parent := FScrBoxV.PanelClient;            // ƎXN[{bNXɏ悹
  FListBoxV.Top := FPanelColumn.Height;                // J\̉ɔzu
  FListBoxV.Width := Width;                            // ڈtƂ
  FListBoxV.Height := Height - FPanelColumn.Height;    // 𒲐
  FListBoxV.BorderStyle := bsNone;                     // \tbg
  FListBoxV.Style := lbOwnerDrawFixed;                 // ŕ`悷邱Ƃʒm
  //FListBoxV.OnKeyDown := fon

  OnResize := OnSelfResize;

end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TListViewV.Destroy;
begin
  FListBoxV.Free;
  FListBoxV := nil;
  FPanelColumn.Free;
  FPanelColumn := nil;
  FColumns.Free;
  FColumns := nil;
  FScrBoxV.Free;
  FScrBoxV := nil;
  FItems.Free;
  FItems := nil;
  inherited;
end;


procedure TListViewV.Loaded;
begin
  inherited;
  //DoListBoxChange();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@CplTCYύXCxg@`                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewV.OnSelfResize(Sender: TObject);
begin
  FScrBoxV.ViewClient();
  DoListBoxChange();

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@J̍ύXCxg@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewV.SetColumnHeight(const Value: Integer);
begin
  FColumnHeight := Value;
  FPanelColumn.Height := Value;
  FPanelColumn.ViewColumn;
end;

procedure TListViewV.DoListClick;
begin
  if Assigned(FOnListClick) then FOnListClick(Self);
end;

procedure TListViewV.DoListDblClick;
begin
  if Assigned(FOnListDblClick) then FOnListDblClick(Self);
end;


//--------------------------------------------------------------------------//
//                                                                          //
//  `@I[i[`Cxg@`                                            //
//                                                                          //
//   - Input -  Column : `悷                                         //
//              Index  : `悷s                                         //
//              Rect   : `̈                                           //
//              State  : `捀ڂ̏                                     //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewV.DoDrawItem(Column, Index: Integer; Rect: TRect;
  State: TOwnerDrawState);
begin
  if Assigned(FOnDrawItem) then FOnDrawItem(FListBoxV.Canvas,Column,Index,Rect,State);
end;

procedure TListViewV.DoColumnClick(Column: Integer);
begin
  if Assigned(FOnColumnClick) then FOnColumnClick(Self,Column);
end;

function TListViewV.GetItemIndex: Integer;
begin
  result := FListBoxV.ItemIndex;
end;

function TListViewV.GetItemHeight: Integer;
begin
  result := FListBoxV.ItemHeight;
end;

procedure TListViewV.SetItemHeight(const Value: Integer);
begin
  FListBoxV.ItemHeight := Value;
end;

procedure TListViewV.Refresh;
begin
  inherited;
  FListBoxV.Refresh;
  FPanelColumn.FCurLineFlag := False;
end;

procedure TListViewV.SetItemIndex(const Value: Integer);
begin
  FListBoxV.ItemIndex := Value;
  FScrBoxV.FVertScrollBar.Position := FListBoxV.TopIndex;    // XN[o[̏Ԃ킹
end;

{ TListViewVColumns }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TListViewVColumns.Create;
begin

end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TListViewVColumns.Destroy;
begin
  Clear();
  inherited;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@J̒ǉ@`                                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - ǉf[^                                              //
//                                                                          //
//--------------------------------------------------------------------------//
function TListViewVColumns.Add: TListViewVColumn;
var
  d : TListViewVColumn;
  dp : TPanel;
  dv : TListViewV;
begin
  dv := TListViewV(FOwner);                // TListViewVւ̎Q
  d := TListViewVColumn.Create;            // Jf[^
  d.FOwner := FOwner;                      // TListViewV֎QƂ
  d.FIndex := Count;                       // ڂm点
  inherited Add(d);                        // TListɃ|C^ǉ
  dp := dv.FPanelColumn.Add();             // Jpplǉ
  dp.Width := d.Width;                     // ̏l
  dp.Alignment := d.Alignment;             // LvV\ʒu
  dv.FPanelColumn.ViewColumn();            // SJ̉𒲐
  result := d;                             // ǉJf[^Ԃ
end;

procedure TListViewVColumns.Assign(Source: TListViewVColumns);
begin

end;

procedure TListViewVColumns.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TListViewVColumns.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TListViewVColumns.GetItems(Index: Integer): TListViewVColumn;
begin
  result := inherited Items[Index];
end;

{ TListViewVColumn }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TListViewVColumn.Create;
begin
  FWidth := 50;                // J̉lZbg
  FMinWidth := 16;
  FAlignment := taLeftJustify;
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TListViewVColumn.Destroy;
begin
  inherited;

end;

procedure TListViewVColumn.Assign(Source: TPersistent);
begin
  inherited;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Jɕ\镶ύXCxg@`                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVColumn.SetCaption(const Value: string);
var
  dp : TListViewVPanelColumns;
begin
  FCaption := Value;                       // ϐɊi[
  dp := TListViewV(FOwner).FPanelColumn;
  dp.Items[FIndex].Caption := Value;       // J̕\ɔf
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@J̉ύXCxg@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVColumn.SetWidth(const Value: Integer);
var
  dv : TListViewV;
begin
  dv := TListViewV(FOwner);                        // TListViewVQ
  FWidth := Value;                                 // ϐɊi[
  dv.FPanelColumn.Items[FIndex].Width := Value;    // plɔf
  dv.FPanelColumn.ViewColumn();                    // ωpl̉Ëʒu킹
end;

procedure TListViewVColumn.SetAlignment(const Value: TAlignment);
var
  dv : TListViewV;
begin
  dv := TListViewV(FOwner);                         // TListViewVQ
  FAlignment := Value;                              // ϐɊi[
  dv.FPanelColumn.Items[FIndex].Alignment := Value; // plɔf
end;

{ TListViewVPanelColumns }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TListViewVPanelColumns.Create(AOwner: TComponent);
begin
  inherited;
  AutoSize := True;               // JʂɉăTCYύX
  FList := TList.Create;          // plێpXg𐶐
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TListViewVPanelColumns.Destroy;
begin
  Clear();
  FList.Free;
  inherited;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@J\p̃plǉ@`                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - ǉf[^                                              //
//                                                                          //
//   NXQƂTListViewVColumngp邱                       //
//     TListViewVColumnύXƁÃNXɎIɔf         //
//                                                                          //
//--------------------------------------------------------------------------//
function TListViewVPanelColumns.Add: TPanel;
var
  d,d2 : TPanel;
  dv : TListViewV;
begin
  dv := TListViewV(Owner);                 // TListViewVQ
  d := TPanel.Create(Self);                // plǉ
  d.Parent := Self;                        // gɓ\t
  d.Top := 0;                              // xWO
  d.Left := 0;                             // wWO
  d.Height := dv.FColumnHeight;            // 𒲐
  d.Tag := FList.Count;                    // ڂ̃pli[
  d.OnMouseDown := OnSubMouseDown;         // }EX~Cxg蓖
  d.OnMouseMove := OnSubMouseMove;         // }EXړCxg蓖
  d.OnMouseUp := OnSubMouseUp;             // }EX㏸Cxg蓖
  if FList.Count > 0 then begin            // Qڈȍ~̏ꍇ
    d2 := Items[FList.Count-1];            // ̃plQ
    d.Left := d2.Left + d2.Width;          // ̃plɑ悤ɍĔzu
  end;
  FList.Add(d);                            // TList^Ƀ|C^ǉ
  result := d;                             // ǉf[^Ԃ

end;

procedure TListViewVPanelColumns.Clear;
var
  i : Integer;
begin
  for i := FList.Count-1 downto 0 do begin
    Items[i].Free;
  end;
  FList.Clear;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@J̉ύX@`                                            //
//                                                                          //
//   - Input -  Index : ύXJԍ                                  //
//              MoveX : ύX鉡̑l                                //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVPanelColumns.ColumnMove(const Index, MoveX: Integer);
var
  dv : TListViewV;
  d : TListViewVColumn;
  j : Integer;
begin
  dv := TListViewV(Owner);               // TListViewVQ
  d := dv.Columns[Index];                // lێpNXQ
  j := d.Width + MoveX;
  if j <= d.MinWidth then begin
    d.Width := d.MinWidth;
  end
  else if (d.MaxWidth > 0) and (j >= d.MaxWidth) then begin
    d.Width := d.MaxWidth;
  end
  else begin
    d.Width := j;                        // ύX
  end;
end;

function TListViewVPanelColumns.GetItems(Index: Integer): TPanel;
begin
  result := TPanel(FList[Index]);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@}EX~Cxg@`                                              //
//                                                                          //
//   - Input -  Sender : Cxg̃pl                                 //
//              Button : }EX{^̏                                 //
//              Shift  : ShiftL[̏                                    //
//              X,Y    : }EXW                                         //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVPanelColumns.OnSubMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  d : TPanel;
  dv : TListViewV;
  dc : TListViewVColumn;
  i : Integer;
begin
  dv := TListViewV(Owner);           // TListViewVQ
  d := TPanel(Sender);               // ďoplQ
  i := d.Tag;                        // ڂ̃pl擾
  dc := dv.FColumns[i];              // Jݒf[^Q
  if not FMoveFlag then begin        // Jgꂽꍇ
    d.BevelOuter := bvLowered;       // ڂ܂
    dv.DoColumnClick(i);
  end
  else begin                         // JƃJ̊Ԃꂽꍇ
    if dc.WidthLocked then exit;     // bNw肪ꍇ
    FMoveX := X;                     // }EXʒu擾
    FMoveY := Y;
    FCurLineFlag := False;           // J[\`tOZbg
    FMoveCurDown := True;            // Jړ邱Ƃm点
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@}EXړCxg@`                                              //
//                                                                          //
//   - Input -  Sender : Cxg̃pl                                 //
//              Shift  : ShiftL[̏                                    //
//              X,Y    : }EXW                                         //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVPanelColumns.OnSubMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
  f : Boolean;
  d : TPanel;
  dc : TListViewVColumn;
  dv : TListViewV;
  i : Integer;
begin
  dv := TListViewV(Owner);              // TListViewVQ
  d := TPanel(Sender);                  // ďoplQ
  i := d.Tag;                           // ڂ̃pl擾
  dc := dv.FColumns[i];                 // Jݒf[^Q
  if not FMoveCurDown then begin        // Jړ̎w߂ꍇ
    f := False;
    if i < FList.Count - 0 then begin   // ԉE[Ŗꍇ
      f := d.Width - 5 < X;             // J̋؂ɋ߂f
    end;
    if dc.WidthLocked then f := False;  // bNw̏ꍇtOZbg
    FMoveFlag := f;                     // J̋؂蔻ftOɑ
    if f then begin                     // J̋؂̂Ƃ
      d.Cursor := crHSplit;             // }EXJ[\ύX
    end
    else begin                          // J̋؂ł͖ꍇ
      d.Cursor := crDefault;            // }EXJ[\ɖ߂
    end;
  end
  else begin                            // Jړw߂ꍇ
    DrawMoveCursol(d.Left,X);
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ړJ[\`@`                                                //
//                                                                          //
//   - Input -  aLeft : ړW                                        //
//              X     : }EXJ[\W                                  //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVPanelColumns.DrawMoveCursol(const aLeft,X: Integer);
var
  dv : TListViewV;
  c,c2 : TCanvas;
  p,p2 : TPen;
  Y1,Y2 : Integer;
begin
  dv := TListViewV(Owner);
  c := dv.FListBoxV.Canvas;                  // LoXQ
  c2 := TPanelEx(dv.FScrBoxV.FPanel).Canvas; // LoXQ
  p := c.Pen;                                // ݂̃yۑ
  c.Pen.Mode := pmNot;                       // ]p̃yg
  p2 := c2.Pen;                              // ݂̃yۑ
  c2.Pen.Mode := pmNot;                      // ]p̃yg
  Y1 := dv.FListBoxV.Height;
  Y2 := dv.FScrBoxV.FPanel.Height;
  if FCurLineFlag then begin                 // ȑOɐƂꍇ
    c.MoveTo(aLeft + FMoveXOld,0);           // O̐
    c.LineTo(aLeft + FMoveXOld,Y1);
    c2.MoveTo(aLeft + FMoveXOld,0);          // O̐
    c2.LineTo(aLeft + FMoveXOld,Y2);
  end;
  c.MoveTo(aLeft + X,0);                     // J[\p̐
  c.LineTo(aLeft + X,Y1);
  c2.MoveTo(aLeft + X,0);                    // J[\p̐
  c2.LineTo(aLeft + X,Y2);
  FMoveXOld := X;                            // ȑO̒lƂĕۑ
  FCurLineFlag := True;                      // Ƃ\tOZbg
  c2.Pen := p2;                              // ȑÕy𕜌
  c2.Pen.Mode := pmCopy;
  c.Pen := p;                                // ȑÕy𕜌
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@}EX㏸Cxg@`                                              //
//                                                                          //
//   - Input -  Sender : Cxg̃pl                                 //
//              Button : }EX{^̏                                 //
//              Shift  : ShiftL[̏                                    //
//              X,Y    : }EXW                                         //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVPanelColumns.OnSubMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  d : TPanel;
  i : Integer;
begin
  d := TPanel(Sender);                       // ďoplQ
  i := d.Tag;                                // ڂ̃pl擾
  if not FMoveCurDown then begin             // Jړ̎w߂ꍇ
    d.BevelOuter := bvRaised;                // ݂ɖ߂
  end
  else begin
    ColumnMove(i,(X - FMoveX));              // Jړ
    FMoveX := X;                             // ̍W
    FMoveCurDown := False;                   // JړtOZbg
  end;
end;

procedure TListViewV.DoListBoxChange;
var
  db : TListViewVScrollBar;
begin
  db := FScrBoxV.VertScrollBar;
  if FListBoxV.CheckOver() then begin        // ListBoxcɂ͂ݏoꍇ
    db.Max := FListBoxV.GetOverCount();      // őXN[TCYݒ
    db.Visible := True;                      // XN[o[\
  end
  else begin                                 // ͂ݏoȂꍇ
    db.Visible := False;                     // XN[o[\
  end;

  FScrBoxV.FPanelClient.Height := FListBoxV.Top + FListBoxV.Height - 1;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@JŜ̉@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVPanelColumns.ViewColumn;
var
  i,x : Integer;
  dv : TListViewV;
begin
  dv := TListViewV(Owner);
  x := 0;                                     // ԍ[OƂ
  for i := 0 to dv.FColumns.Count-1 do begin  // J[v
    dv.FPanelColumn.Items[i].Left := x;       // J\pl̂wWƂĊi[
    dv.FPanelColumn.Items[i].Height := Height;// J\킹
    x := x + dv.FPanelColumn.Items[i].Width;  // ɕ\WvZ
  end;
  dv.FListBoxV.Width := x;                    // J̑Xg\̉
  dv.FListBoxV.Refresh;                       // \ɕύX邱Ƃm点
  dv.FScrBoxV.PanelClient.Width := x;
  dv.FListBoxV.Top := Height;                // J\̉ɔzu
  dv.FListBoxV.Height := dv.Height - Height;    // 𒲐
end;

{ TListViewVItems }

//**************************************************************************//
//                                                                          //
//  `@Xg̍sf[^ǉ@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - ǉsf[^                                            //
//                                                                          //
//**************************************************************************//
function TListViewVItems.Add: TListViewVItem;
var
  d : TListViewVItem;
  dv : TListViewV;
begin
  d := TListViewVItem.Create;             // sf[^NX𐶐
  d.FOwner := FOwner;                     // TListViwVւ̎Qƒl
  d.FIndex := Count;                      // ǉf[^sڂȂ̂
  dv := TListViewV(FOwner);               // TListViewVւ̎Q
  dv.FListBoxV.Items.Add('');             // Xg\ɂsǉ
  dv.DoListBoxChange();                   // Xg\ɕωƂm点
  inherited Add(d);                       // TList^Ƀ|C^i[
  result := d;                            // ǉf[^Ԓl
end;

function TListViewVItems.Insert(Index: Integer): TListViewVItem;
var
  d : TListViewVItem;
  dv : TListViewV;
begin
  d := TListViewVItem.Create;             // sf[^NX𐶐
  d.FOwner := FOwner;                     // TListViwVւ̎Qƒl
  d.FIndex := Count;                      // ǉf[^sڂȂ̂
  dv := TListViewV(FOwner);               // TListViewVւ̎Q
  dv.FListBoxV.Items.Insert(Index,'');    // Xg\ɂsǉ
  dv.DoListBoxChange();                   // Xg\ɕωƂm点
  inherited Insert(Index,d);              // TList^Ƀ|C^i[
  result := d;                            // ǉf[^Ԓl
end;

//**************************************************************************//
//                                                                          //
//  `@Xg̍sf[^S@`                                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TListViewVItems.Clear;
var
  i : Integer;
  dv : TListViewV;
begin
  dv := TListViewV(FOwner);               // TListViewVւ̎Q
  if dv.FListBoxV <> nil then begin       // ListBox݂ꍇ
    dv.FListBoxV.Clear();                 // ListBox̗vfS폜
  end;

  for i := 0 to Count-1 do begin          // vf[v
    Items[i].Free;                        // vf̃NXj
  end;
  inherited;                              // TListClears
end;

//**************************************************************************//
//                                                                          //
//  `@Xg̍sf[^̂w肵P폜@`                        //
//                                                                          //
//   - Input -  i : 폜s                                              //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TListViewVItems.Delete(i: Integer);
var
  dv : TListViewV;
  j : Integer;
begin
  dv := TListViewV(FOwner);               // TListViewVւ̎Q
  dv.FListBoxV.Items.Delete(i);           // YListBox̗vf폜

  Items[i].Free;
  inherited;

  for j := i to Count-1 do begin          // 폜vfȍ~Ń[v
    Items[j].FIndex := j;                 // sԍU蒼
  end;

end;

destructor TListViewVItems.Destroy;
begin
  Clear();
  inherited;
end;

function TListViewVItems.GetItems(Index: Integer): TListViewVItem;
begin
  result := inherited Items[Index];
end;

function TListViewVItems.GetObjects(Index: Integer): Pointer;
begin
  result := Items[Index].Data;
end;

//**************************************************************************//
//                                                                          //
//  `@Xg̕`揈ꎞ~@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TListViewVItems.BeginUpdate;
var
  dv : TListViewV;
begin
  dv := TListViewV(FOwner);               // TListViewVւ̎Q
  dv.FListBoxV.Items.BeginUpdate;
end;

//**************************************************************************//
//                                                                          //
//  `@Xg̕`揈ĊJ@`                                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TListViewVItems.EndUpdate;
var
  dv : TListViewV;
begin
  dv := TListViewV(FOwner);               // TListViewVւ̎Q
  dv.FListBoxV.Items.EndUpdate;
end;

{ TListViewVItem }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TListViewVItem.Create;
begin
  FStrings := TStringList.Create;       // 񃊃XgNX
  FStrings.OnChange := OnChange;        // ύX̃Cxg蓖
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TListViewVItem.Destroy;
begin
  FStrings.Free;
  inherited;
end;

procedure TListViewVItem.OnChange(Sender: TObject);
var
  d : TListViewV;
  i : Integer;
begin
  i := FIndex;
  d := TListViewV(FOwner);

  //d.FListBoxV.Items.Assign(FStrings);
  d.FListBoxV.Items.Strings[i] := FStrings.Text;   // ListBox`̂߂̃_~[
end;


{ TListViewVScrollBox }

//--------------------------------------------------------------------------//
//                                                                          //
//  `@͂ݏoȂ@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.CheckOverWidth;
var
  db : TListViewVScrollBar;
begin
  // E[͂ݏoȂ
  db := FHorzScrollBar;
  if FPanel.Width < FPanelClient.Width then begin    // ͂ݏoꍇ
    db.Visible := True;                              // XN[o[\
    db.Max := FPanelClient.Width - FPanel.Width;     // őXN[lݒ
    db.LargeChange := FHorzScrollBar.Max div 10 + 1; // XN[ݒ
  end
  else begin                                         // ͂ݏoȂꍇ
    db.Visible := False;                             // XN[o[\
    FPanelClient.Left := 0;                          // XN[ppl[֌Œ
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TListViewVScrollBox.Create(AOwner: TComponent);
begin
  inherited;
  OnResize := OnSelfResize;


  // \gp̃pl𐶐
  FPanel := TPanel.Create(Self);
  FPanel.Parent := Self;
  FPanel.BevelOuter := bvNone;                             // [߂ɉ܂ĕ\

  // XN[R|[lgێpl𐶐
  FPanelClient := TPanel.Create(Self);
  FPanelClient.Parent := FPanel;            // \pplɏ悹
  FPanelClient.OnResize := OnClientResize;
  //FPanelClient.AutoSize := True;            // R|[lgɃTCY킹

  // cXN[o[𐶐
  FVertScrollBar          := TListViewVScrollBar.Create(AOwner);
  FVertScrollBar.Parent   := Self;
  FVertScrollBar.Kind     := sbVertical;
  FVertScrollBar.OnChange := OnVertScrollBarChange;
  FVertScrollBar.OnVisibleChange := OnVertScrollBarVisibleChange;
  FVertScrollBar.LargeChange := 10;
  FVertScrollBar.TabStop := False;

  // XN[o[𐶐
  FHorzScrollBar          := TListViewVScrollBar.Create(AOwner);
  FHorzScrollBar.Parent   := Self;
  FHorzScrollBar.Kind     := sbHorizontal;
  FHorzScrollBar.OnChange := OnHorzScrollBarChange;
  FHorzScrollBar.OnVisibleChange := OnHorzScrollBarVisibleChange;
  FHorzScrollBar.TabStop := False;
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TListViewVScrollBox.Destroy;
begin
  FHorzScrollBar.Free;
  FVertScrollBar.Free;
  FPanelClient.Free;
  FPanel.Free;
  inherited;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ƎXN[{bNX̃TCYύX̏@`                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.DoSelfResize;
begin

  ViewChangeVertBar();           // ύXɍs
  ViewChangeHorzBar();           // ύXɍs
  ViewChangeClientHeight();      // ύXɍs
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ƎXN[{bNX̕\R|[lgTCYύXCxg@`    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.OnClientResize(Sender: TObject);
begin
  ViewClient();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ƎXN[o[ij̒lύXCxg@`                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.OnHorzScrollBarChange(Sender: TObject);
var
  dv : TListViewV;
begin
  FPanelClient.Left := - TScrollBar(Sender).Position; // ʒu炵\̈ύX
  dv := TListViewV(Owner);
  if Assigned(dv.OnHorzScrollBarChange) then begin
    dv.OnHorzScrollBarChange(Self);
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ƎXN[o[ij̕\^\Cxg@`                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.OnHorzScrollBarVisibleChange(Sender: TObject);
begin
  ViewChangeHorzBar();                 // ς̂ōČvZ
  ViewChangeClientHeight();            // ύXɍs
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ƎXN[{bNX̃TCYύXCxg@`                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.OnSelfResize(Sender: TObject);
begin
  DoSelfResize();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ƎXN[o[icj̒lύXCxg@`                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.OnVertScrollBarChange(Sender: TObject);
var
  dv : TListViewV;
begin
  dv := TListViewV(Owner);                              // TListViewVQ
  dv.FListBoxV.TopIndex := TScrollBar(Sender).Position; // ListBox̕\JnʒuύX
  if Assigned(dv.OnVertScrollBarChange) then begin
    dv.OnVertScrollBarChange(Self);
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ƎXN[o[icj̕\^\Cxg@`                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.OnVertScrollBarVisibleChange(Sender: TObject);
begin
  ViewChangeVertBar();        // ς̂ōČvZ
  CheckOverWidth();           // E[͂ݏoȂ
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@`̈̍ύXɍsĔzu@`                            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.ViewChangeClientHeight;
var
  dv : TListViewV;
begin
  dv := TListViewV(Owner);
  dv.FListBoxV.Height := FPanel.Height - dv.FListBoxV.Top;  // ListBox̍
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ύXɍszuČvZ@`                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.ViewChangeHorzBar;
begin
  FVertScrollBar.Left := Width - FVertScrollBar.Width;       // co[̂wW
  FVertScrollBar.Top  := 0;                                  // co[̂xW
  if FHorzScrollBar.Visible then begin                       // o[ꍇ
    FVertScrollBar.Height := Height - FHorzScrollBar.Height; // co[̍o[炷
    FPanel.Height := Height - FHorzScrollBar.Height;         // \̈̍o[炷
  end
  else begin                                                 // o[ꍇ
    FVertScrollBar.Height := Height;                         // co[̍ڈt
    FPanel.Height := Height;                                 // \̈̍ڈt
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ύXɍszuČvZ@`                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.ViewChangeVertBar;
begin
  FHorzScrollBar.Left := 0;                                  // o[̂wW
  FHorzScrollBar.Top  := Height - FHorzScrollBar.Height;     // o[̂xW
  if FVertScrollBar.Visible then begin                       // co[ꍇ
    FHorzScrollBar.Width := Width - FVertScrollBar.Width;    // o[̕co[炷
    FPanel.Width := Width - FVertScrollBar.Width;            // \̈̕co[炷
  end
  else begin                                                 // co[Ȃꍇ
    FHorzScrollBar.Width := Width;                           // o[̕ڈt
    FPanel.Width := Width;                                   // \̈̕ڈt
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\R|[lgύXɍs@`                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBox.ViewClient;
begin
  CheckOverWidth();           // E[͂ݏoȂ
end;

{ TListViewVListBox }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TListViewVListBox.Create(AOwner: TComponent);
begin
  inherited;
  OnDrawItem := OnSelfDrawItem;         // `Cxg蓖Ă
  OnClick    := OnSelfClick;
  OnDblClick := OnSelfDblClick;
end;

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TListViewVListBox.Destroy;
begin
  inherited;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Xgcɂ͂ݏo@`                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - True : ͂ݏo                                             //
//                                                                          //
//--------------------------------------------------------------------------//
function TListViewVListBox.CheckOver: Boolean;
begin
  result := ItemHeight * Items.Count > Height;
end;

procedure TListViewVListBox.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  // cXN[o[\Ȃ
  Params.Style := Params.Style xor ws_VScroll;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\łȂڐ擾@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - ڐ                                                      //
//                                                                          //
//--------------------------------------------------------------------------//
function TListViewVListBox.GetOverCount: Integer;
begin
  result := Items.Count - (Height div ItemHeight)-0; // 2004/11/15 ŉi̋󔒍s폜
end;

function TListViewVListBox.GetShowCount: Integer;
begin
  result := Height div ItemHeight;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Xg`Cxg@`                                              //
//                                                                          //
//   - Input -  Control : `悷Rg[                              //
//              Index   : `悷sԍ                                    //
//              Rect    : `悷͈                                      //
//              State   : `悵悤ƂĂ鍀ڂ̏                    //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVListBox.OnSelfDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  i,x,y,xh : Integer;
  c : TCanvas;
  s : string;
  dv : TListViewV;
  r : TRect;
begin
  dv := TListViewV(Owner);                              // TListViewQ

  if dv.FStyle = lvStandard then begin                  // ʏ`̏ꍇ
    x := Rect.Left;                                     // \wW擾
    y := Rect.Top;                                      // \xW擾
    c := TListBox(Control).Canvas;                      // `悷TCanvasQ
    if not (odSelected in State)	then begin            // ڂIԂ̏ꍇ
      c.Font.Color := clBlack;                          // F
      c.Brush.Color := clWhite;                         // wiF
    end
    else begin                                          // ڂIԂ̏ꍇ
      c.Font.Color := clWhite;                          // F
      c.Brush.Color := clHighlight;                     // wiFnCCgF
    end;
    c.FillRect(Rect);                                   // `̈hԂ

    for i := 0 to dv.FColumns.Count-1 do begin          // J[v
      if i < dv.FItems[Index].Strings.Count then begin  // `悷ׂڂꍇ
        s := dv.FItems[Index].Strings.Strings[i];       // `悷ׂ擾
        c.TextOut(x,y,s);                               // `s
        x := x + dv.FColumns.Items[i].Width;            // ɕ\鍀ڂ̍WvZ
      end;
    end;
  end
  else if dv.FStyle = lvOwnerDrawFixed then begin       // I[i[`̏ꍇ
    if Index < dv.Items.Count then begin                // \͈͂
      x := 0;                                           // `̈lw
      r.Top  := Rect.Top;                               // `̈[擾
      r.Bottom := Rect.Bottom;                          // `̈扺[擾
      for i := 0 to dv.FColumns.Count-1 do begin        // J[v
        xh := dv.FColumns.Items[i].Width;               // J擾
        r.Left := x;                                    // `̈捶[擾
        r.Right := x + xh;                              // `̈E[擾
        dv.DoDrawItem(i,Index,r,State);                 // I[i[`Cxgs
        x := x + xh;                                    // ɕ\鍀ڂ̍WvZ
      end;
    end
    else begin                                          // \͈͂ł͂Ȃꍇ
      c := TListBox(Control).Canvas;                    // `悷TCanvasQ
      if not (odSelected in State)	then begin          // ڂIԂ̏ꍇ
        c.Font.Color := clBlack;                        // F
        c.Brush.Color := clWhite;                       // wiF
      end
      else begin                                        // ڂIԂ̏ꍇ
        c.Font.Color := clWhite;                        // F
        c.Brush.Color := clHighlight;                   // wiFnCCgF
      end;
      c.FillRect(Rect);                                 // `̈hԂ
    end;
  end;
end;

procedure TListViewVListBox.OnSelfClick(Sender: TObject);
var
  dv : TListViewV;
begin
  dv := TListViewV(Owner);                            // TListViewQ
  dv.FScrBoxV.FVertScrollBar.Position := TopIndex;    // XN[o[̏Ԃ킹
  dv.DoListClick();
end;

procedure TListViewVListBox.OnSelfDblClick(Sender: TObject);
var
  dv : TListViewV;
begin
  dv := TListViewV(Owner);                            // TListViewQ
  dv.FScrBoxV.FVertScrollBar.Position := TopIndex;    // XN[o[̏Ԃ킹
  dv.DoListDblClick();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@}EXzC[ړCxg@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - ڐ                                                      //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVListBox.WMMousewheel(var Msg: TMessage);
var
  dv :TListViewV;
  d : Integer;
begin
  dv := TListViewV(Owner);
  if (Msg.WParam > 0) then
  begin
    { zC[ɓ̏ }
    d := dv.FScrBoxV.FVertScrollBar.Position;
    d := d - dv.FMouseWheelLine;
    dv.FScrBoxV.FVertScrollBar.Position :=  d;
  end
  else
  begin
    { zC[Oɓ̏ }
    d := dv.FScrBoxV.FVertScrollBar.Position;
    d := d + dv.FMouseWheelLine;
    dv.FScrBoxV.FVertScrollBar.Position := d;
  end;
end;

{ TListViewVScrollBar }

procedure TListViewVScrollBar.DoVisibleChange;
begin
  if Assigned(FOnVisibleChange) then FOnVisibleChange(Self);
end;

function TListViewVScrollBar.GetVisible: Boolean;
begin
  result := inherited Visible;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@XN[o[̕\^\ύXCxg@`                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TListViewVScrollBar.SetVisible(const Value: Boolean);
begin
  if inherited Visible = Value then exit;        // lɕύXȂꍇȂ
  inherited Visible := Value;                    // ۂVisiblevpeBɑ
  //TListViewV(Owner).FScrBoxV.DoSelfResize();     //
  DoVisibleChange();                             // eɕ\^\ύXm点
end;

function TListViewV.GetListColor: TColor;
begin
  result := FListBoxV.Color;
end;

procedure TListViewV.SetListColor(const Value: TColor);
begin
  FListBoxV.Color := Value;
end;

function TListViewV.GetColor: TColor;
begin
  result := inherited Color;
end;

procedure TListViewV.SetColor(const Value: TColor);
begin
  inherited Color := Value;
  FScrBoxV.Color := Value;
  FScrBoxV.FPanel.Color := Value;
  FScrBoxV.FPanelClient.Color := Value;
end;

procedure TListViewV.Paint;
begin
  inherited;
  FScrBoxV.ViewClient();
  FScrBoxV.DoSelfResize();
  //DoListBoxChange();

end;

function TListViewV.GetDebugPanel: TPanel;
begin
  result := FScrBoxV.FPanelClient;
end;

function TListViewV.GetListShowCount: Integer;
begin
  result := FListBoxV.ShowCount;
end;

function TListViewV.GetOnListMouseDown: TMouseEvent;
begin
  result := FListBoxV.OnMouseDown;
end;

procedure TListViewV.SetOnListMouseDown(const Value: TMouseEvent);
begin
  FListBoxV.OnMouseDown := Value;
end;

function TListViewV.MousePosToColIndex(const X: Integer): Integer;
var
  i,xx,h : Integer;
begin
  //xx := FScrBoxV.HorzScrollBar.Position + X;
  xx :=  X;
  h := 0;
  result := -1;
  for i := 0 to FColumns.Count-1 do begin
    h := h + FColumns[i].Width;
    if h > xx then begin
      result := i;
      exit;
    end;
  end;

end;

function TListViewV.MousePosToRowIndex(const Y: Integer): Integer;
begin
  result := Y div ItemHeight + FListBoxV.TopIndex;

end;

function TListViewV.ColRowToRect(const X, Y: Integer): TRect;
var
  x1,x2,y1,y2,i,xx : Integer;
begin
  y1 := (Y - FListBoxV.TopIndex) * ItemHeight + ColumnHeight + 3;
  y2 := y1 + ItemHeight - 1;
  x1 := 3;
  x2 := 3;
  for i := 0 to FColumns.Count-1 do begin
    x2 := x2 + FColumns[i].Width;
    if i = X then break;
    x1 := x1 + FColumns[i].Width;
  end;
  xx := FScrBoxV.HorzScrollBar.Position;
  result := Rect(x1-xx,y1,x2-xx,y2);
end;

end.
