unit FormMainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FelicaLibV, StdCtrls, ExtCtrls,DateTimeCtrl, ComCtrls,PanelSuicaHist,
  DBFeliCa;

type
  TFormMain = class(TForm)
    Timer1: TTimer;
    Panel1: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    PBar: TProgressBar;
    BtnOpen: TButton;
    BtnClose: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BtnOpenClick(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private 錾 }
    FFericaLib : TFelicaLibV;            // FelicaǂݎNX
    FPanelSuicaHist : TPanelSuicaHist;   // Suicap\plNX
    FDBFeliCa : TDBFeliCaItems;          // wf[^ǗNX

    procedure ViewSuicaHist();
    procedure OnGetCardInfo(Sender: TObject;Info : TFelicaCardInfo);
    procedure OnGetSuicaHist(Sender: TObject;Status : TFeliCaLibGetSuicaHistStatus;Position : Integer);
  public
    { Public 錾 }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

//**************************************************************************//
//                                                                          //
//  `@tH[@`                                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TFormMain.FormCreate(Sender: TObject);
begin
  FFericaLib := TFelicaLibV.Create;
  FFericaLib.OnGetCardInfo := OnGetCardInfo;
  FFericaLib.OnGetSuicaHist := OnGetSuicaHist;

  FDBFeliCa := TDBFeliCaItems.Create;

  FPanelSuicaHist := TPanelSuicaHist.Create(Self);
  FPanelSuicaHist.Parent := Panel1;
  FPanelSuicaHist.Align := alClient;
  FPanelSuicaHist.DataBase := FDBFeliCa;
  if not FFericaLib.Open then exit;
end;

//**************************************************************************//
//                                                                          //
//  `@tH[j@`                                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TFormMain.FormDestroy(Sender: TObject);
begin
  FFericaLib.Close;
  FPanelSuicaHist.Free;
  FDBFeliCa.Free;
  FFericaLib.Free;
end;

//**************************************************************************//
//                                                                          //
//  `@tH[\@`                                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TFormMain.FormShow(Sender: TObject);
begin
  FPanelSuicaHist.Show;
end;

//**************************************************************************//
//                                                                          //
//  `@Suica̗\@`                                                 //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TFormMain.ViewSuicaHist;
var
  d : TFelicaLibSuicaHistItem;
  i : Integer;
  s : string;
begin
  FPanelSuicaHist.Clear;                                  // \
  for i := FFericaLib.SuicaHist.Count-1 downto 0 do begin // 𐔕[v
    d := FFericaLib.SuicaHist[i];                         // Pf[^Q
    if d.MatineCode = 0 then continue;                    // @킪s̏ꍇ͖
    FPanelSuicaHist.Add(d);                               // \ɒǉ
  end;
  d := FFericaLib.SuicaHist[0];                           // ŏ̃f[^Q
  s := 'c';
  s := s + IntToStr(d.Balance);                           // c\
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ڑ{^NbNCxg@`                                      //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFormMain.BtnOpenClick(Sender: TObject);
begin
  if not FFericaLib.Open then exit;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ؒf{^NbNCxg@`                                      //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFormMain.BtnCloseClick(Sender: TObject);
begin
  FFericaLib.Close;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ʏp^C}[Cxg@`                                      //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFormMain.Timer1Timer(Sender: TObject);
begin
  Label1.Caption := '';
  Label2.Caption := '';
  Timer1.Enabled := False;
end;


//--------------------------------------------------------------------------//
//                                                                          //
//  `@ICJ[h擾Cxg@`                                        //
//                                                                          //
//   - Input -  Info : J[h                                           //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFormMain.OnGetCardInfo(Sender: TObject; Info: TFelicaCardInfo);
var
  i : Integer;
  s : string;
begin
  s := '';
  for i := 0 to 7 do begin
    s := s + IntToHex(Info.IDm[i],2);
  end;
  Label1.Caption := s;
  s := '';
  for i := 0 to 7 do begin
    s := s + IntToHex(Info.PMm[i],2);
  end;
  Label2.Caption := s;
  FFericaLib.ReadSuicaHist();
  Timer1.Enabled := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ICJ[hgp擾iKωCxg@`                            //
//                                                                          //
//   - Input -  Status : 擾                                           //
//   - Output - Ȃ                                                        //
//                                                                          //
//  ICJ[h̗p擾ɂ͎Ԃ邽                      //
//    ̎擾󋵂\邽߂̃Cxg                                  //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFormMain.OnGetSuicaHist(Sender: TObject;
  Status: TFeliCaLibGetSuicaHistStatus; Position: Integer);
begin
  case Status of                       // 擾󋵂ɂĕ
  hsStart:                             // 擾Jn̏ꍇ
    begin
      PBar.Position := 0;              // iKo[łȂԂ
      PBar.Visible := True;            // o[\
    end;
  hsBusy:                              // 擾̏ꍇ
    begin
      PBar.Position := Position;       // o[̈ʒu
    end;
  hsFinish:                            // 擾Ȉꍇ
    begin
      PBar.Visible := False;           // o[
      ViewSuicaHist();                 // \
    end;
  hsError:                             // ُ킪ꍇ
    begin
      PBar.Visible := False;           // o[
    end;
  end;

end;

end.
