unit FeliCaLibV;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls,DateTimeCtrl;

//--------------------------------------------------------------------------//
//  |[OŎgpf[^\                                      //
//--------------------------------------------------------------------------//
type TFelicaPolling = record
  SystemCode : PByteArray;
  TimeSlot   : Byte;
end;

//--------------------------------------------------------------------------//
//  J[hǂݎŎgpf[^\                              //
//--------------------------------------------------------------------------//
type TFelicaCardInfo = record
  IDm : PByteArray;
  PMm : PByteArray;
end;

//--------------------------------------------------------------------------//
//  J[hubNǂݎŎgp̓f[^\                  //
//--------------------------------------------------------------------------//
type TFeliCaInReadBlock = record
  CardIDm : PByteArray;
  ServiceCnt : Byte;
  ServiceList : PByteArray;
  BlockCnt : Byte;
  BlockList : PByteArray;
end;

//--------------------------------------------------------------------------//
//  J[hubNǂݎŎgpo̓f[^\                  //
//--------------------------------------------------------------------------//
type TFeliCaOutReadBlock = record
  Status1 : PByteArray;
  Status2 : PByteArray;
  BlockCnt : PByteArray;
  BlockList : PByteArray;
end;

//--------------------------------------------------------------------------//
//  FeliCapAPIDelphipɒ`                                             //
//--------------------------------------------------------------------------//
type TFeliCaInitLib = function() : Bool; stdcall;
type TFeliCaDisposeLib = function() : Bool; stdcall;
type TFeliCaOpenReader = function() : Bool; stdcall;
type TFeliCaCloseReader = function() : Bool; stdcall;
type TFeliCaGetCardInfo = function(var Polling : TFelicaPolling;var c : PByte;var Info : TFelicaCardInfo) : BOOL;stdcall;
type TFeliCaReadBlock = function(var InReadBlock : TFeliCaInReadBlock;var OutReadBlock : TFeliCaOutReadBlock) : Bool;stdcall;

//--------------------------------------------------------------------------//
//  SuicaǂݎiK\͈͌^                                       //
//--------------------------------------------------------------------------//
type TFeliCaLibGetSuicaHistStatus = (hsNil,hsStart,hsBusy,hsFinish,hsError);

//--------------------------------------------------------------------------//
//  ƎCxg^̒`                                                    //
//--------------------------------------------------------------------------//
type TFeliCaLibGetCardInfo = procedure(Sender: TObject;Info : TFelicaCardInfo) of object;
type TFeliCaLibGetSuicaHist = procedure(Sender: TObject;Status : TFeliCaLibGetSuicaHistStatus;Position : Integer) of object;


//--------------------------------------------------------------------------//
//  Suicapf[^ǗNX                                           //
//--------------------------------------------------------------------------//
type
  TFeliCaLibSuicaHistItem = class(TPersistent)
  private
    { Private 錾 }
    FMatineCode: Integer;
    FProcCode: Integer;
    FDateTime: TDateTimeCtrl;
    FBalance: Integer;
    FInStation: Integer;
    FInCode: Integer;
    FOutStation: Integer;
    FOutCode: Integer;
    FMoneySpent : Integer;
    FRegionCode: Integer;
    FTimeEnabled: Boolean;
    FAreaCode: Integer;
    function GetMatineName: string;
    function GetProcCode: string;
    function GetMoneySpent: Integer;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;
    // Felica蓾ꂽ16oCgf[^Suicaf[^ɕϊ
    procedure SetData(Tbl : array of Byte);


    // @̎
    property MatineCode : Integer read FMatineCode;
    // @̖́iZ@A@Ȃǁj
    property MatineName : string  read GetMatineName;
    // ̎
    property ProcCode : Integer read FProcCode;
    // ̖́i`[WA^xȂǁj
    property ProcName : string read GetProcCode;
    // ޏoA
    property DateTime : TDateTimeCtrl read FDateTime;
    // True : 񂪗L
    property TimeEnabled : Boolean read FTimeEnabled;
    // c
    property Balance : Integer read FBalance;
    // pz
    property MoneySpent : Integer read GetMoneySpent;
    // DwR[h
    property InStation : Integer read FInStation;
    // D[J[
    property InCode : Integer read FInCode;
    // oDwR[h
    property OutStation : Integer read FOutStation;
    // oD[J[
    property OutCode : Integer read FOutCode;
    // nR[h
    property RegionCode : Integer read FRegionCode;
    // nR[h
    property AreaCode : Integer read FAreaCode;
  end;

//--------------------------------------------------------------------------//
//  SuicapꗗǗNX                                             //
//--------------------------------------------------------------------------//
type
  TFelicaLibSuicaHistItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TFelicaLibSuicaHistItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    function Add() : TFelicaLibSuicaHistItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TFelicaLibSuicaHistItem read GetItems;default;
  end;

//--------------------------------------------------------------------------//
//  ICJ[h[_[(Felica)𗘗pNX                                //
//--------------------------------------------------------------------------//
type
  TFeliCaLibV = class(TPersistent)
  private
    { Private 錾 }
    FTimer : TTimer;                                       // |[Op^C}[
    FDllHandle    : THandle;                               // I[hDLL̃nh
    FSystemCode : array[0..1] of Byte;                     // |̕ӂ͉ǂ̗]n
    FIDm : array[0..7] of Byte;                            // |
    FPMm : array[0..7] of Byte;                            // |

    FSuicaHist : TFelicaLibSuicaHistItems;                 // SuicapNX

    FFelicaInRead : TFeliCaInReadBlock;
    FFelicaOutRead : TFeliCaOutReadBlock;

    FFelicaPolling : TFelicaPolling;
    FFelicaCardInfo : TFelicaCardInfo;

    FFelicaInitLib : TFelicaInitLib;                       // eAPI`
    FFelicaDisposeLib : TFelicaDisposeLib;
    FFelicaOpenReader : TFelicaOpenReader;
    FFelicaCloseReader : TFelicaCloseReader;
    FFelicaGetCardInfo : TFelicaGetCardInfo;
    FFelicaReadBlock : TFelicaReadBlock;

    FOnGetCardInfo: TFelicaLibGetCardInfo;
    FOpened: Boolean;
    FOnGetSuicaHist: TFeliCaLibGetSuicaHist;
    // IDLLǂݍ
    function GetDllLibrary(const LibraryName : PChar) : TObject;
    // ^C}[荞ݏ
    procedure ProcTimer();
    procedure OnTimer(Sender: TObject);
  protected
    function GetCardInfo(const SystemCode : Word;const TimeSlot : Byte) : Boolean;
    procedure DoGetCardInfo(Info : TFelicaCardInfo);
    procedure DoGetSuicaHist(Status : TFeliCaLibGetSuicaHistStatus;Position : Integer);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    // ICJ[h[_[ڑ
    function Open() : Boolean;
    // ICJ[h[_[ؒf
    function Close() : Boolean;
    // Íf[^̓ǂ݂Ƃ
    function ReadBlock(const ServiceCode : Word;const Adr : Byte;var BlockData : array of Byte) : Boolean;
    // Suicap擾
    function ReadSuicaHist() : Boolean;

    // True : ڑ
    property Opened : Boolean read FOpened;
    // Suicap
    property SuicaHist : TFelicaLibSuicaHistItems read FSuicaHist;
    // J[hǂ݂Ƃ芮Cxg
    property OnGetCardInfo : TFelicaLibGetCardInfo read FOnGetCardInfo write FOnGetCardInfo;
    // SuicaǂݎCxg
    property OnGetSuicaHist : TFeliCaLibGetSuicaHist read FOnGetSuicaHist write FOnGetSuicaHist;
  end;

implementation

{ THdlcCommDll }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//  DLLPathw肵ȂƂIɌǂݍ܂                 //
//                                                                          //
//**************************************************************************//
constructor TFeliCaLibV.Create;
begin
  FSuicaHist := TFelicaLibSuicaHistItems.Create;
  FTimer := TTimer.Create(nil);
  FTimer.Interval := 100;
  FTimer.Enabled := False;
  FTimer.OnTimer := OnTimer;
  FDllHandle := LoadLibrary('Felica.DLL');                       // DLL𓮓I[h
  if FDllHandle = 0 then exit;                                   // sꍇ
  @FFelicaInitLib := GetDllLibrary('initialize_library');        // ֐ւ̃|C^擾
  @FFelicaDisposeLib := GetDllLibrary('dispose_library');
  @FFelicaOpenReader  := GetDllLibrary('open_reader_writer_auto');
  @FFelicaCloseReader := GetDllLibrary('close_reader_writer');
  @FFelicaGetCardInfo := GetDllLibrary('polling_and_get_card_information');
  @FFelicaReadBlock   := GetDllLibrary('read_block_without_encryption');
end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TFeliCaLibV.Destroy;
begin
  FTimer.Enabled := False;
  if FOpened then begin                       // ڑ̏ꍇ
    Close();                                  // ؒfs
  end;
  if FDllHandle <> 0 then begin
    FreeLibrary(FDllHandle);
  end;
  FTimer.Free;
  FSuicaHist.Free;
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@FelicaJ[h[_ڑJn@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TFeliCaLibV.Open: Boolean;
begin
  result := False;
  if FDllHandle = 0 then exit;               // DLĽĂтɎsĂꍇ
  if FOpened then begin                      // ڑ̏ꍇ
    if not Close() then exit;                // Uڑ؂
  end;
  if not FFelicaInitLib() then exit;         // FelicaCȕ
  if not FFelicaOpenReader() then exit;      // Felica[_[ڑJn
  FOpened := True;
  FTimer.Enabled := True;                    // |[O^C}[Jn
  result := True;
end;

//**************************************************************************//
//                                                                          //
//  `@FelicaJ[h[_ڑI@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TFeliCaLibV.Close: Boolean;
begin
  result := False;
  if FDllHandle = 0 then exit;               // DLĽĂтɎsĂꍇ
  if not FOpened then exit;                  // ڑłȂꍇ
  FTimer.Enabled := False;
  if not FFelicaCloseReader() then exit;     // ؒfs
  if not FFelicaDisposeLib() then exit;      // FelicaCuЂÂ
  result := True;
  FOpened := False;
end;

//**************************************************************************//
//                                                                          //
//  `@Íf[^̓ǂ݂Ƃ@`                                        //
//                                                                          //
//   - Input -  ServiceCode : f[^(Suica$090f)                  //
//              Adr         : ubNǂ݂Ƃʒu(0..255)              //
//              BlockData   : li[z 16Byte                     //
//                                                                          //
//   - Output - True :  False : ُ͂̃ubNɃf[^Ȃ  //
//                                                                          //
//     ̊֐͎błł                                             //
//                                                                          //
//**************************************************************************//
function TFeliCaLibV.ReadBlock(const ServiceCode : Word;const Adr : Byte;var BlockData : array of Byte): Boolean;
var
  ServiceList : array[0..1] of Byte;
  BlockList : array[0..1] of Byte;
  Status1,Status2 : Byte;
  BlockCnt : Byte;
  //OutBlockList : array[0..16] of Byte;
begin
  result := False;
  if FDllHandle = 0 then exit;               // DLĽĂтɎsĂꍇ
  ServiceList[0] := ServiceCode and $ff;
  ServiceList[1] := (ServiceCode shr 8) and $ff;
  BlockList[0] := $80;
  BlockList[1] := Adr;

  FFelicaInRead.CardIDm := FFelicaCardInfo.IDm;
  FFelicaInRead.ServiceCnt := 1;
  FFelicaInRead.ServiceList := @ServiceList;
  FFelicaInRead.BlockCnt := 1;
  FFelicaInRead.BlockList := @BlockList;

  FFelicaOutRead.Status1 := @Status1;
  FFelicaOutRead.Status2 := @Status2;
  FFelicaOutRead.BlockCnt := @BlockCnt;
  FFelicaOutRead.BlockList := @BlockData;

  result := FFelicaReadBlock(FFelicaInRead,FFelicaOutRead);

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@IDLL̃Cuǂݍށ@`                                   //
//                                                                          //
//   - Input -  LibraryName : Cu                                //
//                                                                          //
//   - Output - DLL̃nh                                               //
//                                                                          //
//--------------------------------------------------------------------------//
function TFeliCaLibV.GetDllLibrary(const LibraryName: PChar): TObject;
begin
  result := GetProcAddress(FDllHandle,LibraryName);
  if result = nil then begin
    raise Exception.Create(LibraryName + ' ܂');
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ICJ[hIDf[^ǂ݂Ƃ@`                                    //
//                                                                          //
//   - Input -  SystemCode : Felica̎ ($ffffȂSāH)                 //
//              TimeSlot   : [$00,$01,$03,$07,$0f]w                  //
//                                                                          //
//   - Output - True : ǂ݂Ƃ芮                                         //
//                                                                          //
//--------------------------------------------------------------------------//
function TFeliCaLibV.GetCardInfo(const SystemCode : Word;const TimeSlot : Byte): Boolean;
var
  b : Byte;
  p : PByte;
begin
  FSystemCode[0] := SystemCode and $ff;
  FSystemCode[1] := (SystemCode shr 8) and $ff;
  FFelicaPolling.TimeSlot := 0;
  FFelicaCardInfo.IDm := @FIDm;
  FFelicaCardInfo.PMm := @FPMm;
  FFelicaPolling.SystemCode := @FSystemCode;
  b := 0;
  p := @b;
  result := FFelicaGetCardInfo(FFelicaPolling,p,FFelicaCardInfo);
end;


procedure TFeliCaLibV.ProcTimer;
begin
  if GetCardInfo($ffff,0) then begin
    DoGetCardInfo(FFelicaCardInfo);
  end;
end;

procedure TFeliCaLibV.OnTimer(Sender: TObject);
begin
  FTimer.Enabled := False;
  ProcTimer();
  FTimer.Enabled := True;
end;

procedure TFeliCaLibV.DoGetCardInfo(Info: TFelicaCardInfo);
begin
  if Assigned(FOnGetCardInfo) then begin
    FOnGetCardInfo(Self,Info);
  end;
end;

procedure TFeliCaLibV.DoGetSuicaHist(Status: TFeliCaLibGetSuicaHistStatus; Position: Integer);
begin
  if Assigned(FOnGetSuicaHist) then begin
    FOnGetSuicaHist(Self,Status,Position);
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@Suicapf[^̓ǂ݂Ƃ@`                                   //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True :                                                  //
//                                                                          //
//     ʂSuicaHistvpeBɊi[                                //
//                                                                          //
//**************************************************************************//
function TFeliCaLibV.ReadSuicaHist: Boolean;
const
  Code = $090f;         // SuicapT[rXR[h
  Max  = 16;            // 擾
var
  Tbl : array[0..16] of Byte;
  j : Integer;
  d,d2 : TFelicaLibSuicaHistItem;
begin
  result := False;
  FSuicaHist.Clear;                                //
  for j := 0 to Max-1 do begin                     // Suicapi[XgNA
    if not ReadBlock(Code,j,Tbl) then begin;       // ǂݎُ̏ꍇ
      DoGetSuicaHist(hsError,0);                   // G[ʒm
      exit;
    end;
    d := FSuicaHist.Add();                         // SuicaNXɏǉ
    d.SetData(Tbl);                                // Pf[^ƂĊi[
    if j = 0 then begin                            // Pڂ̏ꍇ
      DoGetSuicaHist(hsStart,0);                   // 擾Jnʒm
    end
    else begin                                     // Qڈȍ~̃f[^̏ꍇ
      d2 := FSuicaHist.Items[j-1];                 // PÕNXQ
      d2.FMoneySpent := d.FBalance - d2.FBalance;  // c痘pQ
      DoGetSuicaHist(hsBusy,j);                    // 擾ł邱Ƃʒm
    end;
  end;
  DoGetSuicaHist(hsFinish,15);                     // 擾ʒm
  result := True;                                  // f[^擾łƔ
end;

{ TFelicaLibSuicaHistItems }

destructor TFelicaLibSuicaHistItems.Destroy;
begin
  Clear();
  inherited;
end;

function TFelicaLibSuicaHistItems.Add: TFelicaLibSuicaHistItem;
var
  d : TFelicaLibSuicaHistItem;
begin
  d := TFelicaLibSuicaHistItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TFelicaLibSuicaHistItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TFelicaLibSuicaHistItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TFelicaLibSuicaHistItems.GetItems(
  Index: Integer): TFelicaLibSuicaHistItem;
begin
  result := inherited Items[Index];
end;

{ TFelicaLibSuicaHistItem }

constructor TFelicaLibSuicaHistItem.Create;
begin
  FDateTime := TDateTimeCtrl.Create;
end;

destructor TFelicaLibSuicaHistItem.Destroy;
begin
  FDateTime.Free;
  inherited;
end;

procedure TFeliCaLibSuicaHistItem.Assign(Source: TPersistent);
var
  a : TFeliCaLibSuicaHistItem;
begin
  if Source is TFeliCaLibSuicaHistItem then begin
    a := TFeliCaLibSuicaHistItem(Source);
    FMatineCode := a.FMatineCode;
    FProcCode := a.FProcCode;
    FDateTime.Assign(a.FDateTime);
    FBalance := a.FBalance;
    FMoneySpent := a.FMoneySpent;
    FInCode := a.FInCode;
    FInStation := a.FInStation;
    FOutCode := a.FOutCode;
    FOutStation := a.FOutStation;
    FRegionCode := a.FRegionCode;
    FTimeEnabled := a.FTimeEnabled;
  end
  else begin
    inherited;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@@R[h@햼̂擾@`                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - @햼                                                    //
//                                                                          //
//--------------------------------------------------------------------------//
function TFelicaLibSuicaHistItem.GetMatineName: string;
var
  s : string;
begin
  case FMatineCode of
      3  : s := 'Z@';
      4  : s := 'gь^[';
      5  : s :='ԍڒ[';
      7  : s :='@';
      8  : s :='@';
      9  : s :='@';
      18 : s :='@';
      20 : s :='@';
      21 : s :='@';
      22 : s :='D@';
      23 : s :='ȈՉD@';
      24,
      25 : s :='[';
      26 : s :='D[';
      27 : s :='gѓdb';
      28 : s :='pZ@';
      29 : s :='AD@';
      31 : s :='ȈՓ@';
      70 : s :='VIEW ALTTE';
      72 : s :='VIEW ALTTE';
      199 : s :='̒[';
      200 : s :='̋@';
  else s := '̑';

  end;
  result := s;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@R[hxz擾@`                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - xz                                                    //
//                                                                          //
//   FMoneySpent͎xƂĂ邽ߓ̓}CiXɂKv  //
//                                                                          //
//--------------------------------------------------------------------------//
function TFeliCaLibSuicaHistItem.GetMoneySpent: Integer;
begin
  case FProcCode of               // ̎ނŕ
    $02,                          // ̏ꍇ
    $07,
    $14,
    $49 : result := -FMoneySpent; // z}CiXɂĕԂ
  else  result := FMoneySpent;    // ẑ܂ܕԂ
  end;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@R[h珈̂擾@`                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output -                                                     //
//                                                                          //
//--------------------------------------------------------------------------//
function TFelicaLibSuicaHistItem.GetProcCode: string;
var
  s : string;
begin
  case FProcCode of               // ̎ނŕ
    1   : s := '^x';        //(Do)
    2   : s := '`[W';        //
    3   : s := 'w';          //(Cw)
    4   : s := 'Z';            //
    5   : s := 'ꐸZ';        // (ꐸZ)
    6   : s := 'D';    // (D)
    7   : s := 'VKs';        // (VKs)
    8   : s := 'T';        // (T)
    13  : s := 'oX(PiTaPan)';  // (PiTaPan)
    15  : s := 'oX(IruCan)';   // (IruCan)
    17  : s := 'Ĕs';      // (Ĕs)
    19  : s := 'Vp';      // (Vp)
    20  : s := 'ꎞ`[W '; //(ꎞI[g`[W)
    21  : s := 'oꎞ`[W';  //(oꎞI[g`[W)
    31  : s := 'oX`[W';    // (oX`[W)
    35  : s := 'w';          // (oXHʓdԊ挔w)
    70  : s := '';            //
    72  : s := 'T';            // (T`[W)
    73  : s := '';            // (W)
    74  : s := '̎';        //
    75  : s := 'ꕨ';        // (ꕨ)
    198 : s := 'p';    // (p)
    203 : s := 'ꌻp';// (ꌻp)
    132 : s := 'АZ';        // (АZ)
    133 : s := 'ГꐸZ';    // (ГꐸZ)
  else s := '̑';

  end;
  result := s;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Felica蓾ꂽ16oCgf[^Suicaf[^ɕϊ@`         //
//                                                                          //
//   - Input -  Tbl : Felica蓾ꂽ16oCgf[^                      //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFelicaLibSuicaHistItem.SetData(Tbl : array of Byte);
var
  i : Integer;
begin
  FMatineCode := Tbl[0];                // @R[h擾
  FProcCode := Tbl[1];                  // R[h擾
  i := Tbl[4] shl 8 + Tbl[5];           // t擾
  FDateTime.Yer := i shr 9 + 2000;      // uNv𕪉
  FDateTime.Mon := (i shr 5) and $f;    // uv𕪉
  FDateTime.Day := i and $1f;           // uv𕪉
  case FProcCode of
    70, 73, 74, 75, 198, 203:           // ̂̏ꍇ
    begin
      i := Tbl[6] shl 8 + Tbl[7];           // 擾iɂĂ͎擾\j
      FDateTime.Hou := i shr 11;            // uv𕪉
      FDateTime.Min := (i shr 5) and $3f;   // uv𕪉
      FDateTime.Sec := i and $1f;           // ubv𕪉
      FTimeEnabled := True;                 // LƂ
    end;
  end;

  FBalance := Tbl[11] shl 8 + Tbl[10];  // c擾

  FInCode     := Tbl[6];                // w̘HR[h擾
  FInStation  := Tbl[7];                // w̉wR[h擾
  FOutCode    := Tbl[8];                // ow̘HR[h擾
  FOutStation := Tbl[9];                // ow̉wR[h擾
  FRegionCode := Tbl[15];               // nR[h擾
  if FRegionCode = 0 then begin
    if FInCode < $80 then begin         // JȐꍇ
      FAreaCode := 0;                   // nR[hwiiqj
    end
    else begin
      FAreaCode := 1;                   // nR[hwi֓Sj
    end;
  end
  else begin
    FAreaCode := 2;                     // nR[hwi֐Sj
  end;

end;

end.
