//**************************************************************************//
//                                                                          //
//  ` Accessf[^x[XȒPɈ߂̃NX  `                       //
//                                                                          //
//          F  Windows 2000/XP                                     //
//        RpCF  Delphi 5.0 (Build 5.108)                            //
//                                                                          //
//        t@CF  DBList.pas                                          //
//                                                                          //
//          ҖF  VRAM̖pt                                        //
//                                                                          //
//      ŏIXVtF  2008/10/13                                          //
//                                                                          //
//  NXׂ͂Ă̌^ւ̑ΉȂǂł                        //
//                                                                          //
//    MultiEventNXKgp邽߁A\[Xɑgݍł          //
//                                                                          //
//**************************************************************************//
unit DBList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls,ComObj,Contnrs;

type TDBParamItemMode = (pmEtc,pmString,pmInteger,pmDouble,pmDateTime,pmBoolean,pmDate,pmTime);
type TDBParamItemKey  = (pkNone,pkOverlaps,pkNotOverlaps,pkAutoNo);

//--------------------------------------------------------------------------//
//  ̃NXɃCxg𔭐NX                                //
//--------------------------------------------------------------------------//

type
  TMultiEventUpdateEvent = procedure(Sender, Arg: TObject) of object;
  TMultiEventReceive = class;

  TMultiEventSend = class(TComponent)
  private
    FObservers: TComponentList;
    function GetObservers(Index: Integer): TMultiEventReceive;
    function GetCount: Integer;
  protected
    property Observers[Index: Integer]: TMultiEventReceive read GetObservers;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure Add(Value: TMultiEventReceive);
    procedure Delete(Value: TMultiEventReceive);

    procedure Notify(Arg : TObject);

    property Count : Integer read GetCount;
  end;

  TMultiEventReceive = class(TComponent)
  private
    { Private 錾 }
    FObservable: TMultiEventSend;
    FOnUpdate: TMultiEventUpdateEvent;
    procedure SetObservable(const Value: TMultiEventSend);
  protected
    { Protected 錾 }
    procedure DoUpdate(Arg : TObject);
  public
    { Public 錾 }
    property Observable: TMultiEventSend read FObservable write SetObservable;
  published
    { Published 錾 }
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    property OnUpdate:TMultiEventUpdateEvent read FOnUpdate write FOnUpdate;
  end;

//--------------------------------------------------------------------------//
//  }`Cxg̎MȒPɈ߂̃NX                            //
//--------------------------------------------------------------------------//
type
  TMultiEventReceiveEx = class(TPersistent)
  private
    { Private 錾 }
    FOnChange: TNotifyEvent;
    FDisabled: Boolean;

    procedure OnSelfChange(Sender, Arg: TObject);
    procedure DoChange();
  protected
    FChange : TMultiEventReceive;
  public
    { Public 錾 }
    constructor Create();dynamic;
    destructor Destroy;override;

    property Disabled : Boolean read FDisabled write FDisabled;
    property OnChange : TNotifyEvent read FOnChange write FOnChange;
  end;

//--------------------------------------------------------------------------//
//  }`Cxg̑MɊȒPɈ߂̃NX                      //
//--------------------------------------------------------------------------//
type
  TMultiEventExSend = class(TPersistent)
  private
  { Private 錾 }
    FOnChange: TMultiEventSend;
    FOnAdd: TMultiEventSend;
    FOnClr: TMultiEventSend;
    FOnDel: TMultiEventSend;
  protected
    procedure DoChange();
    procedure DoAdd(Arg: TObject);
    procedure DoDel(Arg: TObject);
    procedure DoClr();
	public
		{ Public 錾 }
    constructor Create();
    destructor Destroy;override;

    property OnChange : TMultiEventSend read FOnChange;
    property OnAdd : TMultiEventSend read FOnAdd;
    property OnDel : TMultiEventSend read FOnDel;
    property OnClr : TMultiEventSend read FOnClr;
  end;

//--------------------------------------------------------------------------//
//  }`Cxg̎MɊȒPɈ߂̃NX                      //
//--------------------------------------------------------------------------//
type
  TMultiEventExRec = class(TPersistent)
  private
    { Private 錾 }
    FOnChange: TMultiEventUpdateEvent;
    FOnAdd   : TMultiEventUpdateEvent;
    FOnClr   : TMultiEventUpdateEvent;
    FOnDel   : TMultiEventUpdateEvent;

    procedure OnSelfChange(Sender, Arg: TObject);
    procedure OnSelfAdd(Sender, Arg: TObject);
    procedure OnSelfDel(Sender, Arg: TObject);
    procedure OnSelfClr(Sender, Arg: TObject);
  protected
    FChange : TMultiEventReceive;
    FAdd : TMultiEventReceive;
    FDel : TMultiEventReceive;
    FClr : TMultiEventReceive;
    FDisabled: Boolean;
  public
    { Public 錾 }
    constructor Create();virtual;
    destructor Destroy;override;

    // True : ꎞIɃCxg~
    property Disabled : Boolean read FDisabled write FDisabled;
    // J[\wݔωɔCxg
    property OnChange : TMultiEventUpdateEvent read FOnChange write FOnChange;
    property OnAdd : TMultiEventUpdateEvent read FOnAdd write FOnAdd;
    property OnDel : TMultiEventUpdateEvent read FOnDel write FOnDel;
    property OnClr : TMultiEventUpdateEvent read FOnClr write FOnClr;
  end;

//--------------------------------------------------------------------------//
//  Accessf[^x[X̗vfǗNX                                //
//--------------------------------------------------------------------------//
type
  TDBListParamItem = class(TPersistent)
  private
    { Private 錾 }
    FField : string;                 // f[^x[X̃tB[h
    FMode  : TDBParamItemMode;       // ^̎
    FKey : TDBParamItemKey;          // True : L[ƂĎgp
    FLen : Integer;                  // ^̏ꍇ̒

    FStr : ^string;                  // ^p|C^
    FInt : ^Integer;                 // l^p|C^
    FDouble : ^Double;               // ^p|C^
    FDateTime : ^TDateTime;
    FBool : ^Boolean;                // Bool^p|C^
    // f[^x[X֓nۂ̈͂ݕ`擾 1 "ABC"...
    function ParamValue() : string;
    // uColum = "abc"v̂悤Ȍ`擾
    function FieldEqValue() : string;
    // `pADO
    function ADOColumnAppend(var tbl : OleVariant) : Boolean;
    // vfv邩mF
    function Compare(d : TDBListParamItem) : Boolean;
  public
    { Public 錾 }
  end;

//--------------------------------------------------------------------------//
//  Accessf[^x[X̂PR[h̗vfǗNX                    //
//--------------------------------------------------------------------------//
type
  TDBListParamItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDBListParamItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    function Add() : TDBListParamItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDBListParamItem read GetItems;default;
    // YtB[h̃CfbNX擾
    function IndexOfField(const Field : string) : Integer;
  end;

//--------------------------------------------------------------------------//
//  Accessf[^x[X̂PR[hɑΉNX                          //
//--------------------------------------------------------------------------//
type
  TDBListItem = class(TPersistent)
  private
    { Private 錾 }
    FParams     : TDBListParamItems;    // f[^x[X̗ƕϐ̊֘AÂꗗ
    // f[^x[X̂PR[hf[^NXɒl𔽉f
    procedure SQLSelect(RcSt: OleVariant);
    // f[^NX̗vfUPDATEɕKvSQL쐬
    function SQLUpdate(const TableName : string) : string;
    function SQLInsert(const TableName : string) : string;
    function SQLExchange(const TableName : string) : string;
  protected
    // PR[h̃f[^NXf[^x[XɊ蓖Ă
    procedure SetParam(const Field : string;var Value : string;Key : TDBParamItemKey;Len : Integer);overload;
    procedure SetParam(const Field : string;var Value : Integer;Key : TDBParamItemKey);overload;
    procedure SetParam(const Field : string;var Value : Double;Key : TDBParamItemKey);overload;
    procedure SetParam(const Field : string;var Value : TDateTime;Key : TDBParamItemKey);overload;
    procedure SetParam(const Field : string;var Value : TDate;Key : TDBParamItemKey);overload;
    procedure SetParam(const Field : string;var Value : TTime;Key : TDBParamItemKey);overload;
    procedure SetParam(const Field : string;var Value : Boolean;Key : TDBParamItemKey);overload;
  public
    { Public 錾 }
    constructor Create;virtual;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    // L[v邩
    function Compare(d : TDBListItem) : Boolean;
    // Sv邩
    function CompareCheck(d : TDBListItem) : Boolean;
    // j[NȂhc̎擾͉ʃNXɈˑ
    function GetID() : string;virtual;abstract;
  end;

//--------------------------------------------------------------------------//
//  ω̃Cxg𔭐NX                                      //
//--------------------------------------------------------------------------//
type
  TDBListEventSend = class(TMultiEventExSend)
  private
    { Private 錾 }
  protected
    procedure DoChange();
    procedure DoAdd(dh : TDBListItem);
    procedure DoDel(dh : TDBListItem);
    procedure DoClr();
  public
    { Public 錾 }
  end;

//--------------------------------------------------------------------------//
//  ω̃Cxg󂯎NX                                        //
//--------------------------------------------------------------------------//
type
  TDBListEventRec = class(TMultiEventExRec)
  private
    { Private 錾 }
  protected
  public
    { Public 錾 }
   // constructor Create();override;
   // destructor Destroy;override;

  end;

//--------------------------------------------------------------------------//
//  Accessf[^x[XTList^̊oň߂̃NX                     //
//--------------------------------------------------------------------------//
type
  TDBList = class(TList)
  private
    { Private 錾 }
    FConnection : OLEVariant;      // f[^x[XڑNX
    FTableName: string;
    FFileName: string;
    FEngineName: string;
    FUserName: string;
    FPassword: string;
    FEvent: TDBListEventSend;
    FSynchronize: Boolean;
    // f[^x[Xڑ
    function Open() : Boolean;
    // f[^x[Xؒf
    function Close() : Boolean;
    // f[^x[Xڑp𐶐
    function ConnectionStr() : string;
    function GetItems(Index: Integer): TDBListItem;
    function SQLExchangeMake(dTo,dFrom : TDBListItem) : string;
    // f[^x[X̗Lΐ
    function CheckAndCreateDataBase() : Boolean;
    // e[u̗Lΐ
    function CheckAndCreateTable() : Boolean;
    // tB[h̗Lΐ
    function CheckAndCreateField() : Boolean;
    //procedure Add(d: TDBListItem);
  protected
    procedure DoAdd(d : TDBListItem);
    procedure DoDel(d : TDBListItem);
    procedure DoClr();
    procedure DoChange();
  public
    { Public 錾 }
    constructor Create;virtual;
    destructor Destroy;override;
    // f[^x[X̍ŏɌĂяo\bh
    function Initialize() : Boolean;
    //procedure Add(d : TDBListItem);
    function Add(d : TDBListItem) : TDBListItem;overload;
    function Add() : TDBListItem;overload;
    // f[^̐ʃNXɈˑ
    function CreateItem() : TDBListItem;virtual;abstract;
    procedure Delete(i : Integer);overload;
    procedure Delete(d : TDBListItem);overload;
    function Extract(ID : Integer) : Boolean;
    procedure Clear();override;
    procedure ClearDB();
    property Items[Index: Integer] : TDBListItem read GetItems;default;

    // f[^x[X̃j[NȃR[hY郊Xgʒu擾
    function IndexOfID(ID : string) : Integer;
    // f[^x[X̃R[hƈv郊Xgʒu擾
    function IndexOfItem(d : TDBListItem) : Integer;
    function IndexOfItemCheck(d : TDBListItem) : Integer;

    // f[^x[Xt@Cǂݍ݃Xgɔf
    function SQLLoadFromFile() : Boolean;
    // f[^x[Xt@CɈCɕۑ
    function SQLSaveToFile() : Boolean;
    // f[^x[X̂PR[hXV
    function SQLUpdate(d : TDBListItem) : Boolean;
    // f[^NX猟ʂXgƂ
    function SQLSelect(d : TDBListItem) : Integer;
    // f[^x[XɃR[hǉ
    function SQLInsert(d : TDBListItem) : Boolean;
    // f[^x[X̃R[hS폜
    function SQLClear() : Boolean;
    // f[^x[X烌R[h폜
    function SQLDelete(i : Integer) : Boolean;
    // ǉ鏈
    //function SQLColumn() : Boolean;
    // f[^x[X̂PR[hXViR[hԍXVj
    function SQLExchange(dTo,dFrom : TDBListItem) : Boolean;


    // f[^x[XGW
    property EngineName : string read FEngineName write FEngineName;
    // f[^x[Xt@C
    property FileName : string read FFileName write FFileName;
    // f[^x[Xe[u
    property TableName : string read FTableName write FTableName;
    // ANZX[U
    property UserName : string read FUserName write FUserName;
    // ANZXpX[h
    property Password : string read FPassword write FPassword;
    // True : f[^x[XƓ
    property Synchronize : Boolean read FSynchronize write FSynchronize;

    //procedure SetParam(const Field : string;var Value : string);
    // CxgMpNX
    property Event: TDBListEventSend read FEvent;
  end;

implementation

const
    //ADODB.DataTypeEnum
    adArray:            Integer =   8192;
    adBigInt:           Integer =   20;
    adBinary:           Integer =   128;
    adBoolean:          Integer =   11;
    adBSTR:             Integer =   8;
    adChapter:          Integer =   136;
    adChar:             Integer =   129;
    adCurrency:         Integer =   6;
    adDate:             Integer =   7;
    adDBDate:           Integer =   133;
    adDBTime:           Integer =   134;
    adDBTimeStamp:      Integer =   135;
    adDecimal:          Integer =   14;
    adDouble:           Integer =   5;
    adEmpty:            Integer =   0;
    adError:            Integer =   10;
    adFileTime:         Integer =   64;
    adGUID:             Integer =   72;
    adIDispatch:        Integer =   9;
    adInteger:          Integer =   3;
    adIUnknown:         Integer =   13;
    adLongVarBinary:    Integer =   205;
    adLongVarChar:      Integer =   201;
    adLongVarWChar:     Integer =   203;
    adNumeric:          Integer =   131;
    adPropVariant:      Integer =   138;
    adSingle:           Integer =   4;
    adSmallInt:         Integer =   2;
    adTinyInt:          Integer =   16;
    adUnsignedBigInt:   Integer =   21;
    adUnsignedInt:      Integer =   19;
    adUnsignedSmallInt: Integer =   18;
    adUnsignedTinyInt:  Integer =   17;
    adUserDefined:      Integer =   132;
    adVarBinary:        Integer =   204;
    adVarChar:          Integer =   200;
    adVariant:          Integer =   12;
    adVarNumeric:       Integer =   139;
    adVarWChar:         Integer =   202;
    adWChar:            Integer =   130;

{ TMultiEventSend }

procedure TMultiEventSend.Add(Value: TMultiEventReceive);
begin
  if FObservers.IndexOf(Value) < 0 then
    FObservers.Add(Value);
end;

constructor TMultiEventSend.Create(AOwner: TComponent);
begin
  inherited;
  FObservers := TComponentList.Create(False);
end;

destructor TMultiEventSend.Destroy;
begin
  FObservers.Free;
  inherited;
end;

function TMultiEventSend.GetObservers(Index: Integer): TMultiEventReceive;
begin
  Result := FObservers[Index] as TMultiEventReceive;
end;


procedure TMultiEventSend.Notify(Arg : TObject);
var i: Integer;
begin
  for i := 0 to FObservers.Count -1 do begin
    (FObservers[i] as TMultiEventReceive).DoUpdate(Arg);
  end;
end;

procedure TMultiEventSend.Delete(Value: TMultiEventReceive);
begin
  FObservers.Extract(Value);
end;

function TMultiEventSend.GetCount: Integer;
begin
  result := FObservers.Count;
end;

{ TMultiEventReceive }

procedure TMultiEventReceive.DoUpdate(Arg : TObject);
begin
  if Assigned(FOnUpdate) then
    FOnUpdate(Self, Arg);
end;

procedure TMultiEventReceive.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited;
  if (Operation = opRemove) and (AComponent = FObservable) then
    SetObservable(nil);
end;

procedure TMultiEventReceive.SetObservable(const Value: TMultiEventSend);
begin
  if Assigned(FObservable) then begin
    FObservable.Delete(Self);
  end;
  FObservable := Value;
  if Assigned(FObservable) then begin
    FObservable.Add(Self);
    FObservable.FreeNotification(Self);
  end;
end;

{ TMultiEventReceiveEx }

constructor TMultiEventReceiveEx.Create;
begin
  FChange := TMultiEventReceive.Create(nil);
  FChange.OnUpdate := OnSelfChange;
end;

destructor TMultiEventReceiveEx.Destroy;
begin
  FChange.Free;
  inherited;
end;

procedure TMultiEventReceiveEx.OnSelfChange(Sender, Arg: TObject);
begin
  DoChange();
end;

{ TMultiEventExSend }

constructor TMultiEventExSend.Create;
begin
  FOnChange := TMultiEventSend.Create(nil);
  FOnAdd := TMultiEventSend.Create(nil);
  FOnDel := TMultiEventSend.Create(nil);
  FOnClr := TMultiEventSend.Create(nil);
end;

destructor TMultiEventExSend.Destroy;
begin
  FOnClr.Free;
  FOnDel.Free;
  FOnAdd.Free;
  FOnChange.Free;
  inherited;
end;

procedure TMultiEventReceiveEx.DoChange;
begin
  if FDisabled then exit;
  if Assigned(FOnChange) then begin
    FOnChange(Self);
  end;
end;

procedure TMultiEventExSend.DoAdd(Arg: TObject);
begin
  FOnAdd.Notify(Arg);
end;

procedure TMultiEventExSend.DoDel(Arg: TObject);
begin
  FOnDel.Notify(Arg);
end;

procedure TMultiEventExSend.DoClr();
begin
  FOnClr.Notify(nil);
end;

procedure TMultiEventExSend.DoChange();
begin
  FOnChange.Notify(nil);
end;

{ TMultiEventExRec }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//   ̃NXpNXCreateOverride邾ł悢           //
//   yz                                                                 //
//     xxx.Create                                                           //
//     begin                                                                //
//       inherited;                                                         //
//       DM.HistWork.Event.OnChange.Add(FChange);                           //
//     end                                                                  //
//                                                                          //
//**************************************************************************//
constructor TMultiEventExRec.Create;
begin
  FChange := TMultiEventReceive.Create(nil);
  FChange.OnUpdate := OnSelfChange;
  FAdd := TMultiEventReceive.Create(nil);
  FAdd.OnUpdate := OnSelfAdd;
  FDel := TMultiEventReceive.Create(nil);
  FDel.OnUpdate := OnSelfDel;
  FClr := TMultiEventReceive.Create(nil);
  FClr.OnUpdate := OnSelfClr;
end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//   ̃NXpNXDestroyOverride邾ł悢          //
//   yz                                                                 //
//     xxx.Destory                                                          //
//     begin                                                                //
//       DM.HistWork.Event.OnChange.Delete(FChange);                        //
//       inherited;                                                         //
//     end                                                                  //
//                                                                          //
//**************************************************************************//
destructor TMultiEventExRec.Destroy;
begin
  FClr.Free;
  FDel.Free;
  FAdd.Free;
  FChange.Free;
  inherited;
end;


procedure TMultiEventExRec.OnSelfAdd(Sender, Arg: TObject);
begin
  if FDisabled then exit;
  if Assigned(FOnAdd) then begin
    FOnAdd(Self,Arg);
  end;
end;

procedure TMultiEventExRec.OnSelfChange(Sender, Arg: TObject);
begin
  if FDisabled then exit;
  if Assigned(FOnChange) then begin
    FOnChange(Self,Arg);
  end;
end;

procedure TMultiEventExRec.OnSelfClr(Sender, Arg: TObject);
begin
  if FDisabled then exit;
  if Assigned(FOnClr) then begin
    FOnClr(Self,Arg);
  end;
end;

procedure TMultiEventExRec.OnSelfDel(Sender, Arg: TObject);
begin
  if FDisabled then exit;
  if Assigned(FOnDel) then begin
    FOnDel(Self,Arg);
  end;
end;

{ TDBList }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TDBList.Create;
begin
  //FConnection := TConnection.Create(nil);
  FConnection := CreateOleObject('ADODB.Connection');

  FEngineName := 'Microsoft.Jet.OLEDB.4.0';
  FUserName   := 'admin';

  FEvent := TDBListEventSend.Create;
end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TDBList.Destroy;
begin
  FSynchronize := False;
  //FEvent.Free;
  Clear();
  FConnection := Unassigned;
  FreeAndNil(FEvent);
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^x[X̍ŏɌĂяo@`                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TDBList.Initialize: Boolean;
begin
  result := True;
  try
    CheckAndCreateDataBase();                      // f[^x[X݂Ȃΐ
    CheckAndCreateTable();                         // e[u݂Ȃΐ
    CheckAndCreateField();                         // tB[h݂Ȃΐ
  except
    result := False;
  end;

end;
{
procedure TDBList.Add(d : TDBListItem);
var
  f : Boolean;
begin
  if FSynchronize then begin            // f[^x[XƓꍇ
    f := SQLInsert(d);                  // f[^x[Xւ̒ǉs
    if not f then exit;                 // ǉɎsꍇI
  end;
  inherited Add(d);                     //
  DoAdd(d);                             // f[^ǉCxgs
end;
}
//**************************************************************************//
//                                                                          //
//  `@XgɃf[^ǉ@`                                        //
//                                                                          //
//   - Input -  d : ǉf[^                                          //
//                                                                          //
//   - Output - XgɒǉAf[^                      //
//                                                                          //
//   ̃f[^́A֐Ăяoׂł                       //
//                                                                          //
//**************************************************************************//
function TDBList.Add(d: TDBListItem): TDBListItem;
var
  f : Boolean;
  dd : TDBListItem;
begin
  result := nil;
  if FSynchronize then begin            // f[^x[XƓꍇ
    f := SQLInsert(d);                  // f[^x[Xւ̒ǉs
    if not f then exit;                 // ǉɎsꍇI
  end;
  dd := CreateItem();                   // Ăǂ悤ɕʂɐ
  try
    dd.Assign(d);                         // NXɒl
    inherited Add(dd);                    // ̃NXXgɒǉ
    DoAdd(dd);                            // f[^ǉCxgs
    DoChange();
    result := dd;                         // ̃NXԂ

  finally
    //dd.Free;
  end;

end;

//**************************************************************************//
//                                                                          //
//  `@XgɃf[^ǉ@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - Xgɒǉf[^                                      //
//                                                                          //
//   Add(d: TDBListItem)Ƃ͈قȂf[^x[Xɔf邱Ƃ͂Ȃ      //
//                                                                          //
//**************************************************************************//
function TDBList.Add: TDBListItem;
var
  d : TDBListItem;
begin
  d := CreateItem();
  inherited Add(d);                     //
  DoAdd(d);                             // f[^ǉCxgs
  DoChange();
  result := d;
end;


//**************************************************************************//
//                                                                          //
//  `@XgSf[^폜@`                                    //
//                                                                          //
//   - Input -  aSynchronize : True:SQL̃f[^S폜                     //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDBList.Clear();
var
  i : Integer;
begin
  DoClr();
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited Clear();
  DoChange();
end;

procedure TDBList.ClearDB;
var
  f : Boolean;
begin
  if FSynchronize  then begin            // f[^x[XƓꍇ
    f := SQLClear();                     // f[^x[Xւ̒ǉs
    if not f then exit;                  // ǉɎsꍇI
  end;
  Clear();
end;

procedure TDBList.Delete(i: Integer);
begin
  DoDel(Items[i]);
  if FSynchronize then begin
    SQLDelete(i);
  end;
  Items[i].Free;
  inherited;
  DoChange();
end;

procedure TDBList.Delete(d: TDBListItem);
var
  i : Integer;
begin
  i := IndexOfItem(d);
  if i = -1 then exit;
  Delete(i);
end;

function TDBList.Extract(ID: Integer): Boolean;
begin
  result := True;
end;

function TDBList.GetItems(Index: Integer): TDBListItem;
begin
  result := inherited Items[Index];
end;

//**************************************************************************//
//                                                                          //
//  `@f[^x[XڑJn@`                                            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDBList.Open: Boolean;
var
  s : string[255];
begin
  result := True;
  try
    s := ConnectionStr();                          // ڑp擾
    FConnection.ConnectionString := s;
    FConnection.Open;                              // f[^x[Xڑ
  except
    result := False;
  end;

end;

//**************************************************************************//
//                                                                          //
//  `@f[^x[XڑI@`                                            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDBList.Close: Boolean;
begin
  FConnection.Close;                     // f[^x[Xؒf
  result := True;
end;

function TDBList.ConnectionStr: string;
var
  s : string;
begin
  // Provider=Microsoft.Jet.OLEDB.4.0;Data Source=
  s := 'Provider='+FEngineName+';';            // f[^x[XGWw
  s := s + 'Data Source='+FileName+';';        // f[^x[Xt@Cw
  //s := s + 'User ID='+FUsername+';';              // ANZX[Uw
  //s := s + 'Password='+FPassword;               // ANZXpX[hw
  result := s;
end;

function TDBList.CheckAndCreateDataBase: Boolean;
var
  s : string[255];
  Catalog: OleVariant;
begin
  result := True;
  try
    if not FileExists(FFileName) then begin        // f[^x[Xt@C݂Ȃꍇ
      Catalog := CreateOleObject('ADOX.Catalog');  // ADOXIuWFNg
      s := ConnectionStr();                        // ڑp擾
      Catalog.Create(s);                           // f[^x[Xt@C쐬
    end;
  except
    result := False;
  end;
end;

function TDBList.CheckAndCreateTable: Boolean;
var
  i : Integer;
  f : Boolean;
  Catalog: OleVariant;
  Table :  OleVariant;
  sp : string[254];
begin
  Catalog := CreateOleObject('ADOX.Catalog');            // ADOXIuWFNg
  sp := ConnectionStr();                                 // ڑp擾
  Catalog.ActiveConnection := sp;                        // f[^x[XANeBu

  f := False;
  for i := 0 to Catalog.Tables.Count - 1 do begin        // e[uvf[v
    if Catalog.Tables[i].type <> 'TABLE' then continue;  // vfe[uȊȌꍇȂ
    if Catalog.Tables[i].Name = FTableName then begin    // we[uƖ̂vꍇ
      f := True;                                         // e[u݂邱Ƃ
      break;                                             // I
    end;
  end;
  if not f then begin                                    // e[u݂Ȃꍇ
    Table := CreateOleObject('ADOX.Table');              // e[uIuWFNg
    Table.Name := FTableName;                            // e[uw
    //Table.Columns.Append(FTableName, adInteger);       // e[ũtB[hǉ
    Catalog.Tables.Append(Table);                        // VKe[uƂĒǉ
    result := False;
  end
  else begin
    result := True;
  end;
  Catalog := Unassigned;
end;

function TDBList.CheckAndCreateField: Boolean;
var
  s : string[255];
  d : TDBListItem;
  i,j,k : Integer;
  ts : TStringList;
  Catalog,Table,Column,Connection : OleVariant;
begin
  result := False;
  ts := TStringList.Create;
  d := CreateItem();                      // NXǉ
  try
    Catalog    := CreateOleObject('ADOX.Catalog');
    Connection := CreateOleObject('ADODB.Connection');
    s := ConnectionStr();                                 // ڑp擾
    Catalog.ActiveConnection := s;                        // f[^x[XANeBu
    Connection.ConnectionString  := s;
    try
      Table := Catalog.Tables[FTableName];
      Connection.Open;
      try
        for i := 0 to Table.Columns.Count-1 do begin
          Column := Table.Columns[i];
          ts.Add(Column.Name);
        end;
        for j := 0 to d.FParams.Count-1 do begin      // f[^̗vf[v
          k := ts.IndexOf(d.FParams[j].FField);       // f[^̗vftB[hɑ݂邩
          if k <> -1 then continue;                   // ݂ȂڍsȂ
          if d.FParams[j].FKey = pkAutoNo then begin
            s := 'Alter Table ' + TableName + ' ADD ' + d.FParams[j].FField + ' Counter(1);';
            Connection.Execute(s);            // SQLs
            continue;
          end;
          d.FParams[j].ADOColumnAppend(Table);        // ADO𗘗pătB[hǉ

        end;
      finally
        Connection.Close;
        Table := Unassigned;
      end;

    finally
      Connection := Unassigned;
      Catalog := Unassigned;
    end;
  finally
    d.Free;
    ts.Free;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^x[Xt@Cǂݍ݃Xgɔf@`                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDBList.SQLLoadFromFile: Boolean;
var
  s : string;
  FRcA: OleVariant;
  FRcSt: OleVariant;
  d : TDBListItem;
  f : Boolean;
begin
  result := False;
  Clear();                                    // ꗗ
  f := Open();                                     // f[^x[Xڑ
  if not f then exit;
  s := 'SELECT * FROM ';                      // SQL쐬
  s := s + TableName + ';';
  try
    FRcSt := FConnection.Execute(s, FRcA, 0); // SQLs
    try
      while not FRcSt.EOF do begin              // ʂ̖[܂Ń[v
        d := CreateItem();                      // NXǉ
        inherited Add(d);
        d.SQLSelect(FRcSt);                     // ʂ̃R[hNXɔf
        FRcSt.MoveNext;                       // ̃R[hփJ[\ړ
      end;
      result := True;
    finally
      FRcSt.Close;                              // ʃR[h̏I
    end;
  finally
    Close();                                  // f[^x[Xؒf
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^x[Xt@CɈCɕۑ@`                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDBList.SQLSaveToFile: Boolean;
var
  s,ss : string;
  FRcA: OleVariant;
  d : TDBListItem;
  f : Boolean;
  j : Integer;
  ts : TStringStream;
begin
  result := False;
  f := Open();                                     // f[^x[Xڑ
  if not f then exit;
  ss := '';
  ts := TStringStream.Create(ss);
  try
    s := 'BEGIN TRANSACTION;';
    FConnection.Execute(s, FRcA, 0);          // SQLs
    for j := 0 to Count-1 do begin
      d := Items[j];

      //i := IndexOfItemCheck(d);                   // IDv郊Xgʒu擾
      //if i <> -1 then continue;                   // ꍇI

    //StopTimStart(1);
      //ts.WriteString(d.SQLInsert(FTableName)+#$0d#$0a);               // f[^XVpSQL쐬
      s := d.SQLInsert(FTableName);
      FConnection.Execute(s, FRcA, 0);          // SQLs
    //StopTimStart(1);
    end;
    //ts.Seek(0, soFromBeginning);
    //ss := ts.DataString;
    //FConnection.Execute(ss, FRcA, 0);          // SQLs
    s := 'COMMIT TRANSACTION;';
    FConnection.Execute(s, FRcA, 0);          // SQLs

    {
    FRcSt := FConnection.Execute(s, FRcA, 0); // SQLs
    try
      while not FRcSt.EOF do begin              // ʂ̖[܂Ń[v
        d := CreateItem();                      // NXǉ
        inherited Add(d);
        d.SQLSelect(FRcSt);                     // ʂ̃R[hNXɔf
        FRcSt.MoveNext;                       // ̃R[hփJ[\ړ
      end;
      result := True;
    finally
      FRcSt.Close;                              // ʃR[h̏I
    end;
    }
  finally
    Close();                                  // f[^x[Xؒf
    ts.Free;
  end;
end;

function TDBList.SQLInsert(d: TDBListItem): Boolean;
var
  i : Integer;
  s : string;
  FRcA: OleVariant;
begin
  result := False;
  i := IndexOfItemCheck(d);                   // IDv郊Xgʒu擾
  if i <> -1 then exit;                        // ꍇI
  s := d.SQLInsert(FTableName);               // f[^XVpSQL쐬

  Open();                                     // f[^x[Xڑ
  try
    FConnection.Execute(s, FRcA, 0);          // SQLs
    //d2 := CreateItem;                          // f[^̑
    //d2.Assign(d);                          // f[^̑
    //inherited Add(d2);
    result := True;
  finally
    Close();                                  // f[^x[Xؒf
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^x[X̂PR[hXV@`                                  //
//                                                                          //
//   - Input -  ID : XVΏۂƂȂ郆j[NȂhc                           //
//              d  : XV郌R[he                                   //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDBList.SQLUpdate(d: TDBListItem): Boolean;
var
  i : Integer;
  s : string;
  FRcA: OleVariant;
 // FRcSt: Recordset;
begin
  result := False;
  i := IndexOfItem(d);                        // IDv郊Xgʒu擾
  if i = -1 then exit;                        // ȂꍇI
  s := d.SQLUpdate(FTableName);               // f[^XVpSQL쐬

  Open();                                     // f[^x[Xڑ
  try
    FConnection.Execute(s, FRcA, 0);          // SQLs
    Items[i].Assign(d);                       // f[^̑
    result := True;
  finally
//    FRcSt.Close;
    Close();                                  // f[^x[Xؒf
  end;
end;

function TDBList.SQLExchange(dTo, dFrom: TDBListItem): Boolean;
var
  i : Integer;
  s : string;
  FRcA: OleVariant;
begin
  result := False;
  i := IndexOfItem(dTo);                      // IDv郊Xgʒu擾
  if i = -1 then exit;                        // ȂꍇI
  s := SQLExchangeMake(dTo, dFrom);     // f[^XVpSQL쐬

  Open();                                     // f[^x[Xڑ
  try
    FConnection.Execute(s, FRcA, 0);          // SQLs
    Items[i].Assign(dFrom);                   // f[^̑
    result := True;
  finally
    Close();                                  // f[^x[Xؒf
  end;
end;

function TDBList.SQLExchangeMake(dTo, dFrom: TDBListItem): string;
var
  s : string;
  i : Integer;
  d : TDBListParamItem;
  f : Boolean;
begin
  result := '';
  s := 'UPDATE ';                            // UPDATEpSQL̐
  s := s + TableName + ' SET ';
  f := False;
  for i := 0 to dFrom.FParams.Count-1 do begin     // vf[v
    d := dFrom.FParams[i];                         // vfNXQ
    //if d.FKey <> pkNone then continue;
    if f then s := s + ',';                  // SQL\̓rł΁u,vǉ
    s := s + d.FieldEqValue();
    f := True;
  end;
  s := s + ' WHERE ';
  f := False;
  for i := 0 to dTo.FParams.Count-1 do begin     // vf[v
    d := dTo.FParams[i];                         // vfNXQ
    if d.FKey = pkNone then continue;
    if f then s := s + ' AND';               // SQL\̓rł΁u,vǉ
    s := s + d.FieldEqValue();
    f := True;
  end;

  result := s;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^x[X̂PR[h폜@`                                  //
//                                                                          //
//   - Input -  i : XgNX̃CfbNXl                            //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDBList.SQLDelete(i : Integer): Boolean;
var
  s : string;
  FRcA: OleVariant;
  j : Integer;
  d : TDBListItem;
  dp : TDBListParamItem;
  f : Boolean;
begin

  s := 'DELETE FROM ' + FTableName                     // SQL쐬
                        + ' WHERE ';
  f := False;
  d := CreateItem();
  try
    for j := 0 to d.FParams.Count-1 do begin         // R[hvf[v
      dp := Items[i].FParams[j];                    // 폜Ώۂ̗vfNXQ

      if dp.FKey = pkNone then continue;
      if f then s := s + ' AND ';                     // Qڈȍ~̗vf̏ꍇuANDvŋ؂
      s := s + dp.FieldEqValue;                     // uxx = "abc"v̌`o
      f := True;
    end;
    s := s + ';';                                    // SQL\̏IƂ
  finally
    d.Free;
  end;

  try
    Open();                                          // f[^x[Xڑ
    FConnection.Execute(s,FRcA,0);                   // SQLs
    //Delete(i);                                       // Xgf[^폜
    result := True;
  finally
    Close();
  end;

end;

//**************************************************************************//
//                                                                          //
//  `@f[^x[X̑SR[h폜@`                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDBList.SQLClear(): Boolean;
var
  s : string;
  FRcA: OleVariant;
begin
  s := 'DELETE FROM ' + FTableName + ';';           // R[hS폜pSQL쐬
  try
    Open();                                         // f[^x[Xڑ
    FConnection.Execute(s,FRcA,0);                  // SQLs
    result := True;
  finally
    Close();
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@f[^NX猟ʂXgƂ@`                        //
//                                                                          //
//   - Input -  Keys : L[                                             //
//                                                                          //
//   - Output - Yf[^                                                //
//                                                                          //
//--------------------------------------------------------------------------//
function TDBList.SQLSelect(d : TDBListItem): Integer;
var
  s : string;
  FRcA: OleVariant;
  FRcSt: OleVariant;
  i : Integer;
  di : TDBListItem;
  dp : TDBListParamItem;
  f : Boolean;
begin

  s := 'SELECT * FROM ' + FTableName                     // SQL쐬
                        + ' WHERE ';
  f := False;
  di := CreateItem();
  try
    for i := 0 to d.FParams.Count-1 do begin               // R[hvf[v
      dp := d.FParams[i];                                  // vfNXQ
      if dp.FKey = pkNone then continue;
      if f then s := s + ' AND ';                       // Qڈȍ~̗vf̏ꍇuANDvŋ؂
      s := s + dp.FieldEqValue();
      f := True;
    end;
    s := s + ';';                                          // SQL\̏IƂ
  finally
    di.Free;
  end;

  try
    Open();                                              // f[^x[Xڑ
    FRcSt := FConnection.Execute(s,FRcA,0);              //SQLs
    Clear();
    while not FRcSt.EOF do begin                         // ʂ̖[܂Ń[v
      d := CreateItem();                                 // NXǉ
      inherited Add(d);                                            // NXǉ
      d.SQLSelect(FRcSt);                                // ʂ̃R[hNXɔf
      FRcSt.MoveNext();                                  // ̃R[hփJ[\ړ
    end;

    result := Count;
  finally
    FRcSt.Close;
    Close();
  end;

end;

//**************************************************************************//
//                                                                          //
//  `@f[^x[X̃j[NȃR[hY郊Xgʒu擾@`      //
//                                                                          //
//   - Input -  ID : Ώۂ̃j[NȂhc                               //
//                                                                          //
//   - Output - -1 : YR[h -1ȊO:Xgʒu                       //
//                                                                          //
//  NX̂ǂ̕ϐIDȂ̂GetIDʂĉʃNXˑƂ       //
//                                                                          //
//**************************************************************************//
function TDBList.IndexOfID(ID: string): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].GetID = ID then begin
      result := i;
      exit;
    end;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^x[X̃R[hƈv郊Xgʒu擾@`                //
//                                                                          //
//   - Input -  d : rf[^NX                                    //
//                                                                          //
//   - Output - -1 : YR[h -1ȊO:Xgʒu                       //
//                                                                          //
//**************************************************************************//
function TDBList.IndexOfItem(d: TDBListItem): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Compare(d) then begin
      result := i;
      exit;
    end;
  end;
end;

function TDBList.IndexOfItemCheck(d: TDBListItem): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].CompareCheck(d) then begin
      result := i;
      exit;
    end;
  end;
end;

procedure TDBList.DoAdd(d : TDBListItem);
begin
  if FEvent = nil then exit;
  FEvent.DoAdd(d);
end;

procedure TDBList.DoDel(d : TDBListItem);
begin
  if FEvent = nil then exit;
  FEvent.DoDel(d);
end;

procedure TDBList.DoClr();
begin
  if FEvent = nil then exit;
  FEvent.DoClr();
end;

procedure TDBList.DoChange();
begin
  if FEvent = nil then exit;
  FEvent.DoChange();
end;

{ TDBListItem }

constructor TDBListItem.Create;
begin
  inherited;
  FParams := TDBListParamItems.Create;
end;

destructor TDBListItem.Destroy;
begin
  FParams.Free;
  inherited;
end;

procedure TDBListItem.Assign(Source: TPersistent);
//var
//  a : TDBItem;
begin
  if Source is TDBListItem then begin
    //a := TDBItem(Source);                 // 炭sv
    //FID := a.FID;
  end
  else begin
    inherited;
  end;
end;

procedure TDBListItem.SetParam(const Field: string; var Value: Integer;
  Key : TDBParamItemKey);
var
  d : TDBListParamItem;
begin
  d := FParams.Add();              // p[^NXXgɒǉ
  d.FInt := @Value;                // p[^ւ̒l|C^i[
  d.FField := Field;               // tB[ĥi[
  d.FMode := pmInteger;                 // j[Nlǂi[
  d.FKey  := Key;
end;

procedure TDBListItem.SetParam(const Field: string; var Value: Double;
  Key: TDBParamItemKey);
var
  d : TDBListParamItem;
begin
  d := FParams.Add();                 // p[^NXXgɒǉ
  d.FDouble := @Value;                // p[^ւ̒l|C^i[
  d.FField := Field;                  // tB[ĥi[
  d.FMode := pmDouble;                // ^̎ނi[
  d.FKey  := Key;                     // j[Nlǂi[
end;

//**************************************************************************//
//                                                                          //
//  `@PR[h̃f[^NXf[^x[XɊ蓖Ă@`          //
//                                                                          //
//   - Input -  Field : f[^x[X̊YtB[h                  //
//              Value : Yf[^̃|C^                            //
//              Mode  : j[NlǂʒmĂ                    //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//   ľ^̎ޕ̊֐OverloadɂėpӂKv               //
//                                                                          //
//**************************************************************************//
procedure TDBListItem.SetParam(const Field: string; var Value: string;
  Key : TDBParamItemKey;Len : Integer);
var
  d : TDBListParamItem;
begin
  d := FParams.Add();              // p[^NXXgɒǉ
  d.FStr := @Value;                // p[^ւ̒l|C^i[
  d.FField := Field;               // tB[ĥi[
  d.FMode := pmString;                 // j[Nlǂi[
  d.FKey  := Key;
  d.FLen := Len;
end;

procedure TDBListItem.SetParam(const Field: string; var Value: TDateTime;
   Key: TDBParamItemKey);
var
  d : TDBListParamItem;
begin
  d := FParams.Add();                   // p[^NXXgɒǉ
  d.FDateTime := @Value;                // p[^ւ̒l|C^i[
  d.FField := Field;                    // tB[ĥi[
  d.FMode := pmDateTime;                // j[Nlǂi[
  d.FKey  := Key;
end;

procedure TDBListItem.SetParam(const Field: string; var Value: TDate;
  Key: TDBParamItemKey);
var
  d : TDBListParamItem;
begin
  d := FParams.Add();                   // p[^NXXgɒǉ
  d.FDateTime := @Value;                // p[^ւ̒l|C^i[
  d.FField := Field;                    // tB[ĥi[
  d.FMode := pmDate;                    // j[Nlǂi[
  d.FKey  := Key;
end;

procedure TDBListItem.SetParam(const Field: string; var Value: TTime;
  Key: TDBParamItemKey);
var
  d : TDBListParamItem;
begin
  d := FParams.Add();                   // p[^NXXgɒǉ
  d.FDateTime := @Value;                // p[^ւ̒l|C^i[
  d.FField := Field;                    // tB[ĥi[
  d.FMode := pmTime;                    // j[Nlǂi[
  d.FKey  := Key;
end;

procedure TDBListItem.SetParam(const Field: string; var Value: Boolean;
  Key: TDBParamItemKey);
var
  d : TDBListParamItem;
begin
  d := FParams.Add();                   // p[^NXXgɒǉ
  d.FBool := @Value;                    // p[^ւ̒l|C^i[
  d.FField := Field;                    // tB[ĥi[
  d.FMode := pmBoolean;                 // j[Nlǂi[
  d.FKey  := Key;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@f[^x[X̂PR[hf[^NXɒl𔽉f@`        //
//                                                                          //
//   - Input -  RcSt : PR[h\f[^                               //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TDBListItem.SQLSelect(RcSt: OleVariant);
  function GetFields(df : OleVariant) : Boolean;
  var
    m : Integer;
    v : Variant;
  begin
    v := df.Value;             // loAg^Ŏ擾
    m := VarType(v);           // ^𒲍
    result := (m <> VarNull)   // ł͂Ȃꍇ True
  end;
var
  i : Integer;
  d : TDBListParamItem;
  //m : DataTypeEnum;
  m : Integer;
  df : OleVariant;
  v : Variant;
  dd : TDateTime;
begin
  for i := 0 to FParams.Count-1 do begin    // f[^vf[v
    d := FParams.Items[i];                  // PvfQ
    case d.FMode of
      pmInteger:
      begin
        df := RcSt.Fields[d.FField];
        v := df.Value;
        m := VarType(v);
        if m <> VarNull then begin          // ̕ł͂Ȃꍇ
          d.FInt^ := df.Value;              // YϐɊYtB[h̃f[^i[
        end
        else begin                          // ̏̕ꍇ
          d.FInt^ := 0;                     // Yϐ̒l
        end;
      end;
      pmDouble:
      begin
        df := RcSt.Fields[d.FField];
        if GetFields(df) then begin          // ̕ł͂Ȃꍇ
          d.FDouble^ := df.Value;              // YϐɊYtB[h̃f[^i[
        end
        else begin                          // ̏̕ꍇ
          d.FDouble^ := 0;                     // Yϐ̒l
        end;
      end;
      pmString:
      begin
        df := RcSt.Fields[d.FField];
        v := df.Value;
        m := VarType(v);
        if m <> VarNull then begin          // ̕ł͂Ȃꍇ
          d.FStr^ := df.Value;              // YϐɊYtB[h̃f[^i[
        end
        else begin                          // ̏̕ꍇ
          d.FStr^ := '';                    // ɐݒ
        end;
      end;
      pmDateTime:
      begin
        df := RcSt.Fields[d.FField];
        v := df.Value;
        m := VarType(v);
        if m <> VarNull then begin          // ̕ł͂Ȃꍇ
          dd := VarToDateTime(df.Value);
          d.FDateTime^ :=dd;  // YϐɊYtB[h̃f[^i[
        end
        else begin                          // ̏̕ꍇ
          //d.FStr^ := '';                    // ɐݒ
        end;
      end;
      pmBoolean:
      begin
        df := RcSt.Fields[d.FField];
        v := df.Value;
        m := VarType(v);
        if m <> VarNull then begin          // ̕ł͂Ȃꍇ
          d.FBool^ := df.Value;              // YϐɊYtB[h̃f[^i[
        end
        else begin                          // ̏̕ꍇ
          d.FBool^ := False;                     // Yϐ̒l
        end;
      end;
    end;

  end;
end;


//--------------------------------------------------------------------------//
//                                                                          //
//  `@f[^NX̗vfUPDATEɕKvSQL쐬@`                   //
//                                                                          //
//   - Input -  TableName : e[u                                    //
//                                                                          //
//   - Output - SQL                                                         //
//                                                                          //
//--------------------------------------------------------------------------//
function TDBListItem.SQLUpdate(const TableName : string): string;
var
  s : string;
  i : Integer;
  d : TDBListParamItem;
  f : Boolean;
begin
  result := '';
  s := 'UPDATE ';                            // UPDATEpSQL̐
  s := s + TableName + ' SET ';
  f := False;
  for i := 0 to FParams.Count-1 do begin     // vf[v
    d := FParams[i];                         // vfNXQ
    if d.FKey <> pkNone then continue;
    if f then s := s + ',';                  // SQL\̓rł΁u,vǉ
    s := s + d.FieldEqValue();
    f := True;
  end;
  s := s + ' WHERE ';
  f := False;
  for i := 0 to FParams.Count-1 do begin     // vf[v
    d := FParams[i];                         // vfNXQ
    if d.FKey = pkNone then continue;
    if f then s := s + ' AND';               // SQL\̓rł΁u,vǉ
    s := s + d.FieldEqValue();
    f := True;
  end;

  result := s;
end;

function TDBListItem.SQLExchange(const TableName: string): string;
var
  s : string;
  i : Integer;
  d : TDBListParamItem;
  f : Boolean;
begin
  result := '';
  s := 'UPDATE ';                            // UPDATEpSQL̐
  s := s + TableName + ' SET ';
  f := False;
  for i := 0 to FParams.Count-1 do begin     // vf[v
    d := FParams[i];                         // vfNXQ
    //if d.FKey <> pkNone then continue;
    if f then s := s + ',';                  // SQL\̓rł΁u,vǉ
    s := s + d.FieldEqValue();
    f := True;
  end;
  s := s + ' WHERE ';
  f := False;
  for i := 0 to FParams.Count-1 do begin     // vf[v
    d := FParams[i];                         // vfNXQ
    if d.FKey = pkNone then continue;
    if f then s := s + ' AND';               // SQL\̓rł΁u,vǉ
    s := s + d.FieldEqValue();
    f := True;
  end;

  result := s;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@f[^NX̗vfInsertɕKvSQL쐬@`                   //
//                                                                          //
//   - Input -  TableName : e[u                                    //
//                                                                          //
//   - Output - SQL                                                         //
//                                                                          //
//--------------------------------------------------------------------------//
function TDBListItem.SQLInsert(const TableName: string): string;
var
  s,sf,sv : string;
  i : Integer;
  d : TDBListParamItem;
  f : Boolean;
begin
  result := '';
  s := 'INSERT INTO ' + TableName;             // UPDATEpSQL̐
  f := False;
  sv := '';
  sf := '';
    for i := 0 to FParams.Count-1 do begin       // vf[v
      d := FParams[i];                           // vfNXQ
      if d.FKey = pkAutoNo then continue;
      if f then begin                            // SQL\̓ȑꍇ
        sf := sf + ',';                          // u,vǉ
        sv := sv + ',';
      end;
      sf := sf + d.FField;                       // tB[hwpSQL
      sv := sv + d.ParamValue;                   // lwpSQL
      f := True;
    end;
    s := s + '(' + sf + ')' + ' VALUES(' + sv + ');'; // InsertpSQLŜ쐬
  result := s;
end;
{
function TDBListItem.SQLInsert(const TableName: string): string;
var
  s,sf,sv : string;
  i : Integer;
  d : TDBListParamItem;
  f : Boolean;
begin
  result := '';
  s := 'INSERT INTO ' + TableName;             // UPDATEpSQL̐
  f := False;
  sv := '';
  sf := '';
  for i := 0 to FParams.Count-1 do begin       // vf[v
    d := FParams[i];                           // vfNXQ
    if d.FKey = pkAutoNo then continue;
    if f then begin                            // SQL\̓ȑꍇ
      sf := sf + ',';                          // u,vǉ
      sv := sv + ',';
    end;
    sf := sf + d.FField;                       // tB[hwpSQL
    sv := sv + d.ParamValue;                   // lwpSQL
    f := True;
  end;
  s := s + '(' + sf + ') VALUES(' + sv + ');'; // InsertpSQLŜ쐬
  result := s;
end;
}
//**************************************************************************//
//                                                                          //
//  `@L[v邩@`                                        //
//                                                                          //
//   - Input -  d : rvfNX                                      //
//                                                                          //
//   - Output - True : v                                                 //
//                                                                          //
//**************************************************************************//
function TDBListItem.Compare(d : TDBListItem): Boolean;
var
  i : Integer;
  dp1,dp2 : TDBListParamItem;
  f : Boolean;
begin
  result := False;
  for i := 0 to FParams.Count-1 do begin       // vf[v
    dp1 := FParams[i];
    dp2 := d.FParams[i];
    if dp1.FKey = pkNone then continue;        // L[ł͂ȂꍇȂ
    f := dp1.Compare(dp2);                     // rs
    if not f then exit;                        // sv̒iKŏI
  end;
  result := True;                              // SvƂ
end;

//**************************************************************************//
//                                                                          //
//  `@Sv邩@`                                              //
//                                                                          //
//   - Input -  d : rvfNX                                      //
//                                                                          //
//   - Output - True : v                                                 //
//                                                                          //
//**************************************************************************//
function TDBListItem.CompareCheck(d: TDBListItem): Boolean;
var
  i : Integer;
  dp1,dp2 : TDBListParamItem;
  f,ff : Boolean;
begin
  result := False;
  ff := False;
  for i := 0 to FParams.Count-1 do begin       // vf[v
    dp1 := FParams[i];
    dp2 := d.FParams[i];
    if dp1.FKey = pkNone then continue;        // L[ł͂ȂꍇȂ
    if dp1.FKey = pkAutoNo then begin          // I[gio[tB[h̏ꍇ
      result := False;                         // Sv郌R[h͖Ƃ
      exit;                                    // I
    end ;
    f := dp1.Compare(dp2);                     // l̔rs
    if not f then exit;                        // sv̒iKŏI
    ff := True;                                // PłrsƂL
  end;
  if ff then begin                             // rꍇ
    result := True;                            // SvƂ
  end
  else begin                                   // rꍇ
    result := False;                           // svƂ
  end;
end;

{ TDBListParamItems }

destructor TDBListParamItems.Destroy;
begin
  Clear();
  inherited;
end;

function TDBListParamItems.Add: TDBListParamItem;
var
  d : TDBListParamItem;
begin
  d := TDBListParamItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDBListParamItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TDBListParamItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDBListParamItems.GetItems(Index: Integer): TDBListParamItem;
begin
  result := inherited Items[Index];
end;


function TDBListParamItems.IndexOfField(const Field: string): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].FField = Field then begin
      result := i;
      exit;
    end;
  end;

end;

{ TDBListParamItem }

//--------------------------------------------------------------------------//
//                                                                          //
//  `@vfv邩mF@`                                            //
//                                                                          //
//   - Input -  d : rvfNX                                      //
//                                                                          //
//   - Output - True : v                                                 //
//                                                                          //
//   vf͌^Ƃɕʂ̕ϐɊi[Ă邽߂̃\bhŔr     //
//                                                                          //
//--------------------------------------------------------------------------//
function TDBListParamItem.Compare(d: TDBListParamItem): Boolean;
begin
  result := False;
  case FMode of
    pmInteger : result  := FInt^ = d.FInt^;          // l^̏ꍇ
    pmDouble : result  := FDouble^ = d.FDouble^;     // ^̏ꍇ
    pmString  : result := FStr^ = d.FStr^;           // ^̏ꍇ
    pmDateTime: result := FDateTime^ = d.FDateTime^; // ^̏ꍇ
    pmBoolean : result := FBool^ = d.FBool^;
  end;

end;

function TDBListParamItem.FieldEqValue: string;
begin
  result := FField + ' = ' + ParamValue();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@SQL֓nۂ̈͂ݕ`擾 1 "ABC"...@`                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - SQLpp[^                                             //
//                                                                          //
//--------------------------------------------------------------------------//
function TDBListParamItem.ParamValue: string;
var
  s : string;
begin
  s := '';
  case FMode of
    // l^̏ꍇ
    pmInteger :  s := IntToStr(FInt^);
    // l^̏ꍇ
    pmDouble :  s := FloatToStr(FDouble^);
    // ^̏ꍇ
    pmString  :   s := '"' + FStr^+'"';
    // ^̏ꍇ
    pmDateTime:   s := '#' + FormatDateTime('yyyy/mm/dd hh:mm:ss',FDateTime^)+'#';
    // t^̏ꍇ
    pmDate:       s := '#' + FormatDateTime('yyyy/mm/dd',FDateTime^)+'#';
    // ^̏ꍇ
    pmTime:       s := '#' + FormatDateTime('hh:mm:ss',FDateTime^)+'#';
    // Yes/NO^̏ꍇ
    pmBoolean:    begin
                    if FBool^ then begin
                      s := '-1';
                    end
                    else begin
                      s := '0';
                    end;
                    //s := IntToStr(Integer(FBool^));
                  end;
  end;
  result := s;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ADO𗘗ptB[hǉs@`                                 //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//--------------------------------------------------------------------------//
function TDBListParamItem.ADOColumnAppend(var tbl : OleVariant): Boolean;
begin
  result := True;
  try
    case FMode of
      // l^̏ꍇ
      pmInteger :  tbl.Columns.Append(FField, adInteger);
      // ^̏ꍇ
      pmDouble:  tbl.Columns.Append(FField, adDouble);
      // ^̏ꍇ
      pmString  :  tbl.Columns.Append(FField, adVarWChar,FLen);
      // ^̏ꍇ
      //pmDateTime:   tbl.Columns.Append(FField, adDBTimeStamp);
      pmDateTime:   tbl.Columns.Append(FField, adDate);
      // t^̏ꍇ
      pmDate:   tbl.Columns.Append(FField, adDate);
      // t^̏ꍇ
      pmTime:   tbl.Columns.Append(FField, adDate);
      // Bool^̏ꍇ
      pmBoolean:   tbl.Columns.Append(FField, adBoolean);
    end;
  except
    result := False;
  end;

end;

{ TDBListEventSend }

procedure TDBListEventSend.DoAdd(dh: TDBListItem);
begin
  inherited DoAdd(dh);
end;

procedure TDBListEventSend.DoChange();
begin
  inherited DoChange();
end;

procedure TDBListEventSend.DoClr;
begin
  inherited DoClr();
end;

procedure TDBListEventSend.DoDel(dh: TDBListItem);
begin
  inherited DoDel(dh);
end;

end.
