unit FormMainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   StdCtrls,DBList,ShFolder, ComCtrls, ExtCtrls;

function GetMyDocFolder() : string;

type
  TDBConfigItem = class(TDBListItem)
  private
    { Private 錾 }
    FID   : Integer;                    // Ǘԍ
    FUser : string;                     // [U[
    FAge : Integer;                     // N
    FDateTime : TDateTime;              // a

  public
    { Public 錾 }
    constructor Create;override;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    function GetID() : string;override;

    property ID : Integer read FID write FID;
    property User : string read FUser write FUser;
    property Age : Integer read FAge write FAge;
    property DateTime : TDateTime read FDateTime write FDateTime;
  end;

type
  TDBConfigItems = class(TDBList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDBConfigItem;
  public
    { Public 錾 }
    constructor Create;override;
    destructor Destroy;override;
    function CreateItem(): TDBListItem;override;
    function Add(): TDBConfigItem;
    property Items[Index: Integer] : TDBConfigItem read GetItems;default;

  end;

type
  TFormMain = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    Panel1: TPanel;
    Edit1: TEdit;
    Edit2: TEdit;
    ComboBox1: TComboBox;
    DateTimePicker1: TDateTimePicker;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure Edit2Exit(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure DateTimePicker1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private 錾 }
    FDBList : TDBConfigItems;
    function DataToStr(d : TDBConfigItem) : string;
    procedure DataSet();
  public
    { Public 錾 }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

procedure TFormMain.FormCreate(Sender: TObject);
begin
  FDBList := TDBConfigItems.Create;
  FDBList.Synchronize := True;
  FDBList.Initialize();
  FDBList.SQLLoadFromFile();
end;

procedure TFormMain.FormDestroy(Sender: TObject);
begin
  FDBList.Free;
end;
{ TDBConfigItems }

constructor TDBConfigItems.Create;
var
  s : string;
begin
  inherited;
  s := GetMyDocFolder();
  s := s + 'test.mdb';
  FileName := s;
  TableName := 'Tݒ}X^';
end;

destructor TDBConfigItems.Destroy;
begin
  Clear();
  inherited;
end;

function TDBConfigItems.Add: TDBConfigItem;
var
  d :TDBConfigItem;
begin
  d := TDBConfigItem.Create;
 inherited Add(d);
  result := d;
end;

function TDBConfigItems.CreateItem: TDBListItem;
var
  d :TDBConfigItem;
begin
  d := TDBConfigItem.Create;
  result := d;
end;

function TDBConfigItems.GetItems(Index: Integer): TDBConfigItem;
begin
  result := TDBConfigItem(inherited Items[Index]);
end;

{ TDBConfigItem }

procedure TDBConfigItem.Assign(Source: TPersistent);
var
  a : TDBConfigItem;
begin
  if Source is TDBConfigItem then begin
    a := TDBConfigItem(Source);
    FID       := a.FID;
    FUser     := a.FUser;
    FAge      := a.FAge;
    FDateTime := a.FDateTime;
    inherited;
  end
  else begin
    inherited;
  end;
end;

constructor TDBConfigItem.Create;
begin
  inherited;
  SetParam('Ǘԍ',FID,pkAutoNo);
  SetParam('O',FUser,pkNone,20);
  SetParam('N',FAge,pkNone);
  SetParam('a',FDateTime,pkNone);
end;

destructor TDBConfigItem.Destroy;
begin
  inherited;

end;

function TDBConfigItem.GetID: string;
begin
//  result := FID;
end;

//**************************************************************************//
//                                                                          //
//  `@MyDocumenttH_擾@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - tH_                                                  //
//                                                                          //
//**************************************************************************//
function GetMyDocFolder: string;
var
  s : string;
  csid,i : Integer;
begin;
  SetLength(s, MAX_PATH);                          // Path̍ő咷m
  csid := CSIDL_PERSONAL;                          // MyDocumenttH_̎擾w
  SHGetFolderPath(0, csid or                       // tH_̎擾
                  CSIDL_FLAG_CREATE,0,0,PChar(s));
  i := Pos(#$0,s);                                 // k̈ʒu擾
  SetLength(s,i-1);                                // 񒷂ۂ̒ɍ킹
  result := s+'\';                                 // ^CR[_pf[^tH_ƂĎ擾
end;

procedure TFormMain.Button1Click(Sender: TObject);
var
  d : TDBConfigItem;
begin
  d := TDBConfigItem.Create();
  d.User := 'VKf[^';
  d.DateTime := Now;
  d.Age := 0;
  FDBList.SQLInsert(d);
  ListBox1.Items.AddObject(DataToStr(d),d);
end;

function TFormMain.DataToStr(d: TDBConfigItem): string;
var
  s : string;
begin
  s := d.FUser;
  result := s;
end;

procedure TFormMain.FormShow(Sender: TObject);
var
  i : Integer;
  d : TDBConfigItem;
begin
  for i := 0 to FDBList.Count-1 do begin
    d := FDBList.Items[i];
    ListBox1.Items.AddObject(DataToStr(d),d);
  end;

end;

procedure TFormMain.ListBox1Click(Sender: TObject);
var
  i : Integer;
  d : TDBConfigItem;
begin
  i := TListBox(Sender).ItemIndex;
  if i = -1 then exit;
  d := TDBConfigItem(TListBox(Sender).Items.Objects[i]);
  Panel1.Enabled := False;
  Edit1.Text := IntToStr(d.ID);
  Edit2.Text := d.User;
  ComboBox1.ItemIndex := d.Age;
  DateTimePicker1.DateTime := d.DateTime;
  Panel1.Enabled := True;
  Panel1.Visible := True;
end;

procedure TFormMain.DataSet;
var
  i : Integer;
  d : TDBConfigItem;
begin
  i := ListBox1.ItemIndex;
  if i = -1 then exit;
  d := TDBConfigItem(ListBox1.Items.Objects[i]);
  //d.ID := Edit1.Text;
  d.User := Edit2.Text;
  d.Age := ComboBox1.ItemIndex;
  d.DateTime := DateTimePicker1.DateTime;
  FDBList.SQLUpdate(d);
  ListBox1.Items.Strings[i] := d.User;
end;

procedure TFormMain.Edit1Exit(Sender: TObject);
begin
  DataSet();
end;

procedure TFormMain.Edit2Exit(Sender: TObject);
begin
  DataSet();
end;

procedure TFormMain.ComboBox1Change(Sender: TObject);
begin
  DataSet();
end;

procedure TFormMain.DateTimePicker1Change(Sender: TObject);
begin
  DataSet();
end;

procedure TFormMain.Button2Click(Sender: TObject);
var
  i : Integer;
begin
  i := ListBox1.ItemIndex;
  if i = -1 then exit;
  FDBList.SQLDelete(i);
  ListBox1.Items.Delete(i);
end;

end.
