//**************************************************************************//
//                                                                          //
//  ` v`udt@CĐNX(Build12) `                               //
//                                                                          //
//          F  v  95/98/NT4.0/2000/XP                 //
//        gpׁ߲F  c T.O (Build 5.108)                    //
//                                                                          //
//        t@CF  vouD                          //
//                                                                          //
//          ҖF  uq`l̖pt                                    //
//                                                                          //
//      ŏIXVtF  QOOS^OR^QX                                //
//                                                                          //
//**************************************************************************//
unit WavePlayV;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,MMSystem,ExtCtrls;

const
  HEAP_ZERO_MEMORY = $00000008;

//==========================================================================//
//  ŕێĂf[^̎                                          //
//==========================================================================//
type TWaveMode = (wmMakeWave,wmLoadWave);

//==========================================================================//
//  oblMIbZ[W\                                          //
//==========================================================================//
type TWOMDone = record
   Msg      : Cardinal;
   hWaveOut : HWAVEOUT;
   pWaveHdr : PWAVEHDR;
   Result   : Integer;
  end;

//==========================================================================//
//  oblo̓foCXf[^NX                                          //
//==========================================================================//
type TWaveOutDevice = class
  private
    { Private 錾 }
    FName        : string;              // 
    FMakerID     : Integer;             // hc
    FProductID   : Integer;             // v_Nghc
    FVerLarge    : Integer;             // o[Wԍij
    FVerSmall    : Integer;             // o[WԍiQj
    FFormats     : Integer;             // gp\Ȍ`
    FChannels    : Integer;             // 1:m 2:XeI
    FSupport     : Integer;             // T|[gԍ
  public
    { Public 錾 }
    property MakerID     : Integer read FMakerID;
    property ProductID   : Integer read FProductID;
    property VerLarge    : Integer read FVerLarge;
    property VerSmall    : Integer read FVerSmall;
    property Name        : string read FName;
    property Formats     : Integer read FFormats;
    property Channels    : Integer read FChannels;
    property Support     : Integer read FSupport;
end;

//==========================================================================//
//  Xg^oblo̓foCXf[^NX                                  //
//==========================================================================//
type TWaveOutDevices = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TWaveOutDevice;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Clear();override;
    property Items[Index: Integer] : TWaveOutDevice read GetItems;default;
    procedure Initialize();
  end;


//==========================================================================//
//  oblo̓NX                                                        //
//==========================================================================//
type
  //TWavePlayV = class(TCustomControl)
  TWavePlayV = class(TComponent)
  private
    { Private 錾 }
    FTimer     : TTimer;
    FHandle: HWND;                           // EChEnh

    FHmmio     : HMMIO;                // v`udo̓foCXhc
    FSCSize    : DWORD;
    FDataSize  : DWORD;
    FhWavOut   : HWAVEOUT;

    FMmckInfoP : MMCKINFO;
    FMmckInfoS : MMCKINFO;

    FpWavEhdr  : PWAVEHDR;
    FpSubchunk : PWaveFormatEx;
    FpData     : pChar;

    FOutDevices : TWaveOutDevices;     // o̓foCXꗗ

    FPortNo   : Longword;              // o̓|[g
    FPlayLoopCount : Integer;          // g`M[v
    FLoopFlag : Boolean;               // True : [v
    FPlaying: Boolean;                 // True : f[^M
    FWaveMode : TWaveMode;             // f[^̎ގʗp
    FOpened : Boolean;                 // True : |[gI[v
    FVolumeMax : Integer;              // TEh{[h̍ő剹
    FVolumeRight: Integer;             // Đ{[Ei0-255j
    FVolumeLeft: Integer;              // Đ{[i0-255j

    FOnPlayStop: TNotifyEvent;

    procedure WndProc(var Msg: TMessage);
    // mۂ̉
    procedure HeapFreeProc();
    // v`udf[^Ɋmۂ
    procedure WaveMemoryAlloc(aLoopCount : Integer);
    // v`udf[^
    procedure WaveMemoryFree();
    // v`udg`f[^쐬
    procedure MakeWaveData(aFrequency : Integer);
    // ʂݒ肷
    procedure ProcVolumeSet();
    // ʂ̍őlƌݒl擾
    procedure ProcVolumeGet();
    // WaveĐȈ
    procedure ProcPlayFinish();
    // foCXɃf[^o
    function Write() : Boolean;
    // ^C}[Cxg
    procedure OnTimer(Sender: TObject);

    procedure ClearMemory();

    function GetPortNo: Integer;
    procedure SetPortNo(const Value: Integer);
    procedure SetVolumeLeft(const Value: Integer);
    procedure SetVolumeRight(const Value: Integer);
    function GetVolume: Integer;
    procedure SetVolume(const Value: Integer);

    function GetVolumeLeft: Integer;
    function GetVolumeRight: Integer;
  protected
    procedure DoPlayStop();
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    // v`udf[^t@Cǂݍ
    function LoadFromFile(const FileName : string) : Boolean;
    // v`udf[^Đ
    function Play(aLoop : Boolean) :Boolean;
    // o͂~
    function Stop() : Boolean;
    // foCXZbg
    function Reset() : Boolean;
    // o̓|[gJ
    function PortOpen() : Boolean;
    // o̓|[g
    function PortClose() : Boolean;
    // uU[쐬
    function MakeWave(aFrequency,aLengthOn,aLengthOff : Integer) :Boolean;

    // True : f[^M
    property Playing : Boolean read FPlaying;
    // Eꊇ̉ʒl
    property Volume : Integer read GetVolume write SetVolume;
    // ʁij
    property VolumeLeft : Integer read GetVolumeLeft write SetVolumeLeft;
    // ʁiEj
    property VolumeRight : Integer read GetVolumeRight write SetVolumeRight;
    // gp\ȉ{[hꗗ
    property Devices : TWaveOutDevices read FOutDevices;
    // gp鉹ԍ(-1:Windowsw肷鉹)
    property PortNo : Integer read GetPortNo write SetPortNo;
    // ĐICxg
    property OnPlayStop : TNotifyEvent read FOnPlayStop write FOnPlayStop;
  end;

implementation

{ TWavePlayV }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//**************************************************************************//
constructor TWavePlayV.Create(AOwner: TComponent);
begin
  inherited;
  FHandle := AllocateHWnd(WndProc);      // ƎEChEnh𐶐
  FOutDevices := TWaveOutDevices.Create;
  FTimer := TTimer.Create(Self);
  FTimer.OnTimer := OnTimer;
  FTimer.Interval := 100;
  FTimer.Enabled := False;
  FPortNo := WAVE_MAPPER;                 // o̓|[g̏lWindowsw
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//**************************************************************************//
destructor TWavePlayV.Destroy;
begin
  Stop;
  WaveMemoryFree();
  HeapFreeProc();
  FTimer.Free;
  FOutDevices.Free;
  DeallocateHWND(FHandle);
  inherited;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@mۂ̉@`                                            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TWavePlayV.HeapFreeProc;
begin
  HeapFree(GetProcessHeap, 0, FpSubchunk);
  HeapFree(GetProcessHeap, 0, FpData);
  HeapFree(GetProcessHeap, 0, FpWavEhdr);
end;

procedure TWavePlayV.ClearMemory;
begin
  HeapFree(GetProcessHeap, 0, FpSubchunk);
  HeapFree(GetProcessHeap, 0, FpData);
end;

//**************************************************************************//
//                                                                          //
//  `@v`udf[^t@Cǂݍށ@`                            //
//                                                                          //
//   - Input -  FileName : ǂݍރt@C                               //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//**************************************************************************//
function TWavePlayV.LoadFromFile(const FileName: string): Boolean;
var
  res: MMRESULT;
begin
  result := False;

  ClearMemory();

  Fhmmio := mmioOpen(PChar(FileName), nil, MMIO_READ);
  try
    if Fhmmio = 0 then begin
      exit;
    end;

    mmioSeek(Fhmmio, 0, SEEK_SET);
    FMmckInfoP.fccType := mmioStringToFOURCC(PChar('WAVE'), 0);
    res := mmioDescend(Fhmmio, @FMmckInfoP, nil, MMIO_FINDRIFF);
    if res <> MMSYSERR_NOERROR then begin
      exit;
    end;

    FMmckInfoS.ckid := mmioStringToFOURCC(PChar('fmt '), 0);
    res := mmioDescend(Fhmmio, @FMmckInfoS, @FMmckInfoP,MMIO_FINDCHUNK);
    if res <> MMSYSERR_NOERROR then begin
      exit;
    end;

    FSCSize := FMmckInfoS.cksize;
    FpSubchunk := HeapAlloc(GetProcessHeap, HEAP_ZERO_MEMORY,FSCSize);
    if (mmioRead(Fhmmio,PChar( FpSubchunk), FSCSize) <> LongInt(FSCSize)) then begin
      HeapFree(GetProcessHeap, 0, FpSubchunk);
      exit;
    end;

    mmioAscend(Fhmmio, @FMmckInfoS, 0);
    FMmckInfoS.ckid := mmioStringToFOURCC(PChar('data'), 0);
    res := mmioDescend(Fhmmio, @FMmckInfoS, @FMmckInfoP,MMIO_FINDCHUNK);
    if res <> MMSYSERR_NOERROR then begin
      HeapFree(GetProcessHeap, 0, FpSubchunk);
      exit;
    end;

    FDataSize := FMmckInfoS.cksize;
    FpData := HeapAlloc(GetProcessHeap, HEAP_ZERO_MEMORY, FDataSize);
    if (mmioRead(Fhmmio, FpData, FDataSize) <> LongInt(FDataSize)) then begin
      HeapFree(GetProcessHeap, 0, FpSubchunk);
      HeapFree(GetProcessHeap, 0, FpData);
      exit;
    end;
  finally
    mmioClose(FHmmio, 0);
  end;

  FWaveMode := wmLoadWave;

  PortClose();
  WaveMemoryFree();

  PortOpen();
  WaveMemoryAlloc(1);
  FTimer.Interval := 10;

  result := True;
end;


//--------------------------------------------------------------------------//
//                                                                          //
//  `@^C}[Cxg@`                                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TWavePlayV.OnTimer(Sender: TObject);
begin
  FTimer.Enabled := False;
  Write();

end;

//**************************************************************************//
//                                                                          //
//  `@v`udf[^Đ@`                                            //
//                                                                          //
//   - Input -  aLoop : True>쐬g`AĐ                         //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//**************************************************************************//
function TWavePlayV.Play(aLoop: Boolean): Boolean;
begin
  if FPlaying then begin
    Stop();
  end;
  FLoopFlag := aLoop;
  ProcVolumeSet();
  Write();
  result := True;
end;

//**************************************************************************//
//                                                                          //
//  `@o̓|[g@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TWavePlayV.PortClose: Boolean;
var
  res: MMRESULT;
begin
  res := waveOutClose(FhWavOut);
  result := res = MMSYSERR_NOERROR;
  FOpened := False;
end;

//**************************************************************************//
//                                                                          //
//  `@o̓|[gJ@`                                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TWavePlayV.PortOpen: Boolean;
var
  res: MMRESULT;
begin
  result := False;
  if FOpened then begin
    PortClose();
  end;
  if FPortNo = WAVE_MAPPER then begin
    res := waveOutOpen(@FhWavOut, WAVE_MAPPER, FpSubchunk,DWORD(FHandle), 0, CALLBACK_WINDOW);
  end
  else begin
    res := waveOutOpen(@FhWavOut, FPortNo, FpSubchunk,DWORD(FHandle), 0, CALLBACK_WINDOW);
  end;
  if res <> MMSYSERR_NOERROR then begin
    HeapFree(GetProcessHeap, 0, FpSubchunk);
    HeapFree(GetProcessHeap, 0, FpData);
    exit;
  end;
  ProcVolumeGet();
  FOpened := True;
  result := True;
end;

//**************************************************************************//
//                                                                          //
//  `@o͂~@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TWavePlayV.Stop: Boolean;
var
  res: MMRESULT;
begin
  FTimer.Enabled := False;
  FLoopFlag := False;
  res := waveOutReset(FhWavOut);
  result := res = MMSYSERR_NOERROR;
  if FLoopFlag then begin
    WaveMemoryFree();
    PortClose();
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@foCXZbg@`                                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TWavePlayV.Reset: Boolean;
var
  res: MMRESULT;
begin
  res := waveOutReset(FhWavOut);
  result := res = MMSYSERR_NOERROR;
end;

//**************************************************************************//
//                                                                          //
//  `@uU[쐬@`                                              //
//                                                                          //
//   - Input -  aFrequency : g                                         //
//              aVolume    :                                            //
//              aLengthOn  : nmԁi10łPbj                           //
//              aLengthOff : neeԁi10łPbj                         //
//              aLoop      : Trueiv[v                               //
//                                                                          //
//   - Output - True : I                                             //
//                                                                          //
//**************************************************************************//
function TWavePlayV.MakeWave(aFrequency, aLengthOn,
  aLengthOff: Integer): Boolean;
begin
  //result := False;
  FWaveMode := wmMakeWave;

  PortClose();
  WaveMemoryFree();

  FTimer.Interval := aLengthOff * 100;

  MakeWaveData(aFrequency);
  PortOpen();
  WaveMemoryAlloc(FPlayLoopCount * aLengthOn div 10);
  result := True;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@v`udf[^Ɋmۂ@`                                //
//                                                                          //
//   - Input -  aLoopCount : o̓[v                                 //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TWavePlayV.WaveMemoryAlloc(aLoopCount : Integer);
begin
  FpWavEhdr := HeapAlloc(GetProcessHeap, HEAP_ZERO_MEMORY, SizeOf(WAVEHDR));

  FpWavEhdr.lpData         := FpData;
  FpWavEhdr.dwBufferLength := FDataSize;
  FpWavEhdr.dwFlags        := WHDR_BEGINLOOP + WHDR_ENDLOOP;
  FpWavEhdr.dwLoops        := aLoopCount;

  waveOutPrepareHeader(FhWavOut, FpWavEhdr, SizeOf(WAVEHDR));

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@v`udf[^@`                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TWavePlayV.WaveMemoryFree;
begin
  waveOutUnPrepareHeader(FhWavOut, FpWavEhdr, SizeOf(WAVEHDR));
  if FpWavEhdr  <> nil then begin
    HeapFree(GetProcessHeap, 0, FpWavEhdr);
    FpWavEhdr := nil;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@v`udg`f[^쐬@`                                        //
//                                                                          //
//   - Input -  aFrequency : gigj                                 //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TWavePlayV.MakeWaveData(aFrequency : Integer);
const
  srate = 44100;               // 44.1kHz ̃TvOƂ
var
  i,j,k : Integer;
begin

  if FpSubchunk <> nil then HeapFree(GetProcessHeap, 0, FpSubchunk);
  if FpData     <> nil then HeapFree(GetProcessHeap, 0, FpData);

  FSCSize    := sizeof(TWaveFormatEx);
  FpSubchunk := HeapAlloc(GetProcessHeap, HEAP_ZERO_MEMORY,FSCSize);


  k := srate div aFrequency;
  FPlayLoopCount := aFrequency;

  FpData    := HeapAlloc(GetProcessHeap, HEAP_ZERO_MEMORY, k*2);
  FDataSize := k*2;

  for i := 0 to k-1 do begin
    j := i * $ffff div (k - 1);
    FpData[i*2+0] := char(j and $ff);
    FpData[i*2+1] := char((j shr 8) and $ff);
  end;

  FpSubchunk^.wFormatTag := WAVE_FORMAT_PCM;
  FpSubchunk^.nChannels  := 1;
  FpSubchunk^.nSamplesPerSec := srate;
  FpSubchunk^.nAvgBytesPerSec := srate;
  FpSubchunk^.wBitsPerSample := 16;
  FpSubchunk^.nBlockAlign := FpSubchunk^.nChannels * FpSubchunk^.wBitsPerSample div 8;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@foCXɃf[^ó@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//--------------------------------------------------------------------------//
function TWavePlayV.Write: Boolean;
var
  res: MMRESULT;
begin
  res := waveOutWrite(FhWavOut, FpWavEhdr, SizeOf(WAVEHDR));
  if res = MMSYSERR_NOERROR then begin
    result := True;
    FPlaying := True;
  end
  else begin
    result := False;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ʂݒ肷@`                                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TWavePlayV.ProcVolumeSet;
var
  d,aVL,aVR : DWord;
begin
  //if not FOpened then exit;                   // |[gĂȂ疢
  aVL := FVolumeLeft  * FVolumeMax div 256;   // ʌvZij
  aVR := FVolumeRight * FVolumeMax div 256;   // ʌvZiEj
  d := (aVR shl 16) or (aVL);                 // E̒lʂƂ
  waveOutSetVolume(FhWavOut,d);               // ʂݒ
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@WaveĐȈ@`                                            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TWavePlayV.ProcPlayFinish;
begin
  if FLoopFlag then begin
    FTimer.Enabled := True;
    Reset();
  end
  else begin
    Reset();
    FPlaying := False;
    DoPlayStop();
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ʂ̍őlƌݒl擾@`                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//  ̉ʍőlFFFFŖꍇ̂ŁȂΉ                  //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TWavePlayV.ProcVolumeGet;
var
  d,d2 : DWord;
  aVL,aVR : Integer;
begin
  waveOutGetVolume(FhWavOut,@d);              // ݂̉ʂ擾
  try                                         // K̉ʂɖ߂
    d2 := $ffffffff;                          // ő剹ʒlݒ
    waveOutSetVolume(FhWavOut,d2);            // ől^
    waveOutGetVolume(FhWavOut,@d2);           // ^̍ő剹ʂ擾
    FVolumeMax := d2 and $ffff;               // ő剹ʂƂ
    aVR := d shr 16;                          // ʂ擾iEj
    aVL := d and $ffff;                       // ʂ擾ij
    FVolumeLeft  := aVL * 255 div FVolumeMax; // 0`255͈̔͂ƂẲʂ擾ij
    FVolumeRight := aVR * 255 div FVolumeMax; // 0`255͈̔͂ƂẲʂ擾iEj
  finally
    waveOutSetVolume(FhWavOut,d);             // ̉ʂɖ߂
  end;
end;

procedure TWavePlayV.DoPlayStop;
begin
  if Assigned(FOnPlayStop) then begin
    FOnPlayStop(Self);
  end;
end;

function TWavePlayV.GetPortNo: Integer;
begin
  result := FPortNo;
end;

procedure TWavePlayV.SetPortNo(const Value: Integer);
begin
  FPortNo := Value;
end;

procedure TWavePlayV.SetVolumeLeft(const Value: Integer);
begin
  FVolumeLeft := Value;
  ProcVolumeSet();
end;

procedure TWavePlayV.SetVolumeRight(const Value: Integer);
begin
  FVolumeRight := Value;
  ProcVolumeSet();
end;

function TWavePlayV.GetVolume: Integer;
begin
  ProcVolumeGet();
  result := (FVolumeLeft + FVolumeRight) div 2;
end;

procedure TWavePlayV.SetVolume(const Value: Integer);
begin
  FVolumeLeft := Value;
  FVolumeRight := Value;
  ProcVolumeSet();
end;

{ TWaveOutDevices }

procedure TWaveOutDevices.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

constructor TWaveOutDevices.Create;
begin
  Initialize();
end;

destructor TWaveOutDevices.Destroy;
begin
  Clear();
  inherited;
end;

function TWaveOutDevices.GetItems(Index: Integer): TWaveOutDevice;
begin
  result := inherited Items[Index];
end;

procedure TWaveOutDevices.Initialize;
var
  i,cnt : Integer;
  d : WAVEOUTCAPS;
  t : TWaveOutDevice;
begin
  Clear();
  cnt := waveOutGetNumDevs();
  for i := 0 to cnt-1 do begin
    waveOutGetDevCaps(i,@d,Sizeof(d));
    t := TWaveOutDevice.Create;
    inherited Add(t);
    t.FMakerID   := d.wMid;
    t.FProductID := d.wPid;
    t.FVerLarge  := (d.vDriverVersion shr 8) and $ff;
    t.FVerSmall  := d.vDriverVersion and $ff;
    t.FFormats   := d.dwFormats;
    t.FChannels  := d.wChannels;
    t.FSupport   := d.dwSupport;
    t.FName      := d.szPname;
  end;

end;

function TWavePlayV.GetVolumeLeft: Integer;
begin
  ProcVolumeGet();
  result := FVolumeLeft;
end;

function TWavePlayV.GetVolumeRight: Integer;
begin
  ProcVolumeGet();
  result := FVolumeRight;
end;

procedure TWavePlayV.WndProc(var Msg: TMessage);
begin
  if (Msg.Msg = MM_WOM_DONE)  then begin        // WaveĐICxg̏ꍇ
    try
      ProcPlayFinish();                         // ĐȈs
    except
      Application.HandleException(Self);
    end
  end
  else begin                                    // WaveĐIȊÕCxg̏ꍇ
    Msg.Result := DefWindowProc(FHandle,Msg.Msg,Msg.wParam, Msg.lParam);
  end;
end;

end.
