unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,MMSystem,WavePlayV;

type
  TFormMain = class(TForm)
    OpenDialog1: TOpenDialog;
    Button3: TButton;
    Button4: TButton;
    Button1: TButton;
    ScrBarFrequency: TScrollBar;
    Button2: TButton;
    Label2: TLabel;
    ScrollBar3: TScrollBar;
    Label3: TLabel;
    ScrollBar4: TScrollBar;
    Label8: TLabel;
    Label9: TLabel;
    GBoxVolume: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    ScrBarVolume: TScrollBar;
    ScrBarVolumeLeft: TScrollBar;
    ScrBarVolumeRight: TScrollBar;
    Label5: TLabel;
    Label4: TLabel;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    LBoxDevice: TListBox;
    Label10: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ScrBarVolumeChange(Sender: TObject);
    procedure ScrBarVolumeLeftChange(Sender: TObject);
    procedure ScrBarVolumeRightChange(Sender: TObject);
    procedure ScrBarFrequencyChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private 錾 }
    FWavePlayV : TWavePlayV;
    procedure OnPlayStop(Sender: TObject);
    procedure ShowDevices();
  public
    { Public 錾 }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

{ TForm1 }

procedure TFormMain.FormCreate(Sender: TObject);
begin
  FWavePlayV := TWavePlayV.Create(Self);
end;

procedure TFormMain.FormDestroy(Sender: TObject);
begin
  FWavePlayV.Free;
end;

procedure TFormMain.Button3Click(Sender: TObject);
begin
  OpenDialog1.InitialDir := ExtractFilePath(Application.ExeName);
  if OpenDialog1.Execute then begin
    FWavePlayV.LoadFromFile(OpenDialog1.FileName);
  end;
end;

procedure TFormMain.Button4Click(Sender: TObject);
begin
  FWavePlayV.PortOpen();
  FWavePlayV.Play(True);
end;

procedure TFormMain.Button2Click(Sender: TObject);
begin
  FWavePlayV.Stop;
end;

procedure TFormMain.Button1Click(Sender: TObject);
begin
  FWavePlayV.MakeWave(ScrBarFrequency.Position,
                  ScrollBar3.Position,ScrollBar4.Position);
end;

procedure TFormMain.ScrBarVolumeChange(Sender: TObject);
begin
  FWavePlayV.Volume := TScrollBar(Sender).Position;
end;

procedure TFormMain.OnPlayStop(Sender: TObject);
begin
  FWavePlayV.PortClose();
end;

procedure TFormMain.ScrBarVolumeLeftChange(Sender: TObject);
begin
  FWavePlayV.VolumeLeft := ScrBarVolumeLeft.Position;
end;

procedure TFormMain.ScrBarVolumeRightChange(Sender: TObject);
begin
  FWavePlayV.VolumeRight := ScrBarVolumeRight.Position;
end;

procedure TFormMain.ScrBarFrequencyChange(Sender: TObject);
begin
  FWavePlayV.Stop();
  FWavePlayV.MakeWave(ScrBarFrequency.Position,
                  ScrollBar3.Position,ScrollBar4.Position);
  FWavePlayV.PortOpen();
  FWavePlayV.Play(True);
end;

procedure TFormMain.FormShow(Sender: TObject);
begin
  FWavePlayV.PortOpen();
  ScrBarVolumeLeft.Position := FWavePlayV.VolumeLeft;
  ScrBarVolumeRight.Position := FWavePlayV.VolumeRight;
  ScrBarVolume.Position := FWavePlayV.Volume;
  FWavePlayV.PortClose();
  ShowDevices();
end;

procedure TFormMain.ShowDevices;
var
  s : string;
  d : TWaveOutDevice;
  i : Integer;
begin
  LBoxDevice.Clear;
  s := '(Windows W)';
  LBoxDevice.Items.Add(s);
  for i := 0 to FWavePlayV.Devices.Count-1 do begin
    d := FWavePlayV.Devices.Items[i];
    s := d.Name;
    LBoxDevice.Items.Add(s);
  end;


end;

end.
