unit StringListEx;

interface

uses
	Windows,Messages, SysUtils, Classes, Graphics, Controls,StdCtrls, ExtCtrls;

type
	TStringListEx = class(TStringList)
	private
		{ Private 錾 }
    function GetCommaTextEx: string;
    procedure SetCommaTextEx(const Value: string);
    function CommaToMarkText(const str : string) : string;
    function MarkTextToComma(const str : string) : string;
	public
		{ Public 錾 }
    property CommaTextEx : string read GetCommaTextEx write SetCommaTextEx;
    function GetInt() : Integer;
    function GetStr() : string;
    function GetColor() : TColor;
    function GetBool() : Boolean;
    function GetDateTime() : TDateTime;

    procedure SetInt(Value : Integer);
    procedure SetStr(Value : string);
    procedure SetBool(Value : Boolean);
    procedure SetDateTime(Value : TDateTime);

    function GetDateTimes(str : string;aDef : TDateTime) :TDateTime;
    procedure SetDateTimes(str : string;const Value : TDateTime);

    function GetStrs(str : string;aDef : string='') : string;
    procedure SetStrs(str : string;const Value : string);

    function GetInts(str : string;aDef : Integer=0) : Integer;
    procedure SetInts(str : string;const Value : Integer);

    function GetBools(str : string;aDef : Boolean=False) : Boolean;
    procedure SetBools(str : string;const Value : Boolean);

    function GetColors(str : string;aDef : TColor) : TColor;
    procedure SetColors(str : string;const Value : TColor);

    function GetStrTblIndex(str : string;Tbl : array of string;aDef : Integer) : Integer;
	end;

implementation

{ TDataSetubiStringListEx }

function TStringListEx.CommaToMarkText(const str: string): string;
var
  s : string;
begin
  s := str;
  s :=StringReplace(s,'&','&a',[rfreplaceall]);
  s :=StringReplace(s,',','&c',[rfreplaceall]);
  s :=StringReplace(s,#$0d#$0a,'&d',[rfreplaceall]);
  result := s;
end;

function TStringListEx.GetBool: Boolean;
begin
  result := StrToIntDef(Strings[0],0) <> 0;
  Delete(0);
end;

function TStringListEx.GetColor: TColor;
begin
  result := StringToColor(Trim(Strings[0]));
  Delete(0);
end;

function TStringListEx.GetCommaTextEx: string;
var
  i : Integer;
  s : string;
begin
  result := '';
  if Count = 0 then exit;
  s :=  CommaToMarkText(Strings[0]);
  for i := 1 to Count-1 do begin
    s := s + ',' + CommaToMarkText(Strings[i]);
  end;
  result := s;
end;

function TStringListEx.GetDateTime: TDateTime;
begin
  result := StrToDateTime(Strings[0]);
  Delete(0);
end;

function TStringListEx.GetDateTimes(str: string;
  aDef: TDateTime): TDateTime;
var
  s : string;
begin
  result := aDef;
  s := Trim(Values[str]);
  if s = '' then exit;
  result := StrToDateTime(s);
end;

function TStringListEx.GetInt: Integer;
begin
  result := StrToIntDef(Strings[0],-1);
  Delete(0);
end;

function TStringListEx.GetStr: string;
begin
  result := MarkTextToComma(Strings[0]);
  Delete(0);
end;

function TStringListEx.GetStrs(str: string; aDef: string =''): string;
var
  s : string;
begin
  result := aDef;
  s := Values[str];
  if s = '' then exit;
  result := s;
end;

function TStringListEx.GetInts(str: string; aDef: Integer): Integer;
var
  s : string;
begin
  result := aDef;
  s := Values[str];
  if s = '' then exit;
  result := StrToIntDef(s,aDef);
end;

function TStringListEx.GetBools(str: string; aDef: Boolean): Boolean;
var
  s : string;
begin
  result := aDef;
  s := Values[str];
  if s = '' then exit;
  result := Boolean(StrToIntDef(s,Integer(aDef)));
end;

function TStringListEx.MarkTextToComma(const str: string): string;
var
  s : string;
begin
  s := str;
  s := StringReplace(s,'&d',#$0d#$0a,[rfreplaceall]);
  s := StringReplace(s,'&c',',',[rfreplaceall]);
  s := StringReplace(s,'&a','&',[rfreplaceall]);
  result := s;
end;

procedure TStringListEx.SetBool(Value: Boolean);
begin
  Add(IntToStr(Integer(Value)));
end;

procedure TStringListEx.SetCommaTextEx(const Value: string);
var
  i : Integer;
  s,m : string;
begin
  Clear;
  for i := 1 to Length(Value) do begin
    m := Copy(Value,i,1);
    if m = ',' then begin
      Add(MarkTextToComma(s));
      s := '';
    end
    else begin
      s := s + m;
    end;
  end;
  //if s <> '' then Add(s);
  Add(MarkTextToComma(s));
end;

procedure TStringListEx.SetDateTime(Value: TDateTime);
begin
  Add(DateTimeToStr(Value));
end;

procedure TStringListEx.SetDateTimes(str: string; const Value: TDateTime);
begin
  Values[str] := DateTimeToStr(Value);
end;

procedure TStringListEx.SetInt(Value: Integer);
begin
  Add(IntToStr(Value));
end;

procedure TStringListEx.SetStr(Value: string);
var
  s : string;
begin
  s := CommaToMarkText(Value);
  Add(s);
end;

procedure TStringListEx.SetStrs(str: string; const Value: string);
begin
  Values[str] := Value;
end;

procedure TStringListEx.SetInts(str: string; const Value: Integer);
begin
  Values[str] := IntToStr(Value);
end;

procedure TStringListEx.SetBools(str: string; const Value: Boolean);
begin
  Values[str] := IntToStr(Integer(Value));
end;

function TStringListEx.GetStrTblIndex(str: string; Tbl: array of string;
  aDef: Integer): Integer;
var
  s : string;
  i : Integer;
begin
  result := aDef;
  s := GetStrs(str,'');
  for i := 0 to High(Tbl) do begin
    if s = Tbl[i] then begin
      result := i;
      break;
    end;
  end;

end;

function TStringListEx.GetColors(str: string; aDef: TColor): TColor;
var
  s : string;
begin
  s := GetStrs(str,'');
  if s <> '' then begin
    result := StringToColor(s);
  end
  else begin
    result := aDef;
  end;
end;

procedure TStringListEx.SetColors(str: string; const Value: TColor);
var
  s : string;
begin
  s := ColorToString(Value);
  SetStrs(str,s);
end;

end.
