unit StringKanji;

interface

uses Classes,Sysutils;

function LengthZen(str : string) : Integer;
function CopyZen(str : string;Index,Count : Integer) : string;
//function PosZen(SubStr,str : string) : Integer;
function IsNumberZen(str : string) : Boolean;
function IsKeywords(const str : string;Keys: array of string) : Boolean;
function StrZenToIntDef(const str : string;Value : Integer) : Integer;
function IsKeywordCuts(const str : string;KeysL,KeysR: array of string;var sMid : string;var sEtc : string) : Boolean;
function TrimZen(const str : string) : string;

function StrCommentToListSub(const str : string; aList : TStringList;aCnt : Integer;var Comment : string) : Boolean;
procedure StrKeywordToList(const str : string; aList : TStringList);
procedure StrCommentToList(const str : string; aList : TStringList;aCnt : Integer;var Comment : string;var aTalkMax : Integer);

implementation

//**************************************************************************//
//                                                                          //
//  `@R[ĥPoCgڂ@`                              //
//                                                                          //
// - input -  str : 镶                                            //
//                                                                          //
// - output - True : R[h                                             //
//                                                                          //
//**************************************************************************//
function IsKanji(str : string) : Boolean;
var
  c : Integer;
begin
  result := False;
  c := Ord(str[1]);
  if (c >= $80) and (c <= $9F) then result := True;
  if (c >= $E0) and (c <= $FF) then result := True;
end;

//**************************************************************************//
//                                                                          //
//  `@lĕ̒擾@`                            //
//                                                                          //
// - input -  str : 𑪂镶                                        //
//                                                                          //
// - output - ̒                                                    //
//                                                                          //
//**************************************************************************//
function LengthZen(str : string) : Integer;
var
  i,cnt : Integer;
  s : string;
begin
  cnt := 0;
  i := 1;
  while(i <= Length(str)) do begin
    s := Copy(str,i,1);
    if IsKanji(s) then begin
      Inc(i,2);
    end
    else begin
      Inc(i);
    end;
    Inc(cnt);
  end;
  result := cnt;
end;

//**************************************************************************//
//                                                                          //
//  `@lĕ擾@`                              //
//                                                                          //
// - input -  str : gp镶                                          //
//            Index : Jnʒu                                              //
//            Count : 擾                                            //
//                                                                          //
// - output - 擾                                            //
//                                                                          //
//**************************************************************************//
function CopyZen(str : string;Index,Count : Integer) : string;
var
  i,cnt : Integer;
  s,r : string;
  //w : WideString;
begin
  //w := str;
  //result := Copy(str,Index,Count);

  r := '';
  cnt := 1;
  i := 1;
  while(i <= Length(str)) do begin
    if IsKanji(Copy(str,i,1)) then begin
      s := Copy(str,i,2);
      Inc(i,2);
    end
    else begin
      s := Copy(str,i,1);
      Inc(i);
    end;
    if cnt >= Index then begin
      if cnt < Index + Count then begin
        r := r + s;
      end;
    end;
    Inc(cnt);
  end;
  result := r;

end;

function IsNumberZen(str : string) : Boolean;
var
  c : Integer;
begin
  result := False;
  if Length(str) = 1 then begin
    c := Ord(str[1]);
    if (c >= $30) and (c <= $39) then begin
      result := True;
    end;
  end
  else begin
    c := (Ord(str[1]) shl 8) + Ord(str[2]);
    if (c >= 33359) and (c <= 33368) then begin
      result := True;
    end;
  end;
  {
  str := 'O';
    c := (Ord(str[1]) shl 8) + Ord(str[2]);
  str := 'X';
    c := (Ord(str[1]) shl 8) + Ord(str[2]);
  }
end;

function StrZenToIntDef(const str : string;Value : Integer) : Integer;
var
  i,sum,c : Integer;
  s : string;
  f : Boolean;
begin
  sum := 0;
  f := False;
  for i := 1 to LengthZen(str) do begin
    s := CopyZen(str,i,1);
    if Length(s) = 1 then begin
      c := Ord(s[1]);
      if (c >= $30) and (c <= $39) then begin
        sum := sum * 10 + (c - $30);
        f := True;
      end;
    end
    else begin
      c := (Ord(s[1]) shl 8) + Ord(s[2]);
      if (c >= 33359) and (c <= 33368) then begin
        sum := sum * 10 + (c - 33359);
        f := True;
      end;
    end;

  end;
  if f then begin
    result := sum;
  end
  else begin
    result := Value;
  end;
end;

function TrimZen(const str : string) : string;
var
  s,ss : string;
  i : Integer;
begin
  ss := str;
  for i := 1 to LengthZen(ss) do begin
    s := CopyZen(ss,i,1);
    if (s <> ' ') and (s <> '@') then begin
      ss := CopyZen(str,i,LengthZen(ss));
      break;
    end;
  end;
  for i := LengthZen(ss) downto 1 do begin
    s := CopyZen(ss,i,1);
    if (s <> ' ') and (s <> '@') then begin
      ss := CopyZen(ss,1,i);
      break;
    end;
  end;
  result := ss;
end;

function IsKeywords(const str : string;Keys: array of string) : Boolean;
var
  i : Integer;
begin
  result := False;
  for i := 0 to High(Keys) do begin
    if str = Keys[i] then result := True;
  end;

end;

function IsKeywordCuts(const str : string;KeysL,KeysR: array of string;var sMid : string;var sEtc : string) : Boolean;
var
  j,ip : Integer;
  f : Boolean;
  s : string;
begin
  result := False;
  f := False;
  for j := 0 to High(KeysL) do begin
    ip := Pos(KeysL[j],str);
    if ip <> 0 then begin
      f := True;
      s := Copy(str,ip + Length(KeysL[j]),Length(str));
      break;
    end;
  end;
  if not f then exit;
  f := False;
  for j := 0 to High(KeysR) do begin
    ip := Pos(KeysR[j],s);
    if ip <> 0 then begin
      f := True;
      sMid := Copy(s,1,ip-1);
      sEtc := Copy(s,ip + Length(KeysR[j]),Length(s));
      break;
    end;
  end;
  result := f;
end;

//**************************************************************************//
//                                                                          //
//  `@w肳ꂽ؂Ƃĕ@`                                //
//                                                                          //
//   - Input -  str : 镶                                        //
//              keys : ؂ƂĎgp镶ꗗ                       //
//              aList : ̕                                      //
//                                                                          //
//   - Output - True :                                              //
//                                                                          //
//**************************************************************************//
procedure StrKeywordToList(const str: string;aList: TStringList);
const
  Tbl : array[0..5] of string= ('(',')','','#','',',');
var
  i : Integer;
  s,n,st : string;
  f1,f2,f3 : Boolean;
begin
  st := '';
  f2 := False;
  f3 := False;
  for i := LengthZen(str) downto 1 do begin
    f1 := False;
    s := CopyZen(str,i,1);
    if not f3 then begin
      if IsKeywords(s,Tbl) then begin
        f1 := True;
        if n <> '' then begin
          aList.Insert(0,n);
          st := '';
          n := '';
          f1 := True;
          f2 := True;
        end;
      end
      else if IsNumberZen(s) then begin
        n := s + n;
        f2 := True;
      end
      else begin
        if f2 then begin
          f3 := True;
        end;
      end;
      if not f1 then st := s + st;
    end
    else begin
      st := s + st;
    end;
  end;
  if st <> '' then aList.Insert(0,st);
end;

procedure StrCommentToList(const str : string; aList : TStringList;aCnt : Integer;var Comment : string;var aTalkMax : Integer);
var
  i : Integer;
  f : Boolean;
  s,sm,se,sc : string;
begin
  if StrCommentToListSub(str,aList,aCnt,sc) then begin
    s := sc;
    Comment := sc;
  end
  else begin
    s := str;
    Comment := str;
    {
    repeat
      f := IsKeywordCuts(s,['u','#',''],['v','#','','@'],sm,se);
      if f then begin
        aList.Add(sm);
      end;
      s := se;
    until f = False;
    }
    for i := 1 to aCnt do begin
      f := IsKeywordCuts(s,['u','#',''],['v','#','','@'],sm,se);
      if f then begin
        aList.Add(sm);
      end;
      s := se;
    end;

    if s <> '' then Comment := s;
  end;
  f := IsKeywordCuts(s,['^S','yS'],['bz','b'],sm,se);
  if f then begin
    //Comment := se;
    aTalkMax := StrZenToIntDef(sm,0);
  end;

end;

function StrCommentToListSub(const str : string; aList : TStringList;aCnt : Integer;var Comment : string) : Boolean;
var
 i,m1 : Integer;
 s,st,sn : string;
begin
  result := False;
  m1 := 0;
  st := '';
  for i := 1 to LengthZen(str) do begin
    s := CopyZen(str,i,1);
    case m1 of
      0:  begin
            if IsKeywords(s,['#','']) then begin
              sn :='';
              m1 := 1;
            end
            else begin
              st := st + s;
            end;
          end;
      1:  begin
            if s ='@' then begin
              m1 := 2;
            end;
          end;
      2:  begin
            if s ='@' then begin
              m1 := 3;
            end
            else if IsKeywords(s,['#','']) then begin
              aList.Add(sn);
              sn := '';
              //st := '';
              m1 := 1;
              result := True;
            end
            else begin
              sn := sn + s;
            end;
          end;
      3:  begin
            if s ='@' then begin
              aList.Add(sn);
              //st := '';
              m1 := 0;
              result := True;
            end
            else begin
              st := st + s;
            end;
          end;
    end;
  end;
  Comment := st;
end;

{
procedure StrCommentToList(const str : string; aList : TStringList;var Comment : string;var aTalkMax : Integer);
var
 i,m1,m2,m3 : Integer;
 s,st,sn,sm,sm2,st2 : string;
begin
  m1 := 0;
  m2 := 0;
  m3 := 0;
  st := '';
  for i := 1 to LengthZen(str) do begin
    s := CopyZen(str,i,1);
    case m1 of
      0:  begin
            if IsKeywords(s,['#','']) then begin
              sn :='';
              m1 := 1;
            end
            else begin
              st := st + s;
            end;
          end;
      1:  begin
            if s ='@' then begin
              m1 := 2;
            end;
          end;
      2:  begin
            if s ='@' then begin
              m1 := 3;
            end
            else if IsKeywords(s,['#','']) then begin
              aList.Add(sn);
              sn := '';
              m1 := 1;
            end
            else begin
              sn := sn + s;
            end;
          end;
      3:  begin
            if s ='@' then begin
              aList.Add(sn);
              m1 := 0;
            end;
          end;
    end;
  if st2 <> '' then begin
    Comment := st2;
  end
  else begin
    Comment := st;
  end;
  aTalkMax := StrZentoIntDef(sm,0);
end;
}
{
function PosZen(SubStr,str : string) : Integer;
var
  i : Integer;
begin
end;
}
end.
