unit ProcPublicFileName;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls,StringListEx,StringListKey,FileCtrl;

function GetFilePath() : string;
function GetFilePathTemp() : string;
function GetFilePathDebugRead(const Name : string) : string;
function GetFilePathDebugWrite(const Name : string) : string;

implementation

function GetFilePath() : string;
begin
  result := ExtractFilePath(Application.ExeName);
end;

function GetFilePathTemp() : string;
begin
  result := ExtractFilePath(Application.ExeName) + 'temp\';
  if DirectoryExists(result) then exit;
  CreateDir(result);
end;

function GetFilePathDebugRead(const Name : string) : string;
var
  s,m : string;
  i,j : Integer;
begin
  s := ExtractFilePath(Application.ExeName);
  j := 0;
  for i := Length(s) downto 1 do begin
    m := s[i];
    if m <> '\' then continue;
    Inc(j);
    if j = 2 then break;
  end;
  s := Copy(s,1,i);
  s := s + '\Debug\Debug_' + Name + '\';
  result := s;
end;

function GetFilePathDebugWrite(const Name : string) : string;
var
  s : string;
begin
  s := ExtractFilePath(Application.ExeName);
  s := s + 'debug\';
  if not DirectoryExists(s) then begin
    CreateDir(s);
  end;
  s := s + Name + '\';
  if not DirectoryExists(s) then begin
    CreateDir(s);
  end;
  result := s;
end;

end.
