unit PanelTvProgramDateList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,DefaultData,
  StringListEx,StringListKey,DataTvSchedulePaperColumn,
  DataTvChannel,DataTvSchedulePaperRect,DataTvSChedule,StringKanji,
  DMUnit,PanelTvProgramColumnConfig,PanelTvProgramColumnData;

//--------------------------------------------------------------------------//
//  V`ԑg\ŎgpԑgAqc̃`lʃf[^NX            //
//--------------------------------------------------------------------------//
type
  TPanelTvProgramDateListItem = class(TPersistent)
  private
    { Private 錾 }
    FDateTime: TDateTimeCtrl;
    FColor: TColor;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy; override;
    property DateTime : TDateTimeCtrl read FDateTime;
    property Color : TColor read FColor write FColor;
  end;

//--------------------------------------------------------------------------//
//  TDataTvScheduleItemsExł͊ǗłȂڂǗ邽߂̃Xg        //
//--------------------------------------------------------------------------//
type
  TPanelTvProgramDateListItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TPanelTvProgramDateListItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    function Add() : TPanelTvProgramDateListItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TPanelTvProgramDateListItem read GetItems;default;

  end;

type
  TPanelTvProgramDateList = class(TPanel)
  private
    { Private 錾 }
    FLBoxDate : TListBox;
    FItems : TPanelTvProgramDateListItems;
    FDateTimeStart: TDateTimeCtrl;
    FConfig: TPanelTvProgramColumnConfig;
    FData: TPanelTvProgramColumnData;
    FOnDateListClick: TNotifyEvent;
    procedure ShowDateList();
    procedure OnDrawItem(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
    procedure OnDateLboxClick(Sender: TObject);
    procedure SetDateTimeStart(const Value: TDateTimeCtrl);

    procedure DoDateListClick();
    function GetSelectDateTime: TDateTimeCtrl;
    procedure SetSelectDateTime(const Value: TDateTimeCtrl);
    function GetItemIndex: Integer;
    procedure SetItemIndex(const Value: Integer);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;

    procedure Show();

    property DateTimeStart : TDateTimeCtrl read FDateTimeStart write SetDateTimeStart;

    property Config : TPanelTvProgramColumnConfig read FConfig write FConfig;
    property Data : TPanelTvProgramColumnData read FData write FData;
    property SelectDateTime : TDateTimeCtrl read GetSelectDateTime write SetSelectDateTime;
    property ItemIndex : Integer read GetItemIndex write SetItemIndex;

    property OnDateListClick : TNotifyEvent read FOnDateListClick write FOnDateListClick;
  end;

implementation

{ TPanelTvProgramDateList }

constructor TPanelTvProgramDateList.Create(AOwner: TComponent);
begin
  inherited;
  Width := 80;
  FDateTimeStart := TDateTimeCtrl.Create;

  FItems := TPanelTvProgramDateListItems.Create;

  FLBoxDate := TListBox.Create(Self);
  FLBoxDate.Parent := Self;
  //FLBoxDate.Width := 120;
  FLBoxDate.Align := alClient;
  FLBoxDate.Font.Size := 14;
  FLBoxDate.ItemHeight := 20;
  FLBoxDate.Style := lbOwnerDrawFixed;
  FLBoxDate.OnDrawItem := OnDrawItem;
  FLBoxDate.OnClick := OnDateLboxClick;

end;

destructor TPanelTvProgramDateList.Destroy;
begin
  FLBoxDate.Free;
  FItems.Free;
  FDateTimeStart.Free;
  inherited;
end;

procedure TPanelTvProgramDateList.Show;
begin
  ShowDateList();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@tꗗ`Cxg@`                                            //
//                                                                          //
//   - Input -  iȗj                                                    //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramDateList.OnDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  cv : TCanvas;
  d : TListBox;
  dd : TPanelTvProgramDateListItem;
begin
  d := TListBox(Control);
  cv := d.Canvas;
  dd := TPanelTvProgramDateListItem(d.Items.Objects[Index]);
  if dd.DateTime.Hou = 0 then begin
    cv.Font.Style := [fsBold];
  end
  else begin
    cv.Font.Style := [];
  end;
  if odSelected in State then begin                            // J[\ʒȕꍇ
    cv.Brush.Color := dd.FColor;
    cv.Brush.Style := bsSolid;
    cv.FillRect(Rect);
    cv.Font.Color := clWhite;
  end
  else begin
    cv.Brush.Color := clWhite;
    cv.Brush.Style := bsSolid;
    cv.FillRect(Rect);
    cv.Font.Color := dd.FColor;
  end;
  cv.TextRect(Rect,Rect.Left , Rect.Top, d.Items[Index]);
end;

procedure TPanelTvProgramDateList.SetDateTimeStart(
  const Value: TDateTimeCtrl);
begin
  FDateTimeStart.Assign(Value);
  ShowDateList();
end;

procedure TPanelTvProgramDateList.ShowDateList;
const
  Tbl : array[1..7] of TColor = (clRed,clBlack,clBlack,clBlack,clBlack,clBlack,clBlue);
  Tbls : array[1..7] of string = ('','','','','','','y');
var
  cnt : Integer;
  s : string;
  d : TDateTimeCtrl;
  dd : TPanelTvProgramDateListItem;
  //dd : TDataTvSchedulePaperDateItem;
  i : Integer;
  f : Boolean;
begin
  d := TDateTimeCtrl.Create;
  try
    //ListDateClear();                                     // tꗗ

    FLBoxDate.Clear;                                       // tꗗ
    FItems.Clear;
    cnt := FConfig.DayMax + FConfig.DayOld;                // t\擾
    d.Assign(FDateTimeStart);                                     // JntƂđ
    d.Min := 0;
    d.Sec := 0;
    //d.DecDay;
    f := False;
    for i := 0 to cnt*6-1 do begin                         // tꗗ\[v
      dd := FItems.Add();
      if (f = False) or (d.Hou = 0) then begin
        s := Format('%2.2d',[d.Day])+'('+Tbls[d.Week]+')'; // \쐬
        f := True;
      end
      else begin
        s := Format(' %2.2d:00',[d.Hou]);                  // \쐬
      end;
      //dd := TDataTvSchedulePaperDateItem.Create;         // tXgɊǗNX
      //dd.FText := s;                                     // \
      dd.FColor := Tbl[d.Week];                          // \F
      dd.FDateTime.Assign(d);                            // NbNƂɔft
      FLBoxDate.Items.AddObject(s,dd);                   // ꗗɒǉ
      d.IncHou(4);                                        // ̓tֈړ
      d.Hou := (d.Hou div 4) * 4;
      //d.Hou := 0;                                        // Qڂ͂OړƂ
    end;
    FLBoxDate.ItemIndex := 0;                            // 擪̓tI𒆂Ƃ
  finally
    d.Free;
  end;
end;

procedure TPanelTvProgramDateList.DoDateListClick;
begin
  if Assigned(FOnDateListClick) then begin
    FOnDateListClick(Self);
  end;
end;

procedure TPanelTvProgramDateList.OnDateLboxClick(Sender: TObject);
begin
  DoDateListClick();
end;

function TPanelTvProgramDateList.GetSelectDateTime: TDateTimeCtrl;
var
  i : Integer;
  d : TPanelTvProgramDateListItem;
begin
  i := FLBoxDate.ItemIndex;
  if i = -1 then exit;
  d := TPanelTvProgramDateListItem(FLBoxDate.Items.Objects[i]);
  result := d.DateTime;
end;

procedure TPanelTvProgramDateList.SetSelectDateTime(
  const Value: TDateTimeCtrl);
var
  d : TPanelTvProgramDateListItem;
  i : Integer;
begin
  for i := 0 to FLBoxDate.Items.Count-1 do begin
    d := TPanelTvProgramDateListItem(FLBoxDate.Items.Objects[i]);
    if d.DateTime.Compari(Value) = 0 then begin
      FLBoxDate.ItemIndex := i;
    end;
  end;

end;

function TPanelTvProgramDateList.GetItemIndex: Integer;
begin
  result := FLBoxDate.ItemIndex;
end;

procedure TPanelTvProgramDateList.SetItemIndex(const Value: Integer);
begin
  FLBoxDate.ItemIndex := Value;
end;

{ TPanelTvProgramDateListItem }

constructor TPanelTvProgramDateListItem.Create;
begin
  FDateTime := TDateTimeCtrl.Create;
end;

destructor TPanelTvProgramDateListItem.Destroy;
begin
  FDateTime.Free;
  inherited;
end;

{ TPanelTvProgramDateListItems }

destructor TPanelTvProgramDateListItems.Destroy;
begin
  Clear();
  inherited;
end;

function TPanelTvProgramDateListItems.Add: TPanelTvProgramDateListItem;
var
  d : TPanelTvProgramDateListItem;
begin
  d := TPanelTvProgramDateListItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TPanelTvProgramDateListItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TPanelTvProgramDateListItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TPanelTvProgramDateListItems.GetItems(
  Index: Integer): TPanelTvProgramDateListItem;
begin
  result := inherited Items[Index];
end;

end.
