unit PanelTvProgramColumnTime;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,
  PanelTvProgramColumnConfig;

type
  TPanelTvProgramColumnTime = class(TPanel)
  private
    { Private 錾 }
    FConfig: TPanelTvProgramColumnConfig;
    procedure View();
    procedure OnSelfResize(Sender: TObject);
  protected
    procedure Paint();override;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;

    procedure Show();

    property Config : TPanelTvProgramColumnConfig read FConfig write FConfig;
  end;

implementation

{ TPanelTvProgramColumnTime }

constructor TPanelTvProgramColumnTime.Create(AOwner: TComponent);
begin
  inherited;
  OnResize := OnSelfResize;
end;

destructor TPanelTvProgramColumnTime.Destroy;
begin
  inherited;
end;

procedure TPanelTvProgramColumnTime.OnSelfResize(Sender: TObject);
begin
  View();
end;

procedure TPanelTvProgramColumnTime.Paint;
begin
  //inherited;
  View();
end;

procedure TPanelTvProgramColumnTime.Show;
begin
  View();
end;

procedure TPanelTvProgramColumnTime.View;
var
  i,y1,aHou,j,yh,xh : Integer;
  cv : TCanvas;
  s : string;
begin
  y1 := 0;                  // ǖ̉_Ƃ
  //cv := FPaintBox.Canvas;
  cv := Canvas;
  aHou := FConfig.DateTimeStart.Hou;        // \Jnijݒ
  aHou := aHou + FConfig.Hou;
  yh := ClientHeight div FConfig.RowCount;
  xh := ClientWidth;
  FConfig.TimeYh := yh;
  for i := 0 to FConfig.RowCount-1 do begin  // ʂɕ\鎞Ԑ[v
    j := (aHou + i) mod 24;
    cv.Brush.Style := bsSolid;
    cv.Pen.Color := clBlack;
    cv.Brush.Color := clBlue;
    cv.Rectangle(0,y1 + i * yh,xh,y1 + (i + 1) * yh);
    cv.Brush.Style := bsClear;
    cv.Font.Color := clWhite;
    cv.Font.Style := [fsBold];
    s := IntToStr(j);
    cv.TextOut(3,y1 + i * yh + yh div 2,s);
  end;
end;

end.
 