unit PanelTvProgramColumnData;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls,DefaultData,StringListEx,StringListKey,MultiEvent,
  DataTvChannel,ProcPublicFileName,DateTimeCtrl,DataTvSchedule,DataRdRecReserve,
  DataConfigRd,DataRdRecReserveChannel;

//--------------------------------------------------------------------------//
//  V`ԑg\ŎgpԑgAqc̃`lʃf[^NX            //
//--------------------------------------------------------------------------//
type
  TPanelTvProgramColumnDataItem = class(TPersistent)
  private
    FDrawIng: Boolean;
    FRect: TRect;        // True : łɕ`ς
  public
    { Public 錾 }
    property Drawing : Boolean read FDrawIng write FDrawing;
    property Rect : TRect read FRect write FRect;
    function CheckPoint(const x,y : Integer) : Boolean;
  end;

//--------------------------------------------------------------------------//
//  TDataTvScheduleItemsExł͊ǗłȂڂǗ邽߂̃Xg        //
//--------------------------------------------------------------------------//
type
  TPanelTvProgramColumnDataItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TPanelTvProgramColumnDataItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    function Add() : TPanelTvProgramColumnDataItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TPanelTvProgramColumnDataItem read GetItems;default;

  end;

//--------------------------------------------------------------------------//
//  V`ԑg\ŎgpԑgAqc̃`lʃf[^NX            //
//--------------------------------------------------------------------------//
type
  TPanelTvProgramColumnDataChannelItem = class(TPersistent)
  private
    FTvDraws : TPanelTvProgramColumnDataItems;
    FTvItems: TDataTvScheduleItemsEx;                 //
    FChannelEx: Integer;
    FChannelTv: Integer;
    FRdItems: TDataRdRecReserveItemsEx;
    FRdDraws: TPanelTvProgramColumnDataItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    property ChannelTv : Integer read FChannelTv write FChannelTv;
    property ChannelEx : Integer read FChannelEx write FChannelEx;

    // ItemsDraws̍ڂ͂P΂P̊֌Wł
    property TvItems : TDataTvScheduleItemsEx read FTvItems;
    property TvDraws : TPanelTvProgramColumnDataItems read FTvDraws;

    // ItemsDraws̍ڂ͂P΂P̊֌Wł
    property RdItems : TDataRdRecReserveItemsEx read FRdItems;
    property RdDraws : TPanelTvProgramColumnDataItems read FRdDraws;
  end;

//--------------------------------------------------------------------------//
//  V`ԑg\ŎgpԑgAqc̃`lʃXgNX            //
//--------------------------------------------------------------------------//
type
  TPanelTvProgramColumnDataChannelItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TPanelTvProgramColumnDataChannelItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    function Add() : TPanelTvProgramColumnDataChannelItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TPanelTvProgramColumnDataChannelItem read GetItems;default;

    function IndexOfTvEx(Tv,Ex : Integer) : Integer;
  end;

//--------------------------------------------------------------------------//
//  V`ԑg\ŎgpԑgAqc̊Ǘf[^NX                    //
//--------------------------------------------------------------------------//
type
  TPanelTvProgramColumnData = class(TPersistent)
  private
    { Private 錾 }
    FChannels : TPanelTvProgramColumnDataChannelItems;

    // TPanelTvProgramColumnDataChannelItemsւ̒ǉ폜͂̃NXKg
    procedure TvAddSub(d : TDataTvScheduleItem);
    procedure TvDelSub(d : TDataTvScheduleItem);

    procedure RdAddSub(d : TDataRdRecReserveItem);
    procedure RdDelSub(d : TDataRdRecReserveItem);

    function RdToChIndex(d : TDataRdRecReserveItem) : TPanelTvProgramColumnDataChannelItem;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure TvAdds(ts : TDataTvScheduleItemsEx);
    procedure TvDels(ts : TDataTvScheduleItemsEx);
    procedure RdAdds(ts : TDataRdRecReserveItemsEx);
    procedure RdDels(ts : TDataRdRecReserveItemsEx);
    procedure RdClr();
    procedure Clear();

    // ScrollBox̕`蒼v
    procedure DrawClear();

    property Channels : TPanelTvProgramColumnDataChannelItems read FChannels;
  end;

implementation

uses  DMUnit,DataConfigRdChannel;

{ TPanelTvProgramColumnData }

constructor TPanelTvProgramColumnData.Create;
begin
  FChannels := TPanelTvProgramColumnDataChannelItems.Create;
end;

destructor TPanelTvProgramColumnData.Destroy;
begin
  FChannels.Free;
  inherited;
end;

procedure TPanelTvProgramColumnData.TvAdds(ts: TDataTvScheduleItemsEx);
var
  d : TDataTvScheduleItem;
  i : Integer;
begin
  for i := 0 to ts.Count-1 do begin
    d := ts[i];
    TvAddSub(d);
  end;
end;

procedure TPanelTvProgramColumnData.TvDels(ts : TDataTvScheduleItemsEx);
var
  d : TDataTvScheduleItem;
  i : Integer;
begin
  for i := 0 to ts.Count-1 do begin
    d := ts[i];
    TvDelSub(d);
  end;
end;

procedure TPanelTvProgramColumnData.TvAddSub(d: TDataTvScheduleItem);
var
  i : Integer;
  dc : TPanelTvProgramColumnDataChannelItem;
begin
  i := FChannels.IndexOfTvEx(d.ChTv,d.ChTvEx);
  if i = -1 then begin
    dc := FChannels.Add();
    dc.ChannelTv := d.ChTv;
    dc.ChannelEx := d.ChTvEx;
  end
  else begin
    dc := FChannels.Items[i];
  end;
  dc.TvItems.Add(d);
  dc.TvDraws.Add();
end;

procedure TPanelTvProgramColumnData.TvDelSub(d: TDataTvScheduleItem);
var
  i,j : Integer;
  dc : TPanelTvProgramColumnDataChannelItem;
begin
  i := FChannels.IndexOfTvEx(d.ChTv,d.ChTvEx);
  if i = -1 then exit;
  dc := FChannels.Items[i];
  j := dc.TvItems.IndexOf(d);
  if j = -1 then exit;
  dc.TvItems.Delete(j);
  dc.TvDraws.Delete(j);
  if dc.TvItems.Count > 0 then exit;
  FChannels.Delete(i);
end;

procedure TPanelTvProgramColumnData.Clear;
begin
  FChannels.Clear;
end;

procedure TPanelTvProgramColumnData.DrawClear;
var
  i,j : Integer;
  d : TPanelTvProgramColumnDataChannelItem;
begin
  for j := 0 to FChannels.Count-1 do begin
    d := FChannels.Items[j];
    for i := 0 to d.TvDraws.Count-1 do begin
      d.TvDraws[i].Drawing := False;
      d.TvDraws[i].Rect := Rect(0,0,0,0);
    end;

  end;

end;

procedure TPanelTvProgramColumnData.RdAddSub(d: TDataRdRecReserveItem);
var
  dc : TPanelTvProgramColumnDataChannelItem;
begin
  dc := RdToChIndex(d);
  if dc = nil then exit;
  dc.RdItems.Add(d);
  dc.RdDraws.Add();
end;

procedure TPanelTvProgramColumnData.RdDelSub(d: TDataRdRecReserveItem);
var
  i : Integer;
  dc : TPanelTvProgramColumnDataChannelItem;
begin
  if FChannels.Count = 0 then exit;
  dc := RdToChIndex(d);
  if dc = nil then exit;
  i := dc.RdItems.IndexOf(d);
  if i = -1 then exit;
  dc.RdItems.Delete(i);
  dc.RdDraws.Delete(i);
end;

function TPanelTvProgramColumnData.RdToChIndex(
  d: TDataRdRecReserveItem): TPanelTvProgramColumnDataChannelItem;
var
  i,j,k,ChTv,ChEx : Integer;
  dc : TDataConfigRdItem;
  dcc : TPanelTvProgramColumnDataChannelItem;
  drc : TDataRdRecReserveChannel;
  dl,dl2 : TDataConfigRdChannelLineItem;
begin
  result := nil;
  i := d.RdIndex;
  if i = -1 then exit;
  ChTv := -1;
  ChEx := -1;
  if i >= DM.Config.Rd.Items.Count then exit;
  dc := DM.Config.Rd.Items[i];
  for j := 0 to dc.Channels.Items.Count-1 do begin
    dl2 := dc.Channels.Items[j];
    dl := dc.Channels.Items[j];
    //if DM.Rd.Items[i].GetRd = nil then exit;
    //if DM.Rd.Items[i].GetRd.RdInfo = nil then exit;
    drc := DM.Rd.Items[i].GetRd.RdInfo.Channels;
    k := drc.Items.IndexOfList(d.Channel);
    if k = -1 then continue;
    if drc.Items[k].Value = dl.Line then begin
    //if d.ChannelStr = dl.Line then begin
      ChTv := dl2.ChannelTv;
      ChEx := dl2.ChannelEx;
      break;
    end;
  end;
  if (ChTv = -1) and (ChEx = -1) then exit;
  i := FChannels.IndexOfTvEx(ChTv,ChEx);
  if i = -1 then begin
    dcc := FChannels.Add();
    dcc.ChannelTv := ChTv;
    dcc.ChannelEx := ChEx;
  end
  else begin
    dcc := FChannels.Items[i];
  end;

  result := dcc;
end;

procedure TPanelTvProgramColumnData.RdAdds(ts: TDataRdRecReserveItemsEx);
var
  d : TDataRdRecReserveItem;
  i : Integer;
begin
  for i := 0 to ts.Count-1 do begin
    d := ts[i];
    RdAddSub(d);
  end;
end;

procedure TPanelTvProgramColumnData.RdDels(ts: TDataRdRecReserveItemsEx);
var
  d : TDataRdRecReserveItem;
  i : Integer;
begin
  for i := 0 to ts.Count-1 do begin
    d := ts[i];
    RdDelSub(d);
  end;
end;

procedure TPanelTvProgramColumnData.RdClr;
var
  i : Integer;
begin
  for i := 0 to FChannels.Count-1 do begin
    FChannels[i].RdItems.Clear;
    FChannels[i].RdDraws.Clear;
  end;

end;

{ TPanelTvProgramColumnDataChannelItems }

destructor TPanelTvProgramColumnDataChannelItems.Destroy;
begin
  Clear();
  inherited;
end;

function TPanelTvProgramColumnDataChannelItems.Add: TPanelTvProgramColumnDataChannelItem;
var
  d : TPanelTvProgramColumnDataChannelItem;
begin
  d := TPanelTvProgramColumnDataChannelItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TPanelTvProgramColumnDataChannelItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TPanelTvProgramColumnDataChannelItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TPanelTvProgramColumnDataChannelItems.GetItems(
  Index: Integer): TPanelTvProgramColumnDataChannelItem;
begin
  result := inherited Items[Index];
end;

function TPanelTvProgramColumnDataChannelItems.IndexOfTvEx(Tv,
  Ex: Integer): Integer;
var
  i : Integer;
  d : TPanelTvProgramColumnDataChannelItem;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    d := Items[i];
    if (d.ChannelTv = Tv) and
       (d.ChannelEx = Ex) then begin
      result := i;
      break;
    end;
  end;

end;

{ TPanelTvProgramColumnDataChannelItem }

constructor TPanelTvProgramColumnDataChannelItem.Create;
begin
  FTvItems := TDataTvScheduleItemsEx.Create;
  FTvDraws := TPanelTvProgramColumnDataItems.Create;
  FRdItems := TDataRdRecReserveItemsEx.Create;
  FRdDraws := TPanelTvProgramColumnDataItems.Create;
end;

destructor TPanelTvProgramColumnDataChannelItem.Destroy;
begin
  FRdDraws.Free;
  FRdItems.Free;
  FTvDraws.Free;
  FTvItems.Free;
  inherited;
end;

{ TPanelTvProgramColumnDataItems }

destructor TPanelTvProgramColumnDataItems.Destroy;
begin
  Clear();
  inherited;
end;

function TPanelTvProgramColumnDataItems.Add: TPanelTvProgramColumnDataItem;
var
  d : TPanelTvProgramColumnDataItem;
begin
  d := TPanelTvProgramColumnDataItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TPanelTvProgramColumnDataItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TPanelTvProgramColumnDataItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TPanelTvProgramColumnDataItems.GetItems(
  Index: Integer): TPanelTvProgramColumnDataItem;
begin
  result := inherited Items[Index];
end;

{ TPanelTvProgramColumnDataItem }

function TPanelTvProgramColumnDataItem.CheckPoint(const x,
  y: Integer): Boolean;
begin
  result := False;
  if (x >= FRect.Left) and (x <= FRect.Right) and
     (y >= FRect.Top) and (y <= FRect.Bottom) then begin
    result := True;
    exit;
  end;
end;

end.
 