//**************************************************************************//
//                                                                          //
//  suԑgf[^V`ŕ\邽߂̐ݒǗNX                  //
//                                                                          //
//**************************************************************************//
unit PanelTvProgramColumnConfig;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls,DefaultData,StringListEx,StringListKey,MultiEvent,
  DataTvChannel,ProcPublicFileName,DateTimeCtrl;

//--------------------------------------------------------------------------//
//  ԑg\̕Ǖ\Ǘf[^NX                                    //
//--------------------------------------------------------------------------//
type
  TPanelTvProgramColumnConfigItem = class(TPersistent)
  private
    FChannelIndex: Integer;
    FChannelEx: Integer;
    FChannelTv: Integer;                 //
    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    property ChannelIndex : Integer read FChannelIndex write FChannelIndex;
    property ChannelTv : Integer read FChannelTv write FChannelTv;
    property ChannelEx : Integer read FChannelEx write FChannelEx;
  end;

//--------------------------------------------------------------------------//
//  ԑg\̕Ǖ\ǗXgNX                                    //
//--------------------------------------------------------------------------//
type
  TPanelTvProgramColumnConfigItems = class(TList)
  private
    function GetItems(Index: Integer): TPanelTvProgramColumnConfigItem;
    { Private 錾 }
  public
    { Public 錾 }
    destructor Destroy;override;
    procedure Assign(Source : TPanelTvProgramColumnConfigItems);
    function Add() : TPanelTvProgramColumnConfigItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TPanelTvProgramColumnConfigItem read GetItems;default;

    function ChToIndex(aCh : Integer) : Integer;

    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(tt : TStringListEx) : Boolean;
  end;

//--------------------------------------------------------------------------//
//  ԑg\̕\ڂǗf[^NX                                  //
//--------------------------------------------------------------------------//
type
  TPanelTvProgramColumnConfig = class(TPersistent)
  private
    { Private 錾 }
    FOnChanges: TMultiEventSend;
    FColumns : TPanelTvProgramColumnConfigItems;
    FRowCount: Integer;
    FColCount: Integer;
    FDayMax: Integer;
    FDateTimeStart: TDateTimeCtrl;
    FDateTimeViewStart: TDateTimeCtrl;
    FDateTimeViewStop: TDateTimeCtrl;

    FChIndex: Integer;
    FChXh: Integer;
    FHou: Integer;
    FTimeYh: Integer;
    FClientHeight: Integer;          // ԑg\\͈̔
    FClientWidth: Integer;
    FDateTimeStop: TDateTimeCtrl;
    FDayOld: Integer;

    procedure DoChange();
    function GetFileName() : string;
    // Ǘt͈͂̌vZs
    procedure ProcCalcDateTime();
    procedure SetTime();
    procedure SetHou(const Value: Integer);
    procedure SetDayMax(const Value: Integer);
    procedure SetDayOld(const Value: Integer);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad() : Boolean;
    function DataLoadDef() : Boolean;
    function DataSave() : Boolean;

    property RowCount : Integer read FRowCount write FRowCount;
    property ColCount : Integer read FColCount write FColCount;
    property DayMax : Integer read FDayMax write SetDayMax;
    property DayOld : Integer read FDayOld write SetDayOld;
    property DateTimeStart : TDateTimeCtrl read FDateTimeStart;
    property DateTimeStop  : TDateTimeCtrl read FDateTimeStop;
    property DateTimeViewStart : TDateTimeCtrl read FDateTimeViewStart;
    property DateTimeViewStop : TDateTimeCtrl read FDateTimeViewStop;

    property Columns : TPanelTvProgramColumnConfigItems read FColumns;

    property TimeYh : Integer read FTimeYh write FTimeYh;
    property ChXh : Integer read FChXh write FChXh;
    // ݕ\̏cʒuiPʂ͎ԁj
    property Hou : Integer read FHou write SetHou;
    // ݕ\̉ʒuiPʂ͕ǁj
    property ChIndex : Integer read FChIndex write FChIndex;
    // ԑg\\̍
    property ClientHeight : Integer read FClientHeight write FClientHeight;
    // ԑg\\̕
    property ClientWidth : Integer read FClientWidth write FClientWidth;

    property OnChanges    : TMultiEventSend read FOnChanges;
  end;

implementation

uses  DMUnit;

{ TPanelTvProgramColumnConfig }

constructor TPanelTvProgramColumnConfig.Create;
begin
  FDateTimeStart := TDateTimeCtrl.Create;
  FDateTimeStart.DateTime := Now;
  FDateTimeStop := TDateTimeCtrl.Create;
  FDateTimeViewStart := TDateTimeCtrl.Create;
  FDateTimeViewStop  := TDateTimeCtrl.Create;
  DayMax := DM.Config.Normal.ReadDay;

  FColumns := TPanelTvProgramColumnConfigItems.Create;
  FColCount := 6;
  FRowCount := 6;
  FOnChanges := TMultiEventSend.Create(nil);
  SetTime();
end;

destructor TPanelTvProgramColumnConfig.Destroy;
begin
  FOnChanges.Free;
  FColumns.Free;
  FDateTimeViewStop.Free;
  FDateTimeViewStart.Free;
  FDateTimeStop.Free;
  FDateTimeStart.Free;
  inherited;
end;

procedure TPanelTvProgramColumnConfig.Assign(Source: TPersistent);
var
  a : TPanelTvProgramColumnConfig;
begin
  if Source is TPanelTvProgramColumnConfig then begin
    a := TPanelTvProgramColumnConfig(Source);
    FColCount := a.FColCount;
    FRowCount := a.FRowCount;
    FColumns.Assign(a.FColumns);
    DoChange();
  end
  else begin
    inherited;
  end;
end;

function TPanelTvProgramColumnConfig.DataLoad(): Boolean;
var
  tk : TStringListKey;
  t : TStringListEx;
  s : string;
begin
  tk := TStringListKey.Create;
  FColumns.Clear;
  try
    result := False;
    s := GetFileName();
    if not FileExists(s) then begin
      DataLoadDef();
      exit;
    end;
    tk.LoadFromFile(s);
    t := tk.Values['TvProgColumn'];
    if t <> nil then begin
      FRowCount := t.GetInts('RowCount',6);
      FColCount := t.GetInts('ColCount',6);
    end;
    t := tk.Values['TvProgColumnChannel'];
    if t <> nil then begin
      FColumns.DataLoad(t);
    end;
    result := True;
  finally
    tk.Free;
  end;

end;

function TPanelTvProgramColumnConfig.DataSave(): Boolean;
var
  t : TStringListEx;
  tk : TStringListKey;
  s : string;
begin
  tk := TStringListKey.Create;
  t := TStringListEx.Create;
  try
    result := False;
    t.SetInts('RowCount',FRowCount);
    t.SetInts('ColCount',FColCount);
    tk.Add('TvProgColumn',t);

    t.Clear;
    FColumns.DataSave(t);
    tk.Add('TvProgColumnChannel',t);

    s := GetFileName();
    tk.SaveToFile(s);

    result := True;
  finally
    t.Free;
    tk.Free;
  end;
end;

procedure TPanelTvProgramColumnConfig.DoChange;
begin
  FOnChanges.Notify(Self);
end;


function TPanelTvProgramColumnConfig.GetFileName: string;
begin
  result := GetFilePathTemp + 'tmp_TvProgramColumn.ini';
end;

function TPanelTvProgramColumnConfig.DataLoadDef: Boolean;
var
  i : Integer;
  d : TDataTvChannelItem;
  dc : TPanelTvProgramColumnConfigItem;
begin
  FColumns.Clear;
  for i := 0 to DM.Config.TvChannel.Items.Count-1 do begin
    d := DM.Config.TvChannel.Items[i];
    if not d.Visible then continue;
    dc := FColumns.Add();
    dc.ChannelTv := d.ChannelTv;
    dc.ChannelEx := d.ChannelEx;
  end;
  result := True;
end;

procedure TPanelTvProgramColumnConfig.SetTime;
begin
  //FDateTimeStart.Min := 0;
  //FDateTimeStart.Sec := 0;
  FDateTimeViewStart.Assign(FDateTimeStart);
  FDateTimeViewStart.IncHou(FHou);
  FDateTimeViewStop.Assign(FDateTimeViewStart);
  FDateTimeViewStop.IncHou(FRowCount);
end;

procedure TPanelTvProgramColumnConfig.SetHou(const Value: Integer);
begin
  FHou := Value;
  SetTime();
end;

procedure TPanelTvProgramColumnConfig.SetDayMax(const Value: Integer);
begin
  FDayMax := Value;
  ProcCalcDateTime();       // Ǘt͈͂̌vZs
end;

procedure TPanelTvProgramColumnConfig.SetDayOld(const Value: Integer);
begin
  FDayOld := Value;
  ProcCalcDateTime();       // Ǘt͈͂̌vZs
end;

procedure TPanelTvProgramColumnConfig.ProcCalcDateTime;
begin
  FDateTimeStop.Assign(FDateTimeStart);
  FDateTimeStop.IncDay(FDayMax);         // ǍZ
  FDateTimeStop.IncDay(FDayOld);         // ߋ̕ۑZ
end;

{ TPanelTvProgramColumnConfigItems }

destructor TPanelTvProgramColumnConfigItems.Destroy;
begin
  Clear();
  inherited;
end;

function TPanelTvProgramColumnConfigItems.Add: TPanelTvProgramColumnConfigItem;
var
  d : TPanelTvProgramColumnConfigItem;
begin
  d := TPanelTvProgramColumnConfigItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TPanelTvProgramColumnConfigItems.Assign(
  Source: TPanelTvProgramColumnConfigItems);
var
  i : Integer;
  d : TPanelTvProgramColumnConfigItem;
begin
  Clear();
  for i := 0 to Source.Count-1 do begin
    d := Add();
    d.Assign(Source[i]);
  end;
end;

function TPanelTvProgramColumnConfigItems.ChToIndex(aCh: Integer): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].ChannelIndex = aCh then begin
      result := i;
      exit;
    end;
  end;
end;

procedure TPanelTvProgramColumnConfigItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

function TPanelTvProgramColumnConfigItems.DataLoad(
  t: TStringListEx): Boolean;
var
  i : Integer;
  d : TPanelTvProgramColumnConfigItem;
  t2 : TStringListEx;
begin
  result := False;
  if t.Count = 0 then exit;
  t2 := TStringListEx.Create;
  try
    Clear;
    for i := 0 to t.Count-1 do begin
      d := Add();
      t2.CommaTextEx := t[i];
      d.DataLoad(t2);
    end;
    result := True;
  finally
    t2.Free;
  end;
end;

function TPanelTvProgramColumnConfigItems.DataSave(
  tt: TStringListEx): Boolean;
var
  i : Integer;
  d : TPanelTvProgramColumnConfigItem;
  t2 : TStringListEx;
begin
  t2 := TStringListEx.Create;
  try
    result := False;
    for i := 0 to Count-1 do begin
      t2.Clear;
      d := Items[i];
      d.DataSave(t2);

      tt.Add(t2.CommaTextEx);
    end;
    result := True;
  finally
    t2.Free;
  end;
end;

procedure TPanelTvProgramColumnConfigItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TPanelTvProgramColumnConfigItems.GetItems(
  Index: Integer): TPanelTvProgramColumnConfigItem;
begin
  result := inherited Items[Index];
end;

{ TPanelTvProgramColumnConfigItem }

procedure TPanelTvProgramColumnConfigItem.Assign(Source: TPersistent);
var
  a : TPanelTvProgramColumnConfigItem;
begin
  if Source is TPanelTvProgramColumnConfigItem then begin
    a := TPanelTvProgramColumnConfigItem(Source);
    FChannelIndex := a.FChannelIndex;
    FChannelTv    := a.FChannelTv;
    FChannelEx    := a.FChannelEx;
  end
  else begin
    inherited;
  end;
end;

function TPanelTvProgramColumnConfigItem.DataLoad(
  t: TStringListEx): Boolean;
begin
  FChannelIndex := t.GetInts('ChannelIndex',FChannelIndex);
  FChannelTv    := t.GetInts('ChannelTv',FChannelTv);
  FChannelEx    := t.GetInts('ChannelEx',FChannelEx);
  result := True;
end;

function TPanelTvProgramColumnConfigItem.DataSave(
  t: TStringListEx): Boolean;
begin
  result := True;
  t.SetInts('ChannelIndex',FChannelIndex);
  t.SetInts('ChannelTv',FChannelTv);
  t.SetInts('ChannelEx',FChannelEx);
end;

end.
 