unit PanelTvProgramColumnClientEvent;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,
  StringListEx,StringListKey,StringKanji,PanelTvProgramColumnChannel,
  PanelTvProgramColumnTime,PanelTvProgramColumnConfig,PanelTvProgramColumnData,
  DataTvSchedule,EventTvSchedule,PanelTvProgramColumnClient,EventRdRec,
  DataRdRecReserve,DataCursorTv,EventCursorTv,EventCursorRd,DrawRdRecReserve;

type TPanelTvProgramColumnClientEventScrollEvent =
            procedure(Sender: TObject; Vector: Integer) of Object;

type
  TPanelTvProgramColumnClientEvent = class(TPanelTvProgramColumnClient)
  private
    { Private 錾 }
    FEventTv : TEventTvSchedule;
    FEventRd : TEventRdRec;
    FEventCurTv : TEventCursorTv;
    FEventCurRd : TEventCursorRd;
    procedure OnTvAdd(Sender: TObject;ts : TDataTvScheduleItemsEx);
    procedure OnTvDel(Sender: TObject;ts : TDataTvScheduleItemsEx);
    procedure OnTvClr(Sender: TObject);

    procedure OnRdAdd(Sender: TObject;ts : TDataRdRecReserveItemsEx);
    procedure OnRdDel(Sender: TObject;ts : TDataRdRecReserveItemsEx);
    procedure OnRdClr(Sender: TObject);

    procedure OnCurTvChange(Sender: TObject);
    procedure OnCurRdChange(Sender: TObject);

  public
    { Public 錾 }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;

     procedure View();override;

     //property OnMouseWheel : TPanelTvProgramColumnClientEventScrollEvent read FOnMouseWheel
     //                                                                    write FOnMouseWheel;
  end;

implementation

uses  DMUnit;

{ TPanelTvProgramColumnClientEvent }

constructor TPanelTvProgramColumnClientEvent.Create(AOwner: TComponent);
begin
  inherited;
  FEventTv := TEventTvSchedule.Create;
  FEventTv.OnAdds := OnTvAdd;
  FEventTv.OnDels := OnTvDel;
  FEventTv.OnClr  := OnTvClr;
  FEventTv.TvSchedule := DM.TvSchedule;

  FEventRd := TEventRdRec.Create;
  FEventRd.OnAdds := OnRdAdd;
  FEventRd.OnDels := OnRdDel;
  FEventRd.OnClr  := OnRdClr;
  FEventRd.Rd := DM.Rd;

  FEventCurTv := TEventCursorTv.Create;
  FEventCurTv.OnChange := OnCurTvChange;
  FEventCurTv.Cursor := DM.CursorTv;

  FEventCurRd := TEventCursorRd.Create;
  FEventCurRd.OnChange := OnCurRdChange;
  FEventCurRd.Cursor := DM.CursorRd;
end;

destructor TPanelTvProgramColumnClientEvent.Destroy;
begin
  FEventCurRd.Free;
  FEventCurTv.Free;
  FEventRd.Free;
  FEventTv.Free;
  inherited;

end;

procedure TPanelTvProgramColumnClientEvent.OnCurTvChange(Sender: TObject);
begin
  View();
end;

procedure TPanelTvProgramColumnClientEvent.OnCurRdChange(Sender: TObject);
begin
  View();
end;

procedure TPanelTvProgramColumnClientEvent.OnRdAdd(Sender: TObject;
  ts: TDataRdRecReserveItemsEx);
begin
  Data.RdAdds(ts);
  View();
end;

procedure TPanelTvProgramColumnClientEvent.OnRdDel(Sender: TObject;
  ts: TDataRdRecReserveItemsEx);
begin
  Data.RdDels(ts);
  Show();
end;

procedure TPanelTvProgramColumnClientEvent.OnRdClr(Sender: TObject);
begin
  Data.RdClr();
  View();
end;

procedure TPanelTvProgramColumnClientEvent.OnTvAdd(Sender: TObject;
  ts: TDataTvScheduleItemsEx);
var
  f : Boolean;
  i : Integer;
  d : TDataTvScheduleItem;
begin
  f := False;
  Data.TvAdds(ts);
  for i := 0 to ts.Count-1 do begin
    d := ts[i];
    f := f or (CheckViewTv(d));
  end;
  if f then View();
end;

procedure TPanelTvProgramColumnClientEvent.OnTvClr(Sender: TObject);
begin
  Data.Clear;
  Clear();
end;

procedure TPanelTvProgramColumnClientEvent.OnTvDel(Sender: TObject;
  ts: TDataTvScheduleItemsEx);
begin
  Data.TvDels(ts);
end;

procedure TPanelTvProgramColumnClientEvent.View;
var
  i,j,x,y,rdi : Integer;
  dss : TPanelTvProgramColumnDataChannelItem;
  r : TRect;
begin
  inherited;
  x := Config.ChIndex * Config.ChXh;
  y := Config.Hou * Config.TimeYh;
  for j := 0 to Data.Channels.Count-1 do begin
    dss := Data.Channels.Items[j];
    i := dss.RdItems.IndexOf(FEventCurRd.Cursor.Rd);
    if i <> -1 then begin
      r := dss.RdDraws[i].Rect;
      r.Left := r.Left - x;
      r.Right := r.Right - x;
      r.Top := r.Top - y;
      r.Bottom := r.Bottom - y;
      //viewr
      rdi := FEventCurRd.Cursor.Rd.RdIndex;
      DrawRdRecReserveDraw(Canvas,FEventCurRd.Cursor.Rd,DM.Config.Rd.Items[rdi].Config,r,True);
      {
      r.Left := r.Left - x;
      r.Right := r.Right - x;
      r.Top := r.Top - y;
      r.Bottom := r.Bottom - y;
      Canvas.Pen.Color := clRed;
      Canvas.Pen.Width := 2;
      Canvas.Brush.Style := bsClear;
      Canvas.Rectangle(r);
      }
      exit;
    end;
    i := dss.TvItems.IndexOf(FEventCurTv.Cursor.Tv);
    if i <> -1 then begin
      r := dss.TvDraws[i].Rect;
      r.Left := r.Left - x;
      r.Right := r.Right - x;
      r.Top := r.Top - y;
      r.Bottom := r.Bottom - y;
      Canvas.Pen.Color := clRed;
      Canvas.Pen.Width := 2;
      Canvas.Brush.Style := bsClear;
      Canvas.Rectangle(r);
      exit;
    end;
  end;
end;



end.
