//**************************************************************************//
//                                                                          //
//  suԑgf[^V`ŕ\XN[\NX                  //
//                                                                          //
//**************************************************************************//
unit PanelTvProgramColumnClient;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,
  StringListEx,StringListKey,StringKanji,PanelTvProgramColumnChannel,
  PanelTvProgramColumnTime,PanelTvProgramColumnConfig,PanelTvProgramColumnData,
  DataTvSchedule,EventTvSchedule,DataRdRecReserve,DataRdRecReserveEncode,
  DataRdRecReserveDateTime,DrawRdRecReserve,DataConfigTvGenre;

type
  TPanelTvProgramColumnClient = class(TPanel)
  private
    { Private 錾 }
    FConfig: TPanelTvProgramColumnConfig;   // ݒǗNX
    FBmpBack : TBitmap;
    FData: TPanelTvProgramColumnData;
    procedure ViewCopy();
    procedure ViewChListTv(dc : TPanelTvProgramColumnDataChannelItem;x : Integer;Fronted : Boolean);
    procedure ViewChListRd(dc : TPanelTvProgramColumnDataChannelItem;x : Integer;Drawed : Boolean);
    procedure ViewTvBack(d : TDataTvScheduleItem;r : TRect);
    procedure ViewTvFront(d : TDataTvScheduleItem;r : TRect);
    function ViewTvFrontTitle(r : TRect;d : TDataTvScheduleItem) : Integer;
    function ViewTvFrontComment(r : TRect;d : TDataTvScheduleItem) : Integer;
    procedure ViewRd(d : TDataRdRecReserveItem;r : TRect);
    procedure ViewRdRecReserveDraw(cv:TCanvas;d : TDataRdRecReserveItem;r : TRect;Selected : Boolean);

    procedure ProcOverlapRdTv(dc : TPanelTvProgramColumnDataChannelItem;aStart,aStop : TDateTimeCtrl);
    procedure ProcOverlapTvRd(dc : TPanelTvProgramColumnDataChannelItem;aStart,aStop : TDateTimeCtrl);

    function DrawTextRect(r : TRect;str : string;RowMax : Integer=9999) : Integer;

    function CheckViewData(aStart1,aStop1,aStart2,aStop2 : TDateTimeCtrl) : Boolean;

    function GetMinLength(d1,d2 : TDateTimeCtrl) : Integer;
  protected
    function CheckViewTv(d : TDataTvScheduleItem) : Boolean;
    function CheckViewRd(d : TDataRdRecReserveItem) : Boolean;
    procedure Paint();override;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;

    procedure Show();
    procedure View();virtual;
    procedure Clear();

    property Config : TPanelTvProgramColumnConfig read FConfig write FConfig;
    property Data : TPanelTvProgramColumnData read FData write FData;

  end;

implementation

uses  DMUnit;

{ TPanelTvProgramColumnClient }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TPanelTvProgramColumnClient.Create(AOwner: TComponent);
begin
  inherited;
  FBmpBack := TBitmap.Create;
  FBmpBack.PixelFormat := pf8bit;
  Color := clSilver;
end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TPanelTvProgramColumnClient.Destroy;
begin
  FBmpBack.Free;
  inherited;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ʍĕ`Cxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumnClient.Paint;
begin
  //inherited;
  ViewCopy();
end;

//**************************************************************************//
//                                                                          //
//  `@\ZbgĂ`@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TPanelTvProgramColumnClient.Show;
begin
  Clear();
  View();
  ViewCopy();
end;

//**************************************************************************//
//                                                                          //
//  `@XN[ƌ݂̕\͈͂`悷@`                            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TPanelTvProgramColumnClient.View;
var
  i,j,k,m : Integer;
  d : TPanelTvProgramColumnConfigItem;
  dc : TPanelTvProgramColumnDataChannelItem;
begin
  for i := 0 to FConfig.ColCount-1 do begin
    j := i + FConfig.ChIndex;
    if j < FConfig.Columns.Count then begin
      d:= FConfig.Columns[j];

      k := FData.Channels.IndexOfTvEx(d.ChannelTv,d.ChannelEx);
      if k = -1 then continue;
      dc := FData.Channels[k];

      for m := 0 to dc.RdItems.Count-1 do begin
        dc.RdItems[m].DateTime.MakeList(FConfig.DateTimeStart,FConfig.DateTimeStop);
      end;

      //ViewChListRd(dc,j);
      ViewChListRd(dc,j,False);      // ^\ƏdȂԑgɍĕ`̎w^
      ViewChListTv(dc,j,False);      // ԑgf[^̔wi`
      ViewChListRd(dc,j,True);       // ^\f[^`
      ViewChListTv(dc,j,True);       // ԑgf[^̓e`
    end;
  end;

  ViewCopy();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ǖɔԑgf[^`悷@`                                  //
//                                                                          //
//   - Input -  d : `悷                                          //
//              x : \鉡ʒui΍Wj                          //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumnClient.ViewChListTv(
  dc: TPanelTvProgramColumnDataChannelItem;x : Integer;Fronted : Boolean);
var
  f : Boolean;
  j : Integer;
  dcd : TDataTvScheduleItem;
  aDraw : TPanelTvProgramColumnDataItem;
  r : TRect;
  y1,y2,xh,yh : Integer;
begin
  for j := 0 to dc.TvItems.Count-1 do begin
    dcd := dc.TvItems[j];
    aDraw := dc.TvDraws[j];
    f := CheckViewTv(dcd);
    //f := CheckViewData(dcd.Start,dcd.Stop,FConfig.DateTimeViewStart,FConfig.DateTimeViewStop);
    if not f then continue;
    if aDraw.Drawing then continue;
    y1 := GetMinLength(FConfig.DateTimeStart,dcd.Start);
    y2 := GetMinLength(FConfig.DateTimeStart,dcd.Stop);
    xh := FConfig.ChXh;
    yh := FConfig.TimeYh;
    r := Rect((x+0)*xh,y1 * yh div 60,
               (x+1)*xh,y2 * yh div 60);
    aDraw.Rect := r;
    if Fronted then begin
      ViewTvFront(dcd,r);
      aDraw.Drawing := True;
    end
    else begin
      ProcOverlapTvRd(dc,dcd.Start,dcd.Stop);
      ViewTvBack(dcd,r);
    end;
  end;

end;

procedure TPanelTvProgramColumnClient.ViewChListRd(
  dc: TPanelTvProgramColumnDataChannelItem; x: Integer;Drawed : Boolean);
var
  j,k : Integer;
  dcd : TDataRdRecReserveItem;
  ds : TDataRdRecReserveDateTimeItems;
  dsi : TDataRdRecReserveDateTimeItem;
  aDraw : TPanelTvProgramColumnDataItem;
  r : TRect;
  y1,y2,xh,yh : Integer;
begin
  for j := 0 to dc.RdItems.Count-1 do begin
    dcd := dc.RdItems[j];
    aDraw := dc.RdDraws[j];
    ds := dcd.DateTime.Items;
    for k := 0 to ds.Count-1 do begin
      dsi := ds[k];

      ProcOverlapRdTv(dc,dsi.Start,dsi.Stop);
      if Drawed then begin                                   // True:`w

        y1 := GetMinLength(FConfig.DateTimeStart,dsi.Start);
        y2 := GetMinLength(FConfig.DateTimeStart,dsi.Stop);
        xh := FConfig.ChXh;
        yh := FConfig.TimeYh;
        r := Rect((x+0)*xh,y1 * yh div 60,
                   (x+1)*xh,y2 * yh div 60);
        aDraw.Rect := r;
        ViewRd(dcd,r);
      end;
    end;
    if Drawed then begin
      aDraw.Drawing := True;
    end;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^iwij`悷@`                                    //
//                                                                          //
//   - Input -  d : `悷                                          //
//              r : `͈́i΍Wj                                    //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumnClient.ViewTvBack(d: TDataTvScheduleItem;r : TRect);
const Tbl : array[0..9] of TColor = (clWhite,$02ECD7FC,$02FCCEFC,$02CEFCFC,
                                     $02FCFCCE,$02D7FCCE,$02CEEAFC,$02D7CEFC,$02CEFCFC,$02FCD7CE);
var
  cv : TCanvas;
  Genre : Integer;
  dg : TDataConfigTvGenreItem;
begin
  cv := FBmpBack.Canvas;
  Genre := DM.Config.Genre.Items.IndexOfGenre(d.Genre);
  dg := DM.Config.Genre.Items[Genre];
  cv.Brush.Color := dg.ColorBack;
  cv.Brush.Style := bsSolid;
  cv.Pen.Color := clBlack;
  cv.Rectangle(r);
  cv.Brush.Color := dg.ColorBack2;
  cv.Brush.Style := dg.BrushStyle;
  cv.Rectangle(r);

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^ij`悷@`                                //
//                                                                          //
//   - Input -  d : `悷                                          //
//              r : `͈́i΍Wj                                    //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumnClient.ViewTvFront(d: TDataTvScheduleItem;r : TRect);
var
  r3 : TRect;
  y : Integer;
  cv : TCanvas;
begin
  cv := FBmpBack.Canvas;

  r3.Top := r.Top + 2;                                          // `w
  r3.Left := r.Left + 2;
  r3.Bottom := r.Bottom - 2;
  r3.Right := r.Right - 2;

  if r3.Right  < r3.Left then r3.Right  := r3.Left;
  if r3.Bottom < r3.Top  then r3.Bottom := r3.Top;

  cv.Brush.Style := bsSolid;
  cv.Pen.Color := clBlack;

  cv.Font.Height := -12;
  y := ViewTvFrontTitle(r3,d);
  r3.Top := r3.Top + y;
  ViewTvFrontComment(r3,d);

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^iԑg^Cgj`悷@`                            //
//                                                                          //
//   - Input -  d : `悷                                          //
//              r : `͈́i΍Wj                                    //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
function TPanelTvProgramColumnClient.ViewTvFrontTitle(r: TRect;
  d: TDataTvScheduleItem): Integer;
var
  cv : TCanvas;
  yh : Integer;
  s : string;
  Genre : Integer;
  dg : TDataConfigTvGenreItem;
begin
  result := 0;
  //cv := FPaintBox.Canvas;
  cv := FBmpBack.Canvas;
  yh := r.Bottom - r.Top;
  s := d.Title;
  if yh < cv.TextHeight(s) then exit;
  Genre := DM.Config.Genre.Items.IndexOfGenre(d.Genre);
  dg := DM.Config.Genre.Items[Genre];

  cv.Font.Style := [fsBold];
  cv.Font.Color := dg.ColorTitle;
  cv.Brush.Style := bsClear;
  result := DrawTextRect(r,s,2);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^iԑgj`悷@`                                //
//                                                                          //
//   - Input -  d : `悷                                          //
//              r : `͈́i΍Wj                                    //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
function TPanelTvProgramColumnClient.ViewTvFrontComment(r: TRect;
  d: TDataTvScheduleItem): Integer;
var
  cv : TCanvas;
  yh : Integer;
  s : string;
  Genre : Integer;
  dg : TDataConfigTvGenreItem;
begin
  //cv := FPaintBox.Canvas;
  result := 0;
  cv := FBmpBack.Canvas;
  yh := r.Bottom - r.Top;
  s := d.Comment;
  if yh < cv.TextHeight(s) then exit;
  Genre := DM.Config.Genre.Items.IndexOfGenre(d.Genre);
  dg := DM.Config.Genre.Items[Genre];
  cv.Font.Style := [];
  cv.Font.Color := dg.ColorComment;
  cv.Brush.Style := bsClear;
  result := DrawTextRect(r,s);
end;

procedure TPanelTvProgramColumnClient.ViewRd(d: TDataRdRecReserveItem;
  r: TRect);
var
  i : Integer;
begin
  i := d.RdIndex;
  DrawRdRecReserveDraw(FBmpBack.Canvas,d,DM.Config.Rd.Items[i].Config,r,False);

end;

procedure TPanelTvProgramColumnClient.ViewRdRecReserveDraw(cv: TCanvas;
  d: TDataRdRecReserveItem; r: TRect; Selected: Boolean);
begin

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@gɓ悤ɕ܂Ԃĕ\@`                          //
//                                                                          //
//   - Input -  r : \͈                                                //
//              s : \镶                                          //
//              RowMax : \ős                                   //
//                                                                          //
//   - Output - ̍ڂ\鑊΂xW                                //
//                                                                          //
//--------------------------------------------------------------------------//
function TPanelTvProgramColumnClient.DrawTextRect(r: TRect; str: string;
  RowMax: Integer): Integer;
var
  s : string;
  cv : TCanvas;
  xh,y : Integer;
  j : Integer;
  r2 : TRect;
begin
  y := 0;
  //cv := FPaintBox.Canvas;
  cv := FBmpBack.Canvas;
  xh := r.Right - r.Left;
  if cv.TextWidth(str) <= xh then begin        // PsŎ܂ꍇ
    s := str;
    r2 := r;
    r2.Top := r.top;
    r2.Bottom := r.top + cv.TextHeight(s);
    cv.TextRect(r2,r2.Left,r2.top,s);
    result := cv.TextHeight(s);
    exit;
  end;
  s := '';
  j := xh div 12;
  while(str <> '') do begin
    s := CopyZen(str,1,j);
    r2 := r;
    r2.Top := r.top + y;
    r2.Bottom := r.top + y + cv.TextHeight(s);
    cv.TextRect(r2,r2.Left,r2.top,s);

    str := CopyZen(str,j+1,LengthZen(str));
    y := y + 12;
    if r.top + y + 12 > r.Bottom then break;
  end;
  result := y;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ĕ`s@`                                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumnClient.ViewCopy;
var
  b : TBitmap;
  x,y,xh,yh : Integer;
  r : TRect;
begin
  x := FConfig.ChIndex * FConfig.ChXh;
  y := FConfig.Hou * FConfig.TimeYh;
  //x := -Left;
  //y := -Top;
  xh := FConfig.ClientWidth;
  yh := FConfig.ClientHeight;
  r := Rect(x,y,x+xh,y+yh);
  b := FBmpBack;

  bitblt(Canvas.Handle,0,0,
         xh,yh,
         b.Canvas.Handle,x,y,SrcCopy);       // ʂɔf
  {
  bitblt(Canvas.Handle,0,0,
         b.Width,b.Height,
         b.Canvas.Handle,0,0,SrcCopy);       // ʂɔf
  }
  {
  b := FBmpFront;
  bitblt(Canvas.Handle,x,y,
         xh,yh,
         b.Canvas.Handle,x,y,SRCAND);       // ʂɔf
  }
  //Canvas.CopyMode := SRCCOPY;
  //Canvas.CopyRect(r,b,r);       // ʂɔf
  {
  bitblt(Canvas.Handle,0,0,
         b.Width,b.Height,
         b.Canvas.Handle,0,0,SrcCopy);       // ʂɔf
  }
  //Canvas.Draw(0,0,FBmpBack);
  //Canvas.Draw(0,0,FBmpFront);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@SẴf[^ĕ`悵@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumnClient.Clear;
var
  xh,yh : Integer;
  i : Integer;
  cv : TCanvas;
begin
  xh := FConfig.ChXh * FConfig.Columns.Count;
  yh := FConfig.TimeYh * (FConfig.DayMax + FConfig.DayOld) * 24;
  Width := xh;
  Height := yh;
  FBmpBack.Width := xh;
  FBmpBack.Height := yh;
  {
  cv := FBmpFront.Canvas;
  cv.Brush.Style := bsSolid;
  cv.Brush.Color := clWhite;
  cv.FillRect(ClientRect);
  }
  //FBmpFront.Transparent := True;
  //FBmpFront.TransparentColor := clSilver;

  cv := FBmpBack.Canvas;
  cv.Brush.Style := bsSolid;
  cv.Brush.Color := clSilver;
  cv.FillRect(ClientRect);
  for i := 0 to FConfig.Columns.Count-1 do begin
    cv.Rectangle(i * FConfig.ChXh,0,
                 (i + 1) * FConfig.ChXh,yh);
  end;
  FData.DrawClear();
end;


function TPanelTvProgramColumnClient.CheckViewTv(d: TDataTvScheduleItem): Boolean;
begin
  result := CheckViewData(d.Start,d.Stop,FConfig.DateTimeViewStart,FConfig.DateTimeViewStop);
end;

function TPanelTvProgramColumnClient.CheckViewRd(
  d: TDataRdRecReserveItem): Boolean;
begin
  result := CheckViewData(d.DateTime.Start,d.DateTime.Stop,FConfig.DateTimeViewStart,FConfig.DateTimeViewStop);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@suԑgP\@`                                            //
//                                                                          //
//   - Input -  aStart1 : ԑg̊Jn                                    //
//              aStop1  : ԑg̏I                                    //
//              aStart2 : \͈͂̊Jn                                //
//              aStop2  : \͈͂̏I                                //
//                                                                          //
//   - Output - True : ԑg\͈͓ɂ                               //
//                                                                          //
//--------------------------------------------------------------------------//
function TPanelTvProgramColumnClient.CheckViewData(aStart1, aStop1,
  aStart2, aStop2: TDateTimeCtrl): Boolean;
var
  ds1,dp1,ds2,dp2 : TDateTime;
begin
  ds1 := aStart1.DateTime;
  dp1 := aStop1.DateTime;
  ds2 := aStart2.DateTime;
  dp2 := aStop2.DateTime;
  result := ((ds1 >= ds2) and (ds1 <= dp2)) or
            ((dp1 >= ds2) and (dp1 <= dp2));
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ڂ̃f[^ɂȂ̂vZ@`                                  //
//                                                                          //
//   - Input -  d1   : ʈԏ̓                                     //
//              d2   : ڂɂȂ̂vZf[^                 //
//                                                                          //
//   - Output - ڂɂȂ邩                                              //
//                                                                          //
//--------------------------------------------------------------------------//
function TPanelTvProgramColumnClient.GetMinLength(d1,
  d2: TDateTimeCtrl): Integer;
var
  d3 : TDateTimeCtrl;
  f : Boolean;
  aMin : Integer;
begin
  result := 0;
  d3 := TDateTimeCtrl.Create;                     // ̃f[^ςȂ悤ɕ쐬
  try
    //if d1.Compari(d2) > 0 then begin            //  < f[^̏ꍇ
    if d1.DateTime < d2.DateTime then begin       //  < f[^̏ꍇ
      aMin := -60;                                // 60OvZ
      d3.Assign(d1);                              // 쐬
      d3.DecHou;
      f := False;
      while not f do begin                        // ʕ\͈͓Ń[v
        if d2.Min <> d3.Min then begin            // قȂꍇ
          d3.IncMin();                            // ܂Ń[v
          Inc(aMin);                              // i߂Z
        end
        else if d2.Hou <> d3.Hou then begin       // قȂꍇ
          d3.IncHou();                            // ܂Ń[v
          Inc(aMin,60);                           // i߂Z
        end
        else begin
          if d2.Day <> d3.Day then begin          // قȂꍇ
            d3.IncDay();                          // ܂Ń[v
            Inc(aMin,60*24);                      // i߂Z
          end
          else begin                              // vꍇ
            //f := True;                          // ͈͓ł邱Ƃm点
            break;                                // [vEo
          end;                                    // 쐬
        end;
      end;
      result := aMin;
    end
    //else if d1.Compari(d2) < 0 then begin       //  < f[^̏ꍇ
    else if d1.DateTime > d2.DateTime then begin  //  > f[^̏ꍇ
      aMin := 60;                                 // 60ォvZJn
      d3.Assign(d1);                              // 쐬
      d3.IncHou;
      f := False;
      while not f do begin                        // ʕ\͈͓Ń[v
        if d2.Min <> d3.Min then begin            // قȂꍇ
          d3.DecMin();                            // ܂Ń[v
          Dec(aMin);                              // i߂Z
        end
        else if d2.Hou <> d3.Hou then begin       // قȂꍇ
          d3.DecHou();                            // ܂Ń[v
          Dec(aMin,60);                           // i߂Z
        end
        else begin
          if d2.Day <> d3.Day then begin          // قȂꍇ
            d3.DecDay();                          // ܂Ń[v
            Dec(aMin,60*24);                      // i߂Z
          end
          else begin                              // vꍇ
            //f := True;                          // ͈͓ł邱Ƃm点
            break;                                // [vEo
          end;
        end;
      end;
      result := aMin;
    end;
  finally
    d3.Free;
  end;
end;


procedure TPanelTvProgramColumnClient.ProcOverlapRdTv(
  dc: TPanelTvProgramColumnDataChannelItem; aStart, aStop: TDateTimeCtrl);
var
  f : Boolean;
  j : Integer;
  dcd : TDataTvScheduleItem;
  aDraw : TPanelTvProgramColumnDataItem;
begin
  for j := 0 to dc.TvItems.Count-1 do begin
    dcd := dc.TvItems[j];
    aDraw := dc.TvDraws[j];
    f := CheckViewData(dcd.Start,dcd.Stop,aStart,aStop);
    if f then begin
      aDraw.Drawing := False;
    end;
  end;
end;

procedure TPanelTvProgramColumnClient.ProcOverlapTvRd(
  dc: TPanelTvProgramColumnDataChannelItem; aStart, aStop: TDateTimeCtrl);
var
  f : Boolean;
  j,k : Integer;
  dcd : TDataRdRecReserveItem;
  ds : TDataRdRecReserveDateTimeItems;
  dsi : TDataRdRecReserveDateTimeItem;
  aDraw : TPanelTvProgramColumnDataItem;
begin
  for j := 0 to dc.RdItems.Count-1 do begin
    dcd := dc.RdItems[j];
    aDraw := dc.RdDraws[j];
    ds := dcd.DateTime.Items;
    for k := 0 to ds.Count-1 do begin
      dsi := ds[k];
      f := CheckViewData(dsi.Start,dsi.Stop,aStart,aStop);
      if f then begin
        aDraw.Drawing := False;
      end;
    end;
  end;
end;

end.
