unit PanelTvProgramColumnChannel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,
  PanelTvProgramColumnConfig,DataTvChannel;

type
  TPanelTvProgramColumnChannel = class(TPanel)
  private
    { Private 錾 }
    FConfig: TPanelTvProgramColumnConfig;
    procedure View();
    procedure ViewSub(r : TRect;dc : TDataTvChannelItem);
    procedure OnSelfResize(Sender: TObject);
  protected
    procedure Paint();override;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;

    procedure Show();

    property Config : TPanelTvProgramColumnConfig read FConfig write FConfig;

  end;

implementation

uses  DMUnit;

{ TPanelTvProgramColumnChannel }

constructor TPanelTvProgramColumnChannel.Create(AOwner: TComponent);
begin
  inherited;
  OnResize := OnSelfResize;
end;

destructor TPanelTvProgramColumnChannel.Destroy;
begin
  inherited;

end;

procedure TPanelTvProgramColumnChannel.OnSelfResize(Sender: TObject);
begin
  View();
end;

procedure TPanelTvProgramColumnChannel.Paint;
begin
  View();
end;


procedure TPanelTvProgramColumnChannel.Show;
begin
  View();
end;

procedure TPanelTvProgramColumnChannel.View;
var
  cv : TCanvas;
  i,j,xh,yh : Integer;
  r : TRect;
  d : TPanelTvProgramColumnConfigItem;
  dc : TDataTvChannelItem;
begin
  cv := Canvas;
  cv.Brush.Style := bsSolid;
  cv.Brush.Color := clBlack;

  xh := ClientWidth div FConfig.ColCount;
  yh := ClientHeight;
  FConfig.ChXh := xh;
  for j := 0 to FConfig.ColCount-1 do begin              // \ǐ[v
    i := j + FConfig.ChIndex;
    if  i < FConfig.Columns.Count then begin             // f[^͈͓̏ꍇ
      d := FConfig.Columns[i];
      r := Rect( j * xh,                         // \͈͂ݒ
                -1,
                (j + 1) * xh,
                yh);
      dc := DM.Config.TvChannel.Items.TvExs[d.ChannelTv,d.ChannelEx];
      if dc = nil then continue;
      ViewSub(r,dc);
    end;
  end;
end;

procedure TPanelTvProgramColumnChannel.ViewSub(r: TRect;
  dc: TDataTvChannelItem);
var
  cv : TCanvas;
  s : string;
  xh : Integer;
begin
  cv := Canvas;
  //cv.FrameRect(r);                             // ǂƂ̘g`

  cv.Brush.Style := bsSolid;
  cv.Brush.Color := clBlue;
  cv.Rectangle(r);

  cv.Brush.Style := bsClear;
  cv.Font.Color := clWhite;
  cv.Font.Style := [fsBold];

  xh := r.Right - r.Left;

  s := dc.Name;
  cv.TextRect(r,r.Left + xh div 2 - cv.TextWidth(s) div 2,r.Top + 2,s);

end;

end.
 