//**************************************************************************//
//                                                                          //
//  suԑgf[^V`ŕ\NX                                //
//                                                                          //
//  cXN[o[w胊XgǗ                                //
//                                                                          //
//**************************************************************************//
unit PanelTvProgramColumn;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,
  StringListEx,StringListKey,StringKanji,PanelTvProgramColumnChannel,
  PanelTvProgramColumnTime,PanelTvProgramColumnConfig,PanelTvProgramColumnClient,
  PanelTvProgramColumnData,PanelTvProgramColumnClientEvent,PanelTvProgramDateList;

type
  TPanelTvProgramColumn = class(TPanel)
  private
    { Private 錾 }
    FHandle: HWND;                              // EChEnh
    FConfig: TPanelTvProgramColumnConfig;       // ݒf[^NX
    FData : TPanelTvProgramColumnData;          // ԑgf[^NX

    FPanelScr : TPanel;                         // V`igj\pl
    FPanelClient : TPanelTvProgramColumnClientEvent; // V`iۂ̕j\pl
    FPanelTime : TPanelTvProgramColumnTime;     // Ԉꗗ\pl
    FPanelCh : TPanelTvProgramColumnChannel;    // ǈꗗ\pl
    FPanelX : TPanel;                           // ̃XN[o[gk{^̓ypl
    FPanelY : TPanel;                           // c̃XN[o[gk{^̓ypl

    FScrBarY : TScrollBar;                      // cXN[o[
    FScrBarX : TScrollBar;                      // XN[o[

    FBtnXInc : TButton;                         // g{^
    FBtnXDec : TButton;                         // k{^
    FBtnYInc : TButton;                         // cg{^
    FBtnYDec : TButton;                         // ck{^

    FDateTimeStart: TDateTimeCtrl;              // \̐擪
    FDateTimeStop : TDateTimeCtrl;
    FDateTimeView: TDateTimeCtrl;
    FOnMinChange: TNotifyEvent;              // \̏I

    procedure OnSelfResize(Sender: TObject);
    procedure ProcResize();
    procedure ProcReTime();
    procedure ProcReCh();

    procedure SetScrBarY();
    procedure SetScrBarX();


    // ԑgg\gk{^NbNCxg
    procedure OnBtnXYClick(Sender: TObject);

    procedure OnScrYChange(Sender: TObject);
    procedure OnScrXChange(Sender: TObject);
    procedure OnScrMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

    procedure WMMousewheel(var Msg: TMessage); message WM_MOUSEWHEEL;
    procedure SetConfig(const Value: TPanelTvProgramColumnConfig);
    procedure SetData(const Value: TPanelTvProgramColumnData);
    procedure SetDateTimeView(const Value: TDateTimeCtrl);
    function GetMinY: Integer;
    procedure SetMinY(const Value: Integer);

  public
    { Public 錾 }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;

    procedure Show();
    // zC[̂߂ɕKvȏ
    procedure ActiveCursor();

    property DateTimeStart : TDateTimeCtrl read FDateTimeStart;
    property DateTimeView : TDateTimeCtrl read FDateTimeView write SetDateTimeView;

    property Config : TPanelTvProgramColumnConfig read FConfig write SetConfig;
    property Data : TPanelTvProgramColumnData read FData write SetData;
    // ԕ̃XN[o[|WV
    property MinY : Integer read GetMinY write SetMinY;

    property OnMinChange : TNotifyEvent read FOnMinChange write FOnMinChange;

  end;

implementation

uses  DMUnit;

{ TPanelTvProgramColumn }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TPanelTvProgramColumn.Create(AOwner: TComponent);
begin
  inherited;

  FDateTimeStart := TDateTimeCtrl.Create;
  FDateTimeStop := TDateTimeCtrl.Create;
  FDateTimeView := TDateTimeCtrl.Create;

  BevelOuter := bvNone;

  FPanelScr := TPanel.Create(Self);
  FPanelScr.Parent := Self;
  FPanelScr.BevelOuter := bvNone;

  FPanelClient := TPanelTvProgramColumnClientEvent.Create(Self);
  FPanelClient.Parent := FPanelScr;
  FPanelClient.BevelOuter := bvNone;
  FPanelClient.Config := FConfig;
  FPanelClient.Data := FData;
  FPanelClient.OnMouseDown := OnScrMouseDown;

  FPanelTime := TPanelTvProgramColumnTime.Create(Self);
  FPanelTime.Parent := Self;
  FPanelTime.BevelOuter := bvNone;
  FPanelTime.Config := FConfig;

  FPanelCh := TPanelTvProgramColumnChannel.Create(Self);
  FPanelCh.Parent := Self;
  FPanelCh.BevelOuter := bvNone;
  FPanelCh.Config := FConfig;

  FPanelX := TPanel.Create(Self);
  FPanelX.Parent := Self;
  FPanelX.BevelOuter := bvNone;

  FPanelY := TPanel.Create(Self);
  FPanelY.Parent := Self;
  FPanelY.BevelOuter := bvNone;

  FBtnXDec := TButton.Create(Self);
  FBtnXDec.Parent := FPanelX;
  FBtnXDec.Align := alRight;
  FBtnXDec.Width := 30;
  FBtnXDec.Caption := '-';
  FBtnXDec.Tag := 0;
  FBtnXDec.OnClick := OnBtnXYClick;

  FBtnXInc := TButton.Create(Self);
  FBtnXInc.Parent := FPanelX;
  FBtnXInc.Align := alRight;
  FBtnXInc.Width := 30;
  FBtnXInc.Caption := '+';
  FBtnXInc.Tag := 1;
  FBtnXInc.OnClick := OnBtnXYClick;

  FBtnYDec := TButton.Create(Self);
  FBtnYDec.Parent := FPanelY;
  FBtnYDec.Align := alBottom;
  FBtnYDec.Width := 30;
  FBtnYDec.Caption := '-';
  FBtnYDec.Tag := 2;
  FBtnYDec.OnClick := OnBtnXYClick;

  FBtnYInc := TButton.Create(Self);
  FBtnYInc.Parent := FPanelY;
  FBtnYInc.Align := alBottom;
  FBtnYInc.Width := 30;
  FBtnYInc.Caption := '+';
  FBtnYInc.Tag := 3;
  FBtnYInc.OnClick := OnBtnXYClick;

  FScrBarX := TScrollBar.Create(Self);
  FScrBarX.Parent := FPanelX;
  FScrBarX.Kind := sbHorizontal;
  FScrBarX.OnChange := OnScrXChange;
  FScrBarX.Align := alClient;

  FScrBarY := TScrollBar.Create(Self);
  FScrBarY.Parent := FPanelY;
  FScrBarY.Kind := sbVertical;
  FScrBarY.OnChange := OnScrYChange;
  FScrBarY.Align := alClient;

  OnResize := OnSelfResize;
end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TPanelTvProgramColumn.Destroy;
begin
  FScrBarY.Free;
  FScrBarX.Free;

  FPanelY.Free;
  FPanelX.Free;

  FPanelCh.Free;
  FPanelTime.Free;
  FPanelClient.Free;

  FPanelScr.Free;

  FDateTimeView.Free;
  FDateTimeStop.Free;
  FDateTimeStart.Free;

  DeallocateHWND(FHandle);
  inherited;

end;

//**************************************************************************//
//                                                                          //
//  `@SĂ̓e`悷@`                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TPanelTvProgramColumn.Show;
var
  dd : TDateTimeCtrl;
begin
  dd := TDateTimeCtrl.Create;
  try
    dd.DateTime := Now;
    dd.Min := 0;                                 // \̃Yh~
    dd.Sec := 0;
    dd.DecDay(DM.Config.Normal.OldDay);
    FConfig.DateTimeStart.Assign(dd);            // ǗJnw
    FConfig.DayMax := DM.Config.Normal.ReadDay;
    FConfig.DayOld := DM.Config.Normal.OldDay;
    FPanelTime.Show;
    SetScrBarY();
    SetScrBarX();
    FPanelClient.Show;
  finally
    dd.Free;
  end;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ʃTCYɊep[c̑傫킹@`                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumn.ProcResize;
var
  xh,yh : Integer;
  dp : TPanel;
begin
  dp := FPanelScr;
  dp.Left := 20;
  dp.Top  := 20;
  yh := ClientHeight;
  xh := ClientWidth;
  //dp.Height := yh - 20;
  //dp.Width  := xh - 20;
  dp.Height := yh - 20 - FScrBarX.Height;
  dp.Width  := xh - 20 - FScrBarY.Width;

  FPanelX.Left := 20;
  FPanelX.Top := dp.Top + dp.Height;
  FPanelX.Width := dp.Width;
  FPanelX.Height := 16;

  FPanelY.Top := 20;
  FPanelY.Left := dp.Left + dp.Width;
  FPanelY.Height := dp.Height;
  FPanelY.Width := 16;

  FPanelTime.Left := 0;
  FPanelTime.Top := 20;
  FPanelTime.Width := 20;
  FPanelTime.Height := dp.Height;

  FPanelCh.Left := 20;
  FPanelCh.Top := 0;
  FPanelCh.Height := 20;
  FPanelCh.Width := dp.Width;

  FConfig.ClientHeight := dp.ClientHeight;
  FConfig.ClientWidth := dp.ClientWidth;

  ProcReCh();
  ProcReTime();
  FPanelClient.Show();
end;



//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԕ\ύXɔs@`                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumn.ProcReTime;
begin
  FDateTimeStop.Assign(FDateTimeStart);
  SetScrBarY();
  FPanelTime.Show();
  FPanelClient.Show();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Ǖ\ύXɔs@`                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumn.ProcReCh;
begin
  SetScrBarX();
  FPanelCh.Show();
  FPanelClient.SHow();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@cXN[o[̍őlvZ@`                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumn.SetScrBarY;
var
  y : Integer;
begin
  y  := (FConfig.DayMax + FConfig.DayOld) * 24 - FConfig.RowCount;
  if y > 0 then begin
    FScrBarY.Max := y;
    FScrBarY.Visible := True;
  end
  else begin
    FScrBarY.Visible := False;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@XN[o[̍őlvZ@`                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumn.SetScrBarX;
var
  x : Integer;
begin
  x := FConfig.Columns.Count - FConfig.ColCount;
  if x > 0 then begin
    FScrBarX.Max := FConfig.Columns.Count - FConfig.ColCount;
    FScrBarX.Visible := True;
  end
  else begin
    FScrBarX.Visible := False;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@cXN[o[̈ړCxg@`                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumn.OnScrXChange(Sender: TObject);
begin
  FConfig.ChIndex := FScrBarX.Position;
  FPanelCh.Show();
  FPanelClient.View();
  //FScrBox.HorzScrollBar.Position := Ch * FConfig.ChXh;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@XN[o[̈ړCxg@`                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumn.OnScrYChange(Sender: TObject);
begin
  FConfig.Hou := FScrBarY.Position;
  FPanelTime.Show();
  FPanelClient.View();
  if Assigned(FOnMinChange) then begin
    FOnMinChange(Self);
  end;
  //FScrBox.VertScrollBar.Position := Hou * FConfig.TimeYh;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑg\}EX~Cxg@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumn.OnScrMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  i,j,x1,y1 : Integer;
  d : TPanelTvProgramColumnDataItem;
  dss : TPanelTvProgramColumnDataChannelItem;
begin
  x1 := FConfig.ChIndex * FConfig.ChXh;
  y1 := FConfig.Hou * FConfig.TimeYh;
  x1 := x1 + X;
  y1 := y1 + Y;

  DM.CursorTv.Tv := nil;                          // ԑg̑I
  DM.CursorRd.Rd := nil;                          // qc̗\I

  for j := 0 to FData.Channels.Count-1 do begin   // \ǐ[v
    dss := FData.Channels.Items[j];               // PǃNXQ
    for i := 0 to dss.RdDraws.Count-1 do begin    // PǂɊ֘Aqc\񐔕[v
      d := dss.RdDraws[i];                        // P\NXQ
      if d.CheckPoint(x1,y1) then begin           // \\͈͂Ƀ}EXꍇ
        DM.CursorRd.Rd := dss.RdItems[i];         // qc̗\ƂđIԂɂ
        exit;                                     // Ȍ̏͋֎~
      end;
    end;
    for i := 0 to dss.TvDraws.Count-1 do begin    // PǂɊ֘Aԑg[v
      d := dss.TvDraws[i];                        // PԑgNXQ
      if d.CheckPoint(x1,y1) then begin           // ԑg\͈͂Ƀ}EXꍇ
        DM.CursorTv.Tv := dss.TvItems[i];         // ԑgIԂɂ
        exit;                                     // Ȍ̏͋֎~
      end;
    end;

  end;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@cgk{^NbNCxg@`                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumn.OnBtnXYClick(Sender: TObject);
var
  m,d : Integer;
begin
  m := TButton(Sender).Tag;
  case m of
    0:  begin
          d := FConfig.ColCount;
          if d < 10 then begin
            Inc(d,2);
            FConfig.ColCount := d;
            ProcReCh();
            //FData.DrawClear;
          end;
        end;
    1:  begin
          d := FConfig.ColCount;
          if d > 4 then begin
            Dec(d,2);
            FConfig.ColCount := d;
            ProcReCh();
            //FData.DrawClear;
          end;
        end;
    2:  begin
          d := FConfig.RowCount;
          if d < 10 then begin
            Inc(d,2);
            FConfig.RowCount := d;
            ProcReTime();
          end;
        end;
    3:  begin
          d := FConfig.RowCount;
          if d > 4 then begin
            Dec(d,2);
            FConfig.RowCount := d;
            ProcReTime();
          end;
        end;
  end;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@g̃TCYύXCxg@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumn.OnSelfResize(Sender: TObject);
begin
  ProcResize();
  Show();
end;


//--------------------------------------------------------------------------//
//                                                                          //
//  `@zC[XN[Cxg@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//    ʃNXŎȂƔƂ                //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvProgramColumn.WMMousewheel(var Msg: TMessage);
var
  y : Integer;
begin
  y := MinY;
  if (Msg.WParam > 0) then begin      // zC[ŏւ̃XN[vꍇ
    Dec(y);
    if y < 0 then y := 0;
  end
  else begin                          // zC[ŉւ̃XN[vꍇ
    Inc(y);
    if y > (FConfig.DayMax + FConfig.DayOld) * 24 then y := FConfig.DayMax * 24;
  end;
  MinY := y;
end;

procedure TPanelTvProgramColumn.SetConfig(
  const Value: TPanelTvProgramColumnConfig);
begin
  FConfig := Value;
  FPanelCh.Config := Value;
  FPanelTime.Config := Value;
  FPanelClient.Config := Value;
end;

procedure TPanelTvProgramColumn.SetData(
  const Value: TPanelTvProgramColumnData);
begin
  FData := Value;
  FPanelClient.Data := Value;
end;

procedure TPanelTvProgramColumn.SetDateTimeView(
  const Value: TDateTimeCtrl);
var
  i,cnt : Integer;
  dd : TDateTimeCtrl;
begin
  dd := TDateTimeCtrl.Create;
  try
    FDateTimeView.Assign(Value);
    //FDateTimeView.Min := 0;
    //FDateTimeView.Sec := 0;
    dd.Assign(FDateTimeStart);
    dd.Min := 0;
    dd.Sec := 0;
    cnt := (FConfig.DayMax + FConfig.DayOld)*24;
    for i := 0 to cnt do begin
      if dd.Compari(FDateTimeView) = 0 then begin
        FScrBarY.Position := i;
        FConfig.Hou := i;
        FPanelTime.Show;
        FPanelClient.View();
        exit;
      end;
      dd.IncHou();
    end;

  finally
    dd.Free;
  end;

end;

function TPanelTvProgramColumn.GetMinY: Integer;
begin
  result := FConfig.Hou;
end;

procedure TPanelTvProgramColumn.SetMinY(const Value: Integer);
begin
  FScrBarY.Position := Value;
end;


procedure TPanelTvProgramColumn.ActiveCursor;
begin
  FScrBarY.SetFocus();
end;

end.
