//**************************************************************************//
//                                                                          //
//  suԑg\\NX                                              //
//                                                                          //
//**************************************************************************//
unit PanelTvList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ComCtrls,ExtCtrls,DefaultData, CommCtrl,StringListEx,
  ListViewV,MultiEvent,DataTvColumn,EventTvSchedule,DataTvSChedule,
  DataTvStatus,DataRdRecReserve,DateTimeCtrl;

{
const
  TPanelTvGuideListColumTbl : array[0..9] of string = ('RecMark','Extend','Date','Time','TimeLength',
                                               'ChannelName','NewEnd','Title','TalkNo','TalkMax');
}

type
  TPanelTvGuideListSort = (tglsDateTime,tglsTitle,tglsChannel,tglsTalkAtoZ,tglsTalkZtoA,tglsGenru);

//--------------------------------------------------------------------------//
//  suԑg\pXgNX                                              //
//--------------------------------------------------------------------------//
type
  TPanelTvList = class(TPanel)
  private
    { Private 錾 }
    FEventTv : TEventTvSchedule;
    FListViewV : TListViewV;
    FOverLapRd : TDataRdRecReserveItemsEx;
    FDateTimeView: TDateTimeCtrl;     // suԑgɏdȂ^擾Ɨp
    procedure ColumnSet();
    procedure ItemTextOutEx(c: TCanvas; r: TRect;
                            X: Integer; const Y: Integer; str: string; ColorTbl: array of TColor;
                            aState: TOwnerDrawState);

    procedure OnListClick(Sender: TObject);
    procedure OnListDblClick(Sender: TObject);
    procedure OnColumClick(Sender: TObject; Column: Integer);
    procedure OnColumnWidthChange(Sender: TObject);
    procedure OnDrawItem(Canvas : TCanvas;Column,Index: Integer;
                                         Rect: TRect; State: TOwnerDrawState);
    procedure OnTvAdd(Sender: TObject;ts : TDataTvScheduleItemsEx);
    procedure OnTvDel(Sender: TObject;ts : TDataTvScheduleItemsEx);
    procedure OnTvClr(Sender: TObject);
    procedure SetDateTimeView(const Value: TDateTimeCtrl);

  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure Show();
    // \Jn
    property DateTimeView : TDateTimeCtrl read FDateTimeView write SetDateTimeView;
  end;

implementation

uses DMUnit;

{ TPanelTvList }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TPanelTvList.Create(AOwner: TComponent);
begin
  inherited;
  FOverLapRd := TDataRdRecReserveItemsEx.Create;

  FListViewV := TListViewV.Create(Self);
  FListViewV.Parent := Self;
  FListViewV.Align := alClient;
  FListViewV.OnDrawItem  := OnDrawItem;
  FListViewV.OnListClick := OnListClick;
  FListViewV.OnListDblClick  := OnListDblClick;
  FListViewV.OnColumnClick := OnColumClick;
  FListViewV.OnColumnWidthChange := OnColumnWidthChange;
  FListViewV.Style := lvOwnerDrawFixed;
  FListViewV.MouseWheelLine := 6;

  FEventTv := TEventTvSchedule.Create;
  FEventTv.OnAdds := OnTvAdd;
  FEventTv.OnDels := OnTvDel;
  FEventTv.OnClr  := OnTvClr;
  FEventTv.TvSchedule := DM.TvSchedule;

end;

destructor TPanelTvList.Destroy;
begin
  FEventTv.Free;
  FListViewV.Free;
  FOverLapRd.Free;
  inherited;

end;

procedure TPanelTvList.Show;
begin
  ColumnSet();
end;

procedure TPanelTvList.ColumnSet;
var
  i : Integer;
  c : TListViewVColumn;
  d : TDataTvColumnItem;
begin
  //Visible := False;
  FListViewV.Columns.Clear;
  for i := 0 to DM.Define.TvColumn.Columns.Count-1 do begin
    c := FListViewV.Columns.Add();
    d := DM.Define.TvColumn.Columns[i];
    c.Data := Pointer(d.Mode);
    c.Caption := d.Caption;
    c.Width   := d.Width;
  end;
end;

procedure TPanelTvList.OnColumClick(Sender: TObject; Column: Integer);
begin

end;

procedure TPanelTvList.OnColumnWidthChange(Sender: TObject);
begin

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Xg`Cxg@`                                              //
//                                                                          //
//   - Input -  ȗ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvList.OnDrawItem(Canvas: TCanvas; Column, Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
  d : TDataTvScheduleItem;
  s : string;
  dd : TDateTime;
  cl : TColor;
begin
  d := TDataTvScheduleItem(FListViewV.Items[Index].Data);
  dd := d.Start.DateTime;
  if not (odSelected	in State)	then begin
    Canvas.Font.Color := clBlack;
    Canvas.Brush.Color := clWhite;
  end
  else begin
    Canvas.Font.Color := clWhite;
    Canvas.Brush.Color := clHighlight;
  end;
  Canvas.FillRect(Rect);


  case TPanelTvGuideListColumMode(FListViewV.Columns[Column].Data) of
    tvcmRecMark :
      begin
        Canvas.Font.Color := clRed;
        s := '@';
        if DM.TvToOverlapRd(FOverLapRd,d) then begin
          s := '';
        end;
        {
        if d.RecOverlap = rtNot then begin
          s := '@';
        end
        else begin

          if d.RecRdNo < DM.Config.RdItems.Count then begin
            Canvas.Font.Color := DMConfig.RdItems[d.RecRdNo].RecMarkColor;
            s := DMConfig.RdItems[d.RecRdNo].RecMarkText;
          end;

        end;
        }
        Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
      end;
    tvcmExtend :
      begin
        if d.Status.Status[tsmExtended].Value then begin
          s := '';
        end
        else begin
          s := '@';
        end;
        Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
      end;
    tvcmDate :
      begin
        case DayOfWeek(dd) of
          1 : cl := clRed;
          7 : cl := clBlue;
        else  cl := clBlack;
        end;
        s := FormatDateTime('dd"(,"aaa",)"',dd);
        ItemTextOutEx(Canvas,Rect,1,0,s,[clBlack,cl,clBlack],State);
      end;
    tvcmTime :
      begin
        s := FormatDateTime('hh:mm',dd);
        Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
      end;
    tvcmTimeLength :
      begin
        s := Format('%4d',[d.TimeLength])+'';
        Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
      end;
    tvcmChannelName :
      begin
        s := '';
        if d.ChannelObj <> nil then begin
          s := d.ChannelObj.Name;
        end;
        Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
      end;
    tvcmNewEnd :
      begin
        d.Status.OutMark(Canvas,Rect,1,1,State);
      end;
    tvcmTitle :
      begin
        s := d.Title;
        Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
      end;
    tvcmTalkNo :
      begin
        if d.TalkNo > 0 then begin
          s := IntToStr(d.TalkNo);
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
        end;
      end;
    tvcmTalkMax :
      begin
          if d.TalkMax > 0 then begin
            s := IntToStr(d.TalkMax);
            Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
          end;
      end;
    tvcmGenru :
      begin
          s := d.GenreStr;
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
      end;
  end;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@w肵FAXgɕ\@`                            //
//                                                                          //
//   - Input -  c        : \LoX                               //
//              r        : \̈                                     //
//              X        : \wW                                   //
//              Y        : \xW                                   //
//              str      : \镶                                   //
//              ColorTbl : gp镶FXg                             //
//              aState : (odSelected : J[\)              //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//  FgpƂɎg                                        //
//    \镶J}ŋ؂ĂΊY镶Fŕ\      //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TPanelTvList.ItemTextOutEx(c: TCanvas; r: TRect;
  X: Integer; const Y: Integer; str: string; ColorTbl: array of TColor;
  aState: TOwnerDrawState);
var
  t : TStringListEx;
  i,xx : Integer;
  s : string;
begin
  t := TStringListEx.Create;
  xx := x;
  try
    t.CommaTextEx := str;
    for i := 0 to t.Count-1 do begin
      if i <= High(ColorTbl) then begin
        if not (odSelected in aState)	then begin
          c.Font.Color := ColorTbl[i];
          c.Brush.Color := clWhite;
        end
        else begin
          c.Font.Color := clWhite;
          c.Brush.Color := clHighlight;
        end;
        s := t[i];
        c.TextOut(r.Left + xx,r.Top + y,s);
        xx := xx + c.TextWidth(s);
      end;
    end;
  finally
    t.Free;
  end;
end;

procedure TPanelTvList.OnListClick(Sender: TObject);
begin

end;

procedure TPanelTvList.OnListDblClick(Sender: TObject);
begin

end;

procedure TPanelTvList.OnTvAdd(Sender: TObject;
  ts: TDataTvScheduleItemsEx);
var
  f : Boolean;
  i : Integer;
  d : TDataTvScheduleItem;
  dv : TListViewVItem;
begin
  f := False;
  for i := 0 to ts.Count-1 do begin
    dv := FListViewV.Items.Add();
    d := ts[i];
    dv.Data := d;
  end;
end;

procedure TPanelTvList.OnTvClr(Sender: TObject);
begin
  FListViewV.Items.Clear;
end;

procedure TPanelTvList.OnTvDel(Sender: TObject;
  ts: TDataTvScheduleItemsEx);
var
  i,j : Integer;
  d : TDataTvScheduleItem;
begin
  for j := FListViewV.Items.Count-1 downto 0 do begin
    d := TDataTvScheduleItem(FListViewV.Items[j]);
    for i := 0 to ts.Count-1 do begin
      if d = ts[i] then begin
        FListViewV.Items.Delete(j);
        break;
      end;
    end;
  end;
end;

procedure TPanelTvList.SetDateTimeView(const Value: TDateTimeCtrl);
var
  d : TDataTvScheduleItem;
  dd : TDateTime;
  i : Integer;
begin
  FDateTimeView := Value;
  for i := 0 to FListViewV.Items.Count-1 do begin
    d := TDataTvScheduleItem(FListViewV.Items[i].Data);
    if d.Start.Compari(Value) >= 0 then begin
      FListViewV.ItemIndex := i;
      exit;
    end;
  end;


end;

end.
