unit PanelRdList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ComCtrls,ExtCtrls,ListViewV,MultiEvent,DataTvSchedule,StringListEx,
  DataConfigTvScheduleColumn,EventTvSchedule,EventRdRec,DataRd,DataRdRecReserve,
  DateTimeCtrl,DataRdRecReserveDateTime,DataRdRecReserveEncode,
  DataRdRecReserveRecPriority;

//--------------------------------------------------------------------------//
//  qc^\ꗗ\NX                                              //
//--------------------------------------------------------------------------//
type
  TPanelRdList = class(TPanel)
  private
    { Private 錾 }
    FListV : TListViewV;
    FEventRd : TEventRdRec;
    FRd: TDataRd;
    FOnPaintMouseDown: TMouseEvent;
    FOnListMouseDown: TMouseEvent;
    procedure SetRd(const Value: TDataRd);

    procedure ViewColumn();
    procedure ViewRdRec();

    procedure OnDrawItem(Canvas : TCanvas;Column,Index: Integer;
                                         Rect: TRect; State: TOwnerDrawState);

    procedure OnSelfListMouseDown(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

    procedure OnRdRecAdds(Sender: TObject;ts : TDataRdRecReserveItemsEx);
    procedure OnRdRecDels(Sender: TObject;ts : TDataRdRecReserveItemsEx);
    procedure OnRdRecClr(Sender: TObject);
    function GetItemIndex: Integer;

    procedure DoListMouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure Show();

    property ListV : TListViewV read FListV;
    property Rd : TDataRd read FRd write SetRd;
    property ItemIndex : Integer read GetItemIndex;
    property OnPaintMouseDown : TMouseEvent read FOnPaintMouseDown write FOnPaintMouseDown;
    property OnListMouseDown : TMouseEvent read FOnListMouseDown write FOnListMouseDown;
  end;

implementation

{ TPanelRdList }

constructor TPanelRdList.Create(AOwner: TComponent);
begin
  inherited;

  FListV := TListViewV.Create(Self);
  FListV.Parent := Self;
  FListV.Align := alClient;
  FListV.OnDrawItem := OnDrawItem;
  FListV.OnListMouseDown:= OnSelfListMouseDown;
  FListV.Style := lvOwnerDrawFixed;

  FEventRd := TEventRdRec.Create;
  FEventRd.OnAdds := OnRdRecAdds;
  FEventRd.OnDels := OnRdRecDels;
  FEventRd.OnClr := OnRdRecClr;
end;

destructor TPanelRdList.Destroy;
begin
  FListV.Free;
  FEventRd.Free;
  inherited;
end;

procedure TPanelRdList.SetRd(const Value: TDataRd);
begin
  FRd := Value;
  if FEventRd.Rd <> nil then exit;  // łRDւ̎Qƍς݂̏ꍇ
  FEventRd.rd := Value;             // RD̃f[^NX蓖Ă
end;

procedure TPanelRdList.Show;
begin
  FListV.Items.Clear;
  ViewColumn();
  ViewRdRec();
end;

procedure TPanelRdList.ViewColumn;
var
  dcs : TListViewVColumns;
  dc : TListViewVColumn;
begin
  dcs := FListV.Columns;
  dcs.Clear;
  dc := dcs.Add();
  dc.Caption := '';
  dc.Width := 8*2;
  dc := dcs.Add();
  dc.Caption := '';
  dc.Width := 8*4;
  dc := dcs.Add();
  dc.Caption := '^t';
  dc.Width := 8*13;
  dc := dcs.Add();
  dc.Caption := '^掞';
  dc.Width := 8*12;
  dc := dcs.Add();
  dc.Caption := 'ch';
  dc := dcs.Add();
  dc.Caption := '^Cg';
  dc.Width := 8*40;
  dc := dcs.Add();
  dc.Caption := 'Dx';
  dc.Width := 8*10;
end;

procedure TPanelRdList.ViewRdRec;
var
  i,j : Integer;
  dr : TDataRdItem;
  drr : TDataRdRecReserveItem;
  vd : TListViewVItem;
begin
  FListV.Items.Clear;
  if Rd = nil then exit;
  if FRd.Items.Count = 0 then exit;
  j := 0;
  dr := FRd.Items[j];
  for i := 0 to dr.RecReserve.Items.Count-1 do begin
    drr := dr.RecReserve.Items[i];
    vd := FListV.Items.Add();
    vd.Data := drr;
    vd.Strings.Text := '';
  end;

end;

procedure TPanelRdList.OnDrawItem(Canvas: TCanvas; Column, Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
  dr : TDataRdRecReserveItem;
  s : string;
  vd : TListViewVItem;
  dd : TDataRdRecReserveDateTimeEx;
begin
  vd := FListV.Items[Index];
  dr := TDataRdRecReserveItem(vd.Data);

  if not (odSelected	in State)	then begin
    Canvas.Font.Color := clBlack;
    Canvas.Brush.Color := clWhite;
  end
  else begin
    Canvas.Font.Color := clWhite;
    Canvas.Brush.Color := clHighlight;
  end;
  Canvas.FillRect(Rect);

  case Column of
    0 : begin
          if dr.Execution then begin
            s := 'u';
          end
          else begin
            s := '  ';
          end;
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);

        end;
    1 : begin
          //i := Ord(dr.Encoder);
          //s := TDataRdRecReserveItemEncoderStr[i];
          s := EncodeModeToStr(dr.Encoder);
          //s := 'R' + IntToStr(dr.EncodeNo+1);
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);

        end;
    2 : begin
          dd := dr.DateTime.Start;
          s := dd.StrFormat('mm""dd""(aaa)');
          //s := FormatDateTime('',dd.DateTime);
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);

        end;
    3:  begin
          dd := dr.DateTime.Start;
          s := Format('%2.2d:%2.2d-',[dd.Hou,dd.Min]);
          dd := dr.DateTime.Stop;
          s := s + Format('%2.2d:%2.2d',[dd.Hou,dd.Min]);
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
        end;
    4:  begin
          //s := ' CH'+Format('%3.3d',[FConfigData.Channels[rd.Channel].Channel]);
          //s := 'CH'+Format('%3.3d',[rd.ChannelNo]);
          s := dr.Channel;
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
        end;
    5:  begin
          s := dr.Title;
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
        end;
    6:  begin
          s := RecPriorityModeToViewStr(dr.RecPriority);
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
        end;

  end;
end;

procedure TPanelRdList.OnRdRecAdds(Sender: TObject;
  ts: TDataRdRecReserveItemsEx);
var
  i : Integer;
  drr : TDataRdRecReserveItem;
  vd : TListViewVItem;
begin
  for i := 0 to ts.Count-1 do begin
    drr := ts[i];
    vd := FListV.Items.Add();
    vd.Data := drr;
    vd.Strings.Text := '';
  end;

end;

procedure TPanelRdList.OnRdRecDels(Sender: TObject;
  ts: TDataRdRecReserveItemsEx);
var
  i : Integer;
  drr : TDataRdRecReserveItem;
  vd : TListViewVItem;
begin

  for i := FListV.Items.Count-1 downto 0 do begin
    vd := FListV.Items[i];
    drr := TDataRdRecReserveItem(vd.Data);
    if ts.IndexOf(drr) <> -1 then begin
      FListV.Items.Delete(i);
    end;
  end;

end;

procedure TPanelRdList.OnRdRecClr(Sender: TObject);
begin
  //FListV.Items.Clear;
end;

function TPanelRdList.GetItemIndex: Integer;
begin
  result := FListV.ItemIndex;
end;

procedure TPanelRdList.OnSelfListMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  DoListMouseDown(Button,Shift,X,Y);
end;

procedure TPanelRdList.DoListMouseDown(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(FOnListMouseDown) then begin
    FOnListMouseDown(Self,Button,Shift,X,Y);
  end;
end;

end.
