unit GetTvStanderd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,StringListEx,StringListKey,ExtCtrls,DefaultData,
  DateTimeCtrl,DataTvSchedule,DataTvChannel,StringKanji,DataTvStatus;

type TTvScheduleMessageLogEvent = procedure(Sender: TObject; MsgStr: string) of Object;

//--------------------------------------------------------------------------//
//  TVԑgTCg擾NX                                    //
//--------------------------------------------------------------------------//
type
  TGetTvStanderd = class(TPersistent)
  private
    { Private 錾 }
    FOwner : TObject;
    FMode: TTvChannelStatusMode;       // `Ԏʗp
    FItems: TDataTvScheduleItemsPlus;      // 擾ԑgf[^ꗗ
    FOnError: TNotifyEvent;
    FOnReceive: TNotifyEvent;
    FModeName: string;
    FOnMessageLog: TTvScheduleMessageLogEvent;
    procedure SetReadMaxDay(const Value: Integer);
  protected
    FMaxDateTime : TDateTimeCtrl;    // 擾悤ƂĂŏI
    procedure DoReceive();
    procedure DoError();
    procedure DoMessageLog(MsgStr : string);

    procedure DataToTalkCut(d : TDataTvScheduleItem;ts : TDataTvScheduleItems);
    function DataToTalkCutTitle(d : TDataTvScheduleItem;ts : TDataTvScheduleItems) : Integer;
    function DataToTalkMax(d : TDataTvScheduleItem;dt : TList) : Boolean;
    function DataToTalkCutComment(d : TDataTvScheduleItem;dt : TList) : Integer;
    function DataToTalkCutTime(d : TDataTvScheduleItem;dt : TList) : Integer;

  public
    { Public 錾 }
    constructor Create;dynamic;
    destructor Destroy;override;
    procedure ProcTimer();dynamic;
    procedure ProcStart();dynamic;
    procedure ProcStartSub();dynamic;
    function ProcNext() : Boolean;dynamic;
    procedure Init();dynamic;
    procedure Reset();dynamic;
    procedure ReadChannelSet();dynamic;

    property Owner : TObject read FOwner write FOwner;
    property Mode : TTvChannelStatusMode read FMode write FMode;
    property ModeName : string read FModeName write FModeName;
    property ReadMaxDay : Integer write SetReadMaxDay;

    function DataLoad(t : TStringListKey) : Boolean;dynamic;
    function DataSave(t : TStringListKey) : Boolean;dynamic;
    procedure AssignConfigCh(a : TDataTvChannel);dynamic;
    procedure AssignDateTime(aStart,aStop : TDateTimeCtrl);dynamic;

    property Items : TDataTvScheduleItemsPlus read FItems write FItems;

    property OnReceive : TNotifyEvent read FOnReceive write FOnReceive;
    property OnError   : TNotifyEvent read FOnError   write FOnError;
    property OnMessageLog : TTvScheduleMessageLogEvent read FOnMessageLog write FOnMessageLog;
  end;

implementation

//uses ConfigData,DataDateTime;

{ TGetTvStanderd }

constructor TGetTvStanderd.Create;
begin
  //FItems := TDataTvScheduleItems.Create;
end;

destructor TGetTvStanderd.Destroy;
begin
  //FItems.Free;
  inherited;
end;

function TGetTvStanderd.DataLoad(t: TStringListKey): Boolean;
begin
  result := False;
end;

function TGetTvStanderd.DataSave(t: TStringListKey): Boolean;
begin
  result := False;
end;

procedure TGetTvStanderd.DoError;
begin
  if Assigned(FOnError) then FOnError(Self);
end;

procedure TGetTvStanderd.DoReceive;
begin
  if Assigned(FOnReceive) then FOnReceive(Self);
end;

procedure TGetTvStanderd.Init;
begin

end;

function TGetTvStanderd.ProcNext: Boolean;
begin
  result := False;
end;

procedure TGetTvStanderd.ProcStart;
begin

end;

procedure TGetTvStanderd.ProcStartSub;
begin

end;

procedure TGetTvStanderd.ProcTimer;
begin

end;

procedure TGetTvStanderd.ReadChannelSet;
begin

end;

procedure TGetTvStanderd.Reset;
begin

end;

procedure TGetTvStanderd.DoMessageLog(MsgStr: string);
begin
  if Assigned(FOnMessageLog) then FOnMessageLog(Self,MsgStr);
end;

procedure TGetTvStanderd.SetReadMaxDay(const Value: Integer);
begin
  //FMaxDateTime.Assign(DMDateTime);
  if FMaxDateTime.Hou < ScheduleTimeTbl[0] then begin
    FMaxDateTime.DecDay;
  end;
  FMaxDateTime.IncDay(Value);
  FMaxDateTime.Hou := ScheduleTimeTbl[0];
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^ɕb܂܂Ăꍇ̕@`                  //
//                                                                          //
//   - Input -  d  : f[^                                         //
//              dt : ̃f[^                                         //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvStanderd.DataToTalkCut(d: TDataTvScheduleItem;
  ts : TDataTvScheduleItems);
begin
  DataToTalkCutTitle(d,ts);              // ^Cg画f
  DataToTalkMax(d,ts);                   // b擾
  DataToTalkCutComment(d,ts);            // Rg𕪊
  DataToTalkCutTime(d,ts);               // JnԏIԂ𕪊
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@bԑgRg𕪊@`                                    //
//                                                                          //
//   - Input -  d : 錳                                          //
//              dt : ̃f[^                                         //
//                                                                          //
//   - Output -                                                   //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvStanderd.DataToTalkCutComment(d: TDataTvScheduleItem; dt: TList): Integer;
var
  i : Integer;
  str,s,sh : string;
  d2 : TDataTvScheduleItem;
begin
  result := 0;
  if dt.Count = 1 then exit;
  str := d.Comment;
  for i := 0 to dt.Count-1 do begin
    d2 := TDataTvScheduleItem(dt[i]);
    sh := '#' + IntToStr(d2.TalkNo);
    s := StrPosSurroundLeftDelete(sh,#$0d#$0a,str);
    s := TrimZen(s);
    d2.Comment := sh + ' ' + s;
  end;

  for i := 0 to dt.Count-1 do begin
    d2 := TDataTvScheduleItem(dt[i]);
    d2.Comment := d2.Comment + #$0d#$0a + str;
  end;

  {
  t := TStringList.Create;
  try
    StrCommentToList(d.Comment,t,dt.Count,sCom,iMax);
    for i := 0 to dt.Count-1 do begin
      d2 :=dt[i];
      if i < t.Count then begin
        d2.SubTitle := TrimZen(t[i]);
        d2.TalkMax := iMax;
        d2.Comment := TrimZen(sCom);
      end;
    end;


  finally
    t.Free;
  end;
  }
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@bԑgJnԁEIԂ𕪊@`                          //
//                                                                          //
//   - Input -  d : 錳                                          //
//              dt : ̃f[^                                         //
//                                                                          //
//   - Output -                                                   //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvStanderd.DataToTalkCutTime(d: TDataTvScheduleItem;dt: TList): Integer;
var
  d2 : TDataTvScheduleItem;
  i,im : Integer;
begin
  result := dt.Count;
  if dt.Count = 0 then exit;
  im := d.TimeLength div dt.Count;
  for i := 0 to dt.Count-1 do begin
    d2 :=dt[i];
    //d2.Start.IncMin(im*i);
    d2.Stop.Assign(d2.Start);
    d2.Stop.IncMin(im);
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@bԑg^Cg𕪊@`                                    //
//                                                                          //
//   - Input -  d : 錳                                          //
//              dt : ̃f[^                                         //
//                                                                          //
//   - Output -                                                   //
//                                                                          //
//   KvȂPb̏ꍇłdtɃf[^vfPǉ   //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvStanderd.DataToTalkCutTitle(d: TDataTvScheduleItem;ts : TDataTvScheduleItems): Integer;
var
  d2 : TDataTvScheduleItem;
  str,st,sn : string;
  i : Integer;
  t : TStringList;
begin
  result := 0;
  t := TStringList.Create;
  try
    str := d.Title;
    st := '';
    sn := '';
    StrKeywordToList(str,t);
    sn := t.Text;
    if t.Count > 1 then begin
      for i := 1 to t.Count-1 do begin
        d2 := TDataTvScheduleItem.Create;
        d2.Assign(d);
        d2.TalkNo := StrZenToIntDef(t[i],0);
        if d2.TalkNo = 1 then begin                  // Pb̏ꍇ
          d2.Status[tsmTalkFirst].Value := True;     // VtOZbg
        end;
        d2.Title := TrimZen(t[0]);
        ts.Add(d2);
        d2.Start.IncMin((i-1)*30);
      end;
    end
    else begin
        d2 := TDataTvScheduleItem.Create;
        d2.Assign(d);
        ts.Add(d2);
    end;

  finally
    t.Free;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@b擾@`                                                //
//                                                                          //
//   - Input -  d : 錳                                          //
//              dt : ̃f[^                                         //
//                                                                          //
//   - Output - True : 擾o                                           //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvStanderd.DataToTalkMax(d: TDataTvScheduleItem;
  dt: TList): Boolean;
var
  f : Boolean;
  s,se,sm : string;
  i,aMax : Integer;
  d2 : TDataTvScheduleItem;
begin
  result := False;
  s := d.Comment;
  f := IsKeywordCuts(s,['^S','yS'],['bz','b'],sm,se);
  if f then begin
    //Comment := se;
    for i := 0 to dt.Count-1 do begin
      d2 := TDataTvScheduleItem(dt[i]);
      aMax  := StrZenToIntDef(sm,0);
      d2.TalkMax := aMax;
      if d2.TalkNo = aMax then begin
        d2.Status[tsmTalkLast].Value := True;
      end;
    end;
    result := True;
    //aTalkMax := StrZenToIntDef(sm,0);
  end;
end;

procedure TGetTvStanderd.AssignConfigCh(a: TDataTvChannel);
begin
end;

procedure TGetTvStanderd.AssignDateTime(aStart, aStop: TDateTimeCtrl);
begin

end;

end.
