//**************************************************************************//
//                                                                          //
//  CSfW^ԑg\擾NX                                              //
//                                                                          //
//**************************************************************************//
unit GetTvCs110;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls,CommInternet,StringListEx,
  CheckLst,DefaultData,DateTimeCtrl,DataTvSchedule,GetTvStanderd,GetTvAnalogRead,
  StringListKey,DataTvChannel,WinsockVHttpClient;

//--------------------------------------------------------------------------//
//  TVԑgTCg擾NX(CSAiOp)                      //
//--------------------------------------------------------------------------//
type
  TGetTvCs110 = class(TGetTvStanderd)
  private
    { Private 錾 }
    //FHttp : THttpGetPutV;                  // ʐMNX
    FHttpV : TWinSockHttpVClient;
    FDateTime : TDateTimeCtrl;             // 擾ԑgt
    FChannel : Integer;                    // 擾ԑg̃`lԍ
    FChannelEx : Integer;                  // 擾ԑg̃`lCfbNX
                                           // gp FConfig.Channels[FChannelEx]
    FHouStart : Integer;                   // 擾f[^1ڂ()t܂p
    FErrorCount : Integer;                 // 擾G[

    FDataSended :Boolean;                  // True:M
    FReadCh : TGetTvReadCSItems;                // Ăяoǈꗗ
    FReads : TGetTvReadCSItems;                 // Ăяoꗗ(OnTvJapanp)
    FReadIndex : Integer;
    //FGetDateTime : TDataTvDateTime;    // 擾悤ƂĂ
    FResetFlag : Boolean;                  // Reset : v邱Ƃm点

    procedure OnHttpReceive(Sender : TObject; ReceiveStr: string);
    procedure OnHttpReceiveSub();
    procedure OnHttpError(Sender : TObject;Code : Integer);
    procedure GetSub();

    function RecTvData(var str : string) : Boolean;
    {
    procedure DataToTalkCut(d : TTvScheduleDatelItem;dt : TTvScheduleDateItems);
    function DataToTalkCutTitle(d : TTvScheduleDatelItem;dt : TTvScheduleDateItems) : Integer;
    function DataToTalkMax(d : TTvScheduleDatelItem;dt : TTvScheduleDateItems) : Boolean;
    function DataToTalkCutComment(d : TTvScheduleDatelItem;dt : TTvScheduleDateItems) : Integer;
    function DataToTalkCutTime(d : TTvScheduleDatelItem;dt : TTvScheduleDateItems) : Integer;
    }

    procedure AdrPageDateTimeSet(t,aCh : TGetTvReadCSItems;aStart, aStop: TDateTimeCtrl);
    function Get(aDateTime : TDateTime;aChannel : Integer) :Boolean;
    //function StrKeywordToList(const str : string;Keys: array of string; aList : TStringList) : Boolean;
  public
    { Public 錾 }
    constructor Create;override;
    destructor Destroy;override;

    procedure ProcTimer();override;
    procedure ProcStart();override;
    procedure ProcStartSub();override;
    function ProcNext() : Boolean;override;
    procedure Init();override;
    procedure Reset();override;
    procedure ReadChannelSet();override;

    function DataLoad(t : TStringListKey) : Boolean;override;
    function DataSave(t : TStringListKey) : Boolean;override;

    procedure AssignDateTime(aStart,aStop : TDateTimeCtrl);override;

  end;

implementation

uses StringKanji,DMUnit,GetTv;

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TGetTvCs110.Create;
begin
  inherited;
  //Mode := cmCsAnalog;
  ModeName := 'XJp[! 110';
  //FGetDateTime := TDataTvDateTime.Create;
  FReadCh := TGetTvReadCSItems.Create;
  FReads := TGetTvReadCSItems.Create;
  //FMaxDateTime := TDataTvDateTime.Create;
  //FReadChannel    := TConfigChannelItems.Create;

  FHttpV := TWinSockHttpVClient.Create;
  FHttpV.PortNo := 80;
  //FHttp.AutoECUChange := True;
  FHttpV.OnReceive := OnHttpReceive;
  FHttpV.OnError   := OnHttpError;
  FDateTime := TDateTimeCtrl.Create;
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TGetTvCs110.Destroy;
begin
  FHttpV.Free;
  FDateTime.Free;
  FReads.Free;
  FReadCh.Free;
  //FReadChannel.Free;
  FMaxDateTime.Free;
  //FGetDateTime.Free;
  inherited;
end;


//**************************************************************************//
//                                                                          //
//  `@ԑgf[^擾@`                                                //
//                                                                          //
//   - Input -  aDateTime : 擾ԑg̓t                              //
//              aChannel  : 擾`l                              //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//   x̑MŎw04痂03:59܂ł̃f[^        //
//                                                                          //
//**************************************************************************//
function TGetTvCs110.Get(aDateTime: TDateTime;
  aChannel: Integer): Boolean;
var
  aDM : TDM;
begin
  aDM := TDM(TGetTvSchedule(Owner).DM);
  FErrorCount := 0;
  //Items.Clear;
  FDateTime.DateTime := aDateTime;
  FChannel  := aChannel;
  FHouStart := -1;
  FChannelEx := aDM.Config.TvChannel.IndexOfEx(aChannel);
  GetSub();
  result := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^擾̎́@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//    G[ȂǃgCɎgp                                  //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvCs110.GetSub;
var
  s : string;
  ts : TStringList;
begin

  s := ModeName+'';
  s := s + FormatDateTime('mm""dd"" hh""',FDateTime.DateTime);
  s := s + IntToStr(FChannel);
  s := s + 'Ăяo';
  DoMessageLog(s);
  {
  //s := 'Decode=S';
  s := '';
  s := s + '&' + 'list=' + IntToStr(FChannel);
  s := s + '&' + 'FROM=';
  s := s + IntToStr(FDateTime.Mon);
  s := s + '-' + IntToStr(FDateTime.Day);
  s := s + '-' + IntToStr(FDateTime.Yer);
  s := s + '&submit= \  ';
  FHttp.Post(0,'http://www.skyperfectv110.jp','prog110/ProgramSheet','','',s);
  }
  FHttpV.HostName := 'www.e2sptv.jp';
  FHttpV.UrlName := '/prog110/ProgramSheet';
  ts := FHttpV.ExtraInfo;
  ts.Clear;
  ts.Values['Decode']  := 'S';
  ts.Values['list']  := IntToStr(FChannel);
  ts.Values['FROM']  := IntToStr(FDateTime.Mon) + '-' + IntToStr(FDateTime.Day) + '-' + IntToStr(FDateTime.Yer);
  ts.Values['submit']    := ' \  ';

  FHttpV.Post();

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^MG[Cxg@`                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvCs110.OnHttpError(Sender: TObject;Code : Integer);
begin
  DoMessageLog(ModeName+'̃f[^MɎs');
  if FErrorCount < 5 then begin
    Inc(FErrorCount);
    GetSub();
  end
  else begin
    FDataSended := False;
    DoError();
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^MCxg@`                                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvCs110.OnHttpReceive(Sender: TObject;
  ReceiveStr: string);
var
  f : Boolean;
  str : string;
begin
  DoMessageLog(ModeName+'̃f[^M');


  str := StrPosSurround('<!--program sheet table starts here -->',
                        '<!--program sheet table ends here -->',
                        ReceiveStr);

  // ԑg\Ō܂Ŏ擾łĂ邩
  if str <> '' then begin
    StrPosSurroundLeftDelete('<td ','</td>',str);
    repeat
      f := RecTvData(str);
    until f = True;
    OnHttpReceiveSub();
  end;  
  FDataSended := False;
end;

procedure TGetTvCs110.OnHttpReceiveSub;
begin
  if FResetFlag then begin
    //Init();
    //FList.Clear;
    //FResetFlagCsA := False;
  end
  else begin
    DoReceive();
    ProcNext();
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@HTMLf[^f[^ɕϊ@`                                    //
//                                                                          //
//   - Input -  str : HTMLf[^                                            //
//                    ԑgf[^ƂĎgpꂽ͍폜            //
//                                                                          //
//   - Output - True : ܂f[^̑\                   //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvCs110.RecTvData(var str: string): Boolean;
var
  aHou,aMin : Integer;
  d : TDataTvScheduleItem;
  ts : TDataTvScheduleItems;
  s,st1,st2,st3 : string;
begin
  ts := TDataTvScheduleItems.Create;
  d := TDataTvScheduleItem.Create;
  try
    result := False;

    d.Start.Date := FDateTime.Date;
    d.Stop.Date  := FDateTime.Date;
    //d.Channel := FChannelEx;
    d.ChTv := DM.Config.TvChannel.Items[FChannelEx].ChannelTv;
    d.ChTvEx := DM.Config.TvChannel.Items[FChannelEx].ChannelEx;

    st1 := StrPosSurroundLeftDelete('<td ','</td>',str);
    st2 := StrPosSurroundLeftDelete('<td ','</td>',str);
    st3 := StrPosSurroundLeftDelete('<td ','</td>',str);
    if st1 = '' then begin
      result := True;
      exit;
    end;

    st1 := StrPosSurround('<span class="hours">','</span>',st1);
    st2 := StrPosSurround('<span class="basetxt">','</span>',st2);
    st3 := StrPosSurround('<span class="basetxt">','</span>',st3);

    if st1 = '' then begin
      result := False;
      exit;
    end;

    s := StrPosLeftDelete(':',st1);
    aHou := StrToIntDef(s,999);
    s := StrPosLeftDelete('-',st1);
    aMin := StrToIntDef(s,999);

    if aHou = 999 then exit;
    if aMin = 999 then exit;

    d.Start.Hou := aHou;
    d.Start.Min := aMin;

    s := StrPosLeftDelete(':',st1);
    d.Stop.Hou := StrToIntDef(s,999);
    //s := StrPosLeftDelete('<',st1);
    s := st1;
    d.Stop.Min := StrToIntDef(s,999);

    d.Title := TrimZen(st2);

    s :=StringReplace(st3,'<br>',#$d#$a,[rfreplaceall]);
    s :=StringReplace(s,'<BR>',#$d#$a,[rfreplaceall]);
    d.Comment := TrimZen(s);

    result := False;

    if d.Title = 'x~' then exit;

    if d.Start.Hou > d.Stop.Hou then begin
      d.Stop.IncDay();
    end;

    if FHouStart <> -1 then begin
      if d.Start.Hou < FHouStart then begin
        // 0܂ꍇ
        d.Start.IncDay();
        d.Stop.IncDay();
        FDateTime.IncDay();
      end;
    end;
    FHouStart := d.Start.Hou;

    // b̕
    DataToTalkCut(d,ts);

    Items.Adds(ts,0);

  finally
    d.Free;
    ts.Free;
  end;


end;
{
//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^ɕb܂܂Ăꍇ̕@`                  //
//                                                                          //
//   - Input -  d  : f[^                                         //
//              dt : ̃f[^                                         //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvCsDigital.DataToTalkCut(d: TTvScheduleDatelItem;
  dt: TTvScheduleDateItems);
begin
  DataToTalkCutTitle(d,dt);              // ^Cg画f
  DataToTalkMax(d,dt);                   // b擾
  //DataToTalkCutComment(d,dt);          // Rg𕪊
  DataToTalkCutTime(d,dt);               // JnԏIԂ𕪊
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@bԑg^Cg𕪊@`                                    //
//                                                                          //
//   - Input -  d : 錳                                          //
//              dt : ̃f[^                                         //
//                                                                          //
//   - Output -                                                   //
//                                                                          //
//   KvȂPb̏ꍇłdtɃf[^vfPǉ   //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvCsDigital.DataToTalkCutTitle(d: TTvScheduleDatelItem;dt: TTvScheduleDateItems) : Integer;
var
  d2 : TTvScheduleDatelItem;
  str,st,sn : string;
  i : Integer;
  t : TStringList;
begin
  result := 0;
  t := TStringList.Create;
  try
    str := d.Title;
    st := '';
    sn := '';
    StrKeywordToList(str,t);
    sn := t.Text;
    if t.Count > 1 then begin
      for i := 1 to t.Count-1 do begin
        d2 := dt.Add();
        d2.Assign(d);
        d2.TalkNo := StrZenToIntDef(t[i],0);
        if d2.TalkNo = 1 then begin           // Pb̏ꍇ
          d2.TalkFirst := True;               // VtOZbg
        end;
        d2.Title := TrimZen(t[0]);
        //d2.Start.IncMin((i-1)*30);
      end;
    end
    else begin
        d2 := dt.Add();
        d2.Assign(d);
    end;

  finally
    t.Free;
  end;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@bԑgRg𕪊@`                                    //
//                                                                          //
//   - Input -  d : 錳                                          //
//              dt : ̃f[^                                         //
//                                                                          //
//   - Output -                                                   //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvCsDigital.DataToTalkCutComment(d: TTvScheduleDatelItem;
  dt: TTvScheduleDateItems): Integer;
var
  d2 : TTvScheduleDatelItem;
  t : TStringList;
  sCom : string;
  i,iMax : Integer;
begin
  result := 0;
  t := TStringList.Create;
  try
    StrCommentToList(d.Comment,t,dt.Count,sCom,iMax);
    for i := 0 to dt.Count-1 do begin
      d2 :=dt[i];
      if i < t.Count then begin
        d2.SubTitle := TrimZen(t[i]);
        d2.TalkMax := iMax;
        d2.Comment := TrimZen(sCom);
      end;
    end;


  finally
    t.Free;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@b擾@`                                                //
//                                                                          //
//   - Input -  d : 錳                                          //
//              dt : ̃f[^                                         //
//                                                                          //
//   - Output - True : 擾o                                           //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvCsDigital.DataToTalkMax(d: TTvScheduleDatelItem;
  dt: TTvScheduleDateItems): Boolean;
var
  f : Boolean;
  s,se,sm : string;
  i,aMax : Integer;
begin
  result := False;
  s := d.Comment;
  f := IsKeywordCuts(s,['^S','yS'],['bz','b'],sm,se);
  if f then begin
    //Comment := se;
    for i := 0 to dt.Count-1 do begin
      aMax  := StrZenToIntDef(sm,0);
      dt[i].TalkMax := aMax;
      if dt[i].TalkNo = aMax then begin
        dt[i].TalkLast := True;
      end;
    end;
    result := True;
    //aTalkMax := StrZenToIntDef(sm,0);
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@bԑgJnԁEIԂ𕪊@`                          //
//                                                                          //
//   - Input -  d : 錳                                          //
//              dt : ̃f[^                                         //
//                                                                          //
//   - Output -                                                   //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvCsDigital.DataToTalkCutTime(d: TTvScheduleDatelItem;
  dt: TTvScheduleDateItems): Integer;
var
  d2 : TTvScheduleDatelItem;
  i,im : Integer;
begin
  result := dt.Count;
  if dt.Count = 0 then exit;
  im := d.TimeLength div dt.Count;
  for i := 0 to dt.Count-1 do begin
    d2 :=dt[i];
    d2.Start.IncMin(im*i);
    d2.Stop.Assign(d2.Start);
    d2.Stop.IncMin(im);
  end;
end;
}
function TGetTvCs110.DataLoad(t: TStringListKey): Boolean;
var
  t2 : TStringListEx;
begin
  t2 := t.Values['TvCs110'];
  if t2 <> nil then begin
    FReads.DataLoad(t2);
  end;
  result := True;
end;

function TGetTvCs110.DataSave(t: TStringListKey): Boolean;
var
  t2 : TStringListEx;
begin
  t2 := TStringListEx.Create;
  try
    FReads.DataSave(t2);
    t.Add('TvCs110',t2);
  finally
    t2.Free;
  end;

  //t.SetDateTimes('GetDateTimeTvGuide',FGetDateTime.DateTime);
  result := True;
end;

//**************************************************************************//
//                                                                          //
//  `@MvɎgpl@`                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvCs110.Init;
var
  d1,d2 : TDateTimeCtrl;
  Max : Integer;
begin
  Max := DM.Config.Normal.ReadDay;
  FReadIndex := 0;                                         // ǂݍݏ̈ʒu擪
  d1 := TDateTimeCtrl.Create;
  d2 := TDateTimeCtrl.Create;
  try
    d1.DateTime := Now;
    d2.Assign(d1);
    d2.IncDay(Max);
    AssignDateTime(d1,d2);

  finally
    d2.Free;
    d1.Free;
  end;

  //FChannelIndex := 0;
  //FGetDateTime.Init();
  {
  FMaxDateTime.Assign(FGetDateTimeCsA);
  FMaxDateTime.Hou := 0;
  FMaxDateTime.Min := 0;
  FMaxDateTime.IncDay();
  FMaxDateTime.IncDay();
  FMaxDateTime.IncDay();
  }
end;

//**************************************************************************//
//                                                                          //
//  `@̃f[^̑Mv@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TGetTvCs110.ProcNext: Boolean;
begin
  if FReadIndex <= FReads.Count-1 then begin
    FReads[FReadIndex].Readed := True;
    Inc(FReadIndex);
  end;
  result := True;
  {
  result := False;
  Inc(FChannelIndex);
  if FChannelIndex >= FReadChannel.Count then begin    // S`lǂݏI
    FChannelIndex := 0;                                // `l͍ŏ
    FGetDateTime.IncDay();                             // ̓t
    result := True;
  end;
  }
end;

procedure TGetTvCs110.ProcStart;
begin
  inherited;

end;

//**************************************************************************//
//                                                                          //
//  `@ԑgf[^vM@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvCs110.ProcStartSub;
var
  aChannel : Integer;
  d : TGetTvReadItemCS;
  //aChannel : Integer;
begin
  if FReadIndex < FReads.Count then begin   // ǂݍݏꗗ̍Ō܂ŗĂȂꍇ
    d := FReads[FReadIndex];                // ǂݍގwf[^Q
    aChannel := d.Channel;
    Get(d.DateTime.DateTime,aChannel);             // vM
    FDataSended := True;                                   // MtOZbg
  end;
  {
  // ŏI\tOf
  if FMaxDateTime.DataToDateTime > FGetDateTime.DataToDateTime then begin
    if FReadChannel.Count > 0 then begin
      aChannel := FReadChannel[FChannelIndex].ChannelEx;
      Get(FGetDateTime.DataToDateTime,aChannel);                // vM
      FDataSended := True;                                      // MtOZbg
    end;
  end;
  }
end;

//**************************************************************************//
//                                                                          //
//  `@^C}[荞݂ōs@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvCs110.ProcTimer;
var
  aDM : TDM;
begin
  aDM := TDM(TGetTvSchedule(Owner).DM);
  if aDM.TvSchedule.ReadBusy then exit;          // t@Cǂݍݒ͖

  if not FDataSended then begin  // CSMł͂Ȃꍇ
    if FResetFlag then begin     // Zbgvꍇ
      FResetFlag := False;       // f[^
      FDataSended := False;      // ԑgf[^ꗗNA
    end                             // ZbgvtOZbg
    else begin                      // ZbgvȂꍇ
      ProcStartSub();               // M
    end;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@ǂݍޔԑgꗗ쐬@`                                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvCs110.ReadChannelSet;
var
  i : Integer;
  d : TDataTvChannelItem;
  d2 : TGetTvReadItemCS;
  aDM : TDM;
begin
  aDM := TDM(TGetTvSchedule(Owner).DM);
  FReadCh.Clear;                                             // ǂݍ݃y[W
  for i := 0 to aDM.Config.TvChannel.Items.Count-1 do begin
    d := aDM.Config.TvChannel.Items[i];
    if not d.UseCsDigital then continue;                        // CSgȂȂ疢
    if not d.Visible then continue;                           // \`lȂ疢
    if not FReadCh.ChkAdrPage(d) then continue;               // łɓǂݍchXgɂȂ疢
    d2 := FReadCh.Add();
    d2.AssignCh(d);
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@ԑgf[^Ď擾@`                                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvCs110.Reset;
begin
  FResetFlag := True;
end;

procedure TGetTvCs110.AssignDateTime(aStart, aStop: TDateTimeCtrl);
  function CheckHou(d : TDateTimeCtrl) : Boolean;
  var
    i : Integer;
  begin
    result := False;
    for i := 0 to High(ScheduleTimeTbl) do begin
      if d.Hou = ScheduleTimeTbl[i] then begin
        result := True;
        break;
      end;
    end;

  end;
var
  aNew,aOld : TGetTvReadCSItems;
begin
  aNew := TGetTvReadCSItems.Create;
  aOld := TGetTvReadCSItems.Create;
  try
    AdrPageDateTimeSet(aNew,FReadCh,aStart,aStop);  // ǂݍރy[WAԑуXg쐬
    FReads.ListMake(aNew);                          // ȑȌԂƕύX̏ԂǂݍޕKv̗L𐶐
    //AdrPageDateTimeEqChk(FReads,aNew,aOld);         // ȑȌԂƕύX̏ԂǂݍޕKv̗L𐶐
  finally
    aOld.Free;
    aNew.Free;
  end;
end;

procedure TGetTvCs110.AdrPageDateTimeSet(t, aCh: TGetTvReadCSItems;
  aStart, aStop: TDateTimeCtrl);
var
  d : TDateTimeCtrl;
  dd : TGetTvReadItemCS;
  i : Integer;
begin
  d := TDateTimeCtrl.Create;
  try
    d.Assign(aStart);                               // ԑg\4n܂̂
    if d.Hou < 4 then begin                         // JnSȑȌꍇ
      d.DecDay();                                   // Oǂݍނ悤
    end;
    while d.DateTime < aStop.DateTime do begin
      for i := 0 to FReadCh.Count-1 do begin
        dd := t.Add();
        dd.Assign(FReadCh[i]);
        dd.DateTime.Assign(d);
      end;

      d.IncDay();                                  // Ԃi߂
    end;
    FReadIndex := 0;
  finally
    d.Free;
  end;
end;

end.
