//**************************************************************************//
//                                                                          //
//  CSAiOԑg\擾NX                                              //
//                                                                          //
//**************************************************************************//
unit GetTvCs;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls,CommInternet,StringListEx,StringListKey,
  CheckLst,DefaultData,DateTimeCtrl,GetTvStanderd,DataTvStatus,GetTvAnalogRead,
  DataTvSchedule,DataTvChannel,WinsockVHttpClient;

//--------------------------------------------------------------------------//
//  TVԑgTCg擾NX(CSAiOp)                      //
//--------------------------------------------------------------------------//
type
  TGetTvCs = class(TGetTvStanderd)
  private
    { Private 錾 }
    //FHttp : THttpGetPutV;                  // ʐMNX
    FHttpV : TWinSockHttpVClient;
    FDateTime : TDateTimeCtrl;             // 擾ԑgt
    FChannel : Integer;                    // 擾ԑg̃`lԍ
    FChannelEx : Integer;                  // 擾ԑg̃`lCfbNX
                                           // gp FConfig.Channels[FChannelEx]
    FHouStart : Integer;                   // 擾f[^1ڂ()t܂p
    FErrorCount : Integer;                 // 擾G[

    FDataSendedCsA :Boolean;               // True:M
    FReadCh : TGetTvReadCSItems;                // Ăяoǈꗗ
    FReads : TGetTvReadCSItems;                 // Ăяoꗗ(OnTvJapanp)
    FReadIndex : Integer;
    //FGetDateTimeCsA : TDataTvDateTime; // 擾悤ƂĂ
    //FChannelIndexCsA : Integer;            // 擾悤ƂĂ`lCfbNX
    FResetFlagCsA : Boolean;               // Reset : v邱Ƃm点

    procedure OnHttpReceive(Sender : TObject; ReceiveStr: string);
    procedure OnHttpReceiveSub();
    procedure OnHttpError(Sender : TObject;Code : Integer);
    procedure GetSub();

    function RecTvData(var str : string) : Boolean;

    procedure RecTvDataNoMoney(d : TDataTvScheduleItem);

    procedure AdrPageDateTimeSet(t,aCh : TGetTvReadCSItems;aStart, aStop: TDateTimeCtrl);

    function Get(aDateTime : TDateTime;aChannel : Integer) :Boolean;
    //function StrKeywordToList(const str : string;Keys: array of string; aList : TStringList) : Boolean;
  public
    { Public 錾 }
    constructor Create;override;
    destructor Destroy;override;

    procedure ProcTimer();override;
    procedure ProcStart();override;
    procedure ProcStartSub();override;
    function ProcNext() : Boolean;override;
    procedure Init();override;
    procedure Reset();override;
    procedure ReadChannelSet();override;

    function DataLoad(t : TStringListKey) : Boolean;override;
    function DataSave(t : TStringListKey) : Boolean;override;

    procedure AssignDateTime(aStart,aStop : TDateTimeCtrl);override;

  end;

implementation

uses StringKanji,DMUnit,GetTv;

{ TGetTvCsAnalog }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TGetTvCs.Create;
begin
  inherited;
  //Mode := cmCsAnalog;
  ModeName := 'XJp[';
  FReadCh := TGetTvReadCSItems.Create;
  FReads := TGetTvReadCSItems.Create;
  {
  FGetDateTimeCsA := TDataTvDateTime.Create;
  FMaxDateTime := TDataTvDateTime.Create;
  FReadChannelCsA := TConfigChannelItems.Create;
  }
  FHttpV := TWinSockHttpVClient.Create;
  FHttpV.AutoEucChange := True;
  FHttpV.PortNo := 80;
  FHttpV.OnReceive := OnHttpReceive;
  FHttpV.OnError   := OnHttpError;
  FDateTime := TDateTimeCtrl.Create;
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TGetTvCs.Destroy;
begin
  FHttpV.Free;
  FDateTime.Free;
  {
  FReadChannelCsA.Free;
  FMaxDateTime.Free;
  FGetDateTimeCsA.Free;
  }
  FReads.Free;
  FReadCh.Free;
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@ԑgf[^擾@`                                                //
//                                                                          //
//   - Input -  aDateTime : 擾ԑg̓t                              //
//              aChannel  : 擾`l                              //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//   x̑MŎw04痂03:59܂ł̃f[^        //
//                                                                          //
//**************************************************************************//
function TGetTvCs.Get(aDateTime: TDateTime;
  aChannel: Integer): Boolean;
var
  aDM : TDM;
begin
  aDM := TDM(TGetTvSchedule(Owner).DM);

  FErrorCount := 0;
  //Items.Clear;
  FDateTime.DateTime := aDateTime;
  FChannel  := aChannel;
  FHouStart := -1;
  FChannelEx := aDM.Config.TvChannel.IndexOfEx(aChannel);
  GetSub();
  result := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^擾̎́@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//    G[ȂǃgCɎgp                                  //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvCs.GetSub;
var
  s : string;
  ts : TStringList;
begin

  s := ModeName+'';
  s := s + FormatDateTime('mm""dd"" hh""',FDateTime.DateTime);
  s := s + IntToStr(FChannel);
  s := s + 'Ăяo';
  DoMessageLog(s);
  
  FHttpV.HostName := 'www.skyperfectv.co.jp';
  //FHttpV.HostName := 'search.skyperfectv.co.jp';
  FHttpV.UrlName := '/prog/ProgramSheet';
  ts := FHttpV.ExtraInfo;
  ts.Clear;
  ts.Values['list']  := IntToStr(FChannel);
  ts.Values['FROM']  := IntToStr(FDateTime.Mon) + '-' + IntToStr(FDateTime.Day) + '-' + IntToStr(FDateTime.Yer);
  ts.Values['x']    := '87';
  ts.Values['y']    := '14';

  FHttpV.Get();

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^MG[Cxg@`                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvCs.OnHttpError(Sender: TObject;Code : Integer);
begin
  DoMessageLog(ModeName+'̃f[^MɎs');
  if FErrorCount < 5 then begin
    Inc(FErrorCount);
    GetSub();
  end
  else begin
    FDataSendedCsA := False;
    DoError();
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^MCxg@`                                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvCs.OnHttpReceive(Sender: TObject;
  ReceiveStr: string);
var
  f : Boolean;
  str : string;
begin
  DoMessageLog(ModeName+'̃f[^M');
  //str := ECUtoSJisString(ReceiveStr);
  str := ReceiveStr;
  // ԑg\Ō܂Ŏ擾łĂ邩
  if Pos('z[y[W',str) <> 0 then begin
    repeat
      f := RecTvData(str);
    until f = True;
    OnHttpReceiveSub();
  end;  
  FDataSendedCsA := False;
end;

procedure TGetTvCs.OnHttpReceiveSub;
begin
  if FResetFlagCsA then begin
    //Init();
    //FList.Clear;
    //FResetFlagCsA := False;
  end
  else begin
    DoReceive();
    ProcNext();
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@HTMLf[^f[^ɕϊ@`                                    //
//                                                                          //
//   - Input -  str : HTMLf[^                                            //
//                    ԑgf[^ƂĎgpꂽ͍폜            //
//                                                                          //
//   - Output - True : ܂f[^̑\                   //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvCs.RecTvData(var str: string): Boolean;
var
  aHou,aMin : Integer;
  d : TDataTvScheduleItem;
  ts : TDataTvScheduleItems;
  dc : TDataTvChannelItem;
  s : string;
  aDM : TDM;
begin
  ts := TDataTvScheduleItems.Create;
  d := TDataTvScheduleItem.Create;
  aDM := TDM(TGetTvSchedule(Owner).DM);
  try
    result := True;

    d.Start.Date := FDateTime.Date;
    d.Stop.Date  := FDateTime.Date;
    //d.Channel := FChannelEx;

    dc := aDM.Config.TvChannel.GetChannelEx(FChannel,cmCsAnalog);
    d.ChTv := dc.ChannelTv;
    d.ChTvEx := dc.ChannelEx;
    //dc := DMConfig.Channels.GetChannelEx(FChannel,cmCsAnalog);
    if dc <> nil then begin
      d.GenreName := dc.GenreName;
    end;

    StrPosToLeftDelete('<td align="left"><span class',str);

    s := StrPosSurround('>',':',str);
    aHou := StrToIntDef(s,999);
    s := StrPosSurround(':','-',str);
    aMin := StrToIntDef(s,999);

    if aHou = 999 then exit;
    if aMin = 999 then exit;

    d.Start.Hou := aHou;
    d.Start.Min := aMin;

    s := StrPosSurround('-',':',str);
    d.Stop.Hou := StrToIntDef(s,999);

    StrPosToLeftDelete('-',str);

    s := StrPosSurround(':','<',str);
    d.Stop.Min := StrToIntDef(s,999);

    StrPosToLeftDelete('<div align="left"><span class=',str);
    d.Title := StrPosSurround('>','</span>',str);

    StrPosToLeftDelete('<td align="left"><span class',str);
    s := StrPosSurround('>','</span>',str);

    s :=StringReplace(s,'<br>',#$d#$a,[rfreplaceall]);
    d.Comment := Trim(s);

    result := False;

    if d.Title = 'x~' then exit;   // ux~v͔ԑgƂĔFȂ
    RecTvDataNoMoney(d);             //  ̔菈

    if d.Start.Hou > d.Stop.Hou then begin
      d.Stop.IncDay();
    end;

    if FHouStart <> -1 then begin
      if d.Start.Hou < FHouStart then begin
        // 0܂ꍇ
        d.Start.IncDay();
        d.Stop.IncDay();
        FDateTime.IncDay();
      end;
    end;
    FHouStart := d.Start.Hou;

    // b̕
    DataToTalkCut(d,ts);

    //dd := TDataTvScheduleItem.Create;
    //dd.Assign(d);
    //Items.Adds(dd);

    Items.Adds(ts,0);

    {
    for i := 0 to dt.Count-1 do begin
      dd := TDataTvScheduleItem.Create;
      dd.Assign(dt[i]);
      Items.Adds(dd);
    end;
    }
    //Items.AddsFinish();

    //Items.Assign(dt);

  finally
    {
    for i := 0 to dt.Count-1 do begin
      TDataTvScheduleItem(dt[i]).Free;
    end;
    }

    d.Free;
    ts.Free;
  end;


end;


function TGetTvCs.DataLoad(t: TStringListKey): Boolean;
var
  t2 : TStringListEx;
begin
  t2 := t.Values['TvCsA'];
  if t2 <> nil then begin
    FReads.DataLoad(t2);
  end;
  result := True;
end;

function TGetTvCs.DataSave(t: TStringListKey): Boolean;
var
  t2 : TStringListEx;
begin
  t2 := TStringListEx.Create;
  try
    FReads.DataSave(t2);
    t.Add('TvCsA',t2);
  finally
    t2.Free;
  end;

  //t.SetDateTimes('GetDateTimeTvGuide',FGetDateTime.DateTime);
  result := True;
end;

//**************************************************************************//
//                                                                          //
//  `@MvɎgpl@`                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvCs.Init;
var
  d1,d2 : TDateTimeCtrl;
  Max : Integer;
begin
  Max := DM.Config.Normal.ReadDay;
  FReadIndex := 0;                                         // ǂݍݏ̈ʒu擪
  d1 := TDateTimeCtrl.Create;
  d2 := TDateTimeCtrl.Create;
  try
    d1.DateTime := Now;
    d2.Assign(d1);
    d2.IncDay(Max);
    AssignDateTime(d1,d2);

  finally
    d2.Free;
    d1.Free;
  end;



  //FChannelIndexCsA := 0;
  //FGetDateTimeCsA.Init();
  {
  FMaxDateTime.Assign(FGetDateTimeCsA);
  FMaxDateTime.Hou := 0;
  FMaxDateTime.Min := 0;
  FMaxDateTime.IncDay();
  FMaxDateTime.IncDay();
  FMaxDateTime.IncDay();
  }
end;

//**************************************************************************//
//                                                                          //
//  `@̃f[^̑Mv@`                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TGetTvCs.ProcNext: Boolean;
begin
  if FReadIndex <= FReads.Count-1 then begin
    FReads[FReadIndex].Readed := True;
    Inc(FReadIndex);
  end;
  result := True;
  {
  result := False;
  Inc(FChannelIndexCsA);
  if FChannelIndexCsA >= FReadChannelCsA.Count then begin // S`lǂݏI
    FChannelIndexCsA := 0;                                // `l͍ŏ
    FGetDateTimeCsA.IncDay();                             // ̓t
    result := True;
  end;
  }
end;

procedure TGetTvCs.ProcStart;
begin
  inherited;

end;

//**************************************************************************//
//                                                                          //
//  `@ԑgf[^vM@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvCs.ProcStartSub;
var
  aChannel : Integer;
  d : TGetTvReadItemCS;
begin
  if FReadIndex < FReads.Count then begin   // ǂݍݏꗗ̍Ō܂ŗĂȂꍇ
    d := FReads[FReadIndex];                // ǂݍގwf[^Q
    aChannel := d.Channel;
    Get(d.DateTime.DateTime,aChannel);             // vM
    FDataSendedCsA := True;                                   // MtOZbg
  end;
  {
  if FReadIndex < FReads.Count then begin   // ǂݍݏꗗ̍Ō܂ŗĂȂꍇ
    d := FReads[FReadIndex];                // ǂݍގwf[^Q
    aAdr  := d.Adr;
    aPage := d.Page;
    if not d.Readed then begin              // ܂ǂݍłȂwf[^̏ꍇ
      Get(d.DateTime,aAdr,aPage);
      FDataSended := True;                  // Mł邱Ƃm点
    end
    else begin
      ProcNext();
    end;
  end;
  Get(d.,aChannel);             // vM
      FDataSendedCsA := True;                                   // MtOZbg
      }
  {
  // ŏI\tOf
  if FMaxDateTime.DataToDateTime > FGetDateTimeCsA.DataToDateTime then begin
    if FReadChannelCsA.Count > 0 then begin
      aChannel := FReadChannelCsA[FChannelIndexCsA].ChannelEx;
      Get(FGetDateTimeCsA.DataToDateTime,aChannel);             // vM
      FDataSendedCsA := True;                                   // MtOZbg
    end;
  end;
  }
end;

//**************************************************************************//
//                                                                          //
//  `@^C}[荞݂ōs@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvCs.ProcTimer;
var
  aDM : TDM;
begin
  aDM := TDM(TGetTvSchedule(Owner).DM);
  if aDM.TvSchedule.ReadBusy then exit;          // t@Cǂݍݒ͖

  if not FDataSendedCsA then begin  // CSMł͂Ȃꍇ
    if FResetFlagCsA then begin     // Zbgvꍇ
      FResetFlagCsA := False;       // f[^
      FDataSendedCsA := False;      // ԑgf[^ꗗNA
    end                             // ZbgvtOZbg
    else begin                      // ZbgvȂꍇ
      ProcStartSub();               // M
    end;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@ǂݍޔԑgꗗ쐬@`                                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvCs.ReadChannelSet;
var
  i : Integer;
  d : TDataTvChannelItem;
  d2 : TGetTvReadItemCS;
  aDM : TDM;
begin
  aDM := TDM(TGetTvSchedule(Owner).DM);
  FReadCh.Clear;                                             // ǂݍ݃y[W
  for i := 0 to aDM.Config.TvChannel.Items.Count-1 do begin
    d := aDM.Config.TvChannel.Items[i];
    if not d.UseCsAnalog then continue;                        // CSgȂȂ疢
    if not d.Visible then continue;                           // \`lȂ疢
    if not FReadCh.ChkAdrPage(d) then continue;               // łɓǂݍchXgɂȂ疢
    d2 := FReadCh.Add();
    d2.AssignCh(d);
  end;

{
  FReadChannelCsA.Clear;
  for i := 0 to DMConfig.Channels.Count-1 do begin
    d := DMConfig.Channels[i];
    if d.UseCsAnalog then begin
      if d.Visible then begin
        d2 := FReadChannelCsA.Add();
        d2.Assign(d);
      end;
    end;

  end;
  }
end;

//**************************************************************************//
//                                                                          //
//  `@ԑgf[^Ď擾@`                                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvCs.Reset;
begin
  FResetFlagCsA := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@𔻒@`                                                  //
//                                                                          //
//   - Input -  d : ԑgf[^                                              //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvCs.RecTvDataNoMoney(d: TDataTvScheduleItem);
var
  s : string;
begin
  s := d.Title;
  StrPosLeftDelete('',s);
  if s <> d.Title then begin
    d.Title := s;
    d.Status[tsmTalkNoMoney].Value := True;;
  end;
end;

procedure TGetTvCs.AssignDateTime(aStart, aStop: TDateTimeCtrl);
  function CheckHou(d : TDateTimeCtrl) : Boolean;
  var
    i : Integer;
  begin
    result := False;
    for i := 0 to High(ScheduleTimeTbl) do begin
      if d.Hou = ScheduleTimeTbl[i] then begin
        result := True;
        break;
      end;
    end;

  end;
var
  aNew,aOld : TGetTvReadCSItems;
begin
  aNew := TGetTvReadCSItems.Create;
  aOld := TGetTvReadCSItems.Create;
  try
    AdrPageDateTimeSet(aNew,FReadCh,aStart,aStop);  // ǂݍރy[WAԑуXg쐬
    FReads.ListMake(aNew);                          // ȑȌԂƕύX̏ԂǂݍޕKv̗L𐶐
    //AdrPageDateTimeEqChk(FReads,aNew,aOld);         // ȑȌԂƕύX̏ԂǂݍޕKv̗L𐶐
  finally
    aOld.Free;
    aNew.Free;
  end;
end;

procedure TGetTvCs.AdrPageDateTimeSet(t, aCh: TGetTvReadCSItems;
  aStart, aStop: TDateTimeCtrl);
var
  d : TDateTimeCtrl;
  dd : TGetTvReadItemCS;
  i : Integer;
begin
  d := TDateTimeCtrl.Create;
  try
    d.Assign(aStart);                               // ԑg\4n܂̂
    if d.Hou < 4 then begin                         // JnSȑȌꍇ
      d.DecDay();                                   // Oǂݍނ悤
    end;
    while d.DateTime < aStop.DateTime do begin
      for i := 0 to FReadCh.Count-1 do begin
        dd := t.Add();
        dd.Assign(FReadCh[i]);
        dd.DateTime.Assign(d);
      end;

      d.IncDay();                                  // Ԃi߂
    end;
    FReadIndex := 0;
  finally
    d.Free;
  end;
end;

end.
