unit GetTvChOnTvJapanUv;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls,CommInternet,StringListEx,
  DataTvChannel,WinsockVHttpClient;

//--------------------------------------------------------------------------//
//  nꗗ擾NX                                                      //
//--------------------------------------------------------------------------//
type
  TGetTvChOnTvJapanUv = class(TPersistent)
  private
    { Private 錾 }
    //FHttp : THttpGetPutV;
    FHttpV : TWinSockHttpVClient;
    FItems: TDataTvChannelItems;
    FAdr : string;
    FPage : Integer;
    FErrCnt : Integer;
    FOnError: TNotifyEvent;
    FOnReceive: TNotifyEvent;
    procedure GetSub();
    procedure ProcRecErr();

    function HtmlStrToChannelItems(str : string) : Boolean;

    procedure OnHttpReceive(Sender : TObject; ReceiveStr: string);
    procedure OnHttpError(Sender : TObject;Code : Integer);

    procedure DoReceive();
    procedure DoError();
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Get(const Adr : string);
    property Items : TDataTvChannelItems read FItems;
    property OnReceive : TNotifyEvent read FOnReceive write FOnReceive;
    property OnError   : TNotifyEvent read FOnError   write FOnError;
  end;

implementation

{ TGetChannel }

constructor TGetTvChOnTvJapanUv.Create;
begin
  FHttpV := TWinSockHttpVClient.Create;
  FHttpV.AutoEucChange := True;
  FHttpV.OnReceive := OnHttpReceive;
  FHttpV.OnError := OnHttpError;
  FHttpV.PortNo := 80;
  FItems := TDataTvChannelItems.Create;
end;

destructor TGetTvChOnTvJapanUv.Destroy;
begin
  FItems.Free;
  FHttpV.Free;
  inherited;
end;

procedure TGetTvChOnTvJapanUv.DoError;
begin
  if Assigned(FOnError) then begin
    FOnError(Self);
  end;
end;

procedure TGetTvChOnTvJapanUv.DoReceive;
begin
  if Assigned(FOnReceive) then begin
    FOnReceive(Self);
  end;
end;

procedure TGetTvChOnTvJapanUv.Get(const Adr : string);
begin
  FErrCnt := 0;
  FAdr := Adr;
  FPage := 1;
  GetSub();
end;

procedure TGetTvChOnTvJapanUv.GetSub();
var
  d : TDateTime;
  ts : TStringList;
begin

  d := Now;

  ts := FHttpV.ExtraInfo;
  ts.Clear;
  FHttpV.HostName := 'www.ontvjapan.com';
  FHttpV.UrlName := '/program/gridNormal.php';
  ts.Values['frame']  := 'off';
  ts.Values['tikicd'] := FAdr;
  ts.Values['way']    := 'v';
  ts.Values['page']   := IntToStr(FPage);
  ts.Values['genre']  := 'all';
  ts.Values['hour_select'] := '6';
  ts.Values['s_hiduke'] := FormatDateTime('yyyymmdd',d);
  ts.Values['s_jikan'] := FormatDateTime('hhmm',d);
  FHttpV.Get();

  //FHttpV.Get(0,url,ss,'','',info);
end;

function TGetTvChOnTvJapanUv.HtmlStrToChannelItems(str: string): Boolean;
var
  s,s2,s3 : string;
  d : TDataTvChannelItem;
begin
  FItems.Clear;
  s := StrPosSurround('<SELECT name="quick_sel"','</SELECT>',str);
  result := False;
  if s = '' then begin
    exit;
  end;
  repeat
    s2 := StrPosSurroundLeftDelete('<OPTION ','->',s);
    if s2 = '' then break;
    d := FItems.Add();
    s3 := StrPosSurround('&page=','&',s2);
    if s3 = '' then s3 := '1';
    d.PageNo := StrToIntDef(s3,1)-1;
    s3 := StrPosSurround('&tikicd=','&',s2);
    d.AdrNo := s3;
    s3 := StrPosSurround(' >','<',s2);
    d.Name := s3;
    d.UseTvGuide := True;
    s3 := StrPosSurround('#','"',s2);
    d.ChannelTv := StrToIntDef(s3,0);
    d.ChannelEx := -1;
    d.Mode := cmNormal;
    d.GenreName := 'ngEBSECS';

  until s = '';
  result := True;
end;


procedure TGetTvChOnTvJapanUv.OnHttpError(Sender: TObject;Code : Integer);
begin
  ProcRecErr();
end;

procedure TGetTvChOnTvJapanUv.OnHttpReceive(Sender: TObject; ReceiveStr: string);
var
  f : Boolean;
begin
  f := HtmlStrToChannelItems(ReceiveStr);
  if f then begin
    DoReceive();
  end
  else begin
    ProcRecErr();
  end;
end;

procedure TGetTvChOnTvJapanUv.ProcRecErr;
begin
  if FErrCnt < 3 then begin
    DoError();
  end
  else begin
    Inc(FErrCnt);
    GetSub();
  end;
end;

end.
