unit GetTvChOnTvJapanEx;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls,CommInternet,StringListEx,
  DataTvChannel,WinsockVHttpClient;

//--------------------------------------------------------------------------//
//  nꗗ擾NX                                                      //
//--------------------------------------------------------------------------//
type
  TGetTvOnTvJapanEx = class(TPersistent)
  private
    { Private 錾 }
    //FHttp : THttpGetPutV;
    FHttpV : TWinSockHttpVClient;
    FItems: TDataTvChannelItems;
    FAdr : string;
    FPage : Integer;
    FErrCnt : Integer;
    FOnError: TNotifyEvent;
    FOnReceive: TNotifyEvent;
    FOnProcess: TNotifyEvent;
    FMode: TTvChannelStatusMode;
    procedure GetSub();
    procedure ProcRecErr();

    function HtmlStrToChannelItems(str : string) : Boolean;
    procedure ProcNext();

    procedure OnHttpReceive(Sender : TObject; ReceiveStr: string);
    procedure OnHttpError(Sender : TObject;Code : Integer);

    procedure DoReceive();
    procedure DoError();
    procedure DoProcess();
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Get(Mode : TTvChannelStatusMode);
    procedure GetCATV(BCode : string);
    property Items : TDataTvChannelItems read FItems;

    property Page : Integer read FPage;

    property OnReceive : TNotifyEvent read FOnReceive write FOnReceive;
    property OnError   : TNotifyEvent read FOnError   write FOnError;
    property OnProcess : TNotifyEvent read FOnProcess write FOnProcess;
  end;

implementation

{ TGetTvOnTvJapanEx }

constructor TGetTvOnTvJapanEx.Create;
begin
  FHttpV := TWinSockHttpVClient.Create;
  FHttpV.AutoEucChange := True;
  FHttpV.OnReceive := OnHttpReceive;
  FHttpV.OnError := OnHttpError;
  FHttpV.PortNo := 80;
  FItems := TDataTvChannelItems.Create;
end;

destructor TGetTvOnTvJapanEx.Destroy;
begin
  FItems.Free;
  FHttpV.Free;
  inherited;
end;

procedure TGetTvOnTvJapanEx.DoError;
begin
  if Assigned(FOnError) then begin
    FOnError(Self);
  end;
end;

procedure TGetTvOnTvJapanEx.DoProcess;
begin
  if Assigned(FOnProcess) then begin
    FOnProcess(Self);
  end;
end;

procedure TGetTvOnTvJapanEx.DoReceive;
begin
  if Assigned(FOnReceive) then begin
    FOnReceive(Self);
  end;
end;

procedure TGetTvOnTvJapanEx.Get(Mode : TTvChannelStatusMode);
begin
  case Mode of
    cmBsDigital : FAdr := '3001';
    cmCsAnalog  : FAdr := '1000';
    cmCsDigital : FAdr := '3003';
  end;
  FMode := Mode;
  FErrCnt := 0;
  FPage := 0;
  GetSub();
end;

procedure TGetTvOnTvJapanEx.GetCATV(BCode: string);
begin
  FAdr := BCode;
  FMode := cmCATV;
  FErrCnt := 0;
  FPage := 0;
  GetSub();
end;

procedure TGetTvOnTvJapanEx.GetSub;
var
  d : TDateTime;
  ts : TStringList;
begin
  d := Now;

  FHttpV.HostName := 'www.ontvjapan.com';
  FHttpV.UrlName := '/program/gridNormal.php';
  ts := FHttpV.ExtraInfo;
  ts.Clear;
  ts.Values['frame']  := 'off';
  ts.Values['tikicd'] := FAdr;
  ts.Values['way']    := 'v';
  ts.Values['page']   := IntToStr(FPage+1);
  ts.Values['genre']  := 'all';
  ts.Values['hour_select'] := '6';
  ts.Values['s_hiduke'] := FormatDateTime('yyyymmdd',d);
  ts.Values['s_jikan'] := FormatDateTime('hhmm',d);
  FHttpV.Get();

end;

function TGetTvOnTvJapanEx.HtmlStrToChannelItems(str: string): Boolean;
var
  s,sc,sn,se : string;
  d : TDataTvChannelItem;
begin
  result := False;
  str := StrPosSurround('<!--####################ԑg\/####################-->',
                        ' vAlign=top ',str);
  s := StrPosSurroundLeftDelete('<TD class=time align','</TD>',str);

  if s = '' then exit;
  repeat
    s := StrPosSurroundLeftDelete('<TD class=time align','</TD>',str);
    // XJp[ƂẴ`lԍ
    se := StrPosSurround('FFFFFF;">','ch<',s);
    // OnTvJapanł
    sc := StrPosSurround('&ch=','"',s);
    sn := StrPosSurround('<b>','</b>',s);
    if sc = '' then break;
    d := FItems.Add();
    d.Name := sn;
    d.ChannelTv := StrToIntDef(sc,0);
    d.ChannelEx := StrToIntDef(se,-1);
    d.AdrNo  := FAdr;
    d.PageNo := FPage;
    d.Mode   := FMode;
    d.UseTvGuide := True;
    result := True;
  until str = '';
end;

procedure TGetTvOnTvJapanEx.OnHttpError(Sender: TObject;Code : Integer);
begin
  ProcRecErr();
end;

procedure TGetTvOnTvJapanEx.OnHttpReceive(Sender: TObject;
  ReceiveStr: string);
var
  f : Boolean;
begin
  f := HtmlStrToChannelItems(ReceiveStr);
  if f then begin
    ProcNext();
    GetSub();
  end
  else begin
    DoReceive();
  end;
end;

procedure TGetTvOnTvJapanEx.ProcNext;
begin
  Inc(FPage);
  DoProcess();
end;

procedure TGetTvOnTvJapanEx.ProcRecErr;
begin
  if FErrCnt < 3 then begin
    DoError();
  end
  else begin
    Inc(FErrCnt);
    GetSub();
  end;
end;

end.
