unit GetTvChOnTvJapanBroadcast;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls,CommInternet,StringListEx,
  DataTvChannel,ProcPublicfileName,DataRdRecReserveList,WinsockVHttpClient;

//--------------------------------------------------------------------------//
//  nꗗ擾NX                                                      //
//--------------------------------------------------------------------------//
type
  TGetTvOnTvJapanBloadcast = class(TPersistent)
  private
    { Private 錾 }
    //FHttp : THttpGetPutV;
    FHttpV : TWinSockHttpVClient;
    FBroadcasts: TDataRdRecReserveList;
    FPage : Integer;
    FErrCnt : Integer;
    FOnError: TNotifyEvent;
    FOnReceive: TNotifyEvent;
    FMode: TTvChannelStatusMode;
    FZipCode : string;
    procedure GetSub();
    procedure ProcRecErr();

    function HtmlStrToBloadcastItems(str : string) : Boolean;

    procedure OnHttpBroadcastReceive(Sender : TObject; ReceiveStr: string);
    procedure OnHttpBroadcastError(Sender : TObject;Code : Integer);

    procedure DoReceive();
    procedure DoError();
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Get(ZipCode  : string);
    property Broadcasts : TDataRdRecReserveList read FBroadcasts;

    property Page : Integer read FPage;

    property OnReceive : TNotifyEvent read FOnReceive write FOnReceive;
    property OnError   : TNotifyEvent read FOnError   write FOnError;
  end;

implementation

{ TGetTvOnTvJapanEx }

constructor TGetTvOnTvJapanBloadcast.Create;
begin
  FHttpV := TWinSockHttpVClient.Create;
  FHttpV.AutoEucChange := True;
  FHttpV.OnReceive := OnHttpBroadcastReceive;
  FHttpV.PortNo := 80;
  FHttpV.OnError := OnHttpBroadcastError;
  FBroadcasts := TDataRdRecReserveList.Create;
end;

destructor TGetTvOnTvJapanBloadcast.Destroy;
begin
  FBroadcasts.Free;
  FHttpV.Free;
  inherited;
end;

procedure TGetTvOnTvJapanBloadcast.DoError;
begin
  if Assigned(FOnError) then begin
    FOnError(Self);
  end;
end;

procedure TGetTvOnTvJapanBloadcast.DoReceive;
begin
  if Assigned(FOnReceive) then begin
    FOnReceive(Self);
  end;
end;

procedure TGetTvOnTvJapanBloadcast.Get(ZipCode  : string);
begin
  FZipCode := ZipCode;
  FMode := cmCATV;
  FErrCnt := 0;
  FPage := 0;
  GetSub();
end;

procedure TGetTvOnTvJapanBloadcast.GetSub;
var
  d : TDateTime;
  ts : TStringList;
begin
  d := Now;

  FHttpV.HostName := 'www.ontvjapan.com';
  FHttpV.UrlName := '/areachange/step2.php3';
  ts := FHttpV.ExtraInfo;
  ts.Clear;
  ts.Values['Decode']  := 'E';
  ts.Values['s_jikan'] := '0500';
  ts.Values['s_hiduke'] := FormatDateTime('yyyymmdd',d);
  ts.Values['sel_mode']  := '';
  ts.Values['hour_select'] := '6';
  ts.Values['nonf']  := '';
  ts.Values['s_zip']  := FZipCode;
  ts.Values['x']  := '11';
  ts.Values['y']  := '9';

  FHttpV.Get();
  {
  sm := '&';
  d := Now;
  ss   := 'areachange/step2.php3';
  info := 'Decode=E';
  info := info + sm + 's_jikan=0500';
  info := info + sm + 's_hiduke='+FormatDateTime('yyyymmdd',d);
  info := info + sm + 'sel_mode=';
  info := info + sm + 'hour_select=6';
  info := info + sm + 'nonf=';
  info := info + sm + 's_zip=' + FZipCode;
  info := info + sm + 'x=11';
  info := info + sm + 'y=9';

  url := 'http://www.ontvjapan.com';
  FHttp.Post(80,url,ss,'','',info);
  }
end;

procedure TGetTvOnTvJapanBloadcast.OnHttpBroadcastReceive(Sender: TObject;
  ReceiveStr: string);
var
  f : Boolean;
begin
  f := HtmlStrToBloadcastItems(ReceiveStr);
  if f then begin
    DoReceive();
  end
  else begin
    DoError();
  end;
end;

procedure TGetTvOnTvJapanBloadcast.OnHttpBroadcastError(Sender: TObject;Code : Integer);
begin
  ProcRecErr();
end;

function TGetTvOnTvJapanBloadcast.HtmlStrToBloadcastItems(
  str: string): Boolean;
var
  ss,s,sv,sn : string;
  d : TDataRdRecReserveListItem;
begin
  FBroadcasts.Items.Clear;
  ss := StrPosSurround('CLASS="orange-in"','</TABLE>',str);
  repeat
    s := StrPosSurroundLeftDelete('NAME="tikicd"','</TR>',ss);
    if s = '' then break;
    sv := StrPosSurround('VALUE="','"',s);
    if sv = '' then break;
    sn := StrPosSurround('>','<',s);
    if sn = '' then break;
    d := FBroadcasts.Items.Add();
    d.NameInfo := sn;
    d.Value    := sv;
  until ss = '';
  result := (FBroadcasts.Items.Count > 0);
end;

procedure TGetTvOnTvJapanBloadcast.ProcRecErr;
begin
  if FErrCnt < 3 then begin
    DoError();
  end
  else begin
    Inc(FErrCnt);
    GetSub();
  end;
end;

end.
