unit GetTvChCs110;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls,CommInternet,StringListEx,
  DataTvChannel,WinsockVHttpClient;

//--------------------------------------------------------------------------//
//  brPPOǈꗗ擾NX                                        //
//--------------------------------------------------------------------------//
type
  TGetTvChCs110 = class(TPersistent)
  private
    { Private 錾 }
    //FHttp : THttpGetPutV;
    FHttpV : TWinSockHttpVClient;
    FItems: TDataTvChannelItems;
    FErrCnt : Integer;
    FOnError: TNotifyEvent;
    FOnReceive: TNotifyEvent;
    FGenres: TStringList;
    procedure GetSub();
    procedure ProcRecErr();

    function HtmlStrToChannelItems(str : string) : Boolean;

    procedure OnHttpReceive(Sender : TObject; ReceiveStr: string);
    procedure OnHttpError(Sender : TObject;Code : Integer);

    procedure DoReceive();
    procedure DoError();
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Get();
    property Items : TDataTvChannelItems read FItems;
    property Genres : TStringList read FGenres;
    property OnReceive : TNotifyEvent read FOnReceive write FOnReceive;
    property OnError   : TNotifyEvent read FOnError   write FOnError;
  end;

implementation

{ TGetTvCs110Ch }

constructor TGetTvChCs110.Create;
begin
  FHttpV := TWinSockHttpVClient.Create;
  //FHttp.AutoECUChange := True;
  FHttpV.PortNo := 80;
  FHttpV.OnReceive := OnHttpReceive;
  FHttpV.OnError := OnHttpError;
  FItems := TDataTvChannelItems.Create;
  FGenres := TStringList.Create;
end;

destructor TGetTvChCs110.Destroy;
begin
  FGenres.Free;
  FItems.Free;
  FHttpV.Free;
  inherited;
end;

procedure TGetTvChCs110.DoError;
begin
  if Assigned(FOnError) then begin
    FOnError(Self);
  end;
end;

procedure TGetTvChCs110.DoReceive;
begin
  if Assigned(FOnReceive) then begin
    FOnReceive(Self);
  end;
end;

procedure TGetTvChCs110.Get();
begin
  FErrCnt := 0;
  GetSub();
end;

procedure TGetTvChCs110.GetSub;
begin

  FHttpV.HostName := 'www.e2sptv.jp';
  FHttpV.UrlName := '/prog110/channel/index.html';
  FHttpV.Get();
  {
  s := 'prog110/channel/index.html';
  //s := 'channel/index.html';
  FHttp.Get(0,'http://www.skyperfectv110.jp',s,'','','');
  }
end;

function TGetTvChCs110.HtmlStrToChannelItems(str: string): Boolean;
var
  s,s1,s2,Genre : string;
  d : TDataTvChannelItem;
begin
  FGenres.Clear;
  FItems.Clear;
  repeat
    s := StrPosSurroundLeftDelete(' table starts here -->',
                                  ' table ends here -->',str);
    Genre := StrPosSurround(' alt="','"',s);
    if Genre = '' then break;
    FGenres.Add(Genre);
    s := StrPosSurroundLeftDelete('<table border="0" ',
                                   '</table>',s);
    if s = '' then break;

    repeat
      s1 := StrPosSurroundLeftDelete('<tr valign="top">',
                                    '</tr>',s);
      if s1 = '' then break;
      s2 := StrPosSurroundLeftDelete('class="basetxt"','</td>',s1);
      s2 := StrPosSurroundLeftDelete('.html">','</a>',s2);
      if s2 = '' then break;
      d := FItems.Add();
      d.ChannelEx := StrToIntDef(s2,0);
      d.ChannelTv := 0;
      d.GenreName := Genre;
      d.Mode := cmCsDigital;
      d.UseCsDigital := True;
      s2 := StrPosSurroundLeftDelete('class="basetxt"','</td>',s1);
      s2 := StrPosSurroundLeftDelete('.html">','</a>',s2);
      d.Name := s2;
    until s1 = '';
  until s = '';
  result := True;
end;

procedure TGetTvChCs110.OnHttpError(Sender: TObject;Code : Integer);
begin
  ProcRecErr();
end;

procedure TGetTvChCs110.OnHttpReceive(Sender: TObject; ReceiveStr: string);
var
  t : TStringList;
begin
  t := TStringList.Create;
  try
    t.Add(ReceiveStr);
    //t.SaveToFile(GetFileName());
    //HtmlStrToGenres(ReceiveStr);
    HtmlStrToChannelItems(ReceiveStr);
    DoReceive();
  finally
    t.Free;
  end;
end;

procedure TGetTvChCs110.ProcRecErr;
begin
  if FErrCnt < 3 then begin
    DoError();
  end
  else begin
    Inc(FErrCnt);
    GetSub();
  end;
end;

end.
