unit GetTvChCs;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls,CommInternet,StringListEx,
  DataTvChannel,WinsockVHttpClient;

//--------------------------------------------------------------------------//
//  brPPOǈꗗ擾NX                                        //
//--------------------------------------------------------------------------//
type
  TGetTvChCs = class(TPersistent)
  private
    { Private 錾 }
    //FHttp : THttpGetPutV;
    FHttpV : TWinSockHttpVClient;
    FItems: TDataTvChannelItems;
    FErrCnt : Integer;
    FOnError: TNotifyEvent;
    FOnReceive: TNotifyEvent;
    FGenres: TStringList;
    procedure GetSub();
    procedure ProcRecErr();

    function HtmlStrToChannelItems(str : string) : Boolean;

    procedure OnHttpReceive(Sender : TObject; ReceiveStr: string);
    procedure OnHttpError(Sender : TObject;Code : Integer);

    procedure DoReceive();
    procedure DoError();
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Get();
    property Items : TDataTvChannelItems read FItems;
    property Genres : TStringList read FGenres;
    property OnReceive : TNotifyEvent read FOnReceive write FOnReceive;
    property OnError   : TNotifyEvent read FOnError   write FOnError;
  end;

implementation

{ TGetTvCs110Ch }

constructor TGetTvChCs.Create;
begin
  FHttpV := TWinSockHttpVClient.Create;
  FHttpV.AutoEucChange := True;
  FHttpV.OnReceive := OnHttpReceive;
  FHttpV.OnError := OnHttpError;
  FHttpV.PortNo := 80;
  FItems := TDataTvChannelItems.Create;
  FGenres := TStringList.Create;
end;

destructor TGetTvChCs.Destroy;
begin
  FGenres.Free;
  FItems.Free;
  FHttpV.Free;
  inherited;
end;

procedure TGetTvChCs.DoError;
begin
  if Assigned(FOnError) then begin
    FOnError(Self);
  end;
end;

procedure TGetTvChCs.DoReceive;
begin
  if Assigned(FOnReceive) then begin
    FOnReceive(Self);
  end;
end;

procedure TGetTvChCs.Get();
begin
  FErrCnt := 0;
  GetSub();
end;

procedure TGetTvChCs.GetSub;
begin

  //FHttpV.HostName := 'search.skyperfectv.co.jp';
  //FHttpV.UrlName := '/prog/channel/';

  FHttpV.HostName := 'www.skyperfectv.co.jp';
  FHttpV.UrlName := '/prog/channel/';

  //http://www.skyperfectv.co.jp/prog/channel/

  FHttpV.Get();
  {
  ts := FHttpV.ExtraInfo;
  ts.Clear;
  ts.Values['Decode']  := 'E';
  ts.Values['s_jikan'] := '0500';
  ts.Values['s_hiduke'] := FormatDateTime('yyyymmdd',d);
  ts.Values['sel_mode']  := '';
  ts.Values['hour_select'] := '6';
  ts.Values['nonf']  := '';
  ts.Values['s_zip']  := FZipCode;
  ts.Values['x']  := '11';
  ts.Values['y']  := '9';

  FHttpV.Get();

  s := 'prog/channel/';
  FHttp.Get(0,'http://search.skyperfectv.co.jp',s,'','','');
  }
end;

function TGetTvChCs.HtmlStrToChannelItems(str: string): Boolean;
var
  s,s1,Genre,sc,sn : string;
  d : TDataTvChannelItem;
begin
  result := False;
  FGenres.Clear;
  FItems.Clear;
  str := StrPosSurroundLeftDelete('<!--ꗗ\ -->',
                                '<!--/ꗗ\ -->',str);
  repeat
    s := StrPosSurroundLeftDelete('<!--`l-->',
                                  '<!--/ -->',str);
    Genre := StrPosSurround('f12c464646wB"> ',' </span>',s);
    if Genre = '' then break;
    FGenres.Add(Genre);

    repeat
      s1 := StrPosSurroundLeftDelete('<span class="f12">',
                                     '</tr>',s);
      if s1 = '' then break;

      sc := StrPosSurroundLeftDelete('html">Ch.','<',s1);
      sn := StrPosSurround('.html">','<',s1);

      if sn = '' then break;

      d := FItems.Add();
      d.Name := sn;
      d.ChannelEx := StrToIntDef(sc,0);
      d.ChannelTv := 0;
      d.GenreName := Genre;
      d.Mode := cmCsAnalog;
      d.UseCsAnalog := True;
      result := True;
    until s1 = '';

  until s = '';
end;

procedure TGetTvChCs.OnHttpError(Sender: TObject;Code : Integer);
begin
  ProcRecErr();
end;

procedure TGetTvChCs.OnHttpReceive(Sender: TObject; ReceiveStr: string);
var
  t : TStringList;
begin
  t := TStringList.Create;
  try
    t.Add(ReceiveStr);
    //t.SaveToFile(GetFileName());
    //HtmlStrToGenres(ReceiveStr);
    HtmlStrToChannelItems(ReceiveStr);
    DoReceive();
  finally
    t.Free;
  end;
end;

procedure TGetTvChCs.ProcRecErr;
begin
  if FErrCnt < 3 then begin
    DoError();
  end
  else begin
    Inc(FErrCnt);
    GetSub();
  end;
end;

end.
