unit GetTvAnalogRead;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,StringListEx,StringListKey,DateTimeCtrl,DataTvChannel;

type TGetTvReadMode = (gsOnTvJapan,gsSkyPerfecTV,SkyPerfecTV110);

//--------------------------------------------------------------------------//
//  ԑgf[^擾̂Pf[^                                            //
//--------------------------------------------------------------------------//
type
  TGetTvReadItem = class(TPersistent)
  private
    { Private 錾 }
    FReaded: Boolean;                    // True : łɓǂݍݍς
    FDateTime: TDateTimeCtrl;            // ǂݍޓ
  public
    { Public 錾 }
    constructor Create;virtual;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;
    procedure AssignCh(d : TDataTvChannelItem);virtual;

    function DataSave(t : TStringListEx) : Boolean;virtual;
    function DataLoad(t : TStringListEx) : Boolean;virtual;

    function CompariNotDate(a : TDataTvChannelItem) : Boolean;virtual;

    property DateTime : TDateTimeCtrl read FDateTime;
    property Readed : Boolean read FReaded  write FReaded;

  end;
//--------------------------------------------------------------------------//
//  ԑgf[^擾̂Pf[^iOnTVJapanpj                             //
//--------------------------------------------------------------------------//
type
  TGetTvReadItemAnalog = class(TGetTvReadItem)
  private
    { Private 錾 }
    FAdr: string;                        // ǂݍޒnR[h
    FPage: Integer;                      // ǂݍރy[WԍiǕj
    FExtensionReset: Boolean;            // ǂݍݑOɉtOZbgKvƂ
  public
    { Public 錾 }
    constructor Create;override;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;
    procedure AssignCh(d : TDataTvChannelItem);override;

    function DataSave(t : TStringListEx) : Boolean;override;
    function DataLoad(t : TStringListEx) : Boolean;override;

    function CompariNotDate(a : TDataTvChannelItem) : Boolean;override;

    property Adr : string read FAdr write FAdr;
    property Page : Integer read FPage write FPage;
    property ExtensionReset : Boolean read FExtensionReset write FExtensionReset;
  end;

//--------------------------------------------------------------------------//
//  ԑgf[^擾̂Pf[^iXJp[pj                              //
//--------------------------------------------------------------------------//
type
  TGetTvReadItemCS = class(TGetTvReadItem)
  private
    { Private 錾 }
    FChannel : Integer;
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    procedure AssignCh(d : TDataTvChannelItem);override;

    function DataSave(t : TStringListEx) : Boolean;override;
    function DataLoad(t : TStringListEx) : Boolean;override;

    function CompariNotDate(a : TDataTvChannelItem) : Boolean;override;

    property Channel : Integer read FChannel write FChannel;
  end;

//--------------------------------------------------------------------------//
//  ԑgf[^擾ǗNX                                            //
//--------------------------------------------------------------------------//
type
  TGetTvReadItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TGetTvReadItem;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Delete(i : Integer);
    procedure Clear();override;

    property Items[Index: Integer] : TGetTvReadItem read GetItems;default;

    function ChkAdrPage(dd : TDataTvChannelItem) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;
    //property Mode : TGetTvReadMode read FMode write FMode;
  end;

//--------------------------------------------------------------------------//
//  ԑgf[^擾ǗNX                                            //
//--------------------------------------------------------------------------//
type
  TGetTvReadTvAnalogItems = class(TGetTvReadItems)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TGetTvReadItemAnalog;
  public
    { Public 錾 }
    function Add() : TGetTvReadItemAnalog;
    procedure Assign(Source : TGetTvReadItems);
    function DataLoad(t : TStringListEx) : Boolean;
    procedure ListMake(aNew : TGetTvReadTvAnalogItems);
    function IndexOf(d : TGetTvReadItemAnalog) : Integer;
    //function DataLoad(t : TStringListEx) : Boolean;

    property Items[Index: Integer] : TGetTvReadItemAnalog read GetItems;default;
  end;

//--------------------------------------------------------------------------//
//  ԑgf[^擾ǗNX                                            //
//--------------------------------------------------------------------------//
type
  TGetTvReadCSItems = class(TGetTvReadItems)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TGetTvReadItemCS;
  public
    { Public 錾 }
    function Add() : TGetTvReadItemCS;
    procedure Assign(Source : TGetTvReadItems);
    function DataLoad(t : TStringListEx) : Boolean;
    procedure ListMake(aNew : TGetTvReadItems);
    //function DataLoad(t : TStringListEx) : Boolean;

    property Items[Index: Integer] : TGetTvReadItemCS read GetItems;default;
  end;

implementation

{ TGetTvAnalogReadItems }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TGetTvReadItems.Create;
begin

end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TGetTvReadItems.Destroy;
begin
  Clear();
  inherited;
end;

procedure TGetTvReadItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TGetTvReadItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TGetTvReadItems.GetItems(Index: Integer): TGetTvReadItem;
begin
  result := inherited Items[Index];
end;


{ TGetTvReadItems }

function TGetTvReadItems.ChkAdrPage(dd : TDataTvChannelItem): Boolean;
var
  i : Integer;
  d : TGetTvReadItem;
begin
  result := True;
  for i := 0 to Count-1 do begin
    d := Items[i];
    if d.CompariNotDate(dd) then begin
    //if (d.Page = dd.PageNo) and (d.Adr = dd.AdrNo) then begin
      result := False;
      exit;
    end;
  end;

end;


function TGetTvReadItems.DataSave(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  i : Integer;
begin
  t2 := TStringListEx.Create;
  try
    t.Clear;
    for i := 0 to Count-1 do begin
      Items[i].DataSave(t2);
      t.Add(t2.CommaTextEx);
    end;
    result := True;
  finally
    t2.Free;
  end;

end;



{ TGetTvReadItem }

constructor TGetTvReadItem.Create;
begin
  FDateTime := TDateTimeCtrl.Create;
end;

destructor TGetTvReadItem.Destroy;
begin
  FDateTime.Free;
  inherited;
end;

procedure TGetTvReadItem.Assign(Source: TPersistent);
var
  a : TGetTvReadItem;
begin
  if Source is TGetTvReadItem then begin
    a := TGetTvReadItem(Source);
    FDateTime.Assign(a.FDateTime);
    FReaded := a.FReaded;
  end
  else begin
    inherited;
  end;

end;

procedure TGetTvReadItem.AssignCh(d: TDataTvChannelItem);
begin

end;

function TGetTvReadItem.CompariNotDate(
  a: TDataTvChannelItem): Boolean;
begin
  result := False;
end;

function TGetTvReadItem.DataLoad(t: TStringListEx): Boolean;
begin
  FDateTime.DataLoad('DateTime',t);
  FReaded := t.GetBools('Readed',FReaded);
  result := True;
end;

function TGetTvReadItem.DataSave(t: TStringListEx): Boolean;
begin
  FDateTime.DataSave('DateTime',t);
  t.SetBools('Readed',FReaded);
  result := True;
end;

{ TGetTvReadItemAnalog }

procedure TGetTvReadItemAnalog.Assign(Source: TPersistent);
var
  a : TGetTvReadItemAnalog;
begin
  if Source is TGetTvReadItemAnalog then begin
    a := TGetTvReadItemAnalog(Source);
    FAdr            := a.FAdr;
    FPage           := a.FPage;
    FExtensionReset := a.FExtensionReset;
    inherited Assign(a);
  end
  else begin
    inherited;
  end;
end;

procedure TGetTvReadItemAnalog.AssignCh(d: TDataTvChannelItem);
begin
  FAdr := d.AdrNo;
  FPage := d.PageNo;
end;

constructor TGetTvReadItemAnalog.Create;
begin
  inherited;
end;

destructor TGetTvReadItemAnalog.Destroy;
begin
  inherited;
end;

function TGetTvReadItemAnalog.DataLoad(t: TStringListEx): Boolean;
begin
  FAdr := t.GetStrs('Adr',FAdr);
  FPage := t.GetInts('Page',FPage);
  FExtensionReset := t.GetBools('Reset',FExtensionReset);

  //FLineXD := t.GetInts('LineXD',FLineXD);
  inherited DataLoad(t);
  result := True;
end;

function TGetTvReadItemAnalog.DataSave(t: TStringListEx): Boolean;
begin
  t.SetStrs('Adr',FAdr);
  t.SetInts('Page',FPage);
  t.SetBools('Reset',FExtensionReset);
  inherited DataSave(t);
  result := True;
end;

function TGetTvReadItemAnalog.CompariNotDate(a: TDataTvChannelItem): Boolean;
begin
  result := False;
  if (FPage = a.PageNo) and (FAdr = a.AdrNo) then result := True;

end;

{ TGetTvReadTvAnalogItems }

function TGetTvReadTvAnalogItems.Add: TGetTvReadItemAnalog;
var
  d : TGetTvReadItemAnalog;
begin
  d := TGetTvReadItemAnalog.Create;
  inherited Add(d);
  result := d;
end;

procedure TGetTvReadTvAnalogItems.Assign(Source: TGetTvReadItems);
var
  a : TGetTvReadItems;
  d : TGetTvReadItemAnalog;
  i : Integer;
begin
  if Source is TGetTvReadItems then begin
    a := TGetTvReadItems(Source);
    Clear;
    for i := 0 to a.Count-1 do begin
      d := Add();
      d.Assign(a.Items[i]);
    end;

  end
  else begin
    inherited Assign(Source);
  end;
end;

function TGetTvReadTvAnalogItems.DataLoad(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  d : TGetTvReadItemAnalog;
  i : Integer;
begin
  t2 := TStringListEx.Create;
  try
    for i := 0 to t.Count-1 do begin
      d := Add();
      t2.CommaTextEx := t[i];
      d.DataLoad(t2);
    end;
    result := True;
  finally
    t2.Free;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@Vǂݍݏɑ΂Ăłɓǂݍ񂾕ǂݍ܂Ȃ悤@`  //
//                                                                          //
//   - Input -  aNew : ύX̒nAy[WAXg                     //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TGetTvReadTvAnalogItems.GetItems(
  Index: Integer): TGetTvReadItemAnalog;
begin
  result := TGetTvReadItemAnalog(inherited Items[Index]);
end;

function TGetTvReadTvAnalogItems.IndexOf(d: TGetTvReadItemAnalog): Integer;
var
  i : Integer;
  dd : TGetTvReadItemAnalog;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    dd := Items[i];
    if dd.Adr <> d.Adr then continue;
    if dd.Page <> d.Page then continue;
    if dd.DateTime.Compari(d.DateTime) <> 0 then continue;
    result := i;
    exit;
  end;
end;

procedure TGetTvReadTvAnalogItems.ListMake(aNew: TGetTvReadTvAnalogItems);
var
  i,j : Integer;
begin
  for i := 0 to aNew.Count-1 do begin
    j := Self.IndexOf(aNew[i]);
    if j <> -1 then begin
      aNew[i].FReaded := Self[j].FReaded;
    end;
  end;
  Self.Assign(aNew);
end;

{ TGetTvReadCSItems }

function TGetTvReadCSItems.Add: TGetTvReadItemCS;
var
  d : TGetTvReadItemCS;
begin
  d := TGetTvReadItemCS.Create;
  inherited Add(d);
  result := d;
end;

procedure TGetTvReadCSItems.Assign(Source: TGetTvReadItems);
var
  a : TGetTvReadCSItems;
  d : TGetTvReadItemCS;
  i : Integer;
begin
  if Source is TGetTvReadCSItems then begin
    a := TGetTvReadCSItems(Source);
    Clear;
    for i := 0 to a.Count-1 do begin
      d := Add();
      d.Assign(a.Items[i]);
    end;

  end
  else begin
    inherited Assign(Source);
  end;
end;

function TGetTvReadCSItems.DataLoad(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  d : TGetTvReadItemCS;
  i : Integer;
begin
  t2 := TStringListEx.Create;
  try
    for i := 0 to t.Count-1 do begin
      d := Add();
      t2.CommaTextEx := t[i];
      d.DataLoad(t2);
    end;
    result := True;
  finally
    t2.Free;
  end;
end;

function TGetTvReadCSItems.GetItems(Index: Integer): TGetTvReadItemCS;
begin
  result := TGetTvReadItemCS(inherited Items[Index]);
end;

procedure TGetTvReadCSItems.ListMake(aNew: TGetTvReadItems);
var
  i,j : Integer;
begin
  for i := 0 to aNew.Count-1 do begin
    j := Self.IndexOf(aNew[i]);
    if j <> -1 then begin
      aNew[i].FReaded := Self[j].FReaded;
    end;
  end;
  Self.Assign(aNew);
end;

{ TGetTvReadItemCS }

procedure TGetTvReadItemCS.Assign(Source: TPersistent);
var
  a : TGetTvReadItemCS;
begin
  if Source is TGetTvReadItemCS then begin
    a := TGetTvReadItemCS(Source);
    FChannel := a.FChannel;
    inherited Assign(a);
  end
  else begin
    inherited;
  end;
end;

procedure TGetTvReadItemCS.AssignCh(d: TDataTvChannelItem);
begin
  FChannel := d.ChannelEx;

end;

function TGetTvReadItemCS.CompariNotDate(
  a: TDataTvChannelItem): Boolean;
begin
  result := False;
  if (FChannel = a.ChannelEx) then result := True;

end;

function TGetTvReadItemCS.DataLoad(t: TStringListEx): Boolean;
begin
  FChannel := t.GetInts('Channel',FChannel);
  inherited DataLoad(t);
  result := True;
end;

function TGetTvReadItemCS.DataSave(t: TStringListEx): Boolean;
begin
  t.SetInts('Channel',FChannel);
  inherited DataSave(t);
  result := True;
end;

end.
