unit GetTvAnalogAdr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls,CommInternet,StringListEx,
  WinsockVHttpClient;

//--------------------------------------------------------------------------//
//  nf[^NX                                                        //
//--------------------------------------------------------------------------//
type
  TGetTvAnalogAdrItem = class(TPersistent)
  private
    { Private 錾 }
    FName: string;                   // n於
    FCode: string;                  // nR[h
  public
    { Public 錾 }
    property Name : string read FName;
    property Code : string read FCode;
  end;

//--------------------------------------------------------------------------//
//  nf[^XgǗNX                                              //
//--------------------------------------------------------------------------//
type
  TGetTvAnalogAdrItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TGetTvAnalogAdrItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    function Add() : TGetTvAnalogAdrItem;
    procedure Delete(i : Integer);
    procedure Clear();override;

    property Items[Index: Integer] : TGetTvAnalogAdrItem read GetItems;default;
  end;

//--------------------------------------------------------------------------//
//  nꗗ擾NX                                                      //
//--------------------------------------------------------------------------//
type
  TGetTvAnalogAdr = class(TPersistent)
  private
    { Private 錾 }
    //FHttp : THttpGetPutV;
    FHttpV : TWinSockHttpVClient;
    FOnError: TNotifyEvent;
    FOnReceive: TNotifyEvent;
    FItems: TGetTvAnalogAdrItems;
    procedure OnHttpReceive(Sender : TObject; ReceiveStr: string);
    procedure OnHttpError(Sender : TObject;Code : Integer);
    procedure DoReceive();
    procedure DoError();
    procedure DataSet(str : string);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Get();
    property Items : TGetTvAnalogAdrItems read FItems;
    property OnReceive : TNotifyEvent read FOnReceive write FOnReceive;
    property OnError   : TNotifyEvent read FOnError   write FOnError;
  end;

implementation

{ TGetTvAnalogAdr }

constructor TGetTvAnalogAdr.Create;
begin
  FHttpV := TWinSockHttpVClient.Create;
  FHttpV.PortNo := 80;
  FHttpV.AutoEucChange := True;
  FHttpV.OnReceive := OnHttpReceive;
  FHttpV.OnError := OnHttpError;
  FItems := TGetTvAnalogAdrItems.Create;
end;

destructor TGetTvAnalogAdr.Destroy;
begin
  FItems.Free;
  FHttpV.Free;
  inherited;
end;

procedure TGetTvAnalogAdr.DataSet(str: string);
var
  s1,s2 : string;
  d : TGetTvAnalogAdrItem;
begin
  s1 := Copy(str,2,3);
  s2 := Copy(str,9,Length(str));
  d := FItems.Add();
  d.FName := s2;
  d.FCode := '0'+s1;                     // ng\Ot
end;

procedure TGetTvAnalogAdr.DoError;
begin
  if Assigned(FOnError) then begin
    FOnError(Self);
  end;
end;

procedure TGetTvAnalogAdr.DoReceive;
begin
  if Assigned(FOnReceive) then begin
    FOnReceive(Self);
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@nꗗf[^vM@`                                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvAnalogAdr.Get;
var
  d : TDateTime;
  ts : TStringList;
begin
  d := Now;
  FHttpV.HostName := 'www.ontvjapan.com';
  FHttpV.UrlName := '/areachange/areaselect.php3';
  ts := FHttpV.ExtraInfo;
  ts.Clear;
  ts.Values['s_hiduke'] := FormatDateTime('yyyymmdd',d);
  ts.Values['s_jikan'] := FormatDateTime('hhmm',d);
  ts.Values['tv']  := '1';
  ts.Values['force'] := '1';

  FHttpV.Get();

end;

procedure TGetTvAnalogAdr.OnHttpError(Sender: TObject;Code : Integer);
begin
  DoError();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@nꗗf[^M@`                                              //
//                                                                          //
//   - Input -  str : Mf[^                                            //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvAnalogAdr.OnHttpReceive(Sender: TObject;
  ReceiveStr: string);
const
  sh : string = '<A href="javascript:sendUrl(0,';
  se : string = '</A>';
var
  s,str : string;
begin
  str := ReceiveStr;
  //str := ECUtoSJisString(ReceiveStr);
  StrPosToLeftDelete('<!-- ad banner ends -->',str);
  s := StrPosSurround(sh,se,str);
  while s <> '' do begin
    DataSet(s);
    StrPosToLeftDelete(se,str);
    s := StrPosSurround(sh,se,str);
  end;
  DoReceive();
end;

{ TGetTvAnalogAdrItems }

destructor TGetTvAnalogAdrItems.Destroy;
begin
  Clear();
  inherited;
end;

function TGetTvAnalogAdrItems.Add: TGetTvAnalogAdrItem;
var
  d : TGetTvAnalogAdrItem;
begin
  d := TGetTvAnalogAdrItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TGetTvAnalogAdrItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TGetTvAnalogAdrItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TGetTvAnalogAdrItems.GetItems(
  Index: Integer): TGetTvAnalogAdrItem;
begin
  result := inherited Items[Index];
end;

end.
