//**************************************************************************//
//                                                                          //
//  TVԑg\擾NX                                                      //
//                                                                          //
//**************************************************************************//
unit GetTvAnalog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls,CommInternet,StringListEx,StringListKey,DateTimeCtrl,
  CheckLst,DefaultData,GetTvStanderd,DataTvChannel,DataTvSchedule,DataTvStatus,
  GetTvAnalogRead,WinsockVHttpClient,DataTvScheduleGenre,DateTimeCtrlRdTool;

const
  TGetTvAnalogScTbl : array[0..3] of Integer= (4,10,16,22);
type
  TGetTvProcMode = (pmNil,pmHeadDel,pmProc1,pmProc2,pmProc3);

//--------------------------------------------------------------------------//
//  TVԑgTCg擾NX                                    //
//--------------------------------------------------------------------------//
type
  TGetTvAnalog = class(TGetTvStanderd)
  private
    { Private 錾 }
    //FHttp : THttpGetPutV;
    FHttpV : TWinSockHttpVClient;
    FDateTime : TDateTimeCtrl;                // Ăяoԑg̈ꎞۑ
    FConfigCh : TDataTvChannel;               // `lf[^

    FGetDateTime : TDateTimeCtrl;             // 擾悤ƂĂ
    FGetAdrPageIndex : Integer;               // 擾悤ƂĂy[W
    FResetFlag : Boolean;                     // Reset : v邱Ƃm点
    FReadCh : TGetTvReadTvAnalogItems;        // Ăяoǈꗗ
    FReads : TGetTvReadTvAnalogItems;         // Ăяoꗗ(OnTvJapanp)
    FReadIndex : Integer;
    FDataSended : Boolean;                    // True:M
    FReadData : TDataTvScheduleItems;

    FTvHttpStr : string;
    FTvHttpS   : string;
    FProcMode : TGetTvProcMode;

    procedure OnHttpReceive(Sender : TObject; ReceiveStr: string);
    procedure OnHttpError(Sender : TObject;Code : Integer);

    function Get(aDateTime : TDateTimeCtrl;aAdr : string;aPage : Integer) :Boolean;
    function StringToScheduleSub(dss : TDataTvScheduleItems;str : string) : Boolean;
    function HtmlToStrComment(str : string) : string;
    function CheckExtension(str : string) : Boolean;
    function ChannelStrToIndex(str : string) : Integer;

    procedure ProcTimerSub();
    procedure ProcTimerSubSub();

    procedure AdrPageDateTimeSet(t,aCh : TGetTvReadTvAnalogItems;aStart, aStop: TDateTimeCtrl);

    function CheckHou(d : TDateTimeCtrl) : Boolean;

  public
    { Public 錾 }
    constructor Create;override;
    destructor Destroy;override;

    procedure ProcTimer();override;
    procedure Init();override;
    procedure ProcStart();override;
    function ProcNext() : Boolean;override;
    procedure Reset();override;
    procedure ReadChannelSet();override;

    function DataLoad(t : TStringListKey) : Boolean;override;
    function DataSave(t : TStringListKey) : Boolean;override;
    procedure AssignConfigCh(a : TDataTvChannel);override;
    procedure AssignDateTime(aStart,aStop : TDateTimeCtrl);override;

  end;

implementation

uses DMUnit;

{ TGetTv }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TGetTvAnalog.Create;
begin
  inherited;
  FDateTime := TDateTimeCtrl.Create;
  Mode := cmNormal;
  ModeName := 'ON TV JAPAN';
  FHttpV := TWinSockHttpVClient.Create;
  FHttpV.AutoEucChange := True;
  FHttpV.PortNo := 80;
  FHttpV.OnReceive := OnHttpReceive;
  FHttpV.OnError   := OnHttpError;

  FGetDateTime  := TDateTimeCtrl.Create;    // ǂݍݓNX
  FMaxDateTime := TDateTimeCtrl.Create;     // ŏIǂݍݓNX
  FReadCh := TGetTvReadTvAnalogItems.Create;
  FReads := TGetTvReadTvAnalogItems.Create;
  FConfigCh := TDataTvChannel.Create;
  FReadData := TDataTvScheduleItems.Create;
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TGetTvAnalog.Destroy;
begin
  FReadData.Free;
  FHttpV.Free;
  FReadCh.Free;
  FMaxDateTime.Free;
  FGetDateTime.Free;
  FReads.Free;
  FConfigCh.Free;
  FDateTime.Free;
  inherited;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑg\̃`lԍCfbNXԍɕϊ@`            //
//                                                                          //
//   - Input -  str : `l                                      //
//   - Output - CfbNXԍ                                            //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvAnalog.ChannelStrToIndex(str: string): Integer;
var
  i,j : Integer;
  d : TDataTvChannelItem;
begin
  result := -1;
  j := StrToIntDef(str,0);
  for i := 0 to FConfigCh.Items.Count-1 do begin
    d := FConfigCh.Items[i];
    if d.ChannelTv = j then begin
      result := i;
      exit;
    end;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\ԑgf@`                                  //
//                                                                          //
//   - Input -  str : TVԑgf[^                                          //
//                                                                          //
//   - Output - True : \L                                   //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvAnalog.CheckExtension(str: string): Boolean;
begin
  result := False;
  if Pos('',str) <> 0 then begin
    result := True;
  end;
end;

function TGetTvAnalog.DataLoad(t: TStringListKey): Boolean;
var
  t2 : TStringListEx;
begin
  t2 := t.Values['TvA'];
  if t2 <> nil then begin
    FReads.DataLoad(t2);
  end;
  result := True;
end;

function TGetTvAnalog.DataSave(t: TStringListKey): Boolean;
var
  t2 : TStringListEx;
begin
  t2 := TStringListEx.Create;
  try
    FReads.DataSave(t2);
    t.Add('TvA',t2);
  finally
    t2.Free;
  end;

  //t.SetDateTimes('GetDateTimeTvGuide',FGetDateTime.DateTime);
  result := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^擾@`                                            //
//                                                                          //
//   - Input -  aDateTime : 擾ԑg                                //
//              aAdr      : 擾nԍ                                //
//              aPage     : 擾y[Wԍ                              //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvAnalog.Get(aDateTime: TDateTimeCtrl; aAdr : string; aPage: Integer): Boolean;
var
  s,sm : string;
  ts : TStringList;
begin
  //Items.Clear;
  FDateTime.Assign(aDateTime);

  sm := '&';

  s := ModeName+'';
  s := s + FormatDateTime('mm""dd"" hh""',aDateTime.DateTime);
  s := s + aAdr + '-' + IntToStr(aPage);
  s := s + 'Ăяo';
  DoMessageLog(s);


  FHttpV.HostName := 'www.ontvjapan.com';
  FHttpV.UrlName := '/program/gridNormal.php';
  ts := FHttpV.ExtraInfo;
  ts.Clear;
  ts.Values['frame']  := 'off';
  ts.Values['tikicd'] := aAdr;
  ts.Values['way']    := 'v';
  ts.Values['page']   := IntToStr(aPage+1);
  ts.Values['genre']  := 'all';
  ts.Values['hour_select'] := '6';
  ts.Values['s_hiduke'] := FormatDateTime('yyyymmdd',aDateTime.DateTime);
  ts.Values['s_jikan'] := FormatDateTime('hhmm',aDateTime.DateTime);

  FHttpV.Get();

  result := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@TVԑgf[^ԑgeo@`                              //
//                                                                          //
//   - Input -  str : TVԑgf[^                                          //
//                                                                          //
//   - Output - ԑge\                                        //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvAnalog.HtmlToStrComment(str: string): string;
var
  s : string;
begin
  s := '';
  s := StrPosSurround('style_corner">','</span>',str);
  s := StringReplace(s,#$0d,'',[rfReplaceAll]);   // sR[h
  s := StringReplace(s,#$0a,'',[rfReplaceAll]);
  result := s;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@HTTPMG[Cxg@`                                          //
//                                                                          //
//   - Input -  Sender : CxgNX                                 //
//              Code   : G[ԍ                                         //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvAnalog.OnHttpError(Sender: TObject;Code : Integer);
begin
  DoMessageLog(ModeName+'̃f[^MɎs');
  FDataSended := False;
  DoError();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@HTTPMCxg@`                                                //
//                                                                          //
//   - Input -  Sender     : CxgNX                             //
//              ReceiveStr : Mf[^                                 //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvAnalog.OnHttpReceive(Sender: TObject; ReceiveStr: string);
var
  s : string;
begin
  if FResetFlag then begin        // Zbgvꍇ
    FDataSended := False;
    exit;
  end;
  DoMessageLog(ModeName+'̃f[^M');
  s := ReceiveStr;

  // ԑg\Ō܂Ŏ擾łĂ邩
  if Pos('#########ԑg\/܂##########',s) <> 0 then begin
    FTvHttpStr := s;
    FProcMode := pmHeadDel;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgf[^ǍʒuɈړ@`                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetTvAnalog.ProcNext: Boolean;
begin
  if FReadIndex <= FReads.Count-1 then begin           // Ǎꗗ͈͓̔̏ꍇ
    FReads[FReadIndex].Readed := True;                 // ݏ̈ʒuǂݍݒƔf
    Inc(FReadIndex);                                   // ǂݍމӏ
    if FReadIndex < FReads.Count-1 then begin          // Ǎꗗ͈͓̔̏ꍇ
      if FReads[FReadIndex].ExtensionReset then begin  // ԑg֌WȂȂ鎞ԑт̏ꍇ
        FConfigCh.ExtensionReset();                    // ȍ~̉tOZbg
      end;
    end;
  end;
  result := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ԑgǍ̏@`                                            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvAnalog.Init;
var
  Max : Integer;
begin
  Max := DM.Config.Normal.ReadDay;                      // ǂݍޓ擾
  FGetAdrPageIndex := 0;                                // 擾y[Wʒu
  FGetDateTime.DateTime := Now;                         // ݓ擾
  FGetDateTime.Min := 0;
  FGetDateTime.Sec := 0;

  FMaxDateTime.Assign(FGetDateTime);                    // ǂݍދN_ƂȂ
  FMaxDateTime.IncDay(Max);                             // Z

  AssignDateTime(FGetDateTime,FMaxDateTime);            // N_ƏI_ǂݍޒnEEy[W쐬
  FReadIndex := 0;                                      // ǂݍݏ̈ʒu擪
end;

procedure TGetTvAnalog.ProcStart;
begin
//  FGetAdrPageIndex := 0;
//  FReadIndex := 0;
end;


procedure TGetTvAnalog.ProcTimer;
var
  i : Integer;
  aAdr : string;
  aPage : Integer;
  d : TGetTvReadItemAnalog;
begin
  if DM.TvSchedule.ReadBusy then exit;          // t@Cǂݍݒ͖
  if not FDataSended then begin                 // Mł͂Ȃꍇ
    if FResetFlag then begin                    // Zbgvꍇ
      //Init();                                 // f[^
      //FList.Clear;                            // ԑgf[^ꗗNA
      FResetFlag := False;                      // ZbgvtOZbg
      FDataSended := False;                     // MłȂƂm点
    end
    else begin                                  // Zbgvꍇ
      //ProcStartSub();                         // M
      // ŏI\tOf
      if FReadIndex < FReads.Count then begin   // ǂݍݏꗗ̍Ō܂ŗĂȂꍇ
        d := FReads[FReadIndex];                // ǂݍގwf[^Q
        aAdr  := d.Adr;
        aPage := d.Page;
        if not d.Readed then begin              // ܂ǂݍłȂwf[^̏ꍇ
          Get(d.DateTime,aAdr,aPage);
          FDataSended := True;                  // Mł邱Ƃm点
        end
        else begin
          ProcNext();
        end;
      end;
    end;
  end;
  for i := 0 to 9 do begin
    ProcTimerSub();
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@TVԑgTCg瓾XPW[f[^ɕϊ@`            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//   ԑg̉͂ɂ͕S邽ߒiKIɕďs           //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvAnalog.ProcTimerSub;
var
  s : string;
begin
  case FProcMode of
    pmHeadDel : begin
                  // ԑgf[^܂łǂݔ΂
                  s := '<!--####################ԑg\/####################-->';
                  StrPosToLeftDelete(s,FTvHttpStr);
                  FProcMode := pmProc1;
                end;
    pmProc1   : begin
                  // 擾ׂԑgf[^̉ӏ܂œǂݔ΂
                  FTvHttpS := StrPosSurroundLeftDelete('<TD','</TD>',FTvHttpStr);
                  if FTvHttpS = '' then begin                    // ǂݍނׂf[^ꍇ
                    FProcMode := pmNil;                          // Ȃ
                    ProcTimerSubSub();                           // ͏I
                  end
                  else if Pos('hsid=',FTvHttpS) <> 0 then begin  // ԑgf[^̈ʒu܂ŗꍇ
                    FProcMode := pmProc2;                        // ̏
                  end;
                end;
    pmProc2   : begin
                  s := FTvHttpS;                                 // ̕擾
                  StringToScheduleSub(FReadData,s);              // f[^ƂĊi[
                  FProcMode := pmProc1;                          // ǂݍނׂf[^܂ł̌
                end;
  end;
end;

procedure TGetTvAnalog.ProcTimerSubSub;
begin
  if FResetFlag then begin
  end
  else begin
    DoReceive();    // ͏Im点
    ProcNext();
  end;
  FDataSended := False;
end;


//--------------------------------------------------------------------------//
//                                                                          //
//  `@TVԑgTCg瓾iPsjXPW[f[^ɕϊ@`  //
//                                                                          //
//   - Input -  str : TVԑgTCg瓾                            //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetTvAnalog.ReadChannelSet;
var
  i : Integer;
  d : TDataTvChannelItem;
  d2 : TGetTvReadItemAnalog;
begin
  FReadCh.Clear;                                             // ǂݍ݃y[W
  for i := 0 to FConfigCh.Items.Count-1 do begin
    d := FConfigCh.Items[i];
    if not d.UseTvGuide then continue;                        // ONTVJapangȂȂ疢
    if not d.Visible then continue;                           // \`lȂ疢
    if not FReadCh.ChkAdrPage(d) then continue;               // łɓǂݍchXgɂȂ疢
    d2 := FReadCh.Add();
    d2.AssignCh(d);
  end;
end;

procedure TGetTvAnalog.Reset;
begin
  FResetFlag := True;
end;

function TGetTvAnalog.StringToScheduleSub(dss : TDataTvScheduleItems;str: string): Boolean;
  procedure DateTimeSet(dd : TDateTimeCtrlRd;const aHou,aMin : Integer);
  begin
    dd.Assign(FDateTime);
    dd.Hou := aHou;
    dd.Min := aMin;
    dd.Sec := 0;
  end;
var
  i,aHouStart : Integer;
  d : TDataTvScheduleItem;
  dtvch : TDataTvChannelItem;
  s,sd,sj,sc : string;
  aHou,aMin : Integer;
  f,fe : Boolean;
begin
  d := TDataTvScheduleItem.Create;                // ԑgf[^NX𐶐
  aHouStart := FDateTime.Hou;                     // ǂݍ񂾁ijtEp
  try
    result := False;                              // tOs
    s := StrPosSurround('title="','<',str);       // ԑg^Cg擾
    if s = '' then s := '';                   // ԑgꍇ́uvƂ

    sd := StrPosSurround('title="','"',str);      // `l݂̍f[^擾
    sj := Copy(sd,13,Length(sd));                 // W擾
    sj := StrPosLeft('/',sj);                     // u^vɂΏ

    d.Genre := DM.Define.Genre.Items.Genres[sj];  // Wϐɕϊ

    aHou := StrToIntDef(Copy(sd,7,2),999);        // ԑgIij擾
    aMin := StrToIntDef(Copy(sd,10,2),999);       // ԑgIij擾
    if aHou = 999 then exit;                      // ԑgIij̎擾s̏ꍇ
    if aMin = 999 then exit;                      // ԑgIij̎擾s̏ꍇ

    DateTimeSet(d.Stop,aHou,aMin);                // 擾ɔԑgI܂ō쐬

    f := False;                                   // t܂Zbg
    if aHou < aHouStart then begin                // ǂݍ񂾎ԂႢԂɂȂԑg̏ꍇ
      d.Stop.IncDay();                            // ԑgIij̓
      f := True;                                  // t܂Zbg
    end;

    aHou := StrToIntDef(Copy(sd,1,2),999);        // ԑgJnij擾
    aMin := StrToIntDef(Copy(sd,4,2),999);        // ԑgJnij擾
    if aHou = 999 then exit;                      // ԑgJnij̎擾s̏ꍇ
    if aMin = 999 then exit;                      // ԑgJnij̎擾s̏ꍇ

    DateTimeSet(d.Start,aHou,aMin);               // 擾ɔԑgJn܂ō쐬

    if (f) and (aHou < aHouStart) then begin      // ԑgI܂ȂԑgJnႢꍇ
      d.Start.IncDay();                           // ԑgJnij̓
    end;

    d.Title := StrPosSurround('>','',s);          // ԑg^Cg擾
    s := StrPosSurround('href="','"',str);        // Ǖ擾
    sc := Copy(s,Length(s)-6,4);                  // Ǖsvӏ폜
    if sc = '' then exit;                         // ǃf[^Ȃꍇ
    i := ChannelStrToIndex(sc);                   // ǂ擾\ꗗł̃CfbNXl擾
    if i = -1 then exit;                          // ꗗɂȂꍇ
    dtvch := FConfigCh.Items.Items[i];            // ꗗ̒̊YǃNXQ
    d.ChTv := dtvch.ChannelTv;                    // ԑgTCgł̕ǎʔԍP擾
    d.ChTvEx := dtvch.ChannelEx;                  // ԑgTCgł̕ǎʔԍQ擾
    s := StrPosSurround('href="','"',str);        // ԑg̕sv폜
    d.Comment := HtmlToStrComment(str);           // ԑg擾
    fe := CheckExtension(d.Comment);              // \̂ԑgf
    d.ExtensionIndex := dtvch.ExtensionIndex;     // ȍ~A̕ǂ̔ԑgf[^͉\Ɣf
    if d.Title = '' then exit;                    // ^Cgꍇ͖
    if (fe) or (d.ExtensionIndex <> -1) then begin  // ̔ԑg͈ȑOɎ擾ԑgɉ̉\ꍇ
      dtvch.Extended := True;                     // 擾̍ۂɔԑg͉\Ɣf
    end;
    d.Status[tsmExtended].Value := dtvch.Extended;  // ԑgXe[^XƂĉǉ

    d.Status.StringToScheduleStatus(str);         // ȊÕXe[^X擾

    Items.Add(d,0);                               // ԑgXgɒǉiŐƑj

    result := True;
  finally
    d.Free;
  end;

end;


//**************************************************************************//
//                                                                          //
//  `@ݒo^@`                                                      //
//                                                                          //
//   - Input -  a : ǃXg                                            //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvAnalog.AssignConfigCh(a: TDataTvChannel);
begin
  inherited;
  FConfigCh.Assign(a);
end;


//**************************************************************************//
//                                                                          //
//  `@suԑgǂݍޓ͈͂w@`                                //
//                                                                          //
//   - Input -  a : ǃXg                                            //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvAnalog.AssignDateTime(aStart, aStop: TDateTimeCtrl);
var
  aNew,aOld : TGetTvReadTvAnalogItems;
begin
  aNew := TGetTvReadTvAnalogItems.Create;
  aOld := TGetTvReadTvAnalogItems.Create;
  try
    AdrPageDateTimeSet(aNew,FReadCh,aStart,aStop);  // ǂݍޒnAy[WAԑуXg쐬
    FReads.ListMake(aNew);                          // ȑȌԂƕύX̏ԂǂݍޕKv̗L𐶐
  finally
    aOld.Free;
    aNew.Free;
  end;

end;

function TGetTvAnalog.CheckHou(d: TDateTimeCtrl): Boolean;
var
  i : Integer;
begin
  result := False;
  for i := 0 to High(ScheduleTimeTbl) do begin
    if d.Hou = ScheduleTimeTbl[i] then begin
      result := True;
      break;
    end;
  end;

end;

//**************************************************************************//
//                                                                          //
//  `@ǂݍޒnAy[WAԑуXg쐬@`                        //
//                                                                          //
//   - Input -  t : Xg쐬NX                                  //
//              aCh : ǂݍޒnAy[WXg                            //
//              aStart : ǂݍ݊Jn                                   //
//              aStop : ǂݍݏI                                    //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvAnalog.AdrPageDateTimeSet(t, aCh: TGetTvReadTvAnalogItems;
  aStart, aStop: TDateTimeCtrl);
var
  d : TDateTimeCtrl;
  dd : TGetTvReadItemAnalog;
  i : Integer;
begin
  d := TDateTimeCtrl.Create;
  try
    d.Assign(aStart);
    if d.Hou < ScheduleTimeTbl[0] then begin        // JnȑȌꍇ
      d.DecDay();                                   // Oǂݍނ悤ɏC
    end;
    d.Hou := ScheduleTimeTbl[0];                    // vẐߕJnJn
    d.Min := 0;
    while d.DateTime < aStop.DateTime do begin
      for i := 0 to FReadCh.Count-1 do begin
        dd := t.Add();
        dd.Assign(FReadCh[i]);
        dd.DateTime.Assign(d);
        dd.ExtensionReset := False;
        if (d.Hou = ScheduleTimeTbl[0]) and
           (i = 0) then begin
          dd.ExtensionReset := True;                 // ԂZbg
        end;
      end;

      d.IncHou();                                  // Ԃi߂
      while CheckHou(d) = False do begin           // ǂݍݎɊY܂Ń[v
        d.IncHou();                                // Ԃi߂
      end;
    end;
    FReadIndex := 0;
  finally
    d.Free;
  end;

end;


end.
