//**************************************************************************//
//                                                                          //
//  TVԑgf[^擾NX                                            //
//                                                                          //
//**************************************************************************//
unit GetTv;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,StringListEx,ExtCtrls,DefaultData,
  DateTimeCtrl,GetTvAnalog,DataTvSchedule,DataTvChannel,GetTvStanderd,
  MultiEvent,StringListKey;

const
  TvGuideSaveDataVersion = 4;             // TVԑgۑ̃o[Wԍ

type
  TTvProcMode = (pmNormal,pmTvSend,pmTvRec);
  TGetTvScheduleMode = (gsOnTvJapan,gsSkyPerfecTV,SkyPerfecTV110);

//--------------------------------------------------------------------------//
//  TVԑg\ǂݍ݃NX                                                  //
//--------------------------------------------------------------------------//
type TGetTvSchedule = class(TPersistent)
  private
    { Private 錾 }
    FDM : TDataModule;
    FTimer : TTimer;
    FHouOld : Integer;            // Ōɓǂݍ񂾁ij
    FListHttps : TList;           // ԑg擾pʐMNXꗗ

    procedure OnTimer(Sender: TObject);
    procedure OnHttpReceiveTv(Sender: TObject);
    procedure OnHttpErrorTv(Sender: TObject);
    procedure OnMessageLogEx(Sender: TObject;MsgStr : string);
    function GetTvSchedule: TDataTvScheduleItems;
    procedure SetTvSchedule(const Value: TDataTvScheduleItems);
    procedure GetTvListMake(t : TList);
    procedure Clear();
  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;

    procedure ProcStart();
    procedure ProcStop();
    procedure ProcInit();

    procedure AssignConfig(a : TDataTvChannel);
    procedure AssignDateTime(aStart,aStop : TDateTimeCtrl);
    function DataLoad(t : TStringListKey) : Boolean;
    function DataSave(t : TStringListKey) : Boolean;

    property TvSchedule : TDataTvScheduleItems read GetTvSchedule write SetTvSchedule;
    property DM : TDataModule read FDM write FDM;

  end;

implementation

uses DMUnit,GetTvCs,GetTvCs110;

{ TGetTvSchedule }

constructor TGetTvSchedule.Create();
begin

  FTimer := TTimer.Create(nil);
  FTimer.OnTimer := OnTimer;
  FTimer.Interval := 100;
  FTimer.Enabled := False;

  FListHttps := TList.Create;
end;

destructor TGetTvSchedule.Destroy;
begin
  FTimer.Enabled := False;
  Clear();
  FListHttps.Free;

  FTimer.Free;
  //FHttpEx[0].Free;
  inherited;

end;

procedure TGetTvSchedule.AssignConfig(a: TDataTvChannel);
var
  aa : TDM;
  t : TList;
  i : Integer;
  m : TGetTvScheduleMode;
  d : TGetTvStanderd;
begin
  aa := TDM(FDM);

  Clear();
  t := TList.Create;
  try
    GetTvListMake(t);
    for i := 0 to t.Count-1 do begin
      m := TGetTvScheduleMode(t[i]);
      d := nil;
      case m of
        gsOnTvJapan :   begin
                          d := TGetTvAnalog.Create;
                          d.Owner := Self;
                          d.OnReceive := OnHttpReceiveTv;
                          d.OnError := OnHttpErrorTv;
                          d.OnMessageLog := OnMessageLogEx;
                          d.Items := aa.TvSchedule.Items;
                          d.AssignConfigCh(aa.Config.TvChannel);
                          d.ReadChannelSet;
                        end;
        //: ;
        gsSkyPerfecTV : begin
                          d := TGetTvCs.Create;
                          d.Owner := Self;
                          d.OnReceive := OnHttpReceiveTv;
                          d.OnError := OnHttpErrorTv;
                          d.OnMessageLog := OnMessageLogEx;
                          d.Items := aa.TvSchedule.Items;
                          d.AssignConfigCh(aa.Config.TvChannel);
                          d.ReadChannelSet;
                        end;
        SkyPerfecTV110 : begin
                          d := TGetTvCs110.Create;
                          d.Owner := Self;
                          d.OnReceive := OnHttpReceiveTv;
                          d.OnError := OnHttpErrorTv;
                          d.OnMessageLog := OnMessageLogEx;
                          d.Items := aa.TvSchedule.Items;
                          d.AssignConfigCh(aa.Config.TvChannel);
                          d.ReadChannelSet;
                        end;
      end;
      FListHttps.Add(d);
    end;

  finally
    t.Free;
  end;
  //FHttpEx[0].ProcStart();
end;

procedure TGetTvSchedule.OnHttpErrorTv(Sender: TObject);
begin

end;

procedure TGetTvSchedule.OnHttpReceiveTv(Sender: TObject);
begin

end;

procedure TGetTvSchedule.OnMessageLogEx(Sender: TObject; MsgStr: string);
begin

end;

procedure TGetTvSchedule.OnTimer(Sender: TObject);
var
  i : Integer;
  d : TGetTvStanderd;
begin
  FTimer.Enabled := False;
  for i := 0 to FListHttps.Count-1 do begin
    d := TGetTvStanderd(FListHttps[i]);
    d.ProcTimer();
  end;
  FTimer.Enabled := True;
end;

//**************************************************************************//
//                                                                          //
//  `@ԑgf[^擾Jn@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TGetTvSchedule.ProcStart;
begin
  FTimer.Enabled := True;
end;

//**************************************************************************//
//                                                                          //
//  `@ԑgf[^擾~@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//   ԑgf[^̓^C}[荞݂ɂĎ擾邽                   //
//     f[^̎蓮擾ƓɊ荞݂Ȃ悤ɒ~Kv //
//                                                                          //
//**************************************************************************//
procedure TGetTvSchedule.ProcStop;
begin
  FTimer.Enabled := False;
end;

procedure TGetTvSchedule.ProcInit;
var
  i : Integer;
  d : TGetTvStanderd;
begin
  //FHouOld :=
  for i := 0 to FListHttps.Count-1 do begin
    d := TGetTvStanderd(FListHttps[i]);
    d.Init();
  end;
end;

function TGetTvSchedule.GetTvSchedule: TDataTvScheduleItems;
begin

end;

procedure TGetTvSchedule.SetTvSchedule(const Value: TDataTvScheduleItems);
begin
  //FHttpEx[0].Items := Value;
end;

procedure TGetTvSchedule.AssignDateTime(aStart, aStop: TDateTimeCtrl);
var
  i : Integer;
  d : TGetTvStanderd;
begin
  for i := 0 to FListHttps.Count-1 do begin
    d := TGetTvStanderd(FListHttps[i]);
    d.AssignDateTime(aStart,aStop);
  end;
end;

function TGetTvSchedule.DataLoad(t: TStringListKey): Boolean;
var
  i : Integer;
  d : TGetTvStanderd;
begin
  for i := 0 to FListHttps.Count-1 do begin
    d := TGetTvStanderd(FListHttps[i]);
    d.DataLoad(t);
  end;
  //t2 := t.Values['TvA'];
  //FHttpEx[0].DataLoad(t2);
  result := True;
end;

function TGetTvSchedule.DataSave(t: TStringListKey): Boolean;
var
  t2 : TStringListEx;
  i : Integer;
  d : TGetTvStanderd;
begin
  t2 := TStringListEx.Create;
  try
    for i := 0 to FListHttps.Count-1 do begin
      t2.Clear;
      d := TGetTvStanderd(FListHttps[i]);
      d.DataSave(t);
    end;
    result := True;
  finally
    t2.Free;
  end;

end;

procedure TGetTvSchedule.GetTvListMake(t: TList);
  function ChkList(t : TList;d : TGetTvScheduleMode) : Boolean;
  var
    i : Integer;
    d2 : TGetTvScheduleMode;
  begin
    for i := 0 to t.Count-1 do begin
      d2 := TGetTvScheduleMode(t.Items[i]);
      if d2 = d then begin
        result := False;
        exit;
      end;
    end;
    result := True;
  end;
var
  a : TDM;
  d : TDataTvChannelItem;
  j : Integer;
begin
  a := TDM(FDM);
  t.Clear;
  for j := 0 to a.Config.TvChannel.Items.Count-1 do begin
    d := a.Config.TvChannel.Items[j];
    if d.UseTvGuide then begin
      if ChkList(t,gsOnTvJapan) then begin
        t.Add(Pointer(gsOnTvJapan));
      end;
    end;
    if d.UseCsAnalog then begin
      if ChkList(t,gsSkyPerfecTV) then begin
        t.Add(Pointer(gsSkyPerfecTV));
      end;
    end;
    if d.UseCsDigital then begin
      if ChkList(t,SkyPerfecTV110) then begin
        t.Add(Pointer(SkyPerfecTV110));
      end;
    end;
    {
    for i := 0 to Ord(High(TGetTvScheduleMode)) do begin
      if d.UseTvGuide then begin
        if ChkList(t,TGetTvScheduleMode(i)) then begin
          t.Add(Pointer(TGetTvScheduleMode(i)));
        end;
      end;
    end;
    }
  end;


end;

procedure TGetTvSchedule.Clear;
var
  i : Integer;
begin
  FTimer.Enabled := False;
  for i := 0 to FListHttps.Count-1 do begin
    TPersistent(FListHttps.Items[i]).Free;
  end;
end;

end.
