unit GetRdXD91;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,StringListKey,DataTvStatus,DataRdRecReserveDateTime,
  DataConfigRd,DataRdRecReserve,GetRdStanderd,DataRdRecReserveFolder,
  DataRdRecReserveChannel,DataRdRecReserveGenru,DataTvSchedule,
  DataRdRecReserveRate,DataRdRecReserveAudio,DataRdRecReserveMedia,
  DataRdRecReserveDvdr,DataRdRecReserveAspect,DataRdRecReserveChapterMultiVoice,
  DataRdRecReserveLineVoice,DataRdRecReserveEncode,DataTvScheduleGenre,
  DataRdRecReserveDvdChapter,DataRdRecReserveRecPriority,DataRdRecReserveMagicChapter,
  DataRdRecReserveMuteChapter,DataRdRecReserveCmChapter,DataRdRecReserveTitleLink;

//--------------------------------------------------------------------------//
//  qc{NX                                                      //
//--------------------------------------------------------------------------//
type
  TGetRdXD91 = class(TGetRdStanderd)
  private
    { Private 錾 }
    FFrameNo : Integer;              // qcƑMۂ̃t[ԍ
    procedure StrToRdDate(dd : TDataRdRecReserveDateTimeEx;const str : string);
    procedure StrToRdTime(dd : TDataRdRecReserveDateTimeEx;const str : string);
    function StrToRate(const str : string) : TDataRdRecReserveRateItemMode;
    function StrToAudio(const str : string) : TDataRdRecReserveAudioItemMode;
    function StrToMedia(const str : string) : TDataRdRecReserveMediaItemMode;
    function StrToDvdr(const str : string) : TDataRdRecReserveDvdrItemMode;
    function StrToAspect(const str : string) : TDataRdRecReserveAspectItemMode;
    function StrToChapterMultiVoice(const str : string) : TDataRdRecReserveChapterMultiVoiceItemMode;
    function StrToLineVoice(const str : string) : TDataRdRecReserveLineVoiceItemMode;

    procedure StrRdHtmlToDate(d : TDataRdRecReserveItem;const str : string);

    // \ꗗGR[_̎ނ擾
    function  StrRdHtmlToRecListEncoder(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    // \ꗗ^Dx擾
    function  StrRdHtmlToRecListRecPriority(const str : string;dr : TDataRdRecReserveItem) : Boolean;

    // qc\ɕKvȏ炩ߎ擾Ă
    function  StrRdHtmlToRecInfo(const str : string;dr : TDataRdRecReserveItem) : Boolean;

    // L^tH_ꗗƌ݂̃tH_擾
    function  StrRdHtmlToRecInfoFolder(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoGenre(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoChannel(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    procedure StrRdHtmlToRecInfoChannelSub(const str,aName,aValue : string;const aMode : TDataRdRecReserveChannelMode);
    procedure StrRdHtmlToRecInfoChannelBC(const str,aName,aValue : string);
    procedure StrRdHtmlToRecInfoChannelLine(const str,aName,aValue : string);

    // DVD`v^[Ԃ̈ꗗƌ݂̕Ԃ擾
    function  StrRdHtmlToRecInfoDvdChapter(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    // ^Dẍꗗƌ݂̗Dx擾
    function  StrRdHtmlToRecInfoRecPriority(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    // }WbN`v^[̈ꗗƌ݂̏Ԃ擾
    function  StrRdHtmlToRecInfoMagicChapter(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    // `v^[̈ꗗƌ݂̏Ԃ擾
    function  StrRdHtmlToRecInfoMuteChapter(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    // {Ҏ`v^[̈ꗗƌ݂̏Ԃ擾
    function  StrRdHtmlToRecInfoCmChapter(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    // ԑgǂ̈ꗗƌ݂̏Ԃ擾
    function  StrRdHtmlToRecInfoTitleLink(const str : string;dr : TDataRdRecReserveItem) : Boolean;

    function  StrRdHtmlToRecInfoTitle(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoEncode(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoDvdr(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoRate(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoAudio(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoMedia(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoAspect(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoChapterMultiVoice(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoLineVoice(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoDvdAutoChapter(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoComment(const str : string;dr : TDataRdRecReserveItem) : Boolean;

    function RdDateToPostStr(dr : TDataRdRecReserveItem) : string;

    procedure HtmlTblToList(t : TStringListEx;const aStart : string;str : string);

    procedure SendRecEnterXD(dr : TDataRdRecReserveItem);

    function StrInfoToGenreMode(const str : string) : TDataTvScheduleGenre;

  protected
    procedure GetFrameNoSend();override;
    procedure GetFrameNoRec(const str : string);override;

    procedure GetRecListSend();override;
    procedure GetRecListRec(const str : string);override;

    procedure GetRecRateFrameSend();override;
    procedure GetRecRateFrameRec(const str : string);override;

    procedure GetRecRateInfoSend();override;
    procedure GetRecRateInfoRec(const str : string);override;

    procedure RecAddInfoSend();override;
    procedure RecAddInfoRec(const str : string);override;

    procedure RecAddEnterSend();override;
    procedure RecAddEnterRec(const str : string);override;

    procedure RecEnterSend();override;
    procedure RecEnterRec(const str : string);override;

    procedure RecDelSend();override;
    procedure RecDelRec(const str : string);override;

    procedure RecAddNoGetEvent();override;
  public
    { Public 錾 }
    constructor Create;override;
    destructor Destroy;override;

    procedure RecListGet();override;
    procedure RecInfo(dri : Integer);override;
    procedure RecAdd(dr : TDataRdRecReserveItem);override;
    procedure RecChange(dri : Integer;dr : TDataRdRecReserveItem);override;
    procedure RecDel(dri : Integer);override;
    procedure MatineInfoGet();override;
  end;

implementation

{ TGetRdXD91 }

constructor TGetRdXD91.Create;
begin
  inherited;

end;

destructor TGetRdXD91.Destroy;
begin
  inherited;

end;

procedure TGetRdXD91.GetFrameNoSend;
var
  url : string;
begin
  url := '/reserve/b_rsv.htm';
  FInfo.Clear;
  HttpGet(url);
end;

procedure TGetRdXD91.GetFrameNoRec(const str: string);
var
  s2 : string;
begin
  s2 := StrPosSurround('<frame src="/reserve/','/reserve.htm',str);
  s2 := StrPosSurround('<frame src="/reserve/','/reserve.htm',s2);
  FFrameNo := StrToIntDef(s2,0);
  ProcNext();
end;

procedure TGetRdXD91.RecListGet;
const
  tbl : array[0..1] of TGetRdRecProcMode = (pmCheckFrameNo,pmRecListGet);
begin
  FProcs.Add(tbl);
  ProcStart();
end;

procedure TGetRdXD91.RecInfo(dri: Integer);
const
  tbl : array[0..3] of TGetRdRecProcMode = (pmCheckFrameNo,pmRecListGet,
                                            pmRecInfoFrame,pmRecRateInfo);
begin
  FRdRec.AssignInfo(FRdRecs.Items[dri]);
  FCtrlRecIndex := dri;  // ^\ԍ擾
  FProcs.Add(tbl);
  ProcStart();
end;

procedure TGetRdXD91.MatineInfoGet;
const
  tbl : array[0..3] of TGetRdRecProcMode= (pmCheckFrameNo,pmRecListGet,
                                           pmRecInfoFrame,pmRecRateInfo);
begin
  inherited;
  FCtrlRecIndex := 0;  // ^\ԍ擾
  FProcs.Add(tbl);
  ProcStart();
end;

procedure TGetRdXD91.RecAdd(dr: TDataRdRecReserveItem);
const
  tbl : array[0..6] of TGetRdRecProcMode = (pmCheckFrameNo,pmRecListGet,pmRecAddNoGet,
                                            pmRecInfoFrame,pmRecAddInfo,
                                            pmRecAddEnter,pmRecListGet);
begin
  FRdRec.Assign(dr);
  FProcs.Add(tbl);
  ProcStart();
end;

procedure TGetRdXD91.RecChange(dri: Integer; dr: TDataRdRecReserveItem);
const
  tbl : array[0..1] of TGetRdRecProcMode= (pmRecEnter,pmRecListGet);
begin
  FRdRec.Assign(dr);
  FCtrlRecIndex := dri;  // ^\ԍ擾
  FProcs.Add(tbl);
  ProcStart();
end;

procedure TGetRdXD91.RecDel(dri: Integer);
const
  tbl : array[0..5] of TGetRdRecProcMode= (pmCheckFrameNo,pmRecListGet,
                                           pmRecInfoFrame,pmRecRateInfo,
                                           pmRecDel,pmRecListGet);
begin
  FCtrlRecIndex := dri;
  FProcs.Add(tbl);
  ProcStart();
end;

procedure TGetRdXD91.GetRecListSend;
var
  url : string;
begin
  url :=  '/program/'+IntToStr(FFrameNo)+'/program.htm';
  FInfo.Clear;
  HttpGet(url);
end;

procedure TGetRdXD91.GetRecListRec(const str: string);
var
  s,si,ss : string;
  i : Integer;
  f : Boolean;
  d : TDataRdRecReserveItem;
begin
  ss := str;
  ss := StrPosSurroundLeftDelete('<DIV ID="DrawArea">','function	DrawData(){',ss);
  f := True;
  i := 0;
  FRdRecs.Items.Clear;
  while f do begin
    si := Format('%d',[i]);
    s := StrPosSurround('c1['+si+']="','"',ss);
    if s = '' then break;
    d := TDataRdRecReserveItem.Create;
    d.IndexNo := StrToIntDef(s,0);                  // \hc

    s := StrPosSurround('c2['+si+']="','"',ss);    // \s
    d.Execution := s = '1';

    s := StrPosSurround('c3['+si+']="','"',ss);    // ^Cg
    s := StringReplace(s,'<br>','',[rfreplaceall, rfIgnoreCase]);  // ^CgQŝƂ̑΍
    d.Title := s;

    s := StrPosSurround('c4['+si+']="','"',ss);    // GR[_
    StrRdHtmlToRecListEncoder(s,d);

    s := StrPosSurround('c5['+si+']="','"',ss);    // `l
    d.Channel := s;

    s := StrPosSurround('c6['+si+']="','"',ss);    // ^Jn
    StrRdHtmlToDate(d,s);

    s := StrPosSurround('c7['+si+']="','"',ss);    // ^Jn
    StrToRdTime(d.DateTime.Start,s);

    s := StrPosSurround('c8['+si+']="','"',ss);    // ^I
    StrToRdTime(d.DateTime.Stop,s);

    s := StrPosSurround('c17['+si+']="','"',ss);    // ^Dx 
    StrRdHtmlToRecListRecPriority(s,d);
    //d.EncodeNo := StrToIntDef(s,0);

    s := StrPosSurround('c4['+si+']="','"',ss);    // GR[_
    StrRdHtmlToRecListEncoder(s,d);

    FRdRecs.Items.Add(d);
    Inc(i);
  end;
  ProcNext();
end;

procedure TGetRdXD91.GetRecRateFrameSend;
var
  url,s : string;
  id : integer;
begin
  s := IntToStr(FFrameNo);
  url := '/reserve/' + s + '/b_rsvinfo.htm';
  id := 0;
  if FCtrlRecIndex < FRdRecs.Items.Count then begin
    id := FRdRecs.Items[FCtrlRecIndex].IndexNo;
  end;

  FInfo.Clear;
  FInfo.Add(IntToStr(id));
  FInfo.Add(IntToStr(FCtrlRecIndex+1));

  HttpGet(url);
end;

procedure TGetRdXD91.GetRecRateFrameRec(const str: string);
begin
  ProcNext();
end;

procedure TGetRdXD91.GetRecRateInfoSend;
var
  url,s2 : string;
  id : Integer;
begin

  s2 := IntToStr(FFrameNo);
  url := '/reserve/'+s2+'/rsvinfo.htm';
  id := 0;
  if FCtrlRecIndex < FRdRecs.Items.Count then begin
    id := FRdRecs.Items[FCtrlRecIndex].IndexNo;
  end;

  FInfo.Clear;
  FInfo.Add(IntToStr(id));
  FInfo.Add(IntToStr(FCtrlRecIndex+1));

  HttpGet(url);
end;

procedure TGetRdXD91.GetRecRateInfoRec(const str: string);
begin
  StrRdHtmlToRecInfo(str,FRdRec);
  ProcNext();
end;

function TGetRdXD91.StrRdHtmlToRecListEncoder(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
const
  Tbl : array[1..12] of TDataRdRecReserveEncodeItemMode = (encR1,encR2,encTS1,encR1,encR2,encTS1,encVR,encVR,encTS2,encTS2,encTS1,encTS1);
var
  i : Integer;
begin
  FRdInfo.Encode.Assign(FRdDefine.Encode);
  i := StrToIntDef(str,1);
  if (Low(Tbl) <= i) and (i <= High(Tbl)) then begin
    dr.Encoder := Tbl[i];
  end
  else begin
    dr.Encoder := encR1;
  end;
  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecListRecPriority(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  i : Integer;
begin
  i := StrToIntDef(str,2);
  case i of
    0: dr.RecPriority := drpHigher;        // ŗD
    1: dr.RecPriority := drpHigh;          // D
    3: dr.RecPriority := drpLow;           // D
  else dr.RecPriority := drpNormal;        // 
  end;
  result := True;
end;

procedure TGetRdXD91.RecAddInfoSend;
var
  url,s2 : string;
  id : Integer;
begin

  s2 := IntToStr(FFrameNo);
  url := '/reserve/'+s2+'/rsvinfo.htm';
  id := 0;
  if FCtrlRecIndex < FRdRecs.Items.Count then begin
    id := FRdRecs.Items[FCtrlRecIndex].IndexNo;
  end;
  FInfo.Clear;
  FInfo.Add(IntToStr(id));
  FInfo.Add(IntToStr(FCtrlRecIndex+1));
  HttpGet(url);
end;

procedure TGetRdXD91.RecAddInfoRec(const str: string);
begin
  ProcNext();
end;

procedure TGetRdXD91.RecAddEnterSend;
begin
  SendRecEnterXD(FRdRec);
  //ProcNext();              // ̂ԎԂĂȂ̂ŁAIɎ
end;

procedure TGetRdXD91.RecAddEnterRec(const str: string);
begin
  ProcNext();
end;

procedure TGetRdXD91.StrRdHtmlToDate(d: TDataRdRecReserveItem;
  const str: string);
const
  DayTbl : array[0..10] of string = ('j','j','Ηj','j',
                                     'ؗj','j','yj',
                                     '','`','`','`y');
var
  i : Integer;
  dd : TDataRdRecReserveDateTimeEx;
  Mode : TDataRdRecReserveDateTimeMode;
begin
  Mode := rrrdNormal;
  dd := d.DateTime.Start;
  //dd.Mode := rrrdNormal;
  // Tǂ
  for i := 0 to High(DayTbl) do begin
    if DayTbl[i] = str then Mode := TDataRdRecReserveDateTimeMode(i+1);
  end;
  // łȂꍇ͓tƂĊi[
  if dd.Mode = rrrdNormal then begin
    StrToRdDate(dd,str);
  end;
  dd.Mode := Mode;               // T̔̂ߓtɎނ
  d.DateTime.Stop.Assign(dd);
end;

procedure TGetRdXD91.RecEnterSend;
begin
  SendRecEnterXD(FRdRec);
end;

procedure TGetRdXD91.RecEnterRec(const str: string);
begin
  ProcNext();
end;

procedure TGetRdXD91.RecAddNoGetEvent;
begin
  FCtrlRecIndex := FRdRecs.Items.Count;  // ԍŌ̘^\ԍ擾
  ProcNext();
end;

procedure TGetRdXD91.RecDelSend;
var
  url,s2 : string;
begin
  s2 := IntToStr(FFrameNo);
  url := '/program/'+s2+'/delete.htm';
  FInfo.Clear;
  HttpGet(url);
end;

procedure TGetRdXD91.RecDelRec(const str: string);
begin
  ProcNext();
end;

procedure TGetRdXD91.StrToRdTime(dd: TDataRdRecReserveDateTimeEx;
  const str: string);
var
  s : string;
begin
  s := Copy(str,1,2);
  dd.Hou := StrToIntDef(s,0);
  s := Copy(str,4,2);
  dd.Min := StrToIntDef(s,0);
end;

procedure TGetRdXD91.StrToRdDate(dd: TDataRdRecReserveDateTimeEx;
  const str: string);
var
  s : string;
begin
  s := Copy(str,1,4);
  dd.Yer := StrToIntDef(s,0);
  s := Copy(str,6,2);
  dd.Mon := StrToIntDef(s,0);
  s := Copy(str,9,2);
  dd.Day := StrToIntDef(s,0);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\ڍHTMLڍ׃f[^擾@`                        //
//                                                                          //
//   - Input -  str : MHTML                                              //
//              d   : f[^i[                                        //
//                                                                          //
//   - Output - True:I                                               //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetRdXD91.StrRdHtmlToRecInfo(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
begin
  // GR[h擾
  StrRdHtmlToRecInfoEncode(str,dr);

  // tH_擾
  StrRdHtmlToRecInfoFolder(str,dr);

  // W擾
  StrRdHtmlToRecInfoGenre(str,dr);

  // `l擾
  StrRdHtmlToRecInfoChannel(str,dr);

  // DVD`v^[ԏ擾
  StrRdHtmlToRecInfoDvdChapter(str,dr);

  // ^Dx擾
  StrRdHtmlToRecInfoRecPriority(str,dr);

  // }WbN`v^[擾
  StrRdHtmlToRecInfoMagicChapter(str,dr);

  // `v^[
  StrRdHtmlToRecInfoMuteChapter(str,dr);

  // {Ҏ`v^[
  StrRdHtmlToRecInfoCmChapter(str,dr);

  // ԑgǂ
  StrRdHtmlToRecInfoTitleLink(str,dr);

  // ^Cg
  StrRdHtmlToRecInfoTitle(str,dr);

  // ^掿
  StrRdHtmlToRecInfoRate(str,dr);

  // 
  StrRdHtmlToRecInfoAudio(str,dr);

  // L^fBA
  StrRdHtmlToRecInfoMedia(str,dr);

  // DVD݊[h
  StrRdHtmlToRecInfoDvdr(str,dr);

  // DVDL^@ʔ䗦
  StrRdHtmlToRecInfoAspect(str,dr);

  // d`v^[
  StrRdHtmlToRecInfoChapterMultiVoice(str,dr);


  // C
  StrRdHtmlToRecInfoLineVoice(str,dr);

  // DVD`v^[
  StrRdHtmlToRecInfoDvdAutoChapter(str,dr);

  // Rg
  StrRdHtmlToRecInfoComment(str,dr);

  // ڍ׏𓾂Ƃm点
  dr.InfoEnabled := True;

  FRdInfo.Changed := True;

  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecInfoFolder(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  tn,tv : TStringListEx;
  d : TDataRdRecReserveFolderItem;
  i : Integer;
  s : string;
begin
                                                              // tH_f[^
  FRdInfo.Folders.Items.Clear;                                     // tH_f[^

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var hdd_folder_text    = new Array(',str);
    HtmlTblToList(tv,'var hdd_folder_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.Folders.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
    end;

  finally
    tv.Free;
    tn.Free;
  end;

  s := StrPosSurround('var folder_current = "','"',str);
  dr.Folder := s;

  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecInfoDvdChapter(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  tn,tv : TStringListEx;
  d : TDataRdRecReserveDvdChapterItem;
  i : Integer;
  s : string;
begin

  FRdInfo.DvdChapter.Items.Clear;                                     // DVD`v^[ԏ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var dvdchapter_text    = new Array(',str);
    HtmlTblToList(tv,'var dvdchapter_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.DvdChapter.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      d.Mode     := TDataRdRecReserveDvdChapterItemMode(i);
    end;

  finally
    tv.Free;
    tn.Free;
  end;

  s := StrPosSurround('var dvdchapter_current = ',';',str);
  i := StrToIntDef(s,0);
  dr.DvdChChapter := TDataRdRecReserveDvdChapterItemMode(0);

  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecInfoRecPriority(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  tn,tv : TStringListEx;
  d : TDataRdRecReserveRecPriorityItem;
  i : Integer;
  s : string;
begin

  FRdInfo.RecPriority.Items.Clear;                                     // DVD`v^[ԏ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var rec_priority_text    = new Array(',str);
    HtmlTblToList(tv,'var rec_priority_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.RecPriority.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      if d.NameInfo = 'D' then begin
        d.Mode := drpHigh;
      end
      else if d.NameInfo = 'ŗD' then begin
        d.Mode := drpHigher;
      end
      else if d.NameInfo = 'ӂ' then begin
        d.Mode := drpNormal;
      end
      else if d.NameInfo = 'D' then begin
        d.Mode := drpLow;
      end
      else begin
        d.Mode := drpUser;
      end;
    end;

  finally
    tv.Free;
    tn.Free;
  end;

  s := StrPosSurround('var rec_priority_current = ',';',str);
  i := StrToIntDef(s,0);
  dr.RecPriority := FRdInfo.RecPriority.Items[i].Mode;

  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecInfoMagicChapter(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  tn,tv : TStringListEx;
  d : TDataRdRecReserveMagicChapterItem;
  i : Integer;
  s : string;
begin

  FRdInfo.MagicChapter.Items.Clear;                                     // DVD`v^[ԏ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var magicchapter_text    = new Array(',str);
    HtmlTblToList(tv,'var magicchapter_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.MagicChapter.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      if d.Value = '0' then begin
        d.Mode := dmcOff;
      end
      else begin
        d.Mode := dmcOn;
      end;
    end;

  finally
    tv.Free;
    tn.Free;
  end;

  s := StrPosSurround('var magicchapter_current = ',';',str);
  i := StrToIntDef(s,0);
  dr.MagicChapter := FRdInfo.MagicChapter.Items[i].Mode;

  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecInfoMuteChapter(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  tn,tv : TStringListEx;
  d : TDataRdRecReserveMuteChapterItem;
  i : Integer;
  s : string;
begin

  FRdInfo.MuteChapter.Items.Clear;                                     // DVD`v^[ԏ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var mutechapter_text    = new Array(',str);
    HtmlTblToList(tv,'var mutechapter_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.MuteChapter.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      if d.Value = '0' then begin
        d.Mode := mcOff;
      end
      else begin
        d.Mode := mcOn;
      end;
    end;

  finally
    tv.Free;
    tn.Free;
  end;

  s := StrPosSurround('var mutechapter_current = ',';',str);
  i := StrToIntDef(s,0);
  dr.SilentCut := FRdInfo.MuteChapter.Items[i].Mode;

  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecInfoCmChapter(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  tn,tv : TStringListEx;
  d : TDataRdRecReserveCmChapterItem;
  i : Integer;
  s : string;
begin

  FRdInfo.CmChapter.Items.Clear;

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var cmchapter_text    = new Array(',str);
    HtmlTblToList(tv,'var cmchapter_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.CmChapter.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      if d.Value = '0' then begin
        d.Mode := ccOff;
      end
      else begin
        d.Mode := ccOn;
      end;
    end;

  finally
    tv.Free;
    tn.Free;
  end;

  s := StrPosSurround('var cmchapter_current = ',';',str);
  i := StrToIntDef(s,0);
  dr.CmChapter := FRdInfo.CmChapter.Items[i].Mode;

  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecInfoTitleLink(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  tn,tv : TStringListEx;
  d : TDataRdRecReserveTitleLinkItem;
  i : Integer;
  s : string;
begin

  FRdInfo.TitleLink.Items.Clear;

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var t_link_text     = new Array(',str);
    HtmlTblToList(tv,'var t_link_value    = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.TitleLink.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      if d.Value = '0' then begin
        d.Mode := dtlOff;
      end
      else begin
        d.Mode := dtlOn;
      end;
    end;

  finally
    tv.Free;
    tn.Free;
  end;

  s := StrPosSurround('var t_link_current  = ',';',str);
  i := StrToIntDef(s,0);
  dr.TitleLink := FRdInfo.TitleLink.Items[i].Mode;

  result := True;
end;

procedure TGetRdXD91.HtmlTblToList(t: TStringListEx; const aStart: string;
  str: string);
var
  s : string;
begin
  s := StrPosSurround(aStart,');',str);
  s := StringReplace(s,#$0d#$0a,'',[rfreplaceall, rfIgnoreCase]);         // svȕR[h폜
  s := StringReplace(s,#$09,'',[rfreplaceall, rfIgnoreCase]);             // svȕR[h폜
  s := StringReplace(s,'"','',[rfreplaceall, rfIgnoreCase]);             // svȕR[h폜
  t.CommaTextEx := s;
end;

function TGetRdXD91.StrRdHtmlToRecInfoGenre(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  i : Integer;
  tn,tv : TStringListEx;
  d : TDataRdRecReserveGenreItem;
  s : string;
begin

  FRdInfo.Genres.Items.Clear;                                // Wꗗ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var genre_text    = new Array(',str);
    HtmlTblToList(tv,'var genre_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.Genres.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      d.Mode := StrInfoToGenreMode(d.NameInfo);
    end;

  finally
    tv.Free;
    tn.Free;
  end;

  s := StrPosSurround('var genre_current = ',';',str);
  dr.Genre := StrToIntDef(s,0);
  result := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\ڍHTML͂̎ވꗗ擾@`                    //
//                                                                          //
//   - Input -  str : MHTML                                              //
//              aName : ̈ꗗ̎n܂\                        //
//              aValue : vfꗗ̎n܂\                       //
//              FItems : `lf[^i[                           //
//                                                                          //
//   - Output - True:I                                               //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdXD91.StrRdHtmlToRecInfoChannelBC(const str, aName,
  aValue: string);
var
  sc,sv,ssc,ssv : string;
  dc : TDataRdRecReserveChannelItem;
begin
  ssc := StrPosSurround(aName,');',str);                               // ̈ꗗ擾
  ssv := StrPosSurround(aValue,');',str);                              // vfꗗ擾

  while ssc <> '' do begin                                             // ꗗSēǂݏI܂Ń[v
    sc := StrPosSurroundLeftDelete('"','"',ssc);                       // ̈ꗗPvfo
    sv := StrPosSurroundLeftDelete(#$9,#$d,ssv);                       // ʈꗗPvfo
    sv := StringReplace(sv,',','',[rfreplaceall, rfIgnoreCase]);       // ʂ̋؂ɎguCv폜
    sv := StringReplace(sv,'"','',[rfreplaceall, rfIgnoreCase]);       // ʂ̋؂Ɏguhv폜
    if sv = '' then break;                                             // ʂ̗vfȂꍇI
    dc := FRdInfo.BCMedhia.Items.Add();
    dc.NameInfo := sc;
    dc.Value := sv;
    case StrToIntDef(sv,-1) of
      0  : dc.Mode := cmUvAnalog;
      12 : dc.Mode := cmUvDigital;
      10 : dc.Mode := cmBsDigital;
      11 : dc.Mode := cmCs110;
      2  : dc.Mode := cmLine;
      3  : dc.Mode := cmLine;
      4  : dc.Mode := cmLine;
    end;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\ڍHTML`lꗗ擾@`                    //
//                                                                          //
//   - Input -  str : MHTML                                              //
//              aName : ̈ꗗ̎n܂\                        //
//              aValue : vfꗗ̎n܂\                       //
//              aMode : ꗗ̎                                          //
//              FItems : `lf[^i[                           //
//                                                                          //
//   - Output - True:I                                               //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdXD91.StrRdHtmlToRecInfoChannelSub(const str, aName,
  aValue: string; const aMode: TDataRdRecReserveChannelMode);
var
  sc,sv,ssc,ssv : string;
  dc : TDataRdRecReserveChannelItem;
begin
  ssc := StrPosSurround(aName,');',str);                               // ̈ꗗ擾
  ssv := StrPosSurround(aValue,');',str);                              // vfꗗ擾

  while ssc <> '' do begin                                             // ꗗSēǂݏI܂Ń[v
    sc := StrPosSurroundLeftDelete('"','"',ssc);                       // ̈ꗗPvfo
    sv := StrPosSurroundLeftDelete(#$9,#$d,ssv);                       // ʈꗗPvfo
    sv := StringReplace(sv,',','',[rfreplaceall, rfIgnoreCase]);       // ʂ̋؂ɎguCv폜
    sv := StringReplace(sv,'"','',[rfreplaceall, rfIgnoreCase]);       // ʂ̋؂Ɏguhv폜
    if sc = '' then break;                                             // ʂ̗vfȂꍇI
    dc := FRdInfo.Channels.Items.Add();
    dc.NameList := sc;                                              // XgCH\L\L̗p
    dc.NameInfo := sc;
    dc.Value := sv;
    dc.Mode := aMode;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\ڍHTML`lꗗ擾@`                    //
//                                                                          //
//   - Input -  str : MHTML                                              //
//              aName : ̈ꗗ̎n܂\                        //
//              aValue : vfꗗ̎n܂\                       //
//              aMode : ꗗ̎                                          //
//              FItems : `lf[^i[                           //
//                                                                          //
//   - Output - True:I                                               //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdXD91.StrRdHtmlToRecInfoChannelLine(const str, aName,
  aValue: string);
var
  sc,sv,ssc,ssv : string;
  dc : TDataRdRecReserveChannelItem;
begin
  ssc := StrPosSurround(aName,');',str);                               // ̈ꗗ擾
  ssv := StrPosSurround(aValue,');',str);                              // vfꗗ擾

  while ssc <> '' do begin                                             // ꗗSēǂݏI܂Ń[v
    sc := StrPosSurroundLeftDelete('"','"',ssc);                       // ̈ꗗPvfo
    sv := StrPosSurroundLeftDelete('"','"',ssv);                       // ʈꗗPvfo
    //sv := StrPosSurroundLeftDelete(#$9,#$d,ssv);                       // ʈꗗPvfo
    sv := StringReplace(sv,',','',[rfreplaceall, rfIgnoreCase]);       // ʂ̋؂ɎguCv폜
    sv := StringReplace(sv,'"','',[rfreplaceall, rfIgnoreCase]);       // ʂ̋؂Ɏguhv폜
    if sc = '' then break;                                             // ʂ̗vfȂꍇI
    dc := FRdInfo.Channels.Items.Add();
    dc.NameInfo := sc;
    dc.Value := sv;
    dc.Mode := cmLine;
  end;
end;

function TGetRdXD91.StrRdHtmlToRecInfoChannel(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
  function CheckChStr(Line,str : string) : Boolean;
  var
    Len : Integer;
  begin
    Len := Length(str);
    result := (Copy(Line,1,Len) = str);
  end;
var
  i : Integer;
  s : string;
  aMode : TDataRdRecReserveChannelMode;
  aSelect : TDataRdRecReserveChannelItemsEx;
begin
  FRdInfo.Channels.Items.Clear;
  FRdInfo.BCMedhia.Items.Clear;
  // ǎʈꗗ
  StrRdHtmlToRecInfoChannelBC(str,'var bcmedia_text    = new Array(',
                   'var bcmedia_value   = new Array(');
  // nAiOCHꗗ擾
  StrRdHtmlToRecInfoChannelSub(str,'var uva_ch_text    = new Array(',
                   'var uva_ch_value   = new Array(',cmUvAnalog);

  // arAiOCHꗗ擾
  StrRdHtmlToRecInfoChannelSub(str,'var bsa_ch_text    = new Array(',
                   'var bsa_ch_value   = new Array(',cmBsAnalog);

  // nfW^CHꗗ擾
  StrRdHtmlToRecInfoChannelSub(str,'var uvd_ch_text    = new Array(',
                   'var uvd_ch_value   = new Array(',cmUvDigital);

  // arfW^CHꗗ擾
  StrRdHtmlToRecInfoChannelSub(str,'var bsd_ch_text    = new Array(',
                   'var bsd_ch_value   = new Array(',cmBsDigital);

  // brfW^CHꗗ擾
  StrRdHtmlToRecInfoChannelSub(str,'var csd_ch_text    = new Array(',
                   'var csd_ch_value   = new Array(',cmCs110);

  // O͈ꗗ擾
  for i := 1 to 4 do begin
    s := 'l' + IntToStr(i);
    StrRdHtmlToRecInfoChannelLine(str,'var '+s+'_ch_text     = new Array(',
                     'var '+s+'_ch_value    = new Array(');
  end;

  FRdRec.BCMedhiaStr := StrPosSurround('var recinfo_input_line = ',';',str);
  i := FRdInfo.BCMedhia.Items.IndexOfValue(FRdRec.BCMedhiaStr);
  if i <> -1 then begin
    aMode := FRdInfo.BCMedhia.Items[i].Mode;
    aSelect := FRdInfo.Channels.Selects[aMode];
    s := StrPosSurround('var recinfo_channel_no = ',';',str);
    for i := 0 to aSelect.Count-1 do begin
      if CheckChStr(aSelect.Items[i].Value,s) then begin
        FRdRec.ChannelStr  := aSelect.Items[i].Value;
        break;
      end;
    end;
  end;
  {
  i := StrToIntDef((StrPosSurround('var bcmedia_current = ',';',str),-1);
  case i of
    0: aMode = cmUvAnalog;
    1: aMode = cmUvDigital;
    2: aMode = cmBsDigital;
    3: aMode = cmCs110;
    4: aMode = cmLine;
    5: aMode = cmLine;
    6: aMode = cmLine;
  end;
  FRdRec.ChannelStr  := StrPosSurround('var list_no           =',';',str);
  FRdInfo.Channels.Selects[
  }
  {
  case i of
    0: dr.ChannelStr := StrPosSurround('var uva_ch_current = ',';',str);
    1: dr.ChannelStr := StrPosSurround('var uvd_ch_current = ',';',str);
    2: dr.ChannelStr := StrPosSurround('var bsd_ch_current = ',';',str);
    3: dr.ChannelStr := StrPosSurround('var csd_ch_current = ',';',str);
    4: dr.ChannelStr := StrPosSurround('var l1_ch_current = ',';',str);
    5: dr.ChannelStr := StrPosSurround('var l2_ch_current = ',';',str);
    6: dr.ChannelStr := StrPosSurround('var l3_ch_current = ',';',str);
  end;
  }


  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecInfoTitle(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s : string;
begin
  s := StrPosSurround('var title_name = "','"',str);
  dr.Title := s;
  result := True;
end;

function TGetRdXD91.StrToRate(
  const str: string): TDataRdRecReserveRateItemMode;
const
  Tblm : array[0..45] of TDataRdRecReserveRateItemMode =
                                  (rmSP,rmLP,rmJust,
                                   rmA1,rmA2,rmDL,rmSave,
                                   rm10,rm14,
                                   rm20,rm22,rm24,rm26,rm28,
                                   rm30,rm32,rm34,rm36,rm38,
                                   rm40,rm42,rm44,rm46,rm48,
                                   rm50,rm52,rm54,rm56,rm58,
                                   rm60,rm62,rm64,rm66,rm68,
                                   rm70,rm72,rm74,rm76,rm78,
                                   rm80,rm82,rm84,rm86,rm88,
                                   rm90,rm92);
  Tbls :array[0..45] of string =
                                  ('SP 4.4/4.6','LP 2.0/2.2','ެ',
                                   'A1','A2','DL','[gߖ',
                                   'MN 1.0','MN 1.4',
                                   'MN 2.0','MN 2.2','MN 2.4','MN 2.6','MN 2.8',
                                   'MN 3.0','MN 3.2','MN 3.4','MN 3.6','MN 3.8',
                                   'MN 4.0','MN 4.2','MN 4.4','MN 4.6','MN 4.8',
                                   'MN 5.0','MN 5.2','MN 5.4','MN 5.6','MN 5.8',
                                   'MN 6.0','MN 6.2','MN 6.4','MN 6.6','MN 6.8',
                                   'MN 7.0','MN 7.2','MN 7.4','MN 7.6','MN 7.8',
                                   'MN 8.0','MN 8.2','MN 8.4','MN 8.6','MN 8.8',
                                   'MN 9.0','MN 9.2');
var
  i : Integer;
begin
  result := rmSP;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;

end;

function TGetRdXD91.StrRdHtmlToRecInfoRate(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  i : Integer;
  tn,tv : TStringListEx;
  d : TDataRdRecReserveRateItem;
begin

  FRdInfo.Rates.Items.Clear;                                // Wꗗ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var vrate_text    = new Array(',str);
    HtmlTblToList(tv,'var vrate_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.Rates.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      d.Mode     := StrToRate(tn[i]);
    end;

  finally
    tv.Free;
    tn.Free;
  end;

  result := True;
end;

function TGetRdXD91.StrToAudio(
  const str: string): TDataRdRecReserveAudioItemMode;
const
  Tblm : array[0..2] of TDataRdRecReserveAudioItemMode =
                                  (raM1,raM2,raPCM);
  Tbls :array[0..2] of string =   ('M1','M2','PCM');
var
  i : Integer;
begin
  result := raM1;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdXD91.StrRdHtmlToRecInfoAudio(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  i : Integer;
  tn,tv : TStringListEx;
  d : TDataRdRecReserveAudioItem;
begin

  FRdInfo.Audio.Items.Clear;                                // Wꗗ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var amode_text    = new Array(',str);
    HtmlTblToList(tv,'var amode_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.Audio.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      d.Mode     := StrToAudio(tn[i]);
    end;

  finally
    tv.Free;
    tn.Free;
  end;

  result := True;
end;

function TGetRdXD91.StrToMedia(
  const str: string): TDataRdRecReserveMediaItemMode;
const
  Tblm : array[0..1] of TDataRdRecReserveMediaItemMode =
                                  (rmHdd,rmDvd);
  Tbls :array[0..1] of string =   ('HDD','DVD');
var
  i : Integer;
begin
  result := rmHdd;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdXD91.StrRdHtmlToRecInfoMedia(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  i : Integer;
  tn,tv : TStringListEx;
  d : TDataRdRecReserveMediaItem;
begin

  FRdInfo.Media.Items.Clear;                                // Wꗗ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var media_text    = new Array(',str);
    HtmlTblToList(tv,'var media_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.Media.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      d.Mode     := StrToMedia(tn[i]);
    end;

  finally
    tv.Free;
    tn.Free;
  end;

  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecInfoEncode(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  d : TDataRdRecReserveEncodeItem;
  s : string;
  i : Integer;
begin
  FRdInfo.Encode.Items.Clear;
  d := FRdInfo.Encode.Items.Add();
  d.NameInfo := 'VR1';
  d.NameList := 'VR1';
  d.Value    := '1';
  d.Mode     := encR1;

  d := FRdInfo.Encode.Items.Add();
  d.NameInfo := 'VR2';
  d.NameList := 'VR2';
  d.Value    := '2';
  d.Mode     := encR2;

  d := FRdInfo.Encode.Items.Add();
  d.NameInfo := 'TS';
  d.NameList := 'TS';
  d.Value    := '3';
  d.Mode     := encTS1;

  s := StrPosSurround('var encoder           = ',';',str);
  i := StrToIntDef(s,0);
  case i of
    1: dr.Encoder := encR1;
    2: dr.Encoder := encR2;
    3: dr.Encoder := encTS1;
  end;

  result := True;
end;

function TGetRdXD91.StrToDvdr(
  const str: string): TDataRdRecReserveDvdrItemMode;
const
  Tblm : array[0..2] of TDataRdRecReserveDvdrItemMode =
                                  (dmOff,dmMain,dmSub);
  Tbls :array[0..2] of string =   ('','剹','');
var
  i : Integer;
begin
  result := dmOff;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdXD91.StrRdHtmlToRecInfoDvdr(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  i : Integer;
  tn,tv : TStringListEx;
  d : TDataRdRecReserveDvdrItem;
begin

  FRdInfo.Dvdr.Items.Clear;                                // Wꗗ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var dvdr_text    = new Array(',str);
    HtmlTblToList(tv,'var dvdr_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.Dvdr.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      d.Mode     := StrToDvdr(tn[i]);
    end;
  finally
    tv.Free;
    tn.Free;
  end;

  result := True;
end;

function TGetRdXD91.StrToAspect(
  const str: string): TDataRdRecReserveAspectItemMode;
const
  Tblm : array[0..1] of TDataRdRecReserveAspectItemMode =
                                  (ra4vs3,ra16vs9);
  Tbls :array[0..1] of string =   ('4:3Œ','16:9Œ');
var
  i : Integer;
begin
  result := ra4vs3;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdXD91.StrRdHtmlToRecInfoAspect(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  i : Integer;
  tn,tv : TStringListEx;
  d : TDataRdRecReserveAspectItem;
begin

  FRdInfo.Aspect.Items.Clear;                                // Wꗗ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var aspect_text    = new Array(',str);
    HtmlTblToList(tv,'var aspect_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.Aspect.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      d.Mode     := StrToAspect(tn[i]);
    end;
  finally
    tv.Free;
    tn.Free;
  end;

  result := True;
end;

function TGetRdXD91.StrToChapterMultiVoice(
  const str: string): TDataRdRecReserveChapterMultiVoiceItemMode;
const
  Tblm : array[0..1] of TDataRdRecReserveChapterMultiVoiceItemMode =
                                  (rcmOff,rcmOn);
  Tbls :array[0..1] of string =   ('','');
var
  i : Integer;
begin
  result := rcmOff;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdXD91.StrRdHtmlToRecInfoChapterMultiVoice(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  i : Integer;
  tn,tv : TStringListEx;
  d : TDataRdRecReserveChapterMultiVoiceItem;
begin

  FRdInfo.CapMultiVoice.Items.Clear;                                // Wꗗ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var mvchapter_text    = new Array(',str);
    HtmlTblToList(tv,'var mvchapter_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.CapMultiVoice.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      d.Mode     := StrToChapterMultiVoice(tn[i]);
    end;
  finally
    tv.Free;
    tn.Free;
  end;

  result := True;
end;

function TGetRdXD91.StrToLineVoice(
  const str: string): TDataRdRecReserveLineVoiceItemMode;
const
  Tblm : array[0..3] of TDataRdRecReserveLineVoiceItemMode =
                                  (rlvStereo,rlvLeft,rlvRight,rlvLeftAndRight);
  Tbls :array[0..3] of string =   ('XeI','L','R','+');
var
  i : Integer;
begin
  result := rlvStereo;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdXD91.StrRdHtmlToRecInfoLineVoice(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  i : Integer;
  tn,tv : TStringListEx;
  d : TDataRdRecReserveLineVoiceItem;
begin

  FRdInfo.LineVoice.Items.Clear;                                // Wꗗ

  tn := TStringListEx.Create;
  tv := TStringListEx.Create;
  try
    HtmlTblToList(tn,'var lvoice_text    = new Array(',str);
    HtmlTblToList(tv,'var lvoice_value   = new Array(',str);
    for i := 0 to tn.Count-1 do begin
      d := FRdInfo.LineVoice.Items.Add();
      d.NameInfo := tn[i];
      d.Value    := tv[i];
      d.Mode     := StrToLineVoice(tn[i]);
    end;
  finally
    tv.Free;
    tn.Free;
  end;

  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecInfoDvdAutoChapter(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s : string;
  i : Integer;
begin
  // DVD`v^[
  s := StrPosSurround('var dvdchapter_current = ',';',str);
  i := StrToIntDef(s,0);
  dr.DvdChChapter := TDataRdRecReserveDvdChapterItemMode(i);
  result := True;
end;

function TGetRdXD91.StrRdHtmlToRecInfoComment(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s : string;
begin
  // Rg
  s := StrPosSurround('var title_detail = "','";',str);
  dr.Comment := s;
  result := True;
end;

procedure TGetRdXD91.SendRecEnterXD(dr : TDataRdRecReserveItem);
  function DvdChapterToStr(dr : TDataRdRecReserveItem) : string;
  var
    i : Integer;
  begin
    i := FRdInfo.DvdChapter.Items.IndexOfMode(dr.DvdChChapter);
    if i = -1 then i := 0;
    result := FRdInfo.DvdChapter.Items[i].Value;
  end;
var
  s,url : string;
  t,tt : TStringList;
  i : Integer;
begin
  //s3 := 'entry.htm';
  t := TStringList.Create;
  tt := TStringList.Create;
  url :=  'program/'+IntToStr(FFrameNo)+'/entry.htm';

  try
    FInfo.Clear;
    FInfo.Values['Decode'] := 'S';

    if dr.Execution then begin
      s := 'ON';
      FInfo.Values['bExec'] := s;
    end
    else begin
      s := 'OFF';
      FInfo.Values['bExec'] := s;
    end;

    FInfo.Values['start_form'] := '';
    FInfo.Values['title_name'] := dr.Title;
    FInfo.Values['detail'] := dr.Comment;

    if dr.Genre < FRdInfo.Genres.Items.Count then begin
      s := FRdInfo.Genres.Items[dr.Genre].Value;
      FInfo.Values['genre'] := s;
    end
    else begin
      s := IntToStr(dr.Genre);
      FInfo.Values['genre'] := s;
    end;

    // `[i[I 1:R1 2:R2 3:VR
    s := FRdInfo.Encode.Items.Modes[dr.Encoder].Value;
    FInfo.Values['enc_type'] := s;

    FInfo.Values['channel_list'] := dr.ChannelStr;
    FInfo.Values['broadcast'] := dr.BCMedhiaStr;

    if dr.DateTime.Start.Mode = rrrdNormal then begin           // P񂫂̗\̏ꍇ
      s := '0';
    end
    else begin
      s := '1';
    end;
    FInfo.Values['maiyoubi_type'] := s;

    FInfo.Values['date'] := RdDateToPostStr(dr);
    FInfo.Values['start_hour'] := IntToStr(dr.DateTime.Start.Hou);
    FInfo.Values['start_minute'] := IntToStr(dr.DateTime.Start.Min);
    FInfo.Values['end_hour'] := IntToStr(dr.DateTime.Stop.Hou);
    FInfo.Values['end_minute'] := IntToStr(dr.DateTime.Stop.Min);

    s := FRdInfo.Media.Items.Modes[dr.RecMedia].Value;
    FInfo.Values['disc'] := s;

    FInfo.Values['folder'] := dr.Folder;

    s := FRdInfo.Rates.Items.Modes[dr.RecRate].Value;
    FInfo.Values['vrate'] := s;

    s := FRdInfo.Audio.Items.Modes[dr.RecAudio].Value;
    FInfo.Values['amode'] := s;

    // X|[c
    i := Ord(dr.SportExt);
    s := TRdSchedulelSportSendTbl[i];
    FInfo.Values['sport_ext'] := s;

    // ԑgǂ
    //s := IntToStr(Integer(dr.TitleLink));
    s := FRdInfo.TitleLink.Items.Modes[dr.TitleLink].Value;
    FInfo.Values['title_link'] := s;

    // 폜
    i := Integer(dr.AutoDel);
    FInfo.Values['auto_delete'] := TRdSchedulelAutoDelTbl[i];

    //
    s := FRdInfo.Dvdr.Items.Modes[dr.RecDvdr].Value;
    FInfo.Values['dvdr'] := s;

    // CI
    //s := TRdSchedulelAudioLineSendTbl[Ord(dr.AudioLine)];
    s := FRdInfo.LineVoice.Items.Modes[dr.AudioLine].Value;
    FInfo.Values['lVoice'] := s;

    FInfo.Values['edge_left'] := '0';

    // DVD-VideoL^ʔ
    //s := TRdSchedulelAspectSendTbl[Ord(dr.Aspect)];
    s := FRdInfo.Aspect.Items.Modes[dr.Aspect].Value;
    FInfo.Values['aspect'] := s;

    // DVD`v^[
    s := FRdInfo.DvdChapter.Items.Modes[dr.DvdChChapter].Value;
    FInfo.Values['bDvdAutoChapter'] := s;


    s := IntToStr((Integer(dr.HighRateSaved)));
    FInfo.Values['bVPerform'] := s;

    // `v^[
    //s := IntToStr((Integer(dr.SilentCut)*2));
    s := FRdInfo.MuteChapter.Items.Modes[dr.SilentCut].Value;
    FInfo.Values['bAutoChapter'] := s;

    // Dx
    s := FRdInfo.RecPriority.Items.Modes[dr.RecPriority].Value;
    FInfo.Values['rec_priority'] := s;

    // }WbN`v^[
    s := FRdInfo.MagicChapter.Items.Modes[dr.MagicChapter].Value;
    FInfo.Values['MagicChapter'] := s;

    // {Ҏ`v^[
    s := FRdInfo.CmChapter.Items.Modes[dr.CmChapter].Value;
    FInfo.Values['CM_Chapter'] := s;

    FInfo.Values['channel_no'] := dr.ChannelStr;

    FInfo.Values['edge_left'] := '0';
    FInfo.Values['dtv_sid'] := '0';
    FInfo.Values['dtv_nid'] := '0';
    FInfo.Values['net_link'] := '0';

    FInfo.Values['add_ch_text'] := '';
    FInfo.Values['add_ch_value'] := '';
    FInfo.Values['sport_ext_submit'] := '1';
    FInfo.Values['title_link_submit'] := '1';
    FInfo.Values['end_form'] := '0';

    Sleep(100);    // ُp

    HttpPost(url);

  finally
    t.Free;
    tt.Free;
  end;
end;

function TGetRdXD91.RdDateToPostStr(dr: TDataRdRecReserveItem): string;
begin
  if dr.DateTime.Start.Mode = rrrdNormal then begin
    result := FormatDateTime('yyyy/mm/dd(aaa)',dr.DateTime.Start.DateTime);
  end
  else begin
    result := TRdSchedulelDateSendTbl[Ord(dr.DateTime.Start.Mode)];
  end;
end;

function TGetRdXD91.StrInfoToGenreMode(
  const str: string): TDataTvScheduleGenre;
const
  TblM : array[0..9] of TDataTvScheduleGenre =
           (rgMovie,rgMusic,rgDrama,rgAnime,rgSports,rgDocumentary,
                             rgTheater,rgHobby,rgVariety,rgEtc);
  TblS : array[0..9] of string =
           ('f','y','h}','Aj','X|[c','{','','','oGeB','̑');
var
  i : Integer;
begin
  result := rgEtc;
  for i := 0 to High(TblM) do begin
    if Pos(TblS[i],str) <> 0 then begin
      result := TblM[i];
      exit;
    end;
  end;
end;


end.
