unit GetRdX5;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,StringListKey,DataTvStatus,DataRdRecReserveDateTime,
  DataConfigRd,DataRdRecReserve,GetRdStanderd,DataRdRecReserveFolder,
  DataRdRecReserveChannel,DataRdRecReserveGenru,DataTvSchedule,
  DataRdRecReserveRate,DataRdRecReserveAudio,DataRdRecReserveMedia,
  DataRdRecReserveDvdr,DataRdRecReserveAspect,DataRdRecReserveChapterMultiVoice,
  DataRdRecReserveLineVoice,DataRdRecReserveEncode,DataTvScheduleGenre,
  DataRdRecReserveDvdChapter;

//--------------------------------------------------------------------------//
//  qc{NX                                                      //
//--------------------------------------------------------------------------//
type
  TGetRdX5 = class(TGetRdStanderd)
  private
    { Private 錾 }
    FFrameNo : Integer;              // qcƑMۂ̃t[ԍ
  protected

    procedure GetFrameNoSend();override;
    procedure GetFrameNoRec(const str : string);override;

    procedure GetRecListSend();override;
    procedure GetRecListRec(const str : string);override;

    procedure GetRecRateSend();override;
    procedure GetRecRateRec(const str : string);override;

    procedure GetRecRateInfoSend();override;
    procedure GetRecRateInfoRec(const str : string);override;

    procedure RecEnterSend();override;
    procedure RecEnterRec(const str : string);override;

    procedure RecAddInfoSend();override;
    procedure RecAddInfoRec(const str : string);override;

    procedure RecAddEnterSend();override;
    procedure RecAddEnterRec(const str : string);override;

    procedure RecDelSend();override;
    procedure RecDelRec(const str : string);override;

    procedure RecRateChangeEvent();override;
    procedure RecAddNoGetEvent();override;

    procedure HttpPutEnter(aRdRec : TDataRdRecReserveItem);

    function RecoListHeadStr(No : Integer) : string;
    function StrRdHtmlToRecList(str : string) : Boolean;virtual;
    function HtmlTagFrame(var str : string) : string;

    procedure StrRdHtmlToDate(d : TDataRdRecReserveItem;const str : string);

    procedure StrToRdDate(dd : TDataRdRecReserveDateTimeEx;const str : string);
    procedure StrToRdTime(dd : TDataRdRecReserveDateTimeEx;const str : string);
    function StrToRate(const str : string) : TDataRdRecReserveRateItemMode;
    function StrToAudio(const str : string) : TDataRdRecReserveAudioItemMode;
    function StrToMedia(const str : string) : TDataRdRecReserveMediaItemMode;
    function StrToDvdr(const str : string) : TDataRdRecReserveDvdrItemMode;
    function StrToAspect(const str : string) : TDataRdRecReserveAspectItemMode;
    function StrToChapterMultiVoice(const str : string) : TDataRdRecReserveChapterMultiVoiceItemMode;
    function StrToLineVoice(const str : string) : TDataRdRecReserveLineVoiceItemMode;

    procedure StrRdHtmlToTime(d : TDataRdRecReserveItem;const str : string);
    procedure StrRdHtmlToRecMedia(d : TDataRdRecReserveItem;const str : string);
    procedure StrRdHtmlToRecRate(d : TDataRdRecReserveItem;const str : string);
    procedure StrRdHtmlToRecAudio(d : TDataRdRecReserveItem;const str : string);
    procedure StrRdHtmlToEncode(d : TDataRdRecReserveItem;const str : string);

    function  StrRdHtmlToRecInfo(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoEncode(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoTitle(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoFolder(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoGenre(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoChannel(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoRate(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoAudio(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoMedia(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoDvd(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoAspect(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoChapterMultiVoice(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoLineVoice(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoDvdAutoChapter(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoComment(const str : string;dr : TDataRdRecReserveItem) : Boolean;
    function  StrRdHtmlToRecInfoDvdChapter(const str : string;dr : TDataRdRecReserveItem) : Boolean;

    function StrInfoToGenreMode(const str : string) : TDataTvScheduleGenre;

    //function TvToRd(dr : TDataRdRecReserveItem;dt : TDataTvScheduleItem) : Boolean;

    function HtmlStrToSelectValueTbl(const str : string;const aName : string;Tbl : array of string) : Integer;
    function HtmlStrToSelectValue(const str : string;const aName : string) : string;
    function HtmlStrToSelectIndex(const Value : string;Tbl : array of string) : Integer;

    function RdDateToStr(dr : TDataRdRecReserveItem) : string;

  public
    { Public 錾 }
    constructor Create;override;
    destructor Destroy;override;

    procedure RecListGet();override;
    procedure RecAdd(dr : TDataRdRecReserveItem);override;
    procedure RecInfo(dri : Integer);override;
    procedure RecChange(dri : Integer;dr : TDataRdRecReserveItem);override;
    procedure RecDel(dri : Integer);override;
    procedure RecChannel();override;
    procedure MatineInfoGet();override;
    function ConvertMsgToMail(rd : TDataRdRecReserveItem) : string ; override;

  end;

implementation

{ TGetRdX5 }

constructor TGetRdX5.Create;
begin
  inherited;
end;

destructor TGetRdX5.Destroy;
begin
  //FProcs.Free;
  inherited;

end;

procedure TGetRdX5.RecListGet;
const
  tbl : array[0..1] of TGetRdRecProcMode = (pmCheckFrameNo,pmRecListGet);
begin
  FProcs.Add(tbl);
  ProcStart();
end;

procedure TGetRdX5.RecAdd(dr: TDataRdRecReserveItem);
const
  tbl : array[0..6] of TGetRdRecProcMode= (pmCheckFrameNo,pmRecListGet,pmRecAddNoGet,
                                           pmRecRateHead,pmRecAddInfo,pmRecAddEnter,pmRecListGet);
begin

  FRdRec.Assign(dr);
  FProcs.Add(tbl);
  ProcStart();
end;

procedure TGetRdX5.RecDel(dri: Integer);
const
  tbl : array[0..5] of TGetRdRecProcMode= (pmCheckFrameNo,pmRecListGet,
                                           pmRecRateHead,pmRecRateInfo,pmRecDel,pmRecListGet);
begin
  FRdRec.AssignInfo(FRdRecs.Items[dri]);
  FCtrlRecIndex := dri;
  FProcs.Add(tbl);
  ProcStart();
end;

procedure TGetRdX5.RecInfo(dri: Integer);
const
  tbl : array[0..3] of TGetRdRecProcMode= (pmCheckFrameNo,pmRecListGet,
                                           pmRecRateHead,pmRecRateInfo);
begin
  inherited;
  FRdRec.AssignInfo(FRdRecs.Items[dri]);
  FCtrlRecIndex := dri;  // ^\ԍ擾
  FProcs.Add(tbl);
  ProcStart();
end;

procedure TGetRdX5.MatineInfoGet;
const
  tbl : array[0..3] of TGetRdRecProcMode= (pmCheckFrameNo,pmRecListGet,
                                           pmRecRateHead,pmRecRateInfo);
begin
  inherited;
  FCtrlRecIndex := 0;  // ^\ԍ擾
  FProcs.Add(tbl);
  ProcStart();
end;

procedure TGetRdX5.RecChange(dri: Integer; dr: TDataRdRecReserveItem);
const
  tbl : array[0..1] of TGetRdRecProcMode= (pmRecEnter,pmRecListGet);
begin
  FRdRec.Assign(dr);
  FCtrlRecIndex := dri;  // ^\ԍ擾
  FProcs.Add(tbl);
  ProcStart();
end;


procedure TGetRdX5.RecChannel;
const
  tbl : array[0..3] of TGetRdRecProcMode= (pmCheckFrameNo,pmRecListGet,
                                           pmRecRateHead,pmRecRateInfo);
begin

end;


//--------------------------------------------------------------------------//
//                                                                          //
//  `@t[ԍ擾邽߂URL𑗐M  `                           //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdX5.GetFrameNoSend;
var
  url : string;
begin
  url := '/program/b_prgrm.htm';
  FInfo.Clear;
  HttpGet(url);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@MHTMLt[ԍ擾  `                          //
//                                                                          //
//   - Input -  str : ͂HTML                                    //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdX5.GetFrameNoRec(const str : string);
var
  s,s2 : string;
begin
  s := str;
  StrPosSurroundLeftDelete(' scrolling="no">',
                           '',s);
  StrPosSurroundLeftDelete('"sub"',
                           '',s);
  s2 := StrPosSurroundLeftDelete('<frame src="/program/','/program.htm',s);
  FFrameNo := StrToIntDef(s2,0);
  ProcNext();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\ꗗ擾邽߂URL𑗐M  `                           //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdX5.GetRecListSend;
var
  url : string;
begin
  url :=  '/program/'+IntToStr(FFrameNo)+'/program.htm';
  FInfo.Clear;
  HttpGet(url);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@qc擾^\ꗗHTML  `                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdX5.GetRecListRec(const str: string);
var
  s,s1 : string;
  i : Integer;
  f : Boolean;
  t : TStringList;
begin
  FRdRecs.Items.Clear();

  t := TStringList.Create;
  try
    s := str;

    f := True;
    i := 1;
    while f do begin
      s1 := RecoListHeadStr(i);
      StrPosSurroundLeftDelete(s1,'',s);
      f := StrRdHtmlToRecList(s);
      Inc(i);
    end;
  finally
    t.Free;
  end;
  ProcNext();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\̏ڍ׏擾邽߂URL𑗐M  `                     //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdX5.GetRecRateSend;
var
  url,s2 : string;
begin

  s2 := IntToStr(FFrameNo);
  url := '/program/'+s2+'/b_proginfo.htm';
  s2 := ''+IntToStr(FCtrlRecIndex);

  FInfo.Clear;
  FInfo.Add(s2);
  HttpGet(url);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@qc擾^\ڍׂHTML  `                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdX5.GetRecRateRec(const str: string);
begin
 
  ProcNext();
end;

procedure TGetRdX5.GetRecRateInfoSend;
var
  url,s2 : string;
begin
  s2 := IntToStr(FFrameNo);
  url := '/program/'+s2+'/proginfo.htm';

  FInfo.Clear;
  HttpGet(url);
end;

procedure TGetRdX5.GetRecRateInfoRec(const str: string);
begin
  //StrRdHtmlToRecInfo(str,FRdRecs.Items[FCtrlRecIndex]);
  StrRdHtmlToRecInfo(str,FRdRec);
  ProcNext();
end;

procedure TGetRdX5.RecAddInfoSend;
var
  url,s2 : string;
begin
  s2 := IntToStr(FFrameNo);
  url := '/program/'+s2+'/proginfo.htm';

  FInfo.Clear;
  HttpGet(url);
end;

procedure TGetRdX5.RecAddInfoRec(const str: string);
begin
  ProcNext();
end;

procedure TGetRdX5.HttpPutEnter(aRdRec: TDataRdRecReserveItem);
var
  tt : TStringList;
  s,s3 : string;
  dr : TDataRdRecReserveItem;
begin
  dr := aRdRec;
  tt := TStringList.Create;
  try
      s3 :=  '/program/'+IntToStr(FFrameNo)+'/entry.htm';
      //s3 := 'entry.htm';
      FInfo.Clear;
      FInfo.Values['Decode'] := 'S';

      if dr.Execution then begin
        FInfo.Values['bExec'] := 'ON';
      end
      else begin
        FInfo.Values['bExec'] := 'OFF';
      end;

      FInfo.Values['title_name'] := dr.Title;

      if dr.Genre < FRdInfo.Genres.Items.Count then begin
        s := FRdInfo.Genres.Items[dr.Genre].Value;
        FInfo.Values['genre'] := s;
      end
      else begin
        s := IntToStr(dr.Genre);
        FInfo.Values['genre'] := s;
      end;

      FInfo.Values['channel']      := dr.ChannelStr;
      FInfo.Values['date']         := RdDateToStr(dr);
      FInfo.Values['start_hour']   := IntToStr(dr.DateTime.Start.Hou);
      FInfo.Values['start_minute'] := IntToStr(dr.DateTime.Start.Min);

      s := FRdInfo.Encode.Items.ModeToValue(dr.Encoder);
      FInfo.Values['enc_type']     := s;                     // `[i[I

      FInfo.Values['end_hour']     := IntToStr(dr.DateTime.Stop.Hou);
      FInfo.Values['end_minute']   := IntToStr(dr.DateTime.Stop.Min);

      s := FRdInfo.Media.Items.ModeToValue(dr.RecMedia);
      FInfo.Values['disc'] := s;

      s := FRdInfo.Rates.Items.ModeToValue(dr.RecRate);
      FInfo.Values['vrate'] := s;

      s := FRdInfo.Audio.Items.ModeToValue(dr.RecAudio);
      FInfo.Values['amode'] := s;
      FInfo.Values['gcode_name'] := '';

      s := FRdInfo.Dvdr.Items.ModeToValue(dr.RecDvdr);
      FInfo.Values['dvdr'] := s;

      s := FRdInfo.Aspect.Items.ModeToValue(dr.Aspect);
      FInfo.Values['aspect'] := s;

      FInfo.Values['bVPerform'] := IntToStr((Integer(dr.HighRateSaved)));
      FInfo.Values['bAutoChapter'] := IntToStr((Integer(dr.SilentCut)*2));

      s := FRdInfo.CapMultiVoice.Items.ModeToValue(dr.ChapMultiVoice);
      FInfo.Values['bAudioAutoChapter'] := s;
      FInfo.Values['folder'] := dr.Folder;

      // DVD`v^[
      s := FRdInfo.DvdChapter.Items.Modes[dr.DvdChChapter].Value;
      FInfo.Values['bDvdAutoChapter'] := s;
      // CI 
      s := FRdInfo.LineVoice.Items.Modes[dr.AudioLine].Value;
      FInfo.Values['lVoice'] := s;
      //FInfo.Values['lVoice'] := TRdSchedulelAudioLineSendTbl[Ord(dr.AudioLine)];
      FInfo.Values['detail'] := dr.Comment;
      FInfo.Values['dtv_sid'] := '0';
      FInfo.Values['dtv_nid'] := '0';
      FInfo.Values['net_link'] := '0';
      FInfo.Values['end_form'] := '0';

      HttpPost(s3);
  finally
    tt.Free;
  end;
end;


procedure TGetRdX5.RecEnterSend;
begin
  HttpPutEnter(FRdRec);
end;

procedure TGetRdX5.RecEnterRec(const str: string);
begin
  ProcNext();
end;

procedure TGetRdX5.RecAddEnterSend;
begin
  HttpPutEnter(FRdRec);
end;

procedure TGetRdX5.RecAddEnterRec(const str: string);
begin
  ProcNext();
end;

procedure TGetRdX5.RecDelSend;
var
  url,s2 : string;
begin
  s2 := IntToStr(FFrameNo);
  url := '/program/'+s2+'/delete.htm';
  s2 := ''+IntToStr(FCtrlRecIndex);
  FInfo.Clear;
  HttpGet(url);
  //HttpPutDelete(FRdRec);
end;

procedure TGetRdX5.RecDelRec(const str: string);
begin
  ProcNext();
end;


//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\񃊃Xg͂̂߂̕Ԃ@`                          //
//                                                                          //
//   - Input -  No : XgCfbNXԍ                                 //
//                                                                          //
//   - Output - ͂Ɏgp镶                                        //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetRdX5.RecoListHeadStr(No: Integer): string;
var
  s1,s2,s3 : string;
begin
  s1 := 'valign="middle" width="18" class="text">';
  s2 := IntToStr(No);
  s2 := Copy(s2,Length(s2)-1,Length(s2));
  s3 := '</td>';
  result := s1 + s2 + s3;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\Htmlf[^f[^ɒǉ@`                            //
//                                                                          //
//   - Input -  str : 擾^\Htmlf[^                            //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetRdX5.StrRdHtmlToRecList(str: string): Boolean;
var
  sed,sn,sc,sd,st,sm,sr,sa,se : string;
  d : TDataRdRecReserveItem;
begin
  result := False;
  if str = '' then exit;
  sed:= StrPosSurroundLeftDelete('/img/parts/check_','.gif',str);
  StrPosToLeftDelete('b_proginfo.htm',str);

  sn := StrPosSurroundLeftDelete('>','</a></td>',str);

  se := StrPosSurroundLeftDelete('/act_R','.gif',str);
  sc := HtmlTagFrame(str);
  if sc = '---' then exit;
  if sc = '' then exit;
  sd := HtmlTagFrame(str);
  st := HtmlTagFrame(str);
  sm := HtmlTagFrame(str);
  sr := HtmlTagFrame(str);
  sa := HtmlTagFrame(str);

  sn := StringReplace(sn,'<br>','',[rfreplaceall, rfIgnoreCase]);         // ^CgQŝƂ̑΍
  sn := StringReplace(sn,'<BR>','',[rfreplaceall, rfIgnoreCase]);         // ^CgQŝƂ̑΍
  d := TDataRdRecReserveItem.Create;
  d.Execution := sed = 'on';
  d.Title := sn;
  d.Channel := sc;
  //d.StrRdHtmlToChannel(sc);
  StrRdHtmlToDate(d,sd);
  StrRdHtmlToTime(d,st);
  StrRdHtmlToRecMedia(d,sm);
  StrRdHtmlToRecRate(d,sr);
  StrRdHtmlToRecAudio(d,sa);
  StrRdHtmlToEncode(d,se);
  {
  d.EncodeNo := StrToIntDef(se,1)-1;
  case StrToIntDef(se,1) of
    1 : d.Encoder := encR1;
    2 : d.Encoder := encR2;
  end;
  }
  FRdRecs.Items.Add(d);

  result := True;
end;

function TGetRdX5.HtmlTagFrame(var str: string): string;
var
  s,sr : string;
begin
  sr := '';
  s := StrPosSurroundLeftDelete('<td','/td>',str);
  while (s <> '') and (Pos('>',s) <> 0) do begin
    sr := sr + StrPosSurroundLeftDelete('>','<',s);
  end;
  result := sr;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\񃊃XgHTML̓t\Lf[^pɕϊ@`                    //
//                                                                          //
//   - Input -  str : ͂HTML̓t                              //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdX5.StrRdHtmlToDate(d: TDataRdRecReserveItem;
  const str: string);
const
  DayTbl : array[0..10] of string = ('j','j','Ηj','j',
                                     'ؗj','j','yj',
                                     '','`','`','`y');
var
  i : Integer;
  dd : TDataRdRecReserveDateTimeEx;
  Mode : TDataRdRecReserveDateTimeMode;
begin
  Mode := rrrdNormal;
  dd := d.DateTime.Start;
  //dd.Mode := rrrdNormal;
  // Tǂ
  for i := 0 to High(DayTbl) do begin
    if DayTbl[i] = str then Mode := TDataRdRecReserveDateTimeMode(i+1);
  end;
  // łȂꍇ͓tƂĊi[
  if dd.Mode = rrrdNormal then begin
    StrToRdDate(dd,str);
  end;
  dd.Mode := Mode;               // T̔̂ߓtɎނ
  d.DateTime.Stop.Assign(dd);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\񃊃XgHTML̘^掞Ԃf[^pɕϊ@`                    //
//                                                                          //
//   - Input -  str : ͂HTML̘^掞ԕ                          //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdX5.StrRdHtmlToTime(d: TDataRdRecReserveItem;
  const str: string);
var
  s : string;
begin
  s := Copy(str,1,5);
  StrToRdTime(d.DateTime.Start,s);       // ^Jn
  s := Copy(str,7,5);
  StrToRdTime(d.DateTime.Stop,s);       // ^I
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\񃊃XgHTML̉\Lf[^pɕϊ@`                    //
//                                                                          //
//   - Input -  str : ͂HTML̉                              //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdX5.StrRdHtmlToRecAudio(d: TDataRdRecReserveItem;
  const str: string);
var
  i : Integer;
begin
  d.RecAudio := raM1;
  i := FRdInfo.Audio.Items.IndexOfList(str);
  if i = -1 then exit;
  d.RecAudio := FRdInfo.Audio.Items[i].Mode;
end;

procedure TGetRdX5.StrRdHtmlToEncode(d: TDataRdRecReserveItem;
  const str: string);
var
  i : Integer;
begin
  d.Encoder := encR1;
  i := StrToIntDef(str,1);
  case i of
    1: d.Encoder := encR1;
    2: d.Encoder := encR2;
  end;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\񃊃XgHTML̘^惁fBA\Lf[^pɕϊ@`            //
//                                                                          //
//   - Input -  str : ͂HTML̘^惁fBA                      //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdX5.StrRdHtmlToRecMedia(d: TDataRdRecReserveItem;
  const str: string);
var
  i : Integer;
begin
  i := FRdInfo.Media.Items.IndexOfList(str);
  if i = -1 then exit;
  d.RecMedia := FRdInfo.Media.Items[i].Mode;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\񃊃XgHTML̃[g\Lf[^pɕϊ@`                  //
//                                                                          //
//   - Input -  str : ͂HTML̘^惌[g                        //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdX5.StrRdHtmlToRecRate(d: TDataRdRecReserveItem;
  const str: string);
var
  i : Integer;
begin
  d.RecRate := rmSP;
  i := FRdInfo.Rates.Items.IndexOfList(str);
  if i = -1 then exit;
  d.RecRate := FRdInfo.Rates.Items[i].Mode;
end;

procedure TGetRdX5.StrToRdDate(dd: TDataRdRecReserveDateTimeEx;
  const str: string);
var
  s : string;
begin
  s := Copy(str,1,4);
  dd.Yer := StrToIntDef(s,0);
  s := Copy(str,6,2);
  dd.Mon := StrToIntDef(s,0);
  s := Copy(str,9,2);
  dd.Day := StrToIntDef(s,0);
end;

procedure TGetRdX5.StrToRdTime(dd: TDataRdRecReserveDateTimeEx;
  const str: string);
var
  s : string;
begin
  s := Copy(str,1,2);
  dd.Hou := StrToIntDef(s,0);
  s := Copy(str,4,2);
  dd.Min := StrToIntDef(s,0);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\ڍHTMLڍ׃f[^擾@`                        //
//                                                                          //
//   - Input -  str : MHTML                                              //
//              d   : f[^i[                                        //
//                                                                          //
//   - Output - True:I                                               //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetRdX5.StrRdHtmlToRecInfo(const str: string;
  dr : TDataRdRecReserveItem): Boolean;
begin
  // GR[h擾
  StrRdHtmlToRecInfoEncode(str,dr);

  // tH_擾
  StrRdHtmlToRecInfoFolder(str,dr);

  // W擾
  StrRdHtmlToRecInfoGenre(str,dr);

  // `l擾
  StrRdHtmlToRecInfoChannel(str,dr);

  // 掿[g擾
  StrRdHtmlToRecInfoRate(str,dr);

  // 擾
  StrRdHtmlToRecInfoAudio(str,dr);

  // L^fBA擾
  StrRdHtmlToRecInfoMedia(str,dr);

  // DVD݊[h
  StrRdHtmlToRecInfoDvd(str,dr);

  // DVDL^@ʔ䗦
  StrRdHtmlToRecInfoAspect(str,dr);

  // ^Cg
  StrRdHtmlToRecInfoTitle(str,dr);

  // d`v^[
  StrRdHtmlToRecInfoChapterMultiVoice(str,dr);

  // C
  StrRdHtmlToRecInfoLineVoice(str,dr);

  // DVD`v^[
  StrRdHtmlToRecInfoDvdAutoChapter(str,dr);

  // Rg
  StrRdHtmlToRecInfoComment(str,dr);


  // ڍ׏𓾂Ƃm点
  dr.InfoEnabled := True;

  FRdInfo.Changed := True;
  result := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\ڍHTML`lꗗ擾@`                    //
//                                                                          //
//   - Input -  str : MHTML                                              //
//              d   : f[^i[                                        //
//                                                                          //
//   - Output - True:I                                               //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetRdX5.StrRdHtmlToRecInfoChannel(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
  function StrToDelSp(const str : string) : string;
  var
    i : Integer;
    s : string;
  begin
    s := '';
    for i := 1 to Length(str) do begin
      if str[i] <> ' ' then s := s + str[i];
    end;
    result := s;
  end;
  procedure InfoToMode(dc : TDataRdRecReserveChannelItem);
  begin
    if Pos('SP',dc.Value) <> 0 then begin
      dc.Mode := cmCs;
      exit;
    end;
    case StrToIntDef(dc.Value,0) of
      100..120 : dc.Mode := cmBsAnalog;
      201..205 : dc.Mode := cmLine;
    else       dc.Mode := cmUvAnalog;
    end;

  end;
var
  s,st,sh1,sf1,sv,sn : string;
  f : Boolean;
  i : Integer;
  dc : TDataRdRecReserveChannelItem;
begin
  FRdInfo.Channels.Items.Clear;

  sh1 := 'name=channel>';
  sf1 := '</select>';

  s := StrPosSurround(sh1,sf1,str);  // `lf[^擾

  f := False;
  repeat                                                  // `lSĎ擾܂Ń[v
    st := StrPosSurroundLeftDelete('<option','option>',s);
    if st = '' then begin
      f := True;
    end
    else begin
      sv := StrPosSurroundLeftDelete('value="','"',st);        // `lipj擾
      i := Pos(' selected',st);
      sn := StrPosSurroundLeftDelete('>','<',st);               // `li\pj擾
      sv := StringReplace(sv,' ','',[rfreplaceall]);
      dc := FRdInfo.Channels.Items.Add();                             // `lƂĒǉ
      dc.NameInfo := sn;
      dc.NameList := StrToDelSp(sn);
      dc.Value := sv;
      InfoToMode(dc);
      if i > 0 then begin
        dr.ChannelStr := sv;
      end;
    end;
  until f = True;

  result := True;
end;

function TGetRdX5.StrToRate(
  const str: string): TDataRdRecReserveRateItemMode;
const
  Tblm : array[0..43] of TDataRdRecReserveRateItemMode =
                                  (rmSP,rmLP,rmJust,
                                   rmA1,rmA2,
                                   rm10,rm14,
                                   rm20,rm22,rm24,rm26,rm28,
                                   rm30,rm32,rm34,rm36,rm38,
                                   rm40,rm42,rm44,rm46,rm48,
                                   rm50,rm52,rm54,rm56,rm58,
                                   rm60,rm62,rm64,rm66,rm68,
                                   rm70,rm72,rm74,rm76,rm78,
                                   rm80,rm82,rm84,rm86,rm88,
                                   rm90,rm92);
  Tbls :array[0..43] of string =
                                  ('SP 4.4/4.6','LP 2.0/2.2','ެ',
                                   'A1','A2',
                                   'MN 1.0','MN 1.4',
                                   'MN 2.0','MN 2.2','MN 2.4','MN 2.6','MN 2.8',
                                   'MN 3.0','MN 3.2','MN 3.4','MN 3.6','MN 3.8',
                                   'MN 4.0','MN 4.2','MN 4.4','MN 4.6','MN 4.8',
                                   'MN 5.0','MN 5.2','MN 5.4','MN 5.6','MN 5.8',
                                   'MN 6.0','MN 6.2','MN 6.4','MN 6.6','MN 6.8',
                                   'MN 7.0','MN 7.2','MN 7.4','MN 7.6','MN 7.8',
                                   'MN 8.0','MN 8.2','MN 8.4','MN 8.6','MN 8.8',
                                   'MN 9.0','MN 9.2');
var
  i : Integer;
begin
  result := rmSP;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;

end;

function TGetRdX5.StrRdHtmlToRecInfoRate(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,sh,sf,st,sn,sv : string;
  f : Boolean;
  d : TDataRdRecReserveRateItem;
begin
  sh := ' name="vrate"';
  sf := '</select>';
  FRdInfo.Rates.Items.Clear;
  s := StrPosSurround(sh,sf,str);      // 掿[gꗗ擾

  repeat                                                  // `lSĎ擾܂Ń[v
    st := StrPosSurroundLeftDelete('<option','option>',s);
    if st = '' then break;

    sv := StrPosSurround('value="','"',st);        // Ŏgpl擾
    sv := StringReplace(sv,' ','',[rfreplaceall]);
    f := (Pos(' selected',st) <> 0);
    sn := StrPosSurround('>','<',st);              // \Ɏgpl擾

    d := FRdInfo.Rates.Items.Add();                // 掿[gƂĒǉ
    d.NameInfo := sn;
    d.NameList := sn;
    d.Value    := sv;
    d.Mode     := StrToRate(sn);                   // \p̕񂩂ǂ̉掿Ȃ̂
    if f then begin
      dr.RecRate := d.Mode;
    end;
  until s = '';

  result := True;
end;

function TGetRdX5.StrToAudio(
  const str: string): TDataRdRecReserveAudioItemMode;
const
  Tblm : array[0..2] of TDataRdRecReserveAudioItemMode =
                                  (raM1,raM2,raPCM);
  Tbls :array[0..2] of string =   ('M1','M2','PCM');
var
  i : Integer;
begin
  result := raM1;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdX5.StrRdHtmlToRecInfoAudio(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,sh,sf,st,sn,sv : string;
  f : Boolean;
  d : TDataRdRecReserveAudioItem;
begin
  sh := ' name=amode';
  sf := '</SELECT>';
  FRdInfo.Audio.Items.Clear;
  s := StrPosSurround(sh,sf,str);                   // ꗗ擾

  repeat                                                  // `lSĎ擾܂Ń[v
    st := StrPosSurroundLeftDelete('<OPTION','OPTION>',s);
    if st = '' then break;

    sv := StrPosSurround('value=',' ',st);        // Ŏgpl擾
    sv := StringReplace(sv,' ','',[rfreplaceall]);
    f := (Pos(' selected',st) <> 0);
    sn := StrPosSurround('>','<',st);              // \Ɏgpl擾

    d := FRdInfo.Audio.Items.Add();                // 掿[gƂĒǉ
    d.NameInfo := sn;
    d.NameList := sn;
    d.Value    := sv;
    d.Mode     := StrToAudio(sn);                   // \p̕񂩂ǂ̉掿Ȃ̂
    if f then begin
      dr.RecAudio := d.Mode;
    end;
  until s = '';
  result := True;
end;

function TGetRdX5.StrToMedia(
  const str: string): TDataRdRecReserveMediaItemMode;
const
  Tblm : array[0..1] of TDataRdRecReserveMediaItemMode =
                                  (rmHdd,rmDvd);
  Tbls :array[0..1] of string =   ('HDD','DVD');
var
  i : Integer;
begin
  result := rmHdd;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdX5.StrRdHtmlToRecInfoMedia(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,sh,sf,st,sn,sv : string;
  f : Boolean;
  d : TDataRdRecReserveMediaItem;
begin
  sh := ' name=disc';
  sf := '</SELECT>';
  FRdInfo.Media.Items.Clear;
  s := StrPosSurround(sh,sf,str);                   // ꗗ擾

  repeat                                                  // `lSĎ擾܂Ń[v
    st := StrPosSurroundLeftDelete('<OPTION','OPTION>',s);
    if st = '' then break;

    sv := StrPosSurround('value=',' ',st);        // Ŏgpl擾
    sv := StringReplace(sv,' ','',[rfreplaceall]);
    f := (Pos(' selected',st) <> 0);
    sn := StrPosSurround('>','<',st);              // \Ɏgpl擾

    d := FRdInfo.Media.Items.Add();                // 掿[gƂĒǉ
    d.NameInfo := sn;
    d.NameList := sn;
    d.Value    := sv;
    d.Mode     := StrToMedia(sn);                   // \p̕񂩂ǂ̉掿Ȃ̂
    if f then begin
      dr.RecMedia := d.Mode;
    end;
  until s = '';
  result := True;
end;

function TGetRdX5.StrToDvdr(
  const str: string): TDataRdRecReserveDvdrItemMode;
const
  Tblm : array[0..2] of TDataRdRecReserveDvdrItemMode =
                                  (dmOff,dmMain,dmSub);
  Tbls :array[0..2] of string =   ('','剹','');
var
  i : Integer;
begin
  result := dmOff;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdX5.StrRdHtmlToRecInfoDvd(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,sh,sf,st,sn,sv : string;
  f : Boolean;
  d : TDataRdRecReserveDvdrItem;
begin
  sh := ' name=dvdr';
  sf := '</select>';
  FRdInfo.Dvdr.Items.Clear;
  s := StrPosSurround(sh,sf,str);                   // ꗗ擾

  repeat                                                  // `lSĎ擾܂Ń[v
    st := StrPosSurroundLeftDelete('<option','option>',s);
    if st = '' then break;

    sv := StrPosSurround('value','>',st);        // Ŏgpl擾
    f := (Pos(' selected',st) <> 0);
    sv := StrPosSurround('"','"',sv);        
    //sv := StringReplace(sv,' ','',[rfreplaceall]);
    //sv := StringReplace(sv,'=','',[rfreplaceall]);
    //sv := StringReplace(sv,'"','',[rfreplaceall]);
    sn := StrPosSurround('>','<',st);              // \Ɏgpl擾
    sn := Trim(sn);

    d := FRdInfo.Dvdr.Items.Add();                // 掿[gƂĒǉ
    d.NameInfo := sn;
    d.NameList := sn;
    d.Value    := sv;
    d.Mode     := StrToDvdr(sn);                   // \p̕񂩂ǂ̉掿Ȃ̂
    if f then begin
      dr.RecDvdr := d.Mode;
    end;
  until s = '';
  result := True;
end;

function TGetRdX5.StrToAspect(
  const str: string): TDataRdRecReserveAspectItemMode;
const
  Tblm : array[0..1] of TDataRdRecReserveAspectItemMode =
                                  (ra4vs3,ra16vs9);
  Tbls :array[0..1] of string =   ('4:3Œ','16:9Œ');
var
  i : Integer;
begin
  result := ra4vs3;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdX5.StrRdHtmlToRecInfoAspect(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,sh,sf,st,sn,sv : string;
  f : Boolean;
  d : TDataRdRecReserveAspectItem;
begin
  sh := ' name=aspect';
  sf := '</SELECT>';
  FRdInfo.Aspect.Items.Clear;
  s := StrPosSurround(sh,sf,str);                   // ꗗ擾

  repeat                                                  // `lSĎ擾܂Ń[v
    st := StrPosSurroundLeftDelete('<OPTION','OPTION>',s);
    if st = '' then break;

    sv := StrPosSurround('value=',' ',st);        // Ŏgpl擾
    sv := StringReplace(sv,' ','',[rfreplaceall]);
    f := (Pos(' selected',st) <> 0);
    sn := StrPosSurround('>','<',st);              // \Ɏgpl擾

    d := FRdInfo.Aspect.Items.Add();                // 掿[gƂĒǉ
    d.NameInfo := sn;
    d.NameList := sn;
    d.Value    := sv;
    d.Mode     := StrToAspect(sn);                   // \p̕񂩂ǂ̉掿Ȃ̂
    if f then begin
      dr.Aspect := d.Mode;
    end;
  until s = '';
  result := True;
end;

function TGetRdX5.StrToChapterMultiVoice(
  const str: string): TDataRdRecReserveChapterMultiVoiceItemMode;
const
  Tblm : array[0..1] of TDataRdRecReserveChapterMultiVoiceItemMode =
                                  (rcmOff,rcmOn);
  Tbls :array[0..1] of string =   ('','');
var
  i : Integer;
begin
  result := rcmOff;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdX5.StrRdHtmlToRecInfoChapterMultiVoice(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,sh,sf,st,sn,sv : string;
  f : Boolean;
  d : TDataRdRecReserveChapterMultiVoiceItem;
begin
  sh := ' name=bAudioAutoChapter';
  sf := '</SELECT>';
  FRdInfo.CapMultiVoice.Items.Clear;
  s := StrPosSurround(sh,sf,str);                   // ꗗ擾

  repeat                                                  // `lSĎ擾܂Ń[v
    st := StrPosSurroundLeftDelete('<OPTION','OPTION>',s);
    if st = '' then break;

    sv := StrPosSurround('value=',' ',st);        // Ŏgpl擾
    sv := StringReplace(sv,' ','',[rfreplaceall]);
    f := (Pos(' selected',st) <> 0);
    sn := StrPosSurround('>','<',st);              // \Ɏgpl擾

    d := FRdInfo.CapMultiVoice.Items.Add();                // 掿[gƂĒǉ
    d.NameInfo := sn;
    d.NameList := sn;
    d.Value    := sv;
    d.Mode     := StrToChapterMultiVoice(sn);                   // \p̕񂩂ǂ̉掿Ȃ̂
    if f then begin
      dr.ChapMultiVoice := d.Mode;
    end;
  until s = '';
  result := True;
end;

function TGetRdX5.StrToLineVoice(
  const str: string): TDataRdRecReserveLineVoiceItemMode;
const
  Tblm : array[0..3] of TDataRdRecReserveLineVoiceItemMode =
                                  (rlvStereo,rlvLeft,rlvRight,rlvLeftAndRight);
  Tbls :array[0..3] of string =   ('XeI','L','R','+');
var
  i : Integer;
begin
  result := rlvStereo;
  for i := 0 to High(Tbls) do begin
    if Tbls[i] = str then begin
      result := Tblm[i];
      exit;
    end;
  end;
end;

function TGetRdX5.StrRdHtmlToRecInfoLineVoice(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,sh,sf,st,sn,sv : string;
  f : Boolean;
  d : TDataRdRecReserveLineVoiceItem;
begin
  sh := ' name=lVoice';
  sf := '</SELECT>';
  FRdInfo.LineVoice.Items.Clear;
  s := StrPosSurround(sh,sf,str);                   // ꗗ擾

  repeat                                                  // `lSĎ擾܂Ń[v
    st := StrPosSurroundLeftDelete('<OPTION','OPTION>',s);
    if st = '' then break;

    sv := StrPosSurround('value=',' ',st);        // Ŏgpl擾
    sv := StringReplace(sv,' ','',[rfreplaceall]);
    f := (Pos(' selected',st) <> 0);
    sn := StrPosSurround('>','<',st);              // \Ɏgpl擾

    d := FRdInfo.LineVoice.Items.Add();                // 掿[gƂĒǉ
    d.NameInfo := sn;
    d.NameList := sn;
    d.Value    := sv;
    d.Mode     := StrToLineVoice(sn);                   // \p̕񂩂ǂ̉掿Ȃ̂
    if f then begin
      dr.AudioLine := d.Mode;
    end;
  until s = '';
  result := True;
end;

function TGetRdX5.StrRdHtmlToRecInfoTitle(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s1 : string;
begin
  s1 := StrPosSurround('<input style="WIDTH: 405px" type=text name=title_name ','</TD>',str);
  s1 := StrPosSurround('value="','"',s1);
  dr.Title := s1;

  result := True;

end;

function TGetRdX5.StrRdHtmlToRecInfoEncode(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,st,sv : string;
  i : Integer;
begin

  FRdInfo.Encode.Assign(FRdDefine.Encode);
  st := StrPosSurround(' name=enc_type','</P>',str);
  repeat
    s := StrPosSurroundLeftDelete(' value','>',st);
    if s = '' then break;
    sv := StrPosSurround('"','"',s);
    i := StrToIntDef(sv,1);
    //f := Pos('checked',s) <> 0;
    case i of
      1: dr.Encoder := encR1;
      2: dr.Encoder := encR2;
    end;

  until st = '';
  result := True;
end;

function TGetRdX5.StrRdHtmlToRecInfoFolder(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,st,sf,sv,sn : string;
  d : TDataRdRecReserveFolderItem;
  f : Boolean;
begin

  FRdInfo.Folders.Items.Clear;                                     // tH_f[^

  s := StrPosSurround('function setFolder(code){','</script>',str);  // tH_f[^擾
  st := StrPosSurround('if (code=="0"){','}'#$0d,s);

  f := False;
  repeat                                                      // tH_SĎ擾܂Ń[v
    sf := StrPosSurroundLeftDelete('].text="','"',st);        // tH_i\pj擾
    if sf = '' then begin                                     // 擾łȂꍇ
      f := True;                                              // [vEo
    end
    else begin                                                // 擾łꍇ
      sn := sf;
      sv := StrPosSurroundLeftDelete('.value="','"',st);      // tH_ipj擾
      d := FRdInfo.Folders.Items.Add();                       // tH_ƂĒǉ
      d.NameInfo := sn;
      d.Value    := sv;
    end;
  until f = True;

  s := StrPosSurround('function onLoadFolder(){','}',str);
  sv := StrPosSurround('.value=="','"',s);
  //s := StrPosSurround('function setFolder(code){','</script>',str);  // tH_f[^擾
  //st := StrPosSurround('if (code=="1" || code=="2"){','}',s);
  //sv := StrPosSurround('.value="','"',st);
  dr.Folder := sv;

  result := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\ڍHTMLWꗗ擾@`                      //
//                                                                          //
//   - Input -  str : MHTML                                              //
//              d   : f[^i[                                        //
//                                                                          //
//   - Output - True:I                                               //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetRdX5.StrRdHtmlToRecInfoGenre(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,st,sn,sv : string;
  f : Boolean;
  i : Integer;
  d : TDataRdRecReserveGenreItem;
begin
                                                              // Wꗗ
  FRdInfo.Genres.Items.Clear;

  s := StrPosSurround(' name=genre>','</select>',str);       // Wf[^擾
  f := False;
  repeat
    st := StrPosSurroundLeftDelete('<option','/option>',s);  // Pf[^擾
    i := Pos(' selected',st);
    if st = '' then break;
    sv := StrPosSurround('value="','"',st);
    sn := StrPosSurround('>','<',st);
    d := FRdInfo.Genres.Items.Add();
    d.NameInfo := sn;
    d.Value    := sv;
    d.Mode := StrInfoToGenreMode(sn);
    if i > 0 then begin
      dr.Genre := StrToIntDef(sv,0);
    end;
  until f = True;                                            // WSĎ擾܂Ń[v

  result := True;
end;

function TGetRdX5.HtmlStrToSelectValueTbl(const str, aName: string;
  Tbl: array of string): Integer;
var
  s : string;
  i : Integer;
begin
  s := HtmlStrToSelectValue(str,aName);
  i := HtmlStrToSelectIndex(s,Tbl);
  result := i;

end;

function TGetRdX5.StrRdHtmlToRecInfoDvdAutoChapter(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,st,sn,sv : string;
  f : Boolean;
  i,j : Integer;
  d : TDataRdRecReserveDvdChapterItem;
begin
                                                              // DVD`v^[Ԉꗗ
  FRdInfo.DvdChapter.Items.Clear;

  s := StrPosSurround(' name=bDvdAutoChapter>','</SELECT>',str);       // DVD`v^[ԕ擾
  f := False;
  j := 0;
  repeat
    st := StrPosSurroundLeftDelete('<OPTION','/OPTION>',s);  // Pf[^擾
    i := Pos(' selected',st);
    if st = '' then break;
    sv := StrPosSurround('value="','"',st);
    sn := StrPosSurround('>','<',st);
    d := FRdInfo.DvdChapter.Items.Add();
    d.NameInfo := sn;
    d.Value    := sv;
    d.Mode := TDataRdRecReserveDvdChapterItemMode(j);
    if i > 0 then begin
      dr.DvdChChapter := TDataRdRecReserveDvdChapterItemMode(j);
    end;
    Inc(j);
  until f = True;                                            // DVD`v^[ԂSĎ擾܂Ń[v

  result := True;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\ڍHTMLRgf[^擾@`                    //
//                                                                          //
//   - Input -  str : MHTML                                              //
//              dr   : f[^i[                                       //
//                                                                          //
//   - Output - True:I                                               //
//                                                                          //
//--------------------------------------------------------------------------//
function TGetRdX5.StrRdHtmlToRecInfoComment(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s1 : string;
begin
  s1 := StrPosSurround('<textarea name=detail','</p>',str);
  s1 := StrPosSurround('</SCRIPT>'+#$0d#$0a,'<',s1);
  dr.Comment := s1;

  result := True;
end;

function TGetRdX5.StrRdHtmlToRecInfoDvdChapter(const str: string;
  dr: TDataRdRecReserveItem): Boolean;
var
  s,st,sf,sv,sn : string;
  d : TDataRdRecReserveDvdChapterItem;
  f : Boolean;
  i : Integer;
begin

  FRdInfo.DvdChapter.Items.Clear;                                     // tH_f[^

  s := StrPosSurround('function setFolder(code){','</script>',str);  // tH_f[^擾
  st := StrPosSurround('if (code=="0"){','}'#$0d,s);

  f := False;
  repeat                                                      // tH_SĎ擾܂Ń[v
    sf := StrPosSurroundLeftDelete('].text="','"',st);        // tH_i\pj擾
    if sf = '' then begin                                     // 擾łȂꍇ
      f := True;                                              // [vEo
    end
    else begin                                                // 擾łꍇ
      sn := sf;
      sv := StrPosSurroundLeftDelete('.value="','"',st);      // tH_ipj擾
      d := FRdInfo.DvdChapter.Items.Add();                       // tH_ƂĒǉ
      d.NameInfo := sn;
      d.Value    := sv;
    end;
  until f = True;

  s := StrPosSurround('function onLoadFolder(){','}',str);
  sv := StrPosSurround('.value=="','"',s);
  i := StrToIntDef(sv,0);
  dr.DvdChChapter := TDataRdRecReserveDvdChapterItemMode(i);

  result := True;
end;

function TGetRdX5.HtmlStrToSelectValue(const str, aName: string): string;
var
  s,ss,sv,svn : string;
begin
  result := '';
  ss := str;
  s := StrPosSurroundLeftDelete('<select name="'+aName + '"','</select>',ss);
  sv := StrPosSurroundLeftDelete('<option value=','</option>',s);
  while sv <> '' do begin
    svn := StrPosSurroundLeftDelete('"','"',sv);
    if Pos('selected>',sv)<>0 then begin
      result := svn;
      break;
    end;
    sv := StrPosSurroundLeftDelete('<option value=','</option>',s);
  end;
end;

function TGetRdX5.HtmlStrToSelectIndex(const Value: string;
  Tbl: array of string): Integer;
var
  i : Integer;
begin
  result := 0;
  for i := 0 to High(Tbl) do begin
    if Tbl[i] = Value then begin
      result := i;
      exit;
    end;
  end;
end;

procedure TGetRdX5.RecRateChangeEvent;
begin
  DoRecChange(FRdRec);
end;

procedure TGetRdX5.RecAddNoGetEvent;
begin
  FCtrlRecIndex := FRdRecs.Items.Count;  // ԍŌ̘^\ԍ擾
  ProcNext();
end;

function TGetRdX5.RdDateToStr(dr: TDataRdRecReserveItem): string;
var
  dd : TDataRdRecReserveDateTimeEx;
begin
  dd := dr.DateTime.Start;
  if dd.Mode = rrrdNormal then begin
    result := FormatDateTime('yyyy/mm/dd(aaa)',dd.DateTime);
  end
  else begin
    result := TRdSchedulelDateSendTbl[Ord(dd.Mode)];
  end;
end;
(*
function TGetRdX5.TvToRd(dr: TDataRdRecReserveItem;
  dt: TDataTvScheduleItem): Boolean;
var
  i : Integer;
begin
  dr.Execution     := True;
  dr.Title         := dt.Title;
  if dt.TalkNo > 0 then begin
    dr.Title := dr.Title + ' #'+IntToStr(dt.TalkNo);
  end;

  i := RdConfig.Channels.IndexOfTvEx(dt.ChTv,dt.ChTvEx);
  if (i >= 0) and (i < RdConfig.Channels.Items.Count) then begin
    dr.ChannelStr := RdConfig.Channels.Items[i].Line;
  end;
  //dr.ChannelStr := Config.Channels.Items[dt.Channel].Line;

  dr.DateTime.Start.Yer     := dt.Start.Yer;
  dr.DateTime.Start.Mon     := dt.Start.Mon;
  dr.DateTime.Start.Day     := dt.Start.Day;
  dr.DateTime.Start.Hou     := dt.Start.Hou;
  dr.DateTime.Start.Min     := dt.Start.Min;

  dr.DateTime.Stop.Yer      := dt.Start.Yer;
  dr.DateTime.Stop.Mon      := dt.Start.Mon;
  dr.DateTime.Stop.Day      := dt.Start.Day;
  dr.DateTime.Stop.Hou      := dt.Stop.Hou;
  dr.DateTime.Stop.Min      := dt.Stop.Min;

  //    i := DMConfig.GenruItems.GenruTvStrToGenruNo(d.GenruStr);
  dr.Genre := 0;
  //dr.Genre         := DMConfig.GenruItems.GenruTvStrToGenruNo(tv.GenruStr);

  dr.RecRate := rmSP;
  dr.RecAudio := amM1;
  dr.RecMedia := mmHdd;
  dr.RecDvdr := dmMain;
  dr.HighRateSaved := False;
  dr.SilentCut := False;
  {
  dr.RecRate       := cd.RateItems[0].RecRate;
  rd.RecAudio      := cd.RateItems[0].RecAudio;
  rd.RecMedia      := cd.RateItems[0].RecMedia;
  rd.RecDvdr       := cd.RateItems[0].RecDvdr;
  rd.HighRateSaved := cd.RateItems[0].HighRateSaved;
  rd.SilentCut     := cd.RateItems[0].SilentCut;
  }
  dr.Comment       := dt.Comment;

  // vZ
  if dr.Status[tsmExtended].Value then begin
    dr.DateTime.Stop.IncMin(30);
  end;
  result := True;
end;
*)
function TGetRdX5.StrInfoToGenreMode(
  const str: string): TDataTvScheduleGenre;
const
  TblM : array[0..9] of TDataTvScheduleGenre =
           (rgMovie,rgMusic,rgDrama,rgAnime,rgSports,rgDocumentary,
                             rgTheater,rgHobby,rgVariety,rgEtc);
  TblS : array[0..9] of string =
           ('f','y','h}','Aj','X|[c','{','','','oGeB','̑');
var
  i : Integer;
begin
  result := rgEtc;
  for i := 0 to High(TblM) do begin
    if Pos(TblS[i],str) <> 0 then begin
      result := TblM[i];
      exit;
    end;
  end;

end;

function TGetRdX5.ConvertMsgToMail(rd : TDataRdRecReserveItem): string;
var
  dd : TDateTimeCtrl;
  s,str : string;
begin
  str := 'open %pass %date %time1 %time2 %ch %rate %audio ';

  ConvertMarkToData(str,'%pass',RdConfig.MailPassword);

  dd := rd.DateTime.Start;
  s := Format('%4.4d%2.2d%2.2d',[dd.Yer,dd.Mon,dd.Day]);
  ConvertMarkToData(str,'%date',s);
  s := Format('%2.2d%2.2d',[dd.Hou,dd.Min]);
  ConvertMarkToData(str,'%time1',s);

  dd := rd.DateTime.Stop;
  s := Format('%2.2d%2.2d',[dd.Hou,dd.Min]);
  ConvertMarkToData(str,'%time2',s);

  s := rd.Channel;
  ConvertMarkToData(str,'%ch',s);

  s := TDataRdRecReserveRateItemModeStrMail[Ord(rd.RecRate)];
  ConvertMarkToData(str,'%rate',s);

  s := TDataRdRecReserveAudioItemModeStrMail[Ord(rd.RecAudio)];
  ConvertMarkToData(str,'%audio',s);

  result := str;
end;

end.
