unit GetRdStanderd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,StringListKey,DataTvStatus,DataRdRecReserveDateTime,
  DataConfigRd,DataRdRecReserve,MultiEvent,DataTvSchedule,DataDefineRd,
  DataRdUsesChannel,DataRdRecReserveInfo,ProcPublicFileName,WinsockVHttpClient;

type
  TGetRdRecProcMode = (pmNil,pmCheckFrameNo,pmRecListGet,
                       pmRecRateHead,pmRecRateInfo,pmRecAddInfo,pmRecAddEnter,
                       pmRecRateChangeEvent,pmRecEnter,pmRecDel,pmRecAddNoGet,
                       pmRecInfoFrame);

const TGetRdRecProcTbl : array[0..11] of string =
                      ('','t[`FbN','^\񃊃Xg擾',
                       '\ڍ׎擾P','\ꗗ{擾','\ꗗ{擾','',
                       '','','','',
                       '');

type
  TGetRdStanderdRecChangeEvent = procedure(Sender : TObject;dr : TDataRdRecReserveItem) of object;

//--------------------------------------------------------------------------//
//  RD𑀍삷邽߂̎菇ǗNX                                  //
//--------------------------------------------------------------------------//
type
  TGetRdProcItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TGetRdRecProcMode;
  public
    { Public 錾 }
    procedure Add(t: array of TGetRdRecProcMode) ;
    property Items[Index: Integer] : TGetRdRecProcMode read GetItems;default;

  end;

//--------------------------------------------------------------------------//
//  qc{NX                                                      //
//--------------------------------------------------------------------------//
type
  TGetRdStanderd = class(TPersistent)
  private
    { Private 錾 }
    //FHttp : THttpGetPutV;                         // httpʐMNX
    FHttpV : TWinSockHttpVClient;
    FRdConfig : TDataConfigRdItem;                 // ʐMݒiXbhŏ邱Ƃl̂j
    FOnRecChange: TGetRdStanderdRecChangeEvent;
    FOnProcError: TNotifyEvent;
    FOnProcFinish: TNotifyEvent;
    FDebugRead : Boolean;
    //FOnReceive: TIdHttpExReceiveEvent;
    //FOnError: TNotifyEvent;
    FErrorCnt : Integer;

    procedure SetRdConfig(const Value: TDataConfigRdItem);

    procedure OnHttpReceive(Sender: TObject; ReceiveStr: string);
    procedure OnHttpError(Sender : TObject;Code : Integer);

    procedure ProcDebug();
  protected
    FInfo : TStringList;
    FProcs: TGetRdProcItems;         // qcւ̑菇Ǘ
    FProcIndex : Integer;            // ݏ̏菇ԍ
    FCtrlRecIndex: Integer;          // 삷\ԍiO`j
    FBusy : Boolean;                 // True : 
    FRdRecs : TDataRdRecReserve;      // \f[^ǗNXiQƁj
    FRdRec : TDataRdRecReserveItem;         // ^\o^sf[^
    FRdInfo : TDataRdRecReserveInfo;        // qcŎgp\ȃ`lꗗ
    FRdDefine : TDataDefineRdItem;     // qc̒`
    procedure HttpGet(const Url : string);
    procedure HttpPost(const Url : string);

    procedure ProcStart();
    procedure ProcNext();
    procedure ProcStop();
    procedure ProcErr();
    procedure ProcEvent();
    procedure ProcReceive(const str : string);

    procedure GetFrameNoSend();virtual;
    procedure GetFrameNoRec(const str : string);virtual;
    procedure GetFrameNoErr();virtual;

    procedure GetRecListSend();virtual;
    procedure GetRecListRec(const str : string);virtual;
    procedure GetRecListErr();virtual;

    procedure GetRecRateFrameSend();virtual;
    procedure GetRecRateFrameRec(const str : string);virtual;
    procedure GetRecRateFrameErr();virtual;

    procedure GetRecRateSend();virtual;
    procedure GetRecRateRec(const str : string);virtual;
    procedure GetRecRateErr();virtual;

    procedure GetRecRateInfoSend();virtual;
    procedure GetRecRateInfoRec(const str : string);virtual;
    procedure GetRecRateInfoErr();virtual;

    procedure RecEnterSend();virtual;
    procedure RecEnterRec(const str : string);virtual;
    procedure RecEnterErr();virtual;

    procedure RecAddInfoSend();virtual;
    procedure RecAddInfoRec(const str : string);virtual;
    procedure RecAddInfoErr();virtual;

    procedure RecAddEnterSend();virtual;
    procedure RecAddEnterRec(const str : string);virtual;
    procedure RecAddEnterErr();virtual;

    procedure RecDelSend();virtual;
    procedure RecDelRec(const str : string);virtual;
    procedure RecDelErr();virtual;

    procedure RecRateChangeEvent();virtual;
    procedure RecAddNoGetEvent();virtual;

    function ConvertMsgToMail(rd : TDataRdRecReserveItem) : string ; virtual;
    function ConvertMarkToData(var str: string;const mark,data : string) : string;

    procedure RecListGet();dynamic;
    procedure RecAdd(dr : TDataRdRecReserveItem);dynamic;
    procedure RecInfo(dri : Integer);dynamic;
    procedure RecChange(dri : Integer;dr : TDataRdRecReserveItem);dynamic;
    procedure RecDel(dri : Integer);dynamic;
    procedure RecChannel();dynamic;
    procedure MatineInfoGet();dynamic;

    procedure EventStop();

    procedure DoRecChange(dr : TDataRdRecReserveItem);
    procedure DoProcFinish();
    procedure DoProcError();

  public
    { Public 錾 }
    constructor Create;dynamic;
    destructor Destroy;override;

    property RdConfig : TDataConfigRdItem read FRdConfig write SetRdConfig;
    property RdRecs : TDataRdRecReserve read FRdRecs write FRdRecs;
    property RdRec : TDataRdRecReserveItem read FRdRec;
    property RdInfo : TDataRdRecReserveInfo read FRdInfo;
    property CtrlRecIndex : Integer read FCtrlRecIndex;

    // SetMatineCode ɂĎgp
    property OnRecChange : TGetRdStanderdRecChangeEvent read FOnRecChange write FOnRecChange;

    property OnProcFinish : TNotifyEvent read FOnProcFinish write FOnProcFinish;
    property OnProcError : TNotifyEvent read FOnProcError write FOnProcError;
  end;

//--------------------------------------------------------------------------//
//  qcNX                                                          //
//--------------------------------------------------------------------------//
type
  TGetRd = class(TPersistent)
  private
    { Private 錾 }
    FRdCtrl : TGetRdStanderd;                        // qcNXi@ɂĐNX͈قȂj
    FEngine: TDataDefineRdItemEngineMode;            // @R[h
    FOnRecChange: TGetRdStanderdRecChangeEvent;
    procedure SetConfig(const Value: TDataConfigRdItem);
    function GetConfig: TDataConfigRdItem;
    function GetBusy: Boolean;
    procedure SetRdRec(const Value: TDataRdRecReserve);
    function GetRdRec: TDataRdRecReserve;
    function GetOnProcError: TNotifyEvent;
    function GetOnProcFinish: TNotifyEvent;
    procedure SetOnProcError(const Value: TNotifyEvent);
    procedure SetOnProcFinish(const Value: TNotifyEvent);
    function GetRdInfo: TDataRdRecReserveInfo;
    procedure SetEngine(const Value: TDataDefineRdItemEngineMode);
    procedure SetRdInfo(const Value: TDataRdRecReserveInfo);
    function GetDefine: TDataDefineRdItem;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure RecList();
    procedure RecInfo(dri : Integer);
    procedure RecChange(dri : Integer;dr : TDataRdRecReserveItem);
    procedure RecAdd(dr : TDataRdRecReserveItem);
    //procedure RecAddTv(dt : TDataTvScheduleItem);
    procedure RecDel(dri : Integer);
    // qcŎgp\ȃ`lꗗ擾
    procedure RecChannel();
    procedure MatineInfoGet();
    // [\p쐬
    function ConvertMsgToMail(dr : TDataRdRecReserveItem) : string;

    property Engine : TDataDefineRdItemEngineMode read FEngine write SetEngine;
    property RdCtrl : TGetRdStanderd read FRdCtrl;
    property Config : TDataConfigRdItem read GetConfig write SetConfig;
    property Define : TDataDefineRdItem read GetDefine;
    property Busy : Boolean read GetBusy;
    property RdRec : TDataRdRecReserve read GetRdRec write SetRdRec;
    property RdInfo : TDataRdRecReserveInfo read GetRdInfo write SetRdInfo;

    property OnRecChange : TGetRdStanderdRecChangeEvent read FOnRecChange write FOnRecChange;

    // IɌĂ΂Cxg
    property OnProcFinish : TNotifyEvent read GetOnProcFinish write SetOnProcFinish;
    property OnProcError : TNotifyEvent read GetOnProcError write SetOnProcError;

  end;

implementation

uses GetRdX5,GetRdH1,GetRdXs46,GetRdH1Ex,GetRdXS48,GetRdXD91;

{ TGetRdStanderd }

constructor TGetRdStanderd.Create;
begin
  FInfo := TStringList.Create;
  FHttpV := TWinSockHttpVClient.Create;
  FHttpV.PortNo := 80;
  FHttpV.OnReceive := OnHttpReceive;
  FHttpV.OnError := OnHttpError;

  FRdConfig := TDataConfigRdItem.Create;
  FRdDefine := TDataDefineRdItem.Create;

//  FRdInfo := TDataRdRecReserveInfo.Create;
  FRdRec := TDataRdRecReserveItem.Create;
  //FRdRec.Info := FRdInfo;
  FProcs := TGetRdProcItems.Create;

end;

destructor TGetRdStanderd.Destroy;
begin
  FOnProcError := nil;
  FOnProcFinish := nil;
  FOnRecChange := nil;
  
//  FRdInfo.Free;
  FRdRec.Free;

  FRdDefine.Free;
  FRdConfig.Free;
  FHttpV.Free;
  FProcs.Free;
  FInfo.Free;
  inherited;
end;

procedure TGetRdStanderd.OnHttpError(Sender: TObject;Code : Integer);
begin
  ProcErr();
end;

procedure TGetRdStanderd.OnHttpReceive(Sender: TObject;
  ReceiveStr: string);
var
  t : TStringList;
  s,m : string;
  i : Integer;
begin
  if FRdConfig.DebugWrite then begin
    t := TStringList.Create;
    try
      i := Ord(FProcs[FProcIndex]);
      m := TGetRdRecProcTbl[i];
      if m <> '' then begin
        s := GetFilePathDebugWrite(FRdConfig.Name) + m + '.html';
        t.Text := ReceiveStr;
        t.SaveToFile(s);
      end;
    finally
      t.Free;
    end;
  end;
  ProcReceive(ReceiveStr);
  //FHttpV.Close();
end;

procedure TGetRdStanderd.DoProcError;
begin
  if Assigned(FOnProcError) then begin
    FOnProcError(Self);
    FOnProcError := nil;                     // xCxg𔭐͋
  end;
end;

procedure TGetRdStanderd.DoProcFinish;
begin
  if Assigned(FOnProcFinish) then begin
    FOnProcFinish(Self);
    FOnProcFinish := nil;                     // xCxg𔭐͋
  end;
end;

procedure TGetRdStanderd.DoRecChange(dr: TDataRdRecReserveItem);
begin
  if Assigned(FOnRecChange) then begin
    FOnRecChange(Self,dr);
    FOnRecChange := nil;                     // xCxg𔭐͋
  end;
end;


procedure TGetRdStanderd.EventStop;
begin
  FOnProcFinish := nil;
  FOnProcError  := nil;
end;

procedure TGetRdStanderd.HttpGet(const Url : string);
begin
  if not FRdConfig.DebugRead then begin
    FHttpV.PortNo := FRdConfig.Port;
    FHttpV.HostName := FRdConfig.Host;
    FHttpV.UrlName := Url;
    FHttpV.ExtraInfo.Assign(FInfo);
    FHttpV.UserName := FRdConfig.User;
    FHttpV.Password := FRdConfig.Password;

    FHttpV.Get();
    //FHttp.Get(FRdConfig.Port,FRdConfig.Host,Url,FRdConfig.User,FRdConfig.Password,Info);
  end
  else begin
    ProcDebug();
  end;

end;

procedure TGetRdStanderd.HttpPost(const Url : string);
begin
  if not FRdConfig.DebugRead then begin
    FHttpV.PortNo := FRdConfig.Port;
    FHttpV.HostName := FRdConfig.Host;
    FHttpV.UrlName := Url;
    FHttpV.ExtraInfo.Assign(FInfo);
    FHttpV.UserName := FRdConfig.User;
    FHttpV.Password := FRdConfig.Password;

    FHttpV.Post();

    //FHttp.Post(FRdConfig.Port,FRdConfig.Host,Url,FRdConfig.User,FRdConfig.Password,Info);
  end
  else begin
    ProcDebug();
  end;
end;


procedure TGetRdStanderd.ProcDebug;
var
  t : TStringList;
  s,m : string;
  i : Integer;
begin
  t := TStringList.Create;
  try
    i := Ord(FProcs[FProcIndex]);
    m := TGetRdRecProcTbl[i];
    if m <> '' then begin
      s := GetFilePathDebugRead(FRdConfig.Name) + m + '.html';
      t.LoadFromFile(s);
    end;
    ProcReceive(t.Text);
  finally
    t.Free;
  end;
end;

procedure TGetRdStanderd.RecAdd(dr: TDataRdRecReserveItem);
begin

end;

procedure TGetRdStanderd.RecChange(dri: Integer;
  dr: TDataRdRecReserveItem);
begin

end;

procedure TGetRdStanderd.RecChannel;
begin

end;

procedure TGetRdStanderd.RecDel(dri: Integer);
begin

end;

procedure TGetRdStanderd.RecInfo(dri: Integer);
begin
  FCtrlRecIndex := dri;
end;

procedure TGetRdStanderd.RecListGet;
begin

end;


procedure TGetRdStanderd.SetRdConfig(const Value: TDataConfigRdItem);
begin
  FRdConfig.Assign(Value);
end;

procedure TGetRdStanderd.MatineInfoGet;
begin

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@t[ԍ̎擾ɎsƂ̏  `                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdStanderd.GetFrameNoErr;
begin
  DoProcError();
end;

procedure TGetRdStanderd.GetFrameNoRec(const str: string);
begin

end;

procedure TGetRdStanderd.GetFrameNoSend;
begin

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\ꗗ̎擾ɎsƂ̏  `                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdStanderd.GetRecListErr;
begin
  DoProcError();
end;

procedure TGetRdStanderd.GetRecListRec(const str: string);
begin

end;

procedure TGetRdStanderd.GetRecListSend;
begin

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\ڍׂ̎擾ɎsƂ̏  `                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdStanderd.GetRecRateErr;
begin
  DoProcError();
end;

procedure TGetRdStanderd.GetRecRateInfoErr;
begin
  DoProcError();
end;

procedure TGetRdStanderd.GetRecRateInfoRec(const str: string);
begin

end;

procedure TGetRdStanderd.GetRecRateInfoSend;
begin

end;

procedure TGetRdStanderd.GetRecRateRec(const str: string);
begin

end;

procedure TGetRdStanderd.GetRecRateSend;
begin

end;

procedure TGetRdStanderd.RecAddEnterErr;
begin
  DoProcError();
end;

procedure TGetRdStanderd.RecAddEnterRec(const str: string);
begin

end;

procedure TGetRdStanderd.RecAddEnterSend;
begin

end;

procedure TGetRdStanderd.RecAddInfoErr;
begin
  DoProcError();
end;

procedure TGetRdStanderd.RecAddInfoRec(const str: string);
begin

end;

procedure TGetRdStanderd.RecAddInfoSend;
begin

end;

procedure TGetRdStanderd.RecAddNoGetEvent;
begin

end;

procedure TGetRdStanderd.RecDelErr;
begin
  DoProcError();
end;

procedure TGetRdStanderd.RecDelRec(const str: string);
begin

end;

procedure TGetRdStanderd.RecDelSend;
begin

end;

procedure TGetRdStanderd.RecEnterErr;
begin
  DoProcError();
end;

procedure TGetRdStanderd.RecEnterRec(const str: string);
begin

end;

procedure TGetRdStanderd.RecEnterSend;
begin

end;

procedure TGetRdStanderd.RecRateChangeEvent;
begin

end;

procedure TGetRdStanderd.GetRecRateFrameSend;
begin

end;

procedure TGetRdStanderd.GetRecRateFrameRec(const str: string);
begin

end;

procedure TGetRdStanderd.GetRecRateFrameErr;
begin
  DoProcError();
end;

procedure TGetRdStanderd.ProcErr;
var
  m : TGetRdRecProcMode;
begin
  if FErrorCnt < 2 then begin
    Inc(FErrorCnt);
    ProcEvent();
    exit;
  end;
  m := FProcs[FProcIndex];
  case m of
    pmCheckFrameNo : GetFrameNoErr();
    pmRecListGet   : GetRecListErr();
    pmRecRateHead  : GetRecRateErr();
    pmRecRateInfo  : GetRecRateInfoErr();
    pmRecEnter     : RecEnterErr();
    pmRecAddInfo   : RecAddInfoErr();
    pmRecAddEnter  : RecAddEnterErr();
    pmRecDel       : RecDelErr();
    pmRecInfoFrame : GetRecRateFrameErr();
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@̏菇(FProcs)ɏ]s@`                            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdStanderd.ProcEvent;
var
  m : TGetRdRecProcMode;
begin
  m := FProcs[FProcIndex];
  case m of
    pmCheckFrameNo       : GetFrameNoSend();
    pmRecListGet         : GetRecListSend();
    pmRecRateHead        : GetRecRateSend();
    pmRecRateInfo        : GetRecRateInfoSend();
    pmRecRateChangeEvent : RecRateChangeEvent();
    pmRecEnter           : RecEnterSend();
    pmRecAddInfo         : RecAddInfoSend();
    pmRecAddEnter        : RecAddEnterSend();
    pmRecDel             : RecDelSend();
    pmRecAddNoGet        : RecAddNoGetEvent();
    pmRecInfoFrame       : GetRecRateFrameSend();
  end;
end;

procedure TGetRdStanderd.ProcReceive(const str: string);
var
  m : TGetRdRecProcMode;
begin
  m := FProcs[FProcIndex];
  case m of
    pmCheckFrameNo : GetFrameNoRec(str);
    pmRecListGet   : GetRecListRec(str);
    pmRecRateHead  : GetRecRateRec(str);
    pmRecRateInfo  : GetRecRateInfoRec(str);
    pmRecEnter     : RecEnterRec(str);
    pmRecAddInfo   : RecAddInfoRec(str);
    pmRecAddEnter  : RecAddEnterRec(str);
    pmRecDel       : RecDelRec(str);
    pmRecInfoFrame : GetRecRateFrameRec(str);
  end;
end;

procedure TGetRdStanderd.ProcNext;
begin
  Inc(FProcIndex);
  if FProcIndex >= FProcs.Count then begin
    DoProcFinish();
    ProcStop();
  end
  else begin
    ProcEvent();
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@炩ߌ߂ꂽ菇(FProcs)ɏ]Jn@`            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdStanderd.ProcStart;
begin
  FBusy := True;
  FProcIndex := 0;
  FErrorCnt := 0;
  ProcEvent();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@菇I@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TGetRdStanderd.ProcStop;
begin
  FBusy := False;
  EventStop();
end;

function TGetRdStanderd.ConvertMsgToMail(rd : TDataRdRecReserveItem): string;
begin

end;

function TGetRdStanderd.ConvertMarkToData(var str: string; const mark,
  data: string): string;
var
  i : Integer;
  s1,s2 : string;
begin
  i := pos(mark,str);
  if i = 0 then exit;
  s1 := Copy(str,1,i-1);
  s2 := Copy(str,i+length(mark),length(str));
  str := s1 + data + s2;
end;

{ TGetRd }

constructor TGetRd.Create;
begin
  
end;

destructor TGetRd.Destroy;
begin
  if FRdCtrl <> nil then begin
    FRdCtrl.Free;
    FRdCtrl := nil;
  end;
  inherited;
end;

function TGetRd.GetBusy: Boolean;
begin
  result := FRdCtrl.FBusy;
end;

function TGetRd.GetConfig: TDataConfigRdItem;
begin
  result := FRdCtrl.RdConfig;
end;


function TGetRd.GetRdRec: TDataRdRecReserve;
begin
  result := nil;
  if FRdCtrl = nil then exit;
  result := FRdCtrl.FRdRecs;
end;

procedure TGetRd.RecInfo(dri: Integer);
begin
  FRdCtrl.RecInfo(dri);
end;

procedure TGetRd.RecChange(dri: Integer; dr: TDataRdRecReserveItem);
begin
  FRdCtrl.RecChange(dri,dr);
end;

procedure TGetRd.RecList;
begin
  FRdCtrl.RecListGet();
end;

procedure TGetRd.SetConfig(const Value: TDataConfigRdItem);
begin
  FRdCtrl.FRdConfig := Value;
end;

procedure TGetRd.SetEngine(const Value: TDataDefineRdItemEngineMode);
begin
  FEngine := Value;
  if FRdCtrl <> nil then begin
    FRdCtrl.Free;
    FRdCtrl := nil;
  end;
  case FEngine of
    reRD_X5   : FRdCtrl := TGetRdX5.Create;
    reRD_H1   : FRdCtrl := TGetRdH1.Create;
    reRD_XS46 : FRdCtrl := TGetRdX5.Create;
    reRD_H1EX : FRdCtrl := TGetRdH1Ex.Create;
    reRD_XS48 : FRdCtrl := TGetRdXS48.Create;
    reRD_XD91 : FRdCtrl := TGetRdXD91.Create;
  end;
  if FRdCtrl <> nil then begin
    FRdCtrl.OnRecChange := FOnRecChange;
  end;
end;


procedure TGetRd.SetRdRec(const Value: TDataRdRecReserve);
begin
  FRdCtrl.FRdRecs := Value;
end;

procedure TGetRd.RecAdd(dr: TDataRdRecReserveItem);
begin
  FRdCtrl.RecAdd(dr);
end;
  {
procedure TGetRd.RecAddTv(dt: TDataTvScheduleItem);
begin
  FRdCtrl.RecAddTv(dt);
end;
 }
function TGetRd.GetOnProcError: TNotifyEvent;
begin
  result := FRdCtrl.OnProcError;
end;

function TGetRd.GetOnProcFinish: TNotifyEvent;
begin
  result := FRdCtrl.OnProcFinish;
end;

procedure TGetRd.SetOnProcError(const Value: TNotifyEvent);
begin
  FRdCtrl.OnProcError := Value;
end;

procedure TGetRd.SetOnProcFinish(const Value: TNotifyEvent);
begin
  FRdCtrl.OnProcFinish := Value;
end;

function TGetRd.GetRdInfo: TDataRdRecReserveInfo;
begin
  result := FRdCtrl.FRdInfo;
end;

procedure TGetRd.RecDel(dri: Integer);
begin
  FRdCtrl.RecDel(dri);
end;

procedure TGetRd.RecChannel;
begin

end;

procedure TGetRd.MatineInfoGet;
begin
  FRdCtrl.MatineInfoGet();
end;

procedure TGetRd.SetRdInfo(const Value: TDataRdRecReserveInfo);
begin
  FRdCtrl.FRdInfo := Value;
end;

function TGetRd.GetDefine: TDataDefineRdItem;
begin
  result := FRdCtrl.FRdDefine;
end;

function TGetRd.ConvertMsgToMail(dr : TDataRdRecReserveItem): string;
begin
  result := FRdCtrl.ConvertMsgToMail(dr);
end;

{ TGetRdProcItems }

procedure TGetRdProcItems.Add(t: array of TGetRdRecProcMode);
var
  i : Integer;
begin
  Clear;
  for i := 0 to High(t) do begin
    inherited Add(Pointer(t[i]));
  end;

end;

function TGetRdProcItems.GetItems(Index: Integer): TGetRdRecProcMode;
begin
  result := TGetRdRecProcMode(inherited Items[Index]);
end;

end.
