unit FrameWebCMUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, SHDocVw,ProcPublicFileName;

type
  TFrameWebCM = class(TFrame)
    WebBrowserCM: TWebBrowser;
  private
    { Private 錾 }
    FWebStr : string;
    FSearchLogo: string;
    procedure CMRefresh();
    function DataLoad() : Boolean;
    function DataSave() : Boolean;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property SearchLogo : string read FSearchLogo write FSearchLogo;
  end;

implementation

{$R *.DFM}

{ TFrameWebCM }

constructor TFrameWebCM.Create(AOwner: TComponent);
begin
  inherited;
  DataLoad();
end;

destructor TFrameWebCM.Destroy;
begin
  inherited;
end;

procedure TFrameWebCM.Show;
var
  s : string;
begin
  s := GetFilePath() + 'default.htm';
  CMRefresh();
  DataSave();
  WebBrowserCM.Navigate(s);
end;

procedure TFrameWebCM.CMRefresh;
const
  sCM : string = 'planex_pci_';
  sCM2 : string = 'href="http://as.dc.impact-ad.jp/adclick/acc_random=';
  sCM3 : string = 'src="http://as.dc.impact-ad.jp/adclick/acc_random=';
var
  s : string;
  i,r : Integer;
begin
  Randomize;                       // 
  r := Random(8)+1;
  s := FWebStr;
  i := Pos(sCM2,s);
  s[i + Length(sCM2)] := Char($30 + r);
  i := Pos(sCM3,s);
  s[i + Length(sCM3)] := Char($30 + r);
  FWebStr := s;
end;

function TFrameWebCM.DataLoad: Boolean;
var
  s : string;
  t : TStringList;
begin
  t := TStringList.Create;
  try
    result := False;
    s := GetFilePath() + 'default.htm';
    if not FileExists(s) then exit;
    t.LoadFromFile(s);
    FWebStr := t.Text;
    result := True;
  finally
    t.Free;
  end;

end;

function TFrameWebCM.DataSave: Boolean;
var
  s : string;
  t : TStringList;
begin
  t := TStringList.Create;
  try
    s := GetFilePath() + 'default.htm';
    t.Text := FWebStr;
    t.SaveToFile(s);
    result := True;
  finally
    t.Free;
  end;
end;

end.
