unit FrameTvPaperUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     DateTimeCtrl, Menus,DataRd,
     DataTvSchedule,GetRdStanderd,PanelTvProgramColumn,PanelTvProgramDateList,
     PanelTvProgramColumnData,PanelTvProgramColumnConfig, ComCtrls,PanelTvList;

type
  TFrameTvPaper = class(TFrame)
    PMenu: TPopupMenu;
    N1: TMenuItem;
    MenuColumnConfig: TMenuItem;
    PCtrlTv: TPageControl;
    TabSheetTvGuide: TTabSheet;
    TabSheetTvList: TTabSheet;
    MenuRdRecDel: TMenuItem;
    MenuRdRecChange: TMenuItem;
    procedure PMenuPopup(Sender: TObject);
    procedure MenuColumnConfigClick(Sender: TObject);
    procedure FrameMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MenuRdRecDelClick(Sender: TObject);
    procedure MenuRdRecChangeClick(Sender: TObject);
    procedure TabSheetTvGuideShow(Sender: TObject);
  private
    { Private 錾 }
    //FPanelPaper : TPanelTvSchedulePaper;
    FConfig: TPanelTvProgramColumnConfig;       // ݒf[^NX
    FData : TPanelTvProgramColumnData;          // ԑgf[^NX

    FPanelPaper2 : TPanelTvProgramColumn;
    FPanelDate : TPanelTvProgramDateList;
    FPanelTvList : TPanelTvList;
    FMenuList : TList;
    FTv : TDataTvScheduleItem;
    FRdIndex : Integer;
    FRdRecIndex : Integer;
    FRdCtrl : TGetRdStanderd;
    procedure ShowMenu();
    Procedure MenuClear();

    procedure MakeTvData();

    procedure OnMenuRdRecClick(Sender: TObject);
    procedure OnDateListClick(Sender: TObject);
    procedure OnMinYChange(Sender: TObject);
    procedure OnRdRecChange(Sender : TObject);

  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    // ݒȂǂ̍ēǍ{\
    procedure Show();

    // zC[̂߂ɕKvȏ
    procedure ActiveCursor();

    // ݒύXOɌĂяoŃG[h~
    procedure Clear();

    // Iꂽǂԑg\ɔf
    procedure ColumnReLoad();
  end;

implementation

uses FormRdRateUnit,FormConfigUnit,FormConfigTvProgColumnChUnit,DMMenuUnit,
     DataRdRecReserve,FormMailRdUnit,DMUnit;

{$R *.DFM}

{ TFrameTvPaper }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TFrameTvPaper.Create(AOwner: TComponent);
var
  t : TDateTimeCtrl;
begin
  inherited;
  FConfig := TPanelTvProgramColumnConfig.Create;
  FConfig.DataLoad();
  FData := TPanelTvProgramColumnData.Create;

  FTv := TDataTvScheduleItem.Create;
  FMenuList := TList.Create;
  t := TDateTimeCtrl.Create;
  try
    t.DateTime := Now;                    // \Jnݎ
    //t.DecDay(DM.Config.Normal.OldDay);    // f[^\̂߂̒
    {
    FPanelPaper := TPanelTvSchedulePaper.Create(Self);
    FPanelPaper.Parent := Self;
    FPanelPaper.Align := alClient;
    FPanelPaper.DateTimeStart := t;
    FPanelPaper.PanelClient.OnPaintMouseDown := OnTvMouseDown;
    }

    FPanelDate := TPanelTvProgramDateList.Create(Self);
    FPanelDate.Parent := Self;
    FPanelDate.Align := alLeft;
    //FPanelDate.DateTimeStart.Assign(t);
    FPanelDate.Config := FConfig;
    FPanelDate.Data :=FData;
    FPanelDate.OnDateListClick := OnDateListClick;

    FPanelPaper2 := TPanelTvProgramColumn.Create(Self);
    FPanelPaper2.Parent := TabSheetTvGuide;
    FPanelPaper2.Align := alClient;
    //FPanelPaper2.DateTimeStart.Assign(t);

    FPanelPaper2.Config := FConfig;
    FPanelPaper2.Data :=FData;
    FPanelPaper2.OnMinChange := OnMinYChange;
    FPanelPaper2.PopupMenu := PMenu;

    FPanelTvList := TPanelTvList.Create(Self);
    FPanelTvList.Parent := TabSheetTvList;
    FPanelTvList.Align := alClient;
  finally
    t.Free;
  end;
end;

destructor TFrameTvPaper.Destroy;
begin
  FPanelDate.Free;
  FPanelPaper2.Free;
  //FPanelPaper.Free;
  MenuClear();
  FMenuList.Free;
  FTv.Free;
  FData.Free;
  FConfig.DataSave();
  FConfig.Free;
  inherited;
end;

procedure TFrameTvPaper.Show;
var
  t : TDateTimeCtrl;
begin
  t := TDateTimeCtrl.Create;
  try
    t.DateTime := Now;                    // \Jnݎ
    t.DecDay(DM.Config.Normal.OldDay);    // f[^\̂߂̒
    FPanelDate.DateTimeStart.Assign(t);
    FPanelPaper2.DateTimeStart.Assign(t);
    MakeTvData();
    FPanelPaper2.Show;
    FPanelDate.Show;
    FPanelTvList.Show();
    t.DateTime := Now;                    // \Jnݎ
    t.Sec := 0;
    t.Min := 0;
    FPanelPaper2.DateTimeView := t;
  finally
    t.Free;
  end;
end;

procedure TFrameTvPaper.Clear;
begin
  FData.Clear;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@qcւ̘^\񃁃j[NbNCxg@`                        //
//                                                                          //
//   - Input -  iȗj                                                    //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameTvPaper.OnMenuRdRecClick(Sender: TObject);
var
  dt : TDataTvScheduleItem;
  RDIndex : Integer;
  df : TFormRdRate;
  d : TDataRdItem;
begin
  RDIndex := TMenuItem(Sender).Tag;                       // ^\sqc擾
  dt := DM.CursorTv.Tv;                                   // ^\sԑgQ
  if dt = nil then exit;                                  // ԑgIԂȂ珈Ȃ
  df := TFormRdRate.Create(Self);                         // ^ݒʂ𐶐
  try
    df.RdInfo.Assign(DM.Rd.Items[RDIndex].GetRd.RdInfo);  // qc擾\pɑ
    df.Tv.Assign(dt);                                     // ԑg
    df.RdIndex := RDIndex;
    df.TvReced := True;
    if df.ShowModal = mrOk then begin
      d := DM.Rd.Items[df.RdIndex];
      d.GetRd.RecAdd(df.Rd);
    end;
  finally
    df.Free;                                              // ^ݒʂj
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Ǝɓo^ꂽj[@`                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameTvPaper.MenuClear;
var
  i : Integer;
begin
  for i := 0 to FMenuList.Count-1 do begin
    TMenuItem(FMenuList[i]).Free;
  end;
  FMenuList.Clear;
end;


//--------------------------------------------------------------------------//
//                                                                          //
//  `@^\RDj[ɓo^@`                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameTvPaper.ShowMenu;
var
  dmenu : TMenuItem;
  i : Integer;
  s : string;
begin
  MenuClear();                                 // Ǝɒǉ
  for i := 0 to DM.Rd.Items.Count-1 do begin  // gp\Ȃqc̑䐔[v
    s := DM.Rd.Items[i].GetRd.Config.Name;    // qĉ̖j[\p
    dmenu := TMenuItem.Create(Self);           // j[NX
    FMenuList.Add(dmenu);                      // ǉʓrL^Ă
    dmenu.Caption := s;                        // j[̕\po^
    dmenu.Tag := i;                            // CxgŎʂ邽߂̐lo^
    dmenu.OnClick := OnMenuRdRecClick;         // NbNCxgo^
    PMenu.Items[0].Add(dmenu);                 // Tuj[ƂĒǉ
  end;

end;


procedure TFrameTvPaper.PMenuPopup(Sender: TObject);
begin
  ShowMenu();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@tꗗNbNCxg@`                                        //
//                                                                          //
//   - Input -  iȗj                                                    //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameTvPaper.OnDateListClick(Sender: TObject);
var
  dd : TDateTimeCtrl;
begin
  dd := FPanelDate.SelectDateTime;    // NbNꂽӏ̓擾
  FPanelPaper2.DateTimeView := dd;    // 擪\Ƃ
  FPanelTvList.DateTimeView := dd;
  if PCtrlTv.ActivePage = TabSheetTvGuide then begin
    FPanelPaper2.ActiveCursor();        // ԑg\̃XN[o[ANeBu
  end;  
end;

procedure TFrameTvPaper.OnMinYChange(Sender: TObject);
begin
  FPanelDate.SelectDateTime := FConfig.DateTimeViewStart;
end;


procedure TFrameTvPaper.MakeTvData;
var
  i : Integer;
  ts : TDataTvScheduleItemsEx;
begin
  FData.Clear;
  ts := TDataTvScheduleItemsEx.Create;
  try
    for i := 0 to DM.TvSchedule.Items.Count-1 do begin
      ts.Add(DM.TvSchedule.Items[i]);
    end;
    FData.TvAdds(ts);
  finally
    ts.Free;
  end;

end;

procedure TFrameTvPaper.MenuColumnConfigClick(Sender: TObject);
var
  df : TFormConfigTvProgColumnCh;
begin
  df := TFormConfigTvProgColumnCh.Create(Self);
  try
    df.Config.Assign(FConfig);
    if df.ShowModal = mrOk then begin
      Visible := False;
      Clear;
      FConfig.Assign(df.Config);
      FConfig.DataSave();
      Show;
      Visible := True;
    end;
  finally
    df.Free;
  end;
end;

procedure TFrameTvPaper.ColumnReLoad;
begin
  FConfig.DataLoadDef();
end;


procedure TFrameTvPaper.FrameMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  p,p2 : TPoint;
begin
  if Button <> mbRight then exit;
  p.x := X;
  p.y := Y;
  p2 := ClientToScreen(p);
  DMMenu.PMenuRdRec.Popup(p2.x + 150 ,p2.y+ 20);
end;

procedure TFrameTvPaper.MenuRdRecDelClick(Sender: TObject);
var
  d : TDataRdItem;
  i,j : Integer;
  dr : TDataRdRecReserveItem;
begin

  if DM.CursorRd.Rd = nil then exit;
  for j := 0 to DM.Rd.Items.Count-1 do begin
    d := DM.Rd.Items[j];
    for i := 0 to d.RecReserve.Items.Count-1 do begin
      dr := d.RecReserve.Items[i];
      if dr = DM.CursorRd.Rd then begin
        d.GetRd.RecDel(i);
        exit;
      end;
    end;

  end;
end;

procedure TFrameTvPaper.MenuRdRecChangeClick(Sender: TObject);
var
  d : TDataRdItem;
  i,j : Integer;
  dr : TDataRdRecReserveItem;
begin

  if DM.CursorRd.Rd = nil then exit;
  for j := 0 to DM.Rd.Items.Count-1 do begin
    FRdIndex := j;
    d := DM.Rd.Items[j];
    FRdCtrl := d.GetRd.RdCtrl;
    for i := 0 to d.RecReserve.Items.Count-1 do begin
      dr := d.RecReserve.Items[i];
      if dr = DM.CursorRd.Rd then begin
        FRdRecIndex := i;
        d.GetRd.OnProcFinish := OnRdRecChange;
        d.GetRd.RecInfo(i);
        exit;
      end;
    end;

  end;
end;

procedure TFrameTvPaper.OnRdRecChange(Sender: TObject);
var
  df : TFormRdRate;
  d : TDataRdItem;
begin
  df := TFormRdRate.Create(Self);
  try
    df.Rd.Assign(FRdCtrl.RdRec);
    df.RdInfo.Assign(FRdCtrl.RdInfo);
    df.RdIndex := FRdIndex;
    d := DM.Rd.Items[FRdIndex];
    d.GetRd.OnProcFinish := nil;
    if df.ShowModal = mrOk then begin
      d.GetRd.RecChange(FRdRecIndex,df.Rd);
    end;
  finally
    df.Free;
  end;
end;

procedure TFrameTvPaper.TabSheetTvGuideShow(Sender: TObject);
begin
  FPanelPaper2.ActiveCursor();
end;

procedure TFrameTvPaper.ActiveCursor;
begin
  FPanelPaper2.ActiveCursor();
end;

end.
