unit FrameRdRecTitleUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,DataRdRecReserve,DataRdRecReserveInfo,DataRdRecReserveGenru;

type
  TFrameRdRecTitle = class(TFrame)
    ChkBoxExec: TCheckBox;
    Label1: TLabel;
    EditTitle: TEdit;
    Label2: TLabel;
    CBoxGenre: TComboBox;
    procedure ChkBoxExecClick(Sender: TObject);
    procedure EditTitleExit(Sender: TObject);
    procedure CBoxGenreChange(Sender: TObject);
  private
    { Private 錾 }
    FRd: TDataRdRecReserveItem;
    FRdInfo: TDataRdRecReserveInfo;
  public
    { Public 錾 }
    procedure Show();
    property Rd : TDataRdRecReserveItem read FRd write FRd;
    property RdInfo : TDataRdRecReserveInfo read FRdInfo write FRdInfo;
  end;

implementation

{$R *.DFM}

{ TFrameRdRecTitle }

procedure TFrameRdRecTitle.Show;
var
  i,j : Integer;
begin
  CBoxGenre.Clear;
  for i := 0 to FRdInfo.Genres.Items.Count-1 do begin
    j := StrToIntDef(FRdInfo.Genres.Items[i].Value,-1);
    CBoxGenre.Items.AddObject(FRdInfo.Genres.Items[i].NameInfo,FRdInfo.Genres.Items[i]);
    if FRd.Genre = j then begin
      CBoxGenre.ItemIndex := i;
    end;
  end;
  ChkBoxExec.Checked := FRd.Execution;
  EditTitle.Text := FRd.Title;
end;

procedure TFrameRdRecTitle.ChkBoxExecClick(Sender: TObject);
var
  f : Boolean;
begin
  f := TCheckBox(Sender).Checked;
  FRd.Execution := f;
end;

procedure TFrameRdRecTitle.EditTitleExit(Sender: TObject);
var
  s : string;
begin
  s := TEdit(Sender).Text;
  FRd.Title := s;
end;

procedure TFrameRdRecTitle.CBoxGenreChange(Sender: TObject);
var
  i : Integer;
  dc : TComboBox;
  dg : TDataRdRecReserveGenre;
begin
  dc := CBoxGenre;
  i := dc.ItemIndex;
  if i = -1 then exit;

  dg := FRdInfo.Genres;
  FRd.Genre := StrToIntDef(dg.Items[i].Value,0);

end;

end.
