unit FrameRdRecRateUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,DataRdRecReserve,DataRdRecReserveFolder,DataRdRecReserveInfo,
  DefaultData,DataRdRecReserveRate,DataRdRecReserveAudio,
  DataRdRecReserveDvdR;

type
  TFrameRdRecRate = class(TFrame)
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    CBoxRate: TComboBox;
    CBoxAudio: TComboBox;
    CBoxDvd: TComboBox;
    procedure CBoxRateClick(Sender: TObject);
    procedure CBoxAudioClick(Sender: TObject);
    procedure CBoxDvdClick(Sender: TObject);
  private
    { Private 錾 }
    FRdInfo: TDataRdRecReserveInfo;
    FRd: TDataRdRecReserveItem;
    procedure ShowAudio();
    procedure ViewAudio();
    procedure ShowDvd();
    procedure ViewDvd();
    procedure ShowRate();
    procedure ViewRate();
  public
    { Public 錾 }
    procedure Show();
    procedure View();
    property Rd : TDataRdRecReserveItem read FRd write FRd;
    property RdInfo : TDataRdRecReserveInfo read FRdInfo write FRdInfo;
  end;

implementation

{$R *.DFM}

{ TFrameRdRecRate }

procedure TFrameRdRecRate.Show;
begin
  ShowRate();
  ShowAudio();
  ShowDvd();
end;

procedure TFrameRdRecRate.View;
begin
  ViewRate();
  ViewAudio();
  ViewDvd();
end;

procedure TFrameRdRecRate.ShowAudio;
var
  dc : TComboBox;
begin
  dc := CBoxAudio;
  dc.Clear;
  dc.Items.AddObject('M1',Pointer(amM1));
  dc.Items.AddObject('M2',Pointer(amM2));
  dc.Items.AddObject('L-PCM',Pointer(amPCM));
end;

procedure TFrameRdRecRate.ShowDvd;
var
  dc : TComboBox;
begin
  dc := CBoxDvd;
  dc.Clear;
  dc.Items.AddObject('؂',Pointer(dmOff));
  dc.Items.AddObject('剹',Pointer(dmMain));
  dc.Items.AddObject('',Pointer(dmSub));
end;

procedure TFrameRdRecRate.ShowRate;
var
  dc : TComboBox;
begin
  dc := CBoxRate;
  dc.Clear;
  dc.Items.AddObject('SP',Pointer(rmSP));
  dc.Items.AddObject('LP',Pointer(rmLP));
  dc.Items.AddObject('A1',Pointer(rmA1));
  dc.Items.AddObject('A2',Pointer(rmA2));
  dc.Items.AddObject('MN1.0',Pointer(rm10));
  dc.Items.AddObject('MN1.4',Pointer(rm14));

  dc.Items.AddObject('MN2.0',Pointer(rm20));
  dc.Items.AddObject('MN2.2',Pointer(rm22));
  dc.Items.AddObject('MN2.4',Pointer(rm24));
  dc.Items.AddObject('MN2.6',Pointer(rm26));
  dc.Items.AddObject('MN2.8',Pointer(rm28));

  dc.Items.AddObject('MN3.0',Pointer(rm30));
  dc.Items.AddObject('MN3.2',Pointer(rm32));
  dc.Items.AddObject('MN3.4',Pointer(rm34));
  dc.Items.AddObject('MN3.6',Pointer(rm36));
  dc.Items.AddObject('MN3.8',Pointer(rm38));

  dc.Items.AddObject('MN4.0',Pointer(rm40));
  dc.Items.AddObject('MN4.2',Pointer(rm42));
  dc.Items.AddObject('MN4.4',Pointer(rm44));
  dc.Items.AddObject('MN4.6',Pointer(rm46));
  dc.Items.AddObject('MN4.8',Pointer(rm48));

  dc.Items.AddObject('MN5.0',Pointer(rm50));
  dc.Items.AddObject('MN5.2',Pointer(rm52));
  dc.Items.AddObject('MN5.4',Pointer(rm54));
  dc.Items.AddObject('MN5.6',Pointer(rm56));
  dc.Items.AddObject('MN5.8',Pointer(rm58));

  dc.Items.AddObject('MN6.0',Pointer(rm60));
  dc.Items.AddObject('MN6.2',Pointer(rm62));
  dc.Items.AddObject('MN6.4',Pointer(rm64));
  dc.Items.AddObject('MN6.6',Pointer(rm66));
  dc.Items.AddObject('MN6.8',Pointer(rm68));

  dc.Items.AddObject('MN7.0',Pointer(rm70));
  dc.Items.AddObject('MN7.2',Pointer(rm72));
  dc.Items.AddObject('MN7.4',Pointer(rm74));
  dc.Items.AddObject('MN7.6',Pointer(rm76));
  dc.Items.AddObject('MN7.8',Pointer(rm78));

  dc.Items.AddObject('MN8.0',Pointer(rm80));
  dc.Items.AddObject('MN8.2',Pointer(rm82));
  dc.Items.AddObject('MN8.4',Pointer(rm84));
  dc.Items.AddObject('MN8.6',Pointer(rm86));
  dc.Items.AddObject('MN8.8',Pointer(rm88));

  dc.Items.AddObject('MN9.0',Pointer(rm90));
  dc.Items.AddObject('MN9.2',Pointer(rm92));

end;

procedure TFrameRdRecRate.ViewAudio;
var
  i : Integer;
  rd1,rd2 : TDataRdRecReserveAudioItemMode;
  dc : TComboBox;
begin
  dc := CBoxAudio;
  rd1 := FRd.RecAudio;
  for i := 0 to dc.Items.Count-1 do begin
    rd2 := TDataRdRecReserveAudioItemMode(dc.Items.Objects[i]);
    if rd1 = rd2 then begin
      dc.ItemIndex := i;
      break;
    end;
  end;
end;

procedure TFrameRdRecRate.ViewDvd;
var
  i : Integer;
  rd1,rd2 : TDataRdRecReserveDvdrItemMode;
  dc : TComboBox;
begin
  dc := CBoxDvd;
  rd1 := FRd.RecDvdr;
  for i := 0 to dc.Items.Count-1 do begin
    rd2 := TDataRdRecReserveDvdrItemMode(dc.Items.Objects[i]);
    if rd1 = rd2 then begin
      dc.ItemIndex := i;
      break;
    end;
  end;
end;

procedure TFrameRdRecRate.ViewRate;
var
  i : Integer;
  rd1,rd2 : TDataRdRecReserveRateItemMode;
begin
  rd1 := FRd.RecRate;
  for i := 0 to CBoxRate.Items.Count-1 do begin
    rd2 := TDataRdRecReserveRateItemMode(CBoxRate.Items.Objects[i]);
    if rd1 = rd2 then begin
      CBoxRate.ItemIndex := i;
      break;
    end;
  end;
end;


procedure TFrameRdRecRate.CBoxRateClick(Sender: TObject);
var
  i : Integer;
  rate : TDataRdRecReserveRateItemMode;
  dc : TComboBox;
begin
  dc := CBoxRate;
  i := dc.ItemIndex;
  if i = -1 then exit;
  rate := TDataRdRecReserveRateItemMode(CBoxRate.Items.Objects[i]);
  FRd.RecRate := rate;
end;

procedure TFrameRdRecRate.CBoxAudioClick(Sender: TObject);
var
  i : Integer;
  audio : TDataRdRecReserveAudioItemMode;
  dc : TComboBox;
begin
  dc := CBoxAudio;
  i := dc.ItemIndex;
  if i = -1 then exit;
  audio := TDataRdRecReserveAudioItemMode(dc.Items.Objects[i]);
  FRd.RecAudio := audio;
end;

procedure TFrameRdRecRate.CBoxDvdClick(Sender: TObject);
var
  i : Integer;
  dvd : TDataRdRecReserveDvdrItemMode;
  dc : TComboBox;
begin
  dc := CBoxDvd;
  i := dc.ItemIndex;
  if i = -1 then exit;
  dvd := TDataRdRecReserveDvdrItemMode(dc.Items.Objects[i]);
  FRd.RecDvdr := dvd;
end;

end.
