//**************************************************************************//
//                                                                          //
//  qc̘^\ꗗŕ\j[ǗNX                    //
//                                                                          //
//**************************************************************************//
unit FrameRdRecListUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     PanelRdList,DMUnit, Menus,DataRd,GetRdStanderd,StringListKey,
     ProcPublicFileName,DataRdRecReserve,EventCursorRd;

type
  TFrameRdRecList = class(TFrame)
    PMenu: TPopupMenu;
    MenuRecChange: TMenuItem;
    MenuRecDel: TMenuItem;
    MenuRecReLoad: TMenuItem;
    MenuRdInfoGet: TMenuItem;
    N1: TMenuItem;
    MenuRdRecSave: TMenuItem;
    procedure MenuRecChangeClick(Sender: TObject);
    procedure MenuRecDelClick(Sender: TObject);
    procedure MenuRecReLoadClick(Sender: TObject);
    procedure MenuRdInfoGetClick(Sender: TObject);
    procedure MenuRdRecSaveClick(Sender: TObject);
  private
    { Private 錾 }
    FPanelList : TPanelRdList;       // ^\ꗗ\pplNX
    FRdIndex : Integer;              // \ύX̂qcCfbNX
    FRdRecIndex : Integer;           // \ύX̂qc\CfbNX
    FCursorRd : TEventCursorRd;
    FEventDisable : Boolean;
    procedure OnSelfListMouseDown(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure OnRdRecChange(Sender : TObject);
    procedure OnRdInfoGet(Sender : TObject);
    procedure OnCursorRdChange(Sender : TObject);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
  end;

implementation

uses FormRdRateUnit;

{$R *.DFM}

{ TFrameRdRecList }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TFrameRdRecList.Create(AOwner: TComponent);
begin
  inherited;
  FPanelList := TPanelRdList.Create(Self);
  FPanelList.Parent := Self;
  FPanelList.Align := alClient;
  FPanelList.OnListMouseDown := OnSelfListMouseDown;

  FCursorRd := TEventCursorRd.Create;
  FCursorRd.OnChange := OnCursorRdChange;
end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TFrameRdRecList.Destroy;
begin
  FCursorRd.Free;
  FPanelList.Free;
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@\@`                                                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TFrameRdRecList.Show;
begin
  FCursorRd.Cursor := DM.CursorRd;
  FPanelList.Rd := DM.Rd;
  FPanelList.Show;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\ꗗ̃}EXNbNCxg@`                                //
//                                                                          //
//   - Input -  ȗ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameRdRecList.OnSelfListMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  p,p2 : TPoint;
  i : Integer;
  dr : TDataRdRecReserveItem;
begin
  i := FPanelList.ItemIndex;      // XgJ[\ʒu擾
  if i = -1 then exit;            // IԂ̏ꍇȂ
  dr := TDataRdRecReserveItem(FPanelList.ListV.Items[i].Data);
  if dr = nil then exit;          // QƃNX݂Ȃꍇ
  FEventDisable := True;          // ̃CxgɔȂ悤ɏ
  DM.CursorRd.Rd := dr;           // qcIƂčXV
  FEventDisable := False;         // Cxg̔
  if Button <> mbRight then exit; // ENbNȊOȂ疢
  //ShowMenu();
  p.x := X;                       // |Cg^ɕϊ
  p.y := Y;
  p2 := ClientToScreen(p);        // ʕ\Wɕϊ
  PopupMenu.Popup(p2.x + 150 ,p2.y+ 20); // |bvAbvj[\
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\ύXj[NbNCxg@`                                //
//                                                                          //
//   - Input -  ȗ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameRdRecList.MenuRecChangeClick(Sender: TObject);
var
  d : TDataRdItem;
begin
  FRdIndex := DM.CursorRd.Rd.RdIndex;              // J[\ʒu̗\Ώۂqc̃CfbNX
  FRdRecIndex := DM.CursorRd.Rd.RdRecIndex;        // J[\ʒu̗\Ώۂqc̗\CfbNX
  d := DM.Rd.Items[FRdIndex];
  d.GetRd.OnProcFinish := OnRdRecChange;           // ĨCxg蓖
  d.GetRd.RecInfo(FRdRecIndex);                    // ڍ׏擾s
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\擾̐ICxg@`                              //
//                                                                          //
//   - Input -  ȗ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameRdRecList.OnRdRecChange(Sender: TObject);
var
  df : TFormRdRate;
  d : TDataRdItem;
  rdctrl : TGetRdStanderd;
begin
  rdctrl := TGetRdStanderd(Sender);         // \ʒmqcNX擾
  df := TFormRdRate.Create(Self);           // \ҏWtH[
  try
    df.Rd.Assign(rdctrl.RdRec);             // 擾\ҏWtH[ɑ
    df.RdInfo.Assign(rdctrl.RdInfo);        // 擾qc̊{ҏWtH[ɑ
    df.RdIndex := FRdIndex;                 // \擾qc̃CfbNX
    if df.ShowModal = mrOk then begin       // tH[̕\Anjꂽꍇ
      d := DM.Rd.Items[FRDIndex];           // ύXsqc̃NXQ
      d.GetRd.RecChange(FRdRecIndex,df.Rd); // qc̗\CfbNXƕҏWtH[ŕύXs
    end;
  finally
    df.Free;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\폜j[NbNCxg@`                                //
//                                                                          //
//   - Input -  ȗ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameRdRecList.MenuRecDelClick(Sender: TObject);
var
  d : TDataRdItem;
begin
  FRdIndex := DM.CursorRd.Rd.RdIndex;              // J[\ʒu̗\Ώۂqc̃CfbNX
  FRdRecIndex := DM.CursorRd.Rd.RdRecIndex;        // J[\ʒu̗\Ώۂqc̗\CfbNX
  d := DM.Rd.Items[FRdIndex];
  d.GetRd.RecDel(FRdRecIndex);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@\Ď擾j[NbNCxg@`                          //
//                                                                          //
//   - Input -  ȗ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameRdRecList.MenuRecReLoadClick(Sender: TObject);
var
  d : TDataRdItem;
begin
  FRdIndex := DM.CursorRd.Rd.RdIndex;              // J[\ʒu̗\Ώۂqc̃CfbNX
  d := DM.Rd.Items[FRdIndex];
  d.GetRd.RecList();
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@qc̊{Ď擾j[NbNCxg@`                    //
//                                                                          //
//   - Input -  ȗ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameRdRecList.MenuRdInfoGetClick(Sender: TObject);
var
  dr : TDataRdItem;
  i : Integer;
begin
  for i := 0 to DM.Rd.Items.Count-1 do begin
    dr := DM.Rd.Items[i];
    dr.GetRd.OnProcFinish := OnRdInfoGet;
    dr.GetRd.RecInfo(0);
  end;

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@qc̗\ۑj[NbNCxg@`                      //
//                                                                          //
//   - Input -  ȗ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameRdRecList.MenuRdRecSaveClick(Sender: TObject);
var
  tk : TStringListKey;
  s : string;
begin
  tk := TStringListKey.Create;
  try
    s := GetFilePathTemp() + 'rdrec.ini';
    DM.Rd.DataRecSave(tk);
    tk.SaveToFile(s);
  finally
    tk.Free;
  end;

  //
end;

procedure TFrameRdRecList.OnRdInfoGet(Sender: TObject);
begin
  DM.Rd.DataInfoSave();      // ǂݍ񂾂qc̏ۑ
end;

procedure TFrameRdRecList.OnCursorRdChange(Sender: TObject);
var
  i : Integer;
  dr : TDataRdRecReserveItem;
begin
  if FEventDisable then exit;
  for i := 0 to FPanelList.ListV.Items.Count-1 do begin
    dr := TDataRdRecReserveItem(FPanelList.ListV.Items[i].Data);
    if dr = DM.CursorRd.Rd then begin
      if FPanelList.ItemIndex <> i then begin
        FPanelList.ListV.ItemIndex := i;
      end;
    end;
  end;


end;

end.
