unit FrameRdRecFolderUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     StdCtrls,DataRdRecReserve,DataRdRecReserveFolder,DataRdRecReserveInfo,
     DefaultData,DataRdRecReserveMedia;

type
  TFrameRdRecFolder = class(TFrame)
    Label2: TLabel;
    CBoxFolder: TComboBox;
    CBoxMedhia: TComboBox;
    Label1: TLabel;
    procedure CBoxMedhiaClick(Sender: TObject);
    procedure CBoxFolderClick(Sender: TObject);
  private
    { Private 錾 }
    FRd: TDataRdRecReserveItem;
    FRdInfo: TDataRdRecReserveInfo;
    procedure ShowMedhia();
    procedure ViewMedhia();
    procedure ShowFolder();
    procedure ViewFolder();
  public
    { Public 錾 }
    procedure Show();
    procedure View();
    property Rd : TDataRdRecReserveItem read FRd write FRd;
    property RdInfo : TDataRdRecReserveInfo read FRdInfo write FRdInfo;
  end;

implementation

{$R *.DFM}

{ TFrameRdRecFolder }

procedure TFrameRdRecFolder.Show;
begin
  ShowFolder();
  ShowMedhia();
end;

procedure TFrameRdRecFolder.View;
begin
  ViewFolder();
  ViewMedhia();
end;

procedure TFrameRdRecFolder.ShowFolder;
var
  i : Integer;
  dc : TComboBox;
  df : TDataRdRecReserveFolder;
begin
  dc := CBoxFolder;
  df := FRdInfo.Folders;
  dc.Clear;
  for i := 0 to df.Items.Count-1 do begin
    dc.Items.AddObject(df.Items[i].NameInfo,df.Items[i]);
    if df.Items[i].Value = FRd.Folder then begin
      dc.ItemIndex := i;
    end;
  end;
end;

procedure TFrameRdRecFolder.ViewFolder;
var
  i : Integer;
  dc : TComboBox;
  df : TDataRdRecReserveFolder;
begin
  dc := CBoxFolder;
  df := FRdInfo.Folders;
  i := df.Items.IndexOfValue(FRd.Folder);
  if i = -1 then i := 0;
  dc.ItemIndex := i;
end;

procedure TFrameRdRecFolder.ShowMedhia;
var
  dc : TComboBox;
begin
  dc := CBoxMedhia;
  dc.Clear;
  dc.Items.AddObject('HDD',Pointer(Ord(mmHdd)));
  dc.Items.AddObject('DVD',Pointer(Ord(mmDvd)));
  dc.Items.AddObject('AB',Pointer(Ord(mmAB)));

end;

procedure TFrameRdRecFolder.ViewMedhia;
var
  i : Integer;
  dc : TComboBox;
begin
  dc := CBoxMedhia;
  for i := 0 to dc.Items.Count-1 do begin
    if FRd.RecMedia = TDataRdRecReserveMediaItemMode(dc.Items.Objects[i]) then begin
      dc.ItemIndex := i;
    end;
  end;

end;

procedure TFrameRdRecFolder.CBoxMedhiaClick(Sender: TObject);
var
  i : Integer;
  dc : TComboBox;
begin
  dc := CBoxMedhia;
  i := dc.ItemIndex;
  if i = -1 then exit;
  FRd.RecMedia := TDataRdRecReserveMediaItemMode(dc.Items.Objects[i]);
end;

procedure TFrameRdRecFolder.CBoxFolderClick(Sender: TObject);
var
  i : Integer;
  dc : TComboBox;
  df : TDataRdRecReserveFolder;
begin
  dc := CBoxFolder;
  df := FRdInfo.Folders;
  i := dc.ItemIndex;
  if i = -1 then exit;
  FRd.Folder := df.Items[i].Value;
end;

end.
