unit FrameRdRecEtcX5Unit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     StdCtrls,DataRdRecReserve,DataRdRecReserveFolder,DataRdRecReserveInfo,
     DefaultData,DataRdRecReserveChapterMultiVoice,DataRdRecReserveAspect,
     DataRdRecReserveLineVoice,DataRdRecReserveDvdChapter,DataRdRecReserveRecPriority,
     DataRdRecReserveMagicChapter,DataRdRecReserveMuteChapter,DataRdRecReserveCmChapter,
     DataRdRecReserveTitleLink;

type
  TFrameRdRecEtcX5 = class(TFrame)
    ChkBoxHighRateSaved: TCheckBox;
    CBoxAspect: TComboBox;
    GroupBox1: TGroupBox;
    ChkBoxSilentCut: TCheckBox;
    ChkBoxAudioAutoChapter: TCheckBox;
    Label10: TLabel;
    CBoxAudioLine: TComboBox;
    Label1: TLabel;
    CBoxDvdChapter: TComboBox;
    Label2: TLabel;
    CBoxRecPriority: TComboBox;
    Label3: TLabel;
    ChkBoxMagicChapter: TCheckBox;
    ChkBoxCmChapter: TCheckBox;
    ChkBoxTitleLink: TCheckBox;
    procedure CBoxAspectChange(Sender: TObject);
    procedure CBoxAudioLineChange(Sender: TObject);
    procedure ChkBoxHighRateSavedClick(Sender: TObject);
    procedure ChkBoxSilentCutClick(Sender: TObject);
    procedure ChkBoxAudioAutoChapterClick(Sender: TObject);
    procedure CBoxDvdChapterChange(Sender: TObject);
    procedure CBoxRecPriorityChange(Sender: TObject);
    procedure ChkBoxMagicChapterClick(Sender: TObject);
    procedure ChkBoxCmChapterClick(Sender: TObject);
    procedure ChkBoxTitleLinkClick(Sender: TObject);
  private
    FRdInfo: TDataRdRecReserveInfo;
    FRd: TDataRdRecReserveItem;
    { Private 錾 }
    procedure ShowAudioLine();
    procedure ViewAudioLine();
    procedure ShowDvdChapter();
    procedure ViewDvdChapter();
    procedure ShowAspect();
    procedure ViewAspect();
    procedure ShowRecPriority();
    procedure ViewRecPriority();
  public
    { Public 錾 }
    procedure Show();
    procedure View();
    property Rd : TDataRdRecReserveItem read FRd write FRd;
    property RdInfo : TDataRdRecReserveInfo read FRdInfo write FRdInfo;
  end;

implementation

{$R *.DFM}

{ TFrameRdRecEtcX5 }

procedure TFrameRdRecEtcX5.Show;
begin
  ShowAspect();
  ShowAudioLine();
  ShowDvdChapter();
  ShowRecPriority();
end;

procedure TFrameRdRecEtcX5.ShowAspect;
var
  dc : TComboBox;
begin
  dc := CBoxAspect;
  dc.Clear;
  dc.Items.AddObject('4:3',Pointer(ra4vs3));
  dc.Items.AddObject('16:9',Pointer(ra16vs9));
end;

procedure TFrameRdRecEtcX5.ShowAudioLine;
var
  dc : TComboBox;
begin
  dc := CBoxAudioLine;
  dc.Clear;
  dc.Items.AddObject('XeI',Pointer(rlvStereo));
  dc.Items.AddObject('k',Pointer(rlvLeft));
  dc.Items.AddObject('q',Pointer(rlvRight));
  dc.Items.AddObject('{',Pointer(rlvLeftAndRight));
end;

procedure TFrameRdRecEtcX5.ShowDvdChapter;
var
  dc : TComboBox;
  i : Integer;
  rd : TDataRdRecReserveDvdChapterItem;
begin
  dc := CBoxDvdChapter;
  dc.Clear;

  for i := 0 to FRdInfo.DvdChapter.Items.Count-1 do begin
    rd := FRdInfo.DvdChapter.Items[i];
    dc.Items.AddObject(rd.NameInfo,rd);
  end;
end;

procedure TFrameRdRecEtcX5.ShowRecPriority;
var
  dc : TComboBox;
  i : Integer;
  rd : TDataRdRecReserveRecPriorityItem;
begin
  dc := CBoxRecPriority;
  dc.Clear;

  for i := 0 to FRdInfo.RecPriority.Items.Count-1 do begin
    rd := FRdInfo.RecPriority.Items[i];
    dc.Items.AddObject(rd.NameInfo,rd);
  end;
end;

procedure TFrameRdRecEtcX5.View;
begin
  ChkBoxHighRateSaved.Checked    := FRd.HighRateSaved;
  ChkBoxAudioAutoChapter.Checked := (FRd.ChapMultiVoice = rcmOn);
  ChkBoxSilentCut.Checked        := (FRd.SilentCut = mcON);
  ChkBoxMagicChapter.Checked     := (FRd.MagicChapter = dmcOn);
  ChkBoxCmChapter.Checked        := (FRd.CmChapter = ccOn);
  ChkBoxTitleLink.Checked        := (FRd.TitleLink = dtlOn);
  ViewAspect();
  ViewAudioLine();
  ViewDvdChapter();
  ViewRecPriority();
end;

procedure TFrameRdRecEtcX5.ViewAspect;
var
  i : Integer;
  rd1,rd2 : TDataRdRecReserveAspectItemMode;
  dc : TComboBox;
begin
  dc := CBoxAspect;
  rd1 := FRd.Aspect;
  for i := 0 to dc.Items.Count-1 do begin
    rd2 := TDataRdRecReserveAspectItemMode(dc.Items.Objects[i]);
    if rd1 = rd2 then begin
      dc.ItemIndex := i;
      break;
    end;
  end;
end;

procedure TFrameRdRecEtcX5.ViewAudioLine;
var
  i : Integer;
  rd1,rd2 : TDataRdRecReserveLineVoiceItemMode;
  dc : TComboBox;
begin
  dc := CBoxAudioLine;
  rd1 := FRd.AudioLine;
  for i := 0 to dc.Items.Count-1 do begin
    rd2 := TDataRdRecReserveLineVoiceItemMode(dc.Items.Objects[i]);
    if rd1 = rd2 then begin
      dc.ItemIndex := i;
      break;
    end;
  end;
end;

procedure TFrameRdRecEtcX5.ViewDvdChapter;
var
  i : Integer;
  rd : TDataRdRecReserveDvdChapterItem;
  dc : TComboBox;
begin
  dc := CBoxDvdChapter;
  for i := 0 to dc.Items.Count-1 do begin
    rd := TDataRdRecReserveDvdChapterItem(dc.Items.Objects[i]);
    if FRd.DvdChChapter = rd.Mode then begin
      dc.ItemIndex := i;
      break;
    end;
  end;
end;

procedure TFrameRdRecEtcX5.ViewRecPriority;
var
  i : Integer;
  rd : TDataRdRecReserveRecPriorityItem;
  dc : TComboBox;
begin
  dc := CBoxRecPriority;
  for i := 0 to dc.Items.Count-1 do begin
    rd := TDataRdRecReserveRecPriorityItem(dc.Items.Objects[i]);
    if FRd.RecPriority = rd.Mode then begin
      dc.ItemIndex := i;
      break;
    end;
  end;
end;

procedure TFrameRdRecEtcX5.CBoxAspectChange(Sender: TObject);
var
  i : Integer;
  Aspect : TDataRdRecReserveAspectItemMode;
  dc : TComboBox;
begin
  dc := CBoxAspect;
  i := dc.ItemIndex;
  if i = -1 then exit;
  Aspect := TDataRdRecReserveAspectItemMode(dc.Items.Objects[i]);
  FRd.Aspect := Aspect;

end;

procedure TFrameRdRecEtcX5.CBoxAudioLineChange(Sender: TObject);
var
  i : Integer;
  Line : TDataRdRecReserveLineVoiceItemMode;
  dc : TComboBox;
begin
  dc := CBoxAudioLine;
  i := dc.ItemIndex;
  if i = -1 then exit;
  Line := TDataRdRecReserveLineVoiceItemMode(dc.Items.Objects[i]);
  FRd.AudioLine := Line;

end;

procedure TFrameRdRecEtcX5.ChkBoxHighRateSavedClick(Sender: TObject);
begin
  FRd.HighRateSaved := ChkBoxHighRateSaved.Checked;
end;

procedure TFrameRdRecEtcX5.ChkBoxSilentCutClick(Sender: TObject);
begin
  if ChkBoxSilentCut.Checked then begin
    FRd.SilentCut := mcON;
  end
  else begin
    FRd.SilentCut := mcOFF;
  end;
end;

procedure TFrameRdRecEtcX5.ChkBoxAudioAutoChapterClick(Sender: TObject);
var
  f : Boolean;
begin
  f := ChkBoxAudioAutoChapter.Checked;
  if f then begin
    FRd.ChapMultiVoice := rcmOn;
  end
  else begin
    FRd.ChapMultiVoice := rcmOff;
  end;
end;

procedure TFrameRdRecEtcX5.CBoxDvdChapterChange(Sender: TObject);
var
  i : Integer;
  dc : TComboBox;
  rd : TDataRdRecReserveDvdChapterItem;
begin
  dc := CBoxDvdChapter;
  i := dc.ItemIndex;
  if i = -1 then exit;
  rd := TDataRdRecReserveDvdChapterItem(dc.Items.Objects[i]);
  FRd.DvdChChapter := rd.Mode;

end;

procedure TFrameRdRecEtcX5.CBoxRecPriorityChange(Sender: TObject);
var
  i : Integer;
  dc : TComboBox;
  rd : TDataRdRecReserveRecPriorityItem;
begin
  dc := CBoxRecPriority;
  i := dc.ItemIndex;
  if i = -1 then exit;
  rd := TDataRdRecReserveRecPriorityItem(dc.Items.Objects[i]);
  FRd.RecPriority := rd.Mode;
end;

procedure TFrameRdRecEtcX5.ChkBoxMagicChapterClick(Sender: TObject);
var
  f : Boolean;
begin
  f := ChkBoxMagicChapter.Checked;
  if f then begin
    FRd.MagicChapter := dmcOn;
  end
  else begin
    FRd.MagicChapter := dmcOff;
  end;
end;

procedure TFrameRdRecEtcX5.ChkBoxCmChapterClick(Sender: TObject);
var
  f : Boolean;
begin
  f := ChkBoxMagicChapter.Checked;
  if f then begin
    FRd.CmChapter := ccOn;
  end
  else begin
    FRd.CmChapter := ccOff;
  end;
end;

procedure TFrameRdRecEtcX5.ChkBoxTitleLinkClick(Sender: TObject);
var
  f : Boolean;
begin
  f := ChkBoxTitleLink.Checked;
  if f then begin
    FRd.TitleLink := dtlOn;
  end
  else begin
    FRd.TitleLink := dtlOff;
  end;
end;

end.
