unit FrameRdRecDateUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,DataRdRecReserve,DataRdRecReserveDateTime;

type
  TFrameRdRecDate = class(TFrame)
    BtnDateDec: TButton;
    CBoxDate: TComboBox;
    EditDate: TEdit;
    BtnDateInc: TButton;
    BtnWeek: TButton;
    Label1: TLabel;
    procedure BtnWeekClick(Sender: TObject);
    procedure OnDateIncDec(Sender: TObject);
  private
    { Private 錾 }
    FRd: TDataRdRecReserveItem;
    function DateTimeToStr(dd : TDataRdRecReserveDateTimeEx) : string;
    procedure WeekToDayChange();
  public
    { Public 錾 }
    procedure Show();
    procedure View();
    property Rd : TDataRdRecReserveItem read FRd write FRd;
  end;

implementation

{$R *.DFM}

{ TFrameRdRecDate }

function TFrameRdRecDate.DateTimeToStr(
  dd: TDataRdRecReserveDateTimeEx): string;
begin
  result := '';
  if dd.Mode <> rrrdNormal then exit;
  result := FormatDateTime('yyyy"N"mm""dd""(aaa)',dd.DateTime);
end;

procedure TFrameRdRecDate.Show;
begin
  CBoxDate.Clear;
  CBoxDate.Items.AddObject('tw',Pointer(rrrdNormal));
  CBoxDate.Items.AddObject('Tj',Pointer(rrrdWeekSun));
  CBoxDate.Items.AddObject('Tj',Pointer(rrrdWeekMon));
  CBoxDate.Items.AddObject('TΗj',Pointer(rrrdWeekTue));
  CBoxDate.Items.AddObject('Tj',Pointer(rrrdWeekWed));
  CBoxDate.Items.AddObject('Tؗj',Pointer(rrrdWeekThu));
  CBoxDate.Items.AddObject('Tj',Pointer(rrrdWeekFri));
  CBoxDate.Items.AddObject('Tyj',Pointer(rrrdWeekSat));
  CBoxDate.Items.AddObject('`ؗj',Pointer(rrrdMonThu));
  CBoxDate.Items.AddObject('`j',Pointer(rrrdMonFri));
  CBoxDate.Items.AddObject('`yj',Pointer(rrrdMonFri));
  CBoxDate.Items.AddObject('@@',Pointer(rrrdAllDay));
end;

procedure TFrameRdRecDate.View;
var
  i : Integer;
  rd1,rd2 : TDataRdRecReserveDateTimeMode;
begin
  rd1 := FRd.DateTime.Start.Mode;
  for i := 0 to CBoxDate.Items.Count-1 do begin
    rd2 := TDataRdRecReserveDateTimeMode(CBoxDate.Items.Objects[i]);
    if rd1 = rd2 then begin
      CBoxDate.ItemIndex := i;
      break;
    end;
  end;
  EditDate.Text := DateTimeToStr(FRd.DateTime.Start);
end;

procedure TFrameRdRecDate.BtnWeekClick(Sender: TObject);
begin
  WeekToDayChange();
end;

procedure TFrameRdRecDate.WeekToDayChange;
  procedure WeekToDate(dd : TDataRdRecReserveDateTimeEx;aWeek : Integer);
  var
    i : Integer;
  begin
    dd.DateTime := Now;
    dd.Mode := rrrdNormal;
    for i := 0 to 6 do begin
      if dd.Week = aWeek then exit;
      dd.IncDay();
    end;
  end;
  procedure DateToWeek(dd : TDataRdRecReserveDateTimeEx);
  var
    aWeek : Integer;
  begin
    aWeek := dd.Week;
    case aWeek of
      1: dd.Mode := rrrdWeekSun;
      2: dd.Mode := rrrdWeekMon;
      3: dd.Mode := rrrdWeekTue;
      4: dd.Mode := rrrdWeekWed;
      5: dd.Mode := rrrdWeekThu;
      6: dd.Mode := rrrdWeekFri;
      7: dd.Mode := rrrdWeekSat;
    end;

  end;
var
  dd : TDataRdRecReserveDateTimeEx;
begin
  dd := FRd.DateTime.Start;
  case dd.Mode of
    rrrdNormal  : DateToWeek(dd);
    rrrdWeekSun : WeekToDate(dd,1);
    rrrdWeekMon : WeekToDate(dd,2);
    rrrdWeekTue : WeekToDate(dd,3);
    rrrdWeekWed : WeekToDate(dd,4);
    rrrdWeekThu : WeekToDate(dd,5);
    rrrdWeekFri : WeekToDate(dd,6);
    rrrdWeekSat : WeekToDate(dd,7);
  end;
  View();
end;

procedure TFrameRdRecDate.OnDateIncDec(Sender: TObject);
var
  Btn : TButton;
begin
  Btn := TButton(Sender);
  if btn.Tag = 0 then begin
    FRd.DateTime.Start.DecDay();
  end
  else begin
    FRd.DateTime.Start.IncDay();
  end;
  View();
end;

end.
