unit FrameRdRecChXD91Unit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,DataRdRecReserve,DataRdRecReserveFolder,DataRdRecReserveInfo,
  DataRdRecReserveChannel,DataDefineRd,DataRdRecReserveEncode, ExtCtrls;

type
  TFrameRdRecChXD91 = class(TFrame)
    Label3: TLabel;
    CBoxChannel: TComboBox;
    CBoxBCMedhia: TComboBox;
    RGrpEncode: TRadioGroup;
    procedure CBoxBCMedhiaChange(Sender: TObject);
    procedure CBoxEncChange(Sender: TObject);
    procedure RGrpEncodeClick(Sender: TObject);
    procedure CBoxChannelChange(Sender: TObject);
  private
    { Private 錾 }
    FRdInfo: TDataRdRecReserveInfo;
    FRd: TDataRdRecReserveItem;
    FRDDefine: TDataDefineRdItem;
    procedure ShowCh(aMode : TDataRdRecReserveChannelMode);
    procedure ShowBCMedhia();
    procedure ShowEnc();
    procedure ViewCh();
    procedure ViewEnc();
    procedure ViewBCMedhia();
  public
    { Public 錾 }
    procedure Show();
    procedure View();
    property Rd : TDataRdRecReserveItem read FRd write FRd;
    property RdInfo : TDataRdRecReserveInfo read FRdInfo write FRdInfo;
    property RDDefine : TDataDefineRdItem read FRDDefine write FRDDefine;
  end;

implementation

{$R *.DFM}

{ TFrameRdRecChXD91 }

procedure TFrameRdRecChXD91.Show;
begin
  ShowBCMedhia();
  //ShowCh();
  ShowEnc();
  View();
end;

procedure TFrameRdRecChXD91.ShowBCMedhia;
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  dc : TComboBox;
begin
  dc := CBoxBCMedhia;
  dc.Clear;
  for i := 0 to FRdInfo.BCMedhia.Items.Count-1 do begin
    d := FRdInfo.BCMedhia.Items[i];
    dc.Items.AddObject(d.NameInfo,d);
  end;
end;

procedure TFrameRdRecChXD91.ShowCh(aMode : TDataRdRecReserveChannelMode);
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  dc : TComboBox;
  ds : TDataRdRecReserveChannelItemsEx;
begin
  dc := CBoxChannel;
  dc.Clear;
  ds := FRdInfo.Channels.Selects[aMode];
  for i := 0 to ds.Count-1 do begin
    d := ds[i];
    dc.Items.AddObject(d.NameInfo,d);
  end;
end;

procedure TFrameRdRecChXD91.ShowEnc;
var
  i : Integer;
  dr : TRadioGroup;
  d : TDataRdRecReserveEncodeItem;
begin
  dr := RGrpEncode;
  dr.Items.Clear;
  for i := 0 to FRDDefine.Encode.Items.Count-1 do begin
    d := FRDDefine.Encode.Items[i];
    dr.Items.AddObject(d.NameInfo,d);
  end;
end;

procedure TFrameRdRecChXD91.View;
begin
  ViewBCMedhia();
  ViewCh();
  ViewEnc();
end;

procedure TFrameRdRecChXD91.ViewBCMedhia;
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  dc : TComboBox;
begin
  dc := CBoxBCMedhia;
  for i := 0 to dc.Items.Count-1 do begin
    d := TDataRdRecReserveChannelItem(dc.Items.Objects[i]);
    if d.Value = FRd.BCMedhiaStr then begin
      dc.ItemIndex := i;
      ShowCh(d.Mode);
    end;
  end;
end;

procedure TFrameRdRecChXD91.ViewCh;
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  dc : TComboBox;
begin
  dc := CBoxChannel;
  for i := 0 to dc.Items.Count-1 do begin
    d := TDataRdRecReserveChannelItem(dc.Items.Objects[i]);
    if d.Value = FRd.ChannelStr then begin
      dc.ItemIndex := i;
    end;
  end;
end;

procedure TFrameRdRecChXD91.ViewEnc;
var
  i : Integer;
  dr : TRadioGroup;
  d : TDataRdRecReserveEncodeItem;
begin
  dr := RGrpEncode;
  for i := 0 to dr.Items.Count-1 do begin
    d := TDataRdRecReserveEncodeItem(dr.Items.Objects[i]);
    if d.Mode = FRd.Encoder then begin
      dr.ItemIndex := i;
    end;
  end;
end;

procedure TFrameRdRecChXD91.CBoxBCMedhiaChange(Sender: TObject);
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  dc : TComboBox;
begin
  dc := TComboBox(Sender);
  i := dc.ItemIndex;
  if i = -1 then exit;
  d := TDataRdRecReserveChannelItem(dc.Items.Objects[i]);
  ShowCh(d.Mode);
  ViewCh();
end;

procedure TFrameRdRecChXD91.CBoxChannelChange(Sender: TObject);
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  dc : TComboBox;
begin
  dc := TComboBox(Sender);
  i := dc.ItemIndex;
  if i = -1 then exit;
  d := TDataRdRecReserveChannelItem(dc.Items.Objects[i]);
  FRd.ChannelStr := d.Value;
end;

procedure TFrameRdRecChXD91.CBoxEncChange(Sender: TObject);
var
  i : Integer;
  d : TDataRdRecReserveEncodeItemMode;
  dc : TComboBox;
begin
  dc := TComboBox(Sender);
  i := dc.ItemIndex;
  if i = -1 then exit;
  d := TDataRdRecReserveEncodeItemMode(dc.Items.Objects[i]);
  FRd.Encoder := d;
end;

procedure TFrameRdRecChXD91.RGrpEncodeClick(Sender: TObject);
var
  i : Integer;
  dr : TRadioGroup;
  d : TDataRdRecReserveEncodeItem;
begin
  dr := RGrpEncode;
  i := dr.ItemIndex;
  if i = -1 then exit;
  d := TDataRdRecReserveEncodeItem(dr.Items.Objects[i]);
  FRd.Encoder := d.Mode;
end;

end.
